/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.ui.preferences.SeamPreferencesMessages;
import org.jboss.tools.seam.ui.widget.editor.SeamRuntimeListFieldEditor;

public class SeamPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String SEAM_PREFERENCES_ID = "org.jboss.tools.common.model.ui.seam";
    private static final int COLUMNS = 3;
    SeamRuntimeListFieldEditor seamRuntimes = new SeamRuntimeListFieldEditor("rtlist", SeamPreferencesMessages.SEAM_PREFERENCE_PAGE_SEAM_RUNTIMES, new ArrayList<SeamRuntime>(Arrays.asList(SeamRuntimeManager.getInstance().getRuntimes())));

    public SeamPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        root.setLayout((Layout)gl);
        this.seamRuntimes.doFillIntoGrid(root);
        return root;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        for (SeamRuntime rt : this.seamRuntimes.getAddedSeamRuntimes()) {
            SeamRuntimeManager.getInstance().addRuntime(rt);
        }
        this.seamRuntimes.getAddedSeamRuntimes().clear();
        for (SeamRuntime rt : this.seamRuntimes.getRemoved()) {
            SeamRuntimeManager.getInstance().removeRuntime(rt);
        }
        this.seamRuntimes.getRemoved().clear();
        List<SeamRuntime> defaultRuntimes = this.seamRuntimes.getDefaultSeamRuntimes();
        SeamRuntime[] seamRuntimeArray = SeamRuntimeManager.getInstance().getRuntimes();
        int n = seamRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime seamRuntime = seamRuntimeArray[n2];
            seamRuntime.setDefault(false);
            ++n2;
        }
        for (SeamRuntime seamRuntime : defaultRuntimes) {
            seamRuntime.setDefault(true);
        }
        this.seamRuntimes.getDefaultSeamRuntimes().clear();
        Map<SeamRuntime, SeamRuntime> changed = this.seamRuntimes.getChangedSeamRuntimes();
        for (SeamRuntime c : changed.keySet()) {
            SeamRuntime o = changed.get(c);
            o.setHomeDir(c.getHomeDir());
            o.setVersion(c.getVersion());
            String oldName = o.getName();
            String newName = c.getName();
            if (oldName.equals(newName)) continue;
            SeamRuntimeManager.getInstance().changeRuntimeName(oldName, newName);
        }
        this.seamRuntimes.getChangedSeamRuntimes().clear();
        SeamRuntimeManager.getInstance().save();
    }

    protected void performDefaults() {
        this.setValid(true);
        this.setMessage(null);
        this.performApply();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

