/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.search.SeamSearchEngine;

public class SeamPathIndexer {
    public IPath[] getVisibleSeamPaths(SearchPattern pattern, IJavaSearchScope scope) {
        FileVisitor seamFileVisitor = new FileVisitor(pattern, scope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)seamFileVisitor, 0);
        }
        catch (CoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
        return seamFileVisitor.getPaths();
    }

    private class FileVisitor
    implements IResourceProxyVisitor {
        private HashMap fPaths = new HashMap();
        IJavaSearchScope fScope = null;
        SearchPattern fPattern = null;

        public FileVisitor(SearchPattern pattern, IJavaSearchScope scope) {
            this.fPattern = pattern;
            this.fScope = scope;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (SeamSearchEngine.getInstance().isCanceled()) {
                return false;
            }
            if (proxy.getType() == 1) {
                IFile file = (IFile)proxy.requestResource();
                if (!file.isSynchronized(0)) {
                    return false;
                }
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription != null) {
                    contentDescription.getContentType().getId();
                }
                if (this.fScope.encloses(proxy.requestFullPath().toString())) {
                    this.fPaths.put(file.getParent().getFullPath(), SeamSearchEngine.getInstance().computeIndexLocation(file.getParent().getFullPath()));
                }
                return false;
            }
            return true;
        }

        public IPath[] getPaths() {
            return this.fPaths.values().toArray(new IPath[this.fPaths.size()]);
        }
    }
}

