/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.DocumentCharSequence;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.core.text.TextSearchVisitor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.IOpenableElement;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamComponent;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;
import org.jboss.tools.seam.internal.core.scanner.java.AnnotatedASTNode;
import org.jboss.tools.seam.internal.core.scanner.java.ResolvedAnnotation;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.search.SeamSearchEngine;
import org.jboss.tools.seam.ui.search.SeamSearchRequestor;
import org.jboss.tools.seam.ui.search.SeamSearchScope;
import org.jboss.tools.seam.ui.text.java.scanner.JavaAnnotationScanner;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamSearchVisitor {
    private final SeamVariableMatcher[] fVariableMatchers;
    private final JavaElementMatcher[] fJavaMatchers;
    private final VarMatcher[] fVarMatchers;
    private final SeamSearchRequestor fCollector;
    private final MultiStatus fStatus;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IResource fSearchRoot;
    private ISeamProject fCurrentSeamProject;
    private Map fDocumentsInEditors;
    private final TextSearchVisitor.ReusableMatchAccess fMatchAccess;
    private IFile fCurrentFile;
    private final FileCharSequenceProvider fFileCharSequenceProvider;
    private SeamSearchScope fCurrentScope = null;
    private ElVarSearcher fELVarSearcher;
    private List<Var> fVarListForCurentValidatedNode = new ArrayList<Var>();
    ISeamMatcher fCurrentMatcher;

    public SeamSearchVisitor(SeamSearchRequestor collector, Var[] vars, IFile file) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fSearchRoot = file;
        this.fJavaMatchers = null;
        this.fVariableMatchers = null;
        this.fVarMatchers = new VarMatcher[vars == null ? 0 : vars.length];
        int i = 0;
        while (vars != null && i < vars.length) {
            this.fVarMatchers[i] = vars[i] == null ? null : new VarMatcher(vars[i], file);
            ++i;
        }
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new TextSearchVisitor.ReusableMatchAccess();
    }

    public SeamSearchVisitor(SeamSearchRequestor collector, IJavaElement[] elements, IProject project) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fSearchRoot = project;
        this.fVarMatchers = null;
        this.fVariableMatchers = null;
        this.fJavaMatchers = new JavaElementMatcher[elements == null ? 0 : elements.length];
        int i = 0;
        while (elements != null && i < elements.length) {
            this.fJavaMatchers[i] = elements[i] == null ? null : new JavaElementMatcher(elements[i], project);
            ++i;
        }
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new TextSearchVisitor.ReusableMatchAccess();
    }

    public SeamSearchVisitor(SeamSearchRequestor collector, ISeamContextVariable[] variables, IProject project) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fSearchRoot = project;
        this.fVarMatchers = null;
        this.fJavaMatchers = null;
        this.fVariableMatchers = new SeamVariableMatcher[variables == null ? 0 : variables.length];
        int i = 0;
        while (variables != null && i < variables.length) {
            this.fVariableMatchers[i] = variables[i] == null ? null : new SeamVariableMatcher(variables[i], project);
            ++i;
        }
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new TextSearchVisitor.ReusableMatchAccess();
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        try {
            if (scope instanceof SeamSearchScope) {
                this.fCurrentScope = (SeamSearchScope)scope;
                if (SeamSearchEngine.isSearchForDeclarations(((SeamSearchScope)scope).getLimitTo())) {
                    IStatus iStatus = this.searchForDeclarations(((SeamSearchScope)scope).evaluateSeamProjectsInScope(this.fStatus), monitor);
                    return iStatus;
                }
                IStatus iStatus = this.searchForReferences(((SeamSearchScope)scope).evaluateSeamProjectsInScope(this.fStatus), monitor);
                return iStatus;
            }
        }
        finally {
            this.fCurrentScope = null;
        }
        return Status.OK_STATUS;
    }

    private int calculateFiles() {
        if (this.fJavaMatchers != null && this.fJavaMatchers.length > 0 || this.fVariableMatchers != null && this.fVariableMatchers.length > 0) {
            IFile[] files = this.fCurrentScope.evaluateFilesInScope(this.fStatus);
            return files == null ? 0 : files.length;
        }
        if (this.fVarMatchers != null && this.fVarMatchers.length > 0) {
            ArrayList<IFile> fileList = new ArrayList<IFile>(this.fVarMatchers.length);
            int i = 0;
            while (i < this.fVarMatchers.length) {
                if (this.fVarMatchers[i] != null && this.fVarMatchers[i].getFile() != null) {
                    fileList.add(this.fVarMatchers[i].getFile());
                }
                ++i;
            }
            return fileList.size();
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    public IStatus searchForDeclarations(ISeamProject[] projects, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = this.calculateFiles();
        this.fCurrentSeamProject = null;
        MonitorUpdateJob monitorUpdateJob = new MonitorUpdateJob();
        try {
            MultiStatus multiStatus;
            this.fProgressMonitor.beginTask(this.getTaskName(), this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processSeamProjects(projects, true);
                multiStatus = this.fStatus;
            }
            catch (Throwable x) {
                SeamGuiPlugin.getPluginLog().logError(x);
                MultiStatus multiStatus2 = this.fStatus;
                monitorUpdateJob.cancel();
                this.fProgressMonitor.done();
                this.fCollector.endReporting();
                return multiStatus2;
                {
                    catch (Throwable throwable) {
                        monitorUpdateJob.cancel();
                        throw throwable;
                    }
                }
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    private void processSeamProjects(ISeamProject[] projects, boolean searchDeclarations) {
        int i = 0;
        while (i < projects.length) {
            boolean res;
            this.fCurrentSeamProject = projects[i];
            boolean bl = res = searchDeclarations ? this.processSeamDeclarationsInProject(this.fCurrentSeamProject) : this.processSeamReferencesInProject(this.fCurrentSeamProject);
            if (!res) break;
            ++i;
        }
    }

    private boolean processSeamReferencesInProject(ISeamProject project) {
        IFile[] files = null;
        if (this.fCurrentScope != null) {
            if (this.fJavaMatchers != null && this.fJavaMatchers.length > 0 || this.fVariableMatchers != null && this.fVariableMatchers.length > 0) {
                files = this.evaluateProjectFilesInScope(project.getProject(), this.fStatus);
            } else if (this.fVarMatchers != null && this.fVarMatchers.length > 0) {
                ArrayList<IFile> fileList = new ArrayList<IFile>(this.fVarMatchers.length);
                int i = 0;
                while (i < this.fVarMatchers.length) {
                    if (this.fVarMatchers[i] != null && this.fVarMatchers[i].getFile() != null) {
                        fileList.add(this.fVarMatchers[i].getFile());
                    }
                    ++i;
                }
                if (!fileList.isEmpty()) {
                    files = fileList.toArray(new IFile[0]);
                }
            }
        }
        SeamELCompletionEngine fCompletionEngine = new SeamELCompletionEngine();
        this.fELVarSearcher = new ElVarSearcher((ELCompletionEngine)fCompletionEngine);
        this.fDocumentsInEditors = SeamSearchVisitor.evalNonFileBufferDocuments();
        boolean res = true;
        int i = 0;
        while (files != null && i < files.length) {
            res = this.processSeamReferencesInFile(files[i]);
            if (!res) break;
            ++i;
        }
        this.fDocumentsInEditors = null;
        this.fELVarSearcher = null;
        return res;
    }

    /*
     * Exception decompiling
     */
    private boolean processSeamReferencesInFile(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void locateMatches(IFile file, CharSequence searchInput) throws CoreException {
        this.fELVarSearcher.setFile(file);
        if ("java".equalsIgnoreCase(file.getFileExtension())) {
            this.locateMatchesInJava(file, searchInput);
        } else {
            this.locateMatchesInDom(file, searchInput);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void locateMatchesInDom(IFile file, CharSequence content) {
        this.fVarListForCurentValidatedNode.clear();
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return;
        }
        IStructuredModel model = null;
        try {
            try {
                model = manager.getModelForRead(file);
                if (!(model instanceof IDOMModel)) return;
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                this.locateMatchesInChildNodes(file, (Node)document, content);
                return;
            }
            catch (CoreException e) {
                SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_EL_VALIDATOR_ERROR_VALIDATING_SEAM_EL, (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_EL_VALIDATOR_ERROR_VALIDATING_SEAM_EL, (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void locateMatchesInChildNodes(IFile file, Node parent, CharSequence content) throws CoreException {
        Var var = this.fELVarSearcher.findVar(parent);
        if (var != null) {
            this.fVarListForCurentValidatedNode.add(var);
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node curentValidatedNode = children.item(i);
            if (1 == curentValidatedNode.getNodeType()) {
                this.locateMatchesInNodeContent(file, ((IDOMNode)curentValidatedNode).getFirstStructuredDocumentRegion(), "XML_TAG_ATTRIBUTE_VALUE", content);
            } else if (3 == curentValidatedNode.getNodeType()) {
                this.locateMatchesInNodeContent(file, ((IDOMNode)curentValidatedNode).getFirstStructuredDocumentRegion(), "XML_CONTENT", content);
            }
            this.locateMatchesInChildNodes(file, curentValidatedNode, content);
            ++i;
        }
        if (var != null) {
            this.fVarListForCurentValidatedNode.remove(var);
        }
    }

    private void locateMatchesInNodeContent(IFile file, IStructuredDocumentRegion node, String regionType, CharSequence content) throws CoreException {
        ITextRegionList regions = node.getRegions();
        int i = 0;
        while (i < regions.size()) {
            String text;
            ITextRegion region = regions.get(i);
            if (region.getType() == regionType && (text = node.getFullText(region)).indexOf("{") > -1) {
                int offset = node.getStartOffset() + region.getStart();
                this.locateMatchesInString(file, text, offset, content);
            }
            ++i;
        }
    }

    private void locateMatchesInJava(IFile file, CharSequence content) throws CoreException {
        try {
            FastJavaPartitionScanner scaner = new FastJavaPartitionScanner();
            Document document = new Document(content.subSequence(0, content.length()).toString());
            scaner.setRange((IDocument)document, 0, document.getLength());
            IToken token = scaner.nextToken();
            while (token != null && token != Token.EOF) {
                if ("__java_string".equals(token.getData())) {
                    int length = scaner.getTokenLength();
                    int offset = scaner.getTokenOffset();
                    String value = document.get(offset, length);
                    if (value.indexOf(123) > -1) {
                        this.locateMatchesInString(file, value, offset, content);
                    }
                }
                token = scaner.nextToken();
            }
            ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
            if (compilationUnit == null) {
                return;
            }
            JavaAnnotationScanner annotationScanner = new JavaAnnotationScanner();
            Map<ResolvedAnnotation, AnnotatedASTNode<ASTNode>> loadedAnnotations = null;
            try {
                annotationScanner.parse(compilationUnit);
                loadedAnnotations = annotationScanner.getResolvedAnnotations();
            }
            catch (ScannerException e) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                return;
            }
            for (ResolvedAnnotation annotation : loadedAnnotations.keySet()) {
                IRegion valueRegion;
                String value;
                if (!annotationScanner.isAnnotationOfType(annotation, "org.jboss.seam.annotations.In") && !annotationScanner.isAnnotationOfType(annotation, "org.jboss.seam.annotations.Out") || (value = annotationScanner.getAnnotationValue(annotation)) == null || value.length() == 0 || (valueRegion = annotationScanner.getAnnotationValueRegion(annotation)) == null) continue;
                valueRegion.getLength();
                int offset = valueRegion.getOffset();
                if (value != null && value.indexOf("#{") >= 0) {
                    this.locateMatchesInString(file, value, offset, content);
                    continue;
                }
                String string = "#{" + value + "}";
                this.locateMatchesInString(file, string, offset - 2, content);
            }
        }
        catch (BadLocationException e) {
            SeamGuiPlugin.getDefault().logError(e);
        }
    }

    private void locateMatchesInString(IFile file, String string, int offset, CharSequence content) throws CoreException {
        int startEl = string.indexOf("#{");
        if (startEl > -1) {
            ELParser parser = ELParserUtil.getJbossFactory().createParser();
            ELModel model = parser.parse(string);
            List is = model.getInstances();
            for (ELInstance i : is) {
                if (i.getExpression() == null) continue;
                this.locateMatchesInEL(file, i.getExpression(), content, offset);
            }
        }
    }

    private void locateMatchesInEL(IFile file, ELExpression el, CharSequence content, int offset) throws CoreException {
        List invocations = el.getInvocations();
        for (ELInvocationExpression token : invocations) {
            Var var;
            boolean res;
            int lengthOfOperandToken;
            int offsetOfOperandToken;
            int end;
            int start;
            ELInvocationExpression expr;
            String operand = token.getText();
            int offsetOfToken = offset + token.getFirstToken().getStart();
            if (this.fJavaMatchers != null) {
                expr = token;
                while (expr != null) {
                    List elements = null;
                    SeamELCompletionEngine fCompletionEngine = new SeamELCompletionEngine();
                    try {
                        elements = fCompletionEngine.getJavaElementsForELOperandTokens(this.fCurrentSeamProject, file, expr);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                    }
                    catch (BadLocationException e) {
                        SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                    }
                    if (elements != null) {
                        int i = 0;
                        while (i < elements.size()) {
                            if (this.matches((IJavaElement)elements.get(i))) {
                                start = 0;
                                end = expr.getEndPosition() - expr.getStartPosition();
                                operand.substring(start, end);
                                offsetOfOperandToken = offsetOfToken + start;
                                lengthOfOperandToken = end - start;
                                this.fMatchAccess.initialize(file, offsetOfOperandToken, lengthOfOperandToken, content);
                                res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                                if (!res) {
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                    expr = expr.getLeft();
                }
                continue;
            }
            if (this.fVariableMatchers != null) {
                expr = token;
                while (expr != null) {
                    Set variables = this.fCurrentSeamProject.getVariablesByName(expr.getText());
                    if (variables != null) {
                        for (ISeamContextVariable variable : variables) {
                            if (!this.matches(variable)) continue;
                            start = 0;
                            end = expr.getEndPosition() - expr.getStartPosition();
                            operand.substring(start, end);
                            offsetOfOperandToken = offsetOfToken + start;
                            lengthOfOperandToken = end - start;
                            this.fMatchAccess.initialize(file, offsetOfOperandToken, lengthOfOperandToken, content);
                            res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                            if (res) continue;
                            return;
                        }
                    }
                    expr = expr.getLeft();
                }
                continue;
            }
            if (this.fVarMatchers == null || (var = this.fELVarSearcher.findVarForEl(operand, this.fVarListForCurentValidatedNode, false)) == null || !this.matches(var)) continue;
            ELInvocationExpression expr2 = token;
            while (expr2.getLeft() != null) {
                expr2 = expr2.getLeft();
            }
            expr2.getText();
            int start2 = expr2.getStartPosition();
            int end2 = expr2.getEndPosition();
            int offsetOfVarRefToken = offsetOfToken + start2;
            int lengthOfVarRefToken = end2 - start2;
            this.fMatchAccess.initialize(file, offsetOfVarRefToken, lengthOfVarRefToken, content);
            boolean res2 = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
            if (res2) continue;
            return;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean processSeamDeclarationsInProject(ISeamProject project) {
        if (this.fJavaMatchers != null && this.fJavaMatchers.length > 0) {
            JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
            IJavaSearchScope scope = factory.createWorkspaceScope(true);
            String description = factory.getWorkspaceScopeDescription(true);
            int i = 0;
            while (i < this.fJavaMatchers.length) {
                ElementQuerySpecification elementQuerySpecification = new ElementQuerySpecification(this.fJavaMatchers[i].getElement(), 0, scope, description);
                JavaSearchQuery query = new JavaSearchQuery((QuerySpecification)elementQuerySpecification);
                query.run(this.fProgressMonitor);
                JavaSearchResult result = (JavaSearchResult)query.getSearchResult();
                Object[] elements = result.getElements();
                int j = 0;
                while (elements != null && j < elements.length) {
                    Match[] matches = result.getMatches(elements[j]);
                    int k = 0;
                    while (matches != null && k < matches.length) {
                        this.fCollector.reportMatch(matches[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.fVariableMatchers != null && this.fVariableMatchers.length > 0) {
            try {
                int i = 0;
                while (i < this.fVariableMatchers.length) {
                    if (this.fVariableMatchers[i] != null) {
                        ISeamContextVariable decl;
                        boolean res;
                        int length;
                        int offset;
                        ISeamContextVariable variable = this.fVariableMatchers[i].getElement();
                        if (variable instanceof ISeamContextShortVariable) {
                            variable = ((ISeamContextShortVariable)variable).getOriginal();
                        }
                        boolean continueWithFactories = true;
                        if (variable instanceof SeamComponent) {
                            SeamComponent comp = (SeamComponent)variable;
                            Set declarations = comp.getAllDeclarations();
                            for (ISeamComponentDeclaration decl2 : declarations) {
                                if (decl2 instanceof IJavaSourceReference) {
                                    IJavaSourceReference sourceRef = (IJavaSourceReference)decl2;
                                    sourceRef.getSourceMember().getResource();
                                    sourceRef.getSourceMember();
                                    sourceRef.getSourceMember().getElementName();
                                    sourceRef.getStartPosition();
                                    sourceRef.getLength();
                                    boolean res2 = this.fCollector.acceptSeamDeclarationSourceReferenceMatch(sourceRef);
                                    if (!res2) {
                                        return true;
                                    }
                                    continueWithFactories = false;
                                    continue;
                                }
                                if (!(decl2 instanceof IOpenableElement)) continue;
                                IResource resource = decl2.getResource();
                                String name = decl2.getName();
                                ITextSourceReference textSourceReference = decl2.getLocationFor("name");
                                if (textSourceReference != null) {
                                    textSourceReference.getStartPosition();
                                    textSourceReference.getLength();
                                    boolean res3 = this.fCollector.acceptSeamDeclarationMatch((ISeamDeclaration)decl2);
                                    if (!res3) {
                                        return true;
                                    }
                                    continueWithFactories = false;
                                    continue;
                                }
                                offset = decl2.getStartPosition();
                                length = decl2.getLength();
                                this.fMatchAccess.initialize((IFile)resource, offset, length, (CharSequence)name);
                                res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                                if (!res) {
                                    return true;
                                }
                                continueWithFactories = false;
                            }
                        } else if (variable instanceof IRole) {
                            decl = variable;
                            IResource resource = decl.getResource();
                            String name = decl.getName();
                            ITextSourceReference textSourceReference = decl.getLocationFor("name");
                            if (textSourceReference != null) {
                                int offset2 = textSourceReference.getStartPosition();
                                int length2 = textSourceReference.getLength();
                                this.fMatchAccess.initialize((IFile)resource, offset2, length2, (CharSequence)name);
                                boolean res4 = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                                if (!res4) {
                                    return true;
                                }
                                continueWithFactories = false;
                            }
                        } else if (variable instanceof IBijectedAttribute) {
                            IBijectedAttribute ba = (IBijectedAttribute)variable;
                            BijectedAttributeType[] types = ba.getTypes();
                            boolean hasDeclarationType = false;
                            int j = 0;
                            while (!hasDeclarationType && types != null && j < types.length) {
                                if (types[j] == BijectedAttributeType.OUT || types[j] == BijectedAttributeType.DATA_BINDER || types[j] == BijectedAttributeType.DATA_MODEL_SELECTION) {
                                    hasDeclarationType = true;
                                }
                                ++j;
                            }
                            if (hasDeclarationType) {
                                ISeamContextVariable decl3 = variable;
                                IResource resource = decl3.getResource();
                                String name = decl3.getName();
                                ITextSourceReference textSourceReference = decl3.getLocationFor("name");
                                if (textSourceReference != null) {
                                    offset = textSourceReference.getStartPosition();
                                    length = textSourceReference.getLength();
                                    this.fMatchAccess.initialize((IFile)resource, offset, length, (CharSequence)name);
                                    res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                                    if (!res) {
                                        return true;
                                    }
                                    continueWithFactories = false;
                                }
                            }
                        }
                        if (continueWithFactories && variable instanceof ISeamDeclaration) {
                            decl = variable;
                            decl.getResource();
                            decl.getName();
                            ITextSourceReference textSourceReference = decl.getLocationFor("name");
                            if (textSourceReference != null) {
                                textSourceReference.getStartPosition();
                                textSourceReference.getLength();
                                boolean res5 = this.fCollector.acceptSeamDeclarationMatch((ISeamDeclaration)decl);
                                if (!res5) {
                                    return true;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                Object[] args = new String[]{SeamSearchVisitor.getExceptionMessage((Exception)((Object)ce)), project.getResource().getFullPath().makeRelative().toString()};
                String message = Messages.format((String)SearchMessages.TextSearchVisitor_error, (Object[])args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)ce));
            }
        }
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
        return true;
    }

    private String getTaskName() {
        ISeamMatcher[] currentMatchers = this.fJavaMatchers == null ? this.fVarMatchers : this.fJavaMatchers;
        StringBuffer elements = new StringBuffer();
        int i = 0;
        while (currentMatchers != null && i < currentMatchers.length) {
            if (currentMatchers[i] != null) {
                if (elements.length() > 0) {
                    elements.append(", ");
                }
                elements.append(currentMatchers[i].getName());
            }
            ++i;
        }
        String taskName = elements.length() == 0 ? SearchMessages.TextSearchVisitor_filesearch_task_label : Messages.format((String)SearchMessages.TextSearchVisitor_textsearch_task_label, (Object)elements.toString());
        return taskName;
    }

    private IStatus searchForReferences(ISeamProject[] projects, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = this.calculateFiles();
        this.fCurrentSeamProject = null;
        MonitorUpdateJob monitorUpdateJob = new MonitorUpdateJob();
        try {
            MultiStatus multiStatus;
            this.fProgressMonitor.beginTask(this.getTaskName(), this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processSeamProjects(projects, false);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    private boolean matches(IJavaElement element) {
        this.fCurrentMatcher = null;
        int i = 0;
        while (this.fJavaMatchers != null && i < this.fJavaMatchers.length) {
            if (this.fJavaMatchers[i] != null && this.fJavaMatchers[i].match(element)) {
                this.fCurrentMatcher = this.fJavaMatchers[i];
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matches(ISeamContextVariable element) {
        this.fCurrentMatcher = null;
        int i = 0;
        while (this.fVariableMatchers != null && i < this.fVariableMatchers.length) {
            if (this.fVariableMatchers[i] != null && this.fVariableMatchers[i].match(element)) {
                this.fCurrentMatcher = this.fVariableMatchers[i];
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matches(Var var) {
        this.fCurrentMatcher = null;
        int i = 0;
        while (this.fVarMatchers != null && i < this.fVarMatchers.length) {
            if (this.fVarMatchers[i] != null && this.fVarMatchers[i].match(var)) {
                this.fCurrentMatcher = this.fVarMatchers[i];
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = FileCharSequenceProvider.BUFFER_SIZE;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    private static Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        SeamSearchVisitor.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private static void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    private IDocument getOpenDocument(IFile file) {
        return SeamSearchVisitor.getOpenDocument(file, this.fDocumentsInEditors);
    }

    public static IDocument getOpenDocument(IFile file, Map documentsInEditors) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = (IDocument)documentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private static String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    private static boolean acceptPaternMatch(SeamSearchRequestor collector, IFile file, int offset, int length, CharSequence content) throws CoreException {
        TextSearchVisitor.ReusableMatchAccess matchAccess = new TextSearchVisitor.ReusableMatchAccess();
        matchAccess.initialize(file, offset, length, content);
        collector.beginReporting();
        boolean result = collector.acceptPatternMatch((TextSearchMatchAccess)matchAccess);
        collector.endReporting();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean acceptPaternMatch(SeamSearchRequestor collector, IFile file, int offset, int length) {
        try {
            IDocument document = SeamSearchVisitor.getOpenDocument(file, SeamSearchVisitor.evalNonFileBufferDocuments());
            if (document != null) {
                DocumentCharSequence documentCharSequence = new DocumentCharSequence(document);
                return SeamSearchVisitor.acceptPaternMatch(collector, file, offset, length, (CharSequence)documentCharSequence);
            }
            FileCharSequenceProvider fileCharSequenceProvider = new FileCharSequenceProvider();
            CharSequence seq = null;
            try {
                seq = fileCharSequenceProvider.newCharSequence(file);
                if (SeamSearchVisitor.hasBinaryContent(seq, file) && !collector.reportBinaryFile(file)) {
                    return true;
                }
                boolean bl = SeamSearchVisitor.acceptPaternMatch(collector, file, offset, length, seq);
                return bl;
            }
            catch (FileCharSequenceProvider.FileCharSequenceException e) {
                e.throwWrappedException();
                return false;
            }
            finally {
                if (seq != null) {
                    try {
                        fileCharSequenceProvider.releaseCharSequence(seq);
                    }
                    catch (IOException e2) {
                        SearchPlugin.log((Throwable)e2);
                    }
                }
            }
        }
        catch (UnsupportedCharsetException e3) {
            SearchPlugin.log((Throwable)e3);
            return false;
        }
        catch (IllegalCharsetNameException e4) {
            SearchPlugin.log((Throwable)e4);
            return false;
        }
        catch (IOException e5) {
            SearchPlugin.log((Throwable)e5);
            return false;
        }
        catch (CoreException e6) {
            SearchPlugin.log((Throwable)e6);
            return false;
        }
        catch (StackOverflowError stackOverflowError) {}
        return false;
    }

    public IFile[] evaluateProjectFilesInScope(IProject project, MultiStatus status) {
        return new ProjectFilesOfScopeCalculator(project, this.fCurrentScope, status).process();
    }

    static interface ISeamMatcher {
        public String getName();

        public boolean match(Object var1);

        public Object getElement();
    }

    class JavaElementMatcher
    implements ISeamMatcher {
        IJavaElement fElement;
        IProject fProject;

        JavaElementMatcher(IJavaElement javaElement, IProject project) {
            this.fElement = javaElement;
            this.fProject = project;
        }

        public String getName() {
            return this.fElement.getElementName();
        }

        public IJavaElement getElement() {
            return this.fElement;
        }

        public boolean match(Object object) {
            if (!(object instanceof IJavaElement)) {
                return false;
            }
            IJavaElement compare = (IJavaElement)object;
            if (this.fElement.equals(compare)) {
                return true;
            }
            if (this.fElement.getElementType() != compare.getElementType()) {
                return false;
            }
            switch (this.fElement.getElementType()) {
                case 8: {
                    return this.matchField((IField)compare);
                }
                case 9: {
                    return this.matchMethod((IMethod)compare);
                }
                case 7: {
                    return this.matchType((IType)compare);
                }
            }
            System.out.println("match: UnsupportedType:\n" + this.fElement.getElementName() + " ==>> " + this.fElement.getElementType());
            return false;
        }

        boolean matchType(IType compare) {
            return this.internalMatchType((IType)this.fElement, compare);
        }

        private boolean internalMatchType(IType type, IType compare) {
            return EclipseJavaUtil.isDerivedClass((String)type.getFullyQualifiedName(), (String)compare.getFullyQualifiedName(), (IProject)this.fProject);
        }

        boolean matchField(IField compare) {
            IField field = (IField)this.fElement;
            if (!field.getElementName().equals(compare.getElementName())) {
                return false;
            }
            if (!this.internalMatchType(field.getDeclaringType(), compare.getDeclaringType())) {
                return false;
            }
            try {
                return field.getTypeSignature().equals(compare.getTypeSignature());
            }
            catch (JavaModelException e) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                return false;
            }
        }

        boolean matchMethod(IMethod compare) {
            IMethod method = (IMethod)this.fElement;
            if (!method.getElementName().equals(compare.getElementName())) {
                return false;
            }
            if (!this.internalMatchType(method.getDeclaringType(), compare.getDeclaringType())) {
                return false;
            }
            try {
                return method.getSignature().equals(compare.getSignature());
            }
            catch (JavaModelException e) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                return false;
            }
        }
    }

    private class MonitorUpdateJob
    extends Job {
        private int fLastNumberOfScannedFiles;

        MonitorUpdateJob() {
            super(SearchMessages.TextSearchVisitor_progress_updating_job);
            this.fLastNumberOfScannedFiles = 0;
        }

        public IStatus run(IProgressMonitor inner) {
            while (!inner.isCanceled()) {
                ISeamProject seamProject = SeamSearchVisitor.this.fCurrentSeamProject;
                if (seamProject != null) {
                    String seamProjectName = seamProject.getProject().getName();
                    Object[] args = new Object[]{seamProjectName, new Integer(SeamSearchVisitor.this.fNumberOfScannedFiles), new Integer(SeamSearchVisitor.this.fNumberOfFilesToScan)};
                    SeamSearchVisitor.this.fProgressMonitor.subTask(Messages.format((String)SeamUIMessages.SeamSearchVisitor_scanning, (Object[])args));
                    int steps = SeamSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                    SeamSearchVisitor.this.fProgressMonitor.worked(steps);
                    this.fLastNumberOfScannedFiles += steps;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return Status.OK_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class ProjectFilesOfScopeCalculator
    implements IResourceProxyVisitor {
        private final IProject fProject;
        private final TextSearchScope fScope;
        private final MultiStatus fStatus;
        private ArrayList fFiles;

        public ProjectFilesOfScopeCalculator(IProject project, SeamSearchScope scope, MultiStatus status) {
            this.fProject = project;
            this.fScope = scope;
            this.fStatus = status;
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.fScope == null) {
                return false;
            }
            boolean inScope = this.fScope.contains(proxy);
            if (inScope && proxy.getType() == 1) {
                IFile file = (IFile)proxy.requestResource();
                if (!file.isSynchronized(0)) {
                    return false;
                }
                if (this.fProject == file.getProject()) {
                    this.fFiles.add(proxy.requestResource());
                }
            }
            return inScope;
        }

        public IFile[] process() {
            this.fFiles = new ArrayList();
            try {
                IResource[] roots = this.fScope.getRoots();
                int i = 0;
                while (i < roots.length) {
                    try {
                        IResource resource = roots[i];
                        if (resource.isAccessible()) {
                            resource.accept((IResourceProxyVisitor)this, 0);
                        }
                    }
                    catch (CoreException ex) {
                        this.fStatus.add(ex.getStatus());
                    }
                    ++i;
                }
                IFile[] iFileArray = this.fFiles.toArray(new IFile[this.fFiles.size()]);
                return iFileArray;
            }
            finally {
                this.fFiles = null;
            }
        }
    }

    class SeamVariableMatcher
    implements ISeamMatcher {
        ISeamContextVariable fVariable;
        IProject fProject;

        SeamVariableMatcher(ISeamContextVariable variable, IProject project) {
            this.fVariable = variable;
            this.fProject = project;
        }

        public String getName() {
            String name = this.fVariable == null ? null : this.fVariable.getName();
            return name == null ? "<null>" : name;
        }

        public boolean match(Object compare) {
            if (this.fVariable == null) {
                return false;
            }
            if (this.fVariable.equals(compare)) {
                return true;
            }
            return this.fVariable.equals(compare);
        }

        public ISeamContextVariable getElement() {
            return this.fVariable;
        }
    }

    class VarMatcher
    implements ISeamMatcher {
        Var fVar;
        IFile fFile;

        VarMatcher(Var var, IFile file) {
            this.fVar = var;
            this.fFile = file;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public String getName() {
            String name = this.fVar == null ? null : this.fVar.getName();
            return name == null ? "<null>" : name;
        }

        public boolean match(Object compare) {
            if (this.fVar == null) {
                return false;
            }
            return this.fVar.equals(compare);
        }

        public Var getElement() {
            return this.fVar;
        }
    }
}

