/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamProjectChangeListener;
import org.jboss.tools.seam.ui.views.AbstractSeamContentProvider;

public class RootContentProvider
extends AbstractSeamContentProvider {
    IWorkspaceRoot root;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
            IProject[] ps = root.getProjects();
            ArrayList<IProject> children = new ArrayList<IProject>();
            int i = 0;
            while (i < ps.length) {
                ISeamProject p;
                if (this.isGoodProject(ps[i]) && (p = SeamCorePlugin.getSeamProject((IProject)ps[i], (boolean)false)) != null) {
                    if (!this.processed.contains(p)) {
                        this.processed.add(p);
                        p.addSeamProjectListener((ISeamProjectChangeListener)this);
                    }
                    children.add(p.getProject());
                }
                ++i;
            }
            return children.toArray(new IProject[0]);
        }
        if (parentElement instanceof IProject) {
            ISeamProject p = SeamCorePlugin.getSeamProject((IProject)((IProject)parentElement), (boolean)false);
            if (p != null) {
                return super.getChildren(p);
            }
            return new Object[0];
        }
        return super.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ISeamProject || element instanceof IProject) {
            return this.root;
        }
        Object o = super.getParent(element);
        if (o instanceof ISeamProject) {
            return ((ISeamProject)o).getProject();
        }
        return o;
    }

    protected Object getTreeObject(Object source) {
        if (source instanceof ISeamProject) {
            return ((ISeamProject)source).getProject();
        }
        return source;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof IWorkspaceRoot || newInput == null) {
            this.root = (IWorkspaceRoot)newInput;
        }
    }

    public void dispose() {
        super.dispose();
        this.root = null;
    }

    boolean isGoodProject(IProject project) {
        return project != null && project.exists() && project.isOpen();
    }
}

