/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.views.ViewConstants;

public class SeamViewLayoutActionGroup
extends ActionGroup
implements ViewConstants {
    public static final String LAYOUT_GROUP_NAME = "layout";
    StructuredViewer structuredViewer;
    IExtensionStateModel stateModel;
    private boolean hasContributedToViewMenu = false;
    private IAction hierarchicalLayoutAction = null;
    private IAction flatLayoutAction = null;
    private IAction labelScopeAction = null;
    private IAction nodeScopeAction = null;
    private IMenuManager layoutSubMenu;
    private IMenuManager scopeSubMenu;
    private MenuItem hierarchicalLayoutItem = null;
    private MenuItem flatLayoutItem = null;
    private MenuItem labelScopeItem = null;
    private MenuItem nodeScopeItem = null;
    boolean isFlatLayout = true;
    boolean isScopeLable = false;

    public SeamViewLayoutActionGroup(StructuredViewer structuredViewer, IExtensionStateModel stateModel) {
        this.structuredViewer = structuredViewer;
        this.stateModel = stateModel;
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.hasContributedToViewMenu) {
            IMenuManager viewMenu = actionBars.getMenuManager();
            if (this.layoutSubMenu == null) {
                this.layoutSubMenu = new MenuManager(SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_SEAM_PACKAGES, SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_SEAM_PACKAGES);
                this.addLayoutActions(this.layoutSubMenu);
                viewMenu.insertAfter("additions", (IContributionItem)new Separator(LAYOUT_GROUP_NAME));
            }
            if (this.scopeSubMenu == null) {
                this.scopeSubMenu = new MenuManager(SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_SCOPE_PRESENTATION, SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_SCOPE_PRESENTATION);
                this.addScopeActions(this.scopeSubMenu);
            }
            viewMenu.appendToGroup(LAYOUT_GROUP_NAME, (IContributionItem)this.layoutSubMenu);
            viewMenu.appendToGroup(LAYOUT_GROUP_NAME, (IContributionItem)this.scopeSubMenu);
            this.hasContributedToViewMenu = true;
        }
    }

    public void unfillActionBars(IActionBars actionBars) {
        if (this.hasContributedToViewMenu) {
            if (this.layoutSubMenu != null) {
                actionBars.getMenuManager().remove((IContributionItem)this.layoutSubMenu);
                this.layoutSubMenu.dispose();
                this.layoutSubMenu = null;
            }
            if (this.scopeSubMenu != null) {
                actionBars.getMenuManager().remove((IContributionItem)this.scopeSubMenu);
                this.scopeSubMenu.dispose();
                this.scopeSubMenu = null;
            }
            this.hasContributedToViewMenu = false;
        }
    }

    void setFlatLayout(boolean b) {
        this.isFlatLayout = b;
        if (this.flatLayoutAction == null) {
            this.createActions();
            this.flatLayoutAction.setChecked(b);
            this.hierarchicalLayoutAction.setChecked(!b);
        }
    }

    void setScopeLable(boolean b) {
        this.isScopeLable = b;
        if (this.labelScopeAction == null) {
            this.createActions();
            this.labelScopeAction.setChecked(b);
            this.nodeScopeAction.setChecked(!b);
        }
    }

    private void createActions() {
        this.flatLayoutAction = new CommonLayoutAction("seam.packageStructure", true, "package.flat");
        this.hierarchicalLayoutAction = new CommonLayoutAction("seam.packageStructure", false, "package.hierarchical");
        this.labelScopeAction = new CommonLayoutAction("seam.scopePresentation", true, "layout.label");
        this.nodeScopeAction = new CommonLayoutAction("seam.scopePresentation", false, "layout.node");
    }

    protected void addLayoutActions(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new SeamContributionItem(this.flatLayoutAction){

            public void fill(Menu menu, int index) {
                int style = 16;
                MenuItem mi = new MenuItem(menu, style, index);
                SeamViewLayoutActionGroup.this.flatLayoutItem = mi;
                mi.setText(SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_FLAT);
                mi.setSelection(SeamViewLayoutActionGroup.this.isFlatLayout);
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((this).SeamViewLayoutActionGroup.this.isFlatLayout) {
                            SeamViewLayoutActionGroup.this.flatLayoutItem.setSelection(true);
                            return;
                        }
                        SeamViewLayoutActionGroup.this.flatLayoutAction.run();
                        SeamViewLayoutActionGroup.this.hierarchicalLayoutItem.setSelection(false);
                        SeamViewLayoutActionGroup.this.flatLayoutItem.setSelection(true);
                        (this).SeamViewLayoutActionGroup.this.isFlatLayout = true;
                        e.doit = false;
                    }
                });
            }

            public boolean isDynamic() {
                return false;
            }
        });
        viewMenu.add((IContributionItem)new SeamContributionItem(this.hierarchicalLayoutAction){

            public void fill(Menu menu, int index) {
                int style = 16;
                MenuItem mi = new MenuItem(menu, style, index);
                SeamViewLayoutActionGroup.this.hierarchicalLayoutItem = mi;
                mi.setText(SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_HIERARCHICAL);
                mi.setSelection(!SeamViewLayoutActionGroup.this.isFlatLayout);
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(this).SeamViewLayoutActionGroup.this.isFlatLayout) {
                            SeamViewLayoutActionGroup.this.hierarchicalLayoutItem.setSelection(true);
                            return;
                        }
                        SeamViewLayoutActionGroup.this.hierarchicalLayoutAction.run();
                        SeamViewLayoutActionGroup.this.flatLayoutItem.setSelection(false);
                        SeamViewLayoutActionGroup.this.hierarchicalLayoutItem.setSelection(true);
                        (this).SeamViewLayoutActionGroup.this.isFlatLayout = false;
                        e.doit = false;
                    }
                });
            }

            public boolean isDynamic() {
                return false;
            }
        });
    }

    protected void addScopeActions(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new SeamContributionItem(this.labelScopeAction){

            public void fill(Menu menu, int index) {
                int style = 16;
                MenuItem mi = new MenuItem(menu, style, index);
                SeamViewLayoutActionGroup.this.labelScopeItem = mi;
                mi.setText(SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_LABEL);
                mi.setSelection(SeamViewLayoutActionGroup.this.isScopeLable);
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((this).SeamViewLayoutActionGroup.this.isScopeLable) {
                            SeamViewLayoutActionGroup.this.labelScopeItem.setSelection(true);
                            return;
                        }
                        SeamViewLayoutActionGroup.this.labelScopeAction.run();
                        SeamViewLayoutActionGroup.this.nodeScopeItem.setSelection(false);
                        SeamViewLayoutActionGroup.this.labelScopeItem.setSelection(true);
                        (this).SeamViewLayoutActionGroup.this.isScopeLable = true;
                        e.doit = false;
                    }
                });
            }

            public boolean isDynamic() {
                return false;
            }
        });
        viewMenu.add((IContributionItem)new SeamContributionItem(this.nodeScopeAction){

            public void fill(Menu menu, int index) {
                int style = 16;
                MenuItem mi = new MenuItem(menu, style, index);
                SeamViewLayoutActionGroup.this.nodeScopeItem = mi;
                mi.setText(SeamUIMessages.SEAM_VIEW_LAYOUT_ACTION_GROUP_NODE);
                mi.setSelection(!SeamViewLayoutActionGroup.this.isScopeLable);
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(this).SeamViewLayoutActionGroup.this.isScopeLable) {
                            SeamViewLayoutActionGroup.this.nodeScopeItem.setSelection(true);
                            return;
                        }
                        SeamViewLayoutActionGroup.this.nodeScopeAction.run();
                        SeamViewLayoutActionGroup.this.labelScopeItem.setSelection(false);
                        SeamViewLayoutActionGroup.this.nodeScopeItem.setSelection(true);
                        (this).SeamViewLayoutActionGroup.this.isScopeLable = false;
                        e.doit = false;
                    }
                });
            }

            public boolean isDynamic() {
                return false;
            }
        });
    }

    private class CommonLayoutAction
    extends Action
    implements IAction {
        private String property;
        private final boolean value;

        public CommonLayoutAction(String property, boolean value, String id) {
            super("", 8);
            this.property = property;
            this.value = value;
            this.setId(id);
        }

        public void run() {
            if (SeamViewLayoutActionGroup.this.stateModel.getBooleanProperty(this.property) != this.value) {
                SeamViewLayoutActionGroup.this.stateModel.setBooleanProperty(this.property, this.value);
                SeamViewLayoutActionGroup.this.structuredViewer.getControl().setRedraw(false);
                try {
                    SeamViewLayoutActionGroup.this.structuredViewer.refresh();
                }
                finally {
                    SeamViewLayoutActionGroup.this.structuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }

    public class SeamContributionItem
    extends ContributionItem {
        IAction action;

        public SeamContributionItem(IAction action) {
            super(action.getId());
            this.action = action;
        }

        public IAction getAction() {
            return this.action;
        }
    }
}

