/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.SeamUiImages;
import org.jboss.tools.seam.ui.views.SeamReferencedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSeamComponentDialog
extends FilteredItemsSelectionDialog {
    private static final String FILE_NAME = "OpenSeamComponentHistory.xml";
    private static final String ROOT_NODE = "historyRootNode";
    private static final String INFO_NODE = "infoNode";
    private static final String PROJECT_NAME = "ProjectName";
    private static final String COMPONENT_NAME = "ComponentName";
    private static final String DELETED = "Deleted";
    private static final String SEPARATOR = " - ";
    private static final String YES = "yes";
    private static final String NO = "no";

    public OpenSeamComponentDialog(Shell shell) {
        super(shell);
        this.setSelectionHistory(new SeamComponentSelectionHistory());
        this.setListLabelProvider(new SeamComponentLabelProvider());
        this.setDetailsLabelProvider(new SeamComponentLabelProvider());
        XMLMemento memento = OpenSeamComponentDialog.loadMemento();
        if (memento != null) {
            this.getSelectionHistory().load((IMemento)memento);
        }
    }

    public void startSearch() {
        this.applyFilter();
    }

    public void okPressed() {
        super.okPressed();
    }

    public void stopSearchAndShowResults() {
        this.refresh();
        List list = this.getSelectedItems().toList();
        Collections.sort(list, this.getItemsComparator());
        this.setResult(list);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new SeamComponentFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.subTask(SeamUIMessages.OPEN_SEAM_COMPONENT_DIALOG_WAIT);
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException interruptedException) {}
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        progressMonitor.beginTask(SeamUIMessages.OPEN_SEAM_COMPONENT_DIALOG_LOADING, projects.length);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            progressMonitor.subTask(project.getName());
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
            if (seamProject != null) {
                ISeamComponent[] iter;
                ISeamComponent[] iSeamComponentArray = iter = seamProject.getComponents();
                int n = iter.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeamComponent component = iSeamComponentArray[n2];
                    if (SeamReferencedFilter.isComponentDeclaredInThisProject(component)) {
                        contentProvider.add((Object)new SeamComponentWrapper(component.getName(), project.getName(), component), itemsFilter);
                    }
                    ++n2;
                }
            }
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    private static XMLMemento loadMemento() {
        XMLMemento memento = null;
        IPath stateLocation = SeamGuiPlugin.getDefault().getStateLocation().append(FILE_NAME);
        File file = new File(stateLocation.toOSString());
        if (file.exists()) {
            InputStreamReader reader = null;
            try {
                try {
                    reader = new FileReader(file);
                    memento = XMLMemento.createReadRoot((Reader)reader);
                }
                catch (IOException ex) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex2) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)ex2);
                    }
                }
                catch (WorkbenchException ex) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex3) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)ex3);
                    }
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)ex);
                }
            }
        }
        return memento;
    }

    private static void saveMemento(XMLMemento xmlMemento) {
        IPath stateLocation = SeamGuiPlugin.getDefault().getStateLocation().append(FILE_NAME);
        File file = new File(stateLocation.toOSString());
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                xmlMemento.save((Writer)writer);
            }
            catch (IOException ex) {
                SeamCorePlugin.getPluginLog().logError((Throwable)ex);
                try {
                    writer.close();
                }
                catch (IOException ex2) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                SeamCorePlugin.getPluginLog().logError((Throwable)ex);
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings(SeamUIMessages.OPEN_SEAM_COMPONENT_DIALOG_NAME);
    }

    public String getElementName(Object item) {
        if (item instanceof SeamComponentWrapper) {
            SeamComponentWrapper componentWrapper = (SeamComponentWrapper)item;
            return componentWrapper.getComponentName();
        }
        return null;
    }

    protected Comparator<SeamComponentWrapper> getItemsComparator() {
        return new SeamComponentComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(this.getSelectedItems().size() >= 0 ? 0 : 4, "org.jboss.tools.seam.ui", null);
    }

    public static void validateHistory(ISeamProject seamProject) {
        String seamProjectName = seamProject.getProject().getName();
        XMLMemento memento = OpenSeamComponentDialog.loadMemento();
        if (memento != null) {
            XMLMemento historyMemento = (XMLMemento)memento.getChild(ROOT_NODE);
            if (historyMemento == null) {
                return;
            }
            IMemento[] mementoElements = historyMemento.getChildren(INFO_NODE);
            int i = 0;
            while (i < mementoElements.length) {
                IMemento mem = mementoElements[i];
                String projectName = mem.getString(PROJECT_NAME);
                if (projectName == null) {
                    mem.putString(DELETED, YES);
                } else if (projectName.equals(seamProjectName)) {
                    String componentName = mem.getString(COMPONENT_NAME);
                    if (componentName == null) {
                        mem.putString(DELETED, YES);
                    } else {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (project != null) {
                            ISeamProject cSeamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
                            if (cSeamProject != null) {
                                ISeamComponent component = cSeamProject.getComponent(componentName);
                                if (component == null) {
                                    mem.putString(DELETED, YES);
                                } else {
                                    mem.putString(DELETED, NO);
                                }
                            } else {
                                mem.putString(DELETED, YES);
                            }
                        } else {
                            mem.putString(DELETED, YES);
                        }
                    }
                }
                ++i;
            }
            OpenSeamComponentDialog.saveMemento(memento);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SeamComponentComparator
    implements Comparator<SeamComponentWrapper> {
        @Override
        public int compare(SeamComponentWrapper left, SeamComponentWrapper right) {
            return left.getComponentName().compareTo(right.getComponentName());
        }
    }

    public class SeamComponentFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public SeamComponentFilter() {
            super((FilteredItemsSelectionDialog)OpenSeamComponentDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (item instanceof SeamComponentWrapper) {
                int lastIndex;
                String pattern;
                SeamComponentWrapper componentWrapper = (SeamComponentWrapper)item;
                boolean result = this.patternMatcher.matches(componentWrapper.getComponentName());
                if (!result && (pattern = this.patternMatcher.getPattern()).indexOf(".") < 0 && (lastIndex = componentWrapper.getComponentName().lastIndexOf(".")) >= 0 && lastIndex + 1 < componentWrapper.getComponentName().length()) {
                    return this.patternMatcher.matches(componentWrapper.getComponentName().substring(lastIndex + 1));
                }
                return result;
            }
            return false;
        }
    }

    public class SeamComponentLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return SeamUiImages.COMPONENT_IMAGE;
        }

        public String getText(Object element) {
            if (element instanceof SeamComponentWrapper) {
                SeamComponentWrapper componentWrapper = (SeamComponentWrapper)element;
                return String.valueOf(componentWrapper.getComponentName()) + OpenSeamComponentDialog.SEPARATOR + componentWrapper.getProjectName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class SeamComponentSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        protected Object restoreItemFromMemento(IMemento memento) {
            XMLMemento mem = (XMLMemento)memento;
            String projectName = mem.getString(OpenSeamComponentDialog.PROJECT_NAME);
            if (projectName == null) {
                return null;
            }
            String componentName = mem.getString(OpenSeamComponentDialog.COMPONENT_NAME);
            if (componentName == null) {
                return null;
            }
            String componentDeleted = mem.getString(OpenSeamComponentDialog.DELETED);
            if (componentDeleted != null && OpenSeamComponentDialog.YES.equals(componentDeleted)) {
                return null;
            }
            return new SeamComponentWrapper(componentName, projectName);
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            SeamComponentWrapper componentWrapper = (SeamComponentWrapper)item;
            XMLMemento mem = (XMLMemento)memento;
            mem.putString(OpenSeamComponentDialog.PROJECT_NAME, componentWrapper.getProjectName());
            mem.putString(OpenSeamComponentDialog.COMPONENT_NAME, componentWrapper.getComponentName());
        }

        public void save(IMemento memento) {
            super.save(memento);
            if (!(memento instanceof XMLMemento)) {
                return;
            }
            XMLMemento xmlMemento = (XMLMemento)memento;
            OpenSeamComponentDialog.saveMemento(xmlMemento);
        }
    }

    public class SeamComponentWrapper {
        private String componentName;
        private String projectName;
        private ISeamComponent component;

        public SeamComponentWrapper(String componentName, String projectName) {
            this.componentName = componentName;
            this.projectName = projectName;
        }

        public SeamComponentWrapper(String componentName, String projectName, ISeamComponent component) {
            this(componentName, projectName);
            this.component = component;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public ISeamComponent getComponent() {
            if (this.component == null) {
                ISeamProject seamProject;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                if (project != null && (seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true)) != null) {
                    ISeamComponent component = seamProject.getComponent(this.componentName);
                    return component;
                }
                return null;
            }
            return this.component;
        }
    }
}

