/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.RenameComponentProcessor;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.internal.project.facet.SeamValidatorFactory;

public class RenameComponentWizard
extends RefactoringWizard {
    private ISeamComponent component;
    private String componentName;
    private IFieldEditor editor;
    private ISeamProject seamProject;

    public RenameComponentWizard(Refactoring refactoring, ISeamComponent component) {
        super(refactoring, 2);
        this.component = component;
        if (component != null) {
            this.seamProject = SeamCorePlugin.getSeamProject((IProject)((IProject)component.getResource()), (boolean)true);
        }
    }

    protected void addUserInputPages() {
        this.setDefaultPageTitle(this.getRefactoring().getName());
        RenameComponentProcessor processor = (RenameComponentProcessor)this.getRefactoring().getAdapter(RenameComponentProcessor.class);
        this.addPage((IWizardPage)new RenameComponentWizardPage(processor));
    }

    class RenameComponentWizardPage
    extends UserInputWizardPage {
        private RenameComponentProcessor processor;

        public RenameComponentWizardPage(RenameComponentProcessor processor) {
            super("");
            this.processor = processor;
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            container.setLayout((Layout)layout);
            layout.numColumns = 2;
            String defaultName = RenameComponentWizard.this.component.getName();
            RenameComponentWizard.this.editor = IFieldEditorFactory.INSTANCE.createTextEditor(RenameComponentWizard.this.componentName, SeamUIMessages.SEAM_WIZARD_FACTORY_SEAM_COMPONENT_NAME, defaultName);
            RenameComponentWizard.this.editor.doFillIntoGrid((Object)container);
            ((CompositeEditor)RenameComponentWizard.this.editor).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    RenameComponentWizardPage.this.validatePage();
                }
            });
            this.setControl((Control)container);
            this.setPageComplete(false);
        }

        protected final void validatePage() {
            Map errors = SeamValidatorFactory.SEAM_COMPONENT_NAME_VALIDATOR.validate((Object)RenameComponentWizard.this.editor.getValueAsString(), (Object)RenameComponentWizard.this.seamProject);
            if (!errors.isEmpty()) {
                this.setErrorMessage(NLS.bind((String)((IStatus)errors.get("default.error")).getMessage(), (Object)SeamUIMessages.SEAM_BASE_WIZARD_PAGE_SEAM_COMPONENTS));
                this.setPageComplete(false);
                return;
            }
            RefactoringStatus status = new RefactoringStatus();
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            this.processor.setNewName(RenameComponentWizard.this.editor.getValueAsString());
        }
    }
}

