/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.jboss.tools.common.ui.widget.editor.INamedElement;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.wizard.FileMapping;
import org.jboss.tools.seam.ui.wizard.SeamBaseOperation;
import org.jboss.tools.seam.ui.wizard.SeamBaseWizard;
import org.jboss.tools.seam.ui.wizard.SeamGenerateEntitiesTablesWizardPage;
import org.jboss.tools.seam.ui.wizard.SeamGenerateEntitiesWizardPage;

public class SeamGenerateEntitiesWizard
extends SeamBaseWizard
implements INewWizard {
    SeamGenerateEntitiesWizardPage page1 = new SeamGenerateEntitiesWizardPage();
    IWizardPage page2 = new SeamGenerateEntitiesTablesWizardPage();
    public static final IUndoableOperation GENERATE_SEAM_ENTITIES = new SeamBaseOperation(SeamUIMessages.SEAM_GENERATE_ENTITIES_WIZARD_ACTION_CREATING_OPERATION){

        @Override
        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Map params = (Map)info.getAdapter(Map.class);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(((INamedElement)params.get("seam.project.name")).getValueAsString());
            try {
                SeamRuntime seamRt;
                ISeamProject seamProject = (ISeamProject)project.getNature("org.jboss.tools.seam.core.seamnature");
                boolean seam2 = seamProject.getRuntime().getVersion().compareTo((Enum)SeamVersion.SEAM_2_0) >= 0;
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.CodeGenerationLaunchConfigurationType");
                launchConfigurationType.getAttribute("");
                ILaunchConfigurationWorkingCopy wc = launchConfigurationType.newInstance(null, String.valueOf(project.getName()) + "-generate-entities");
                wc.setAttribute("org.hibernate.tools.configurationname", ((INamedElement)params.get("hibernate.configuratrion.name")).getValueAsString());
                SeamProjectsSet seamProjectsSet = SeamProjectsSet.create((IProject)project);
                wc.setAttribute("org.hibernate.tools.outputdir", seamProjectsSet.getModelFolder() == null ? "" : seamProjectsSet.getModelFolder().getFullPath().toString());
                boolean isReverseEngineer = "true".equals(((INamedElement)params.get("org.hibernate.tools.schema2hbm")).getValueAsString());
                wc.setAttribute("org.hibernate.tools.schema2hbm", isReverseEngineer);
                if (isReverseEngineer) {
                    wc.setAttribute("org.hibernate.tools.package", seamProjectsSet.getEntityPackage());
                    wc.setAttribute("org.hibernate.tools.prefercompositeids", true);
                    wc.setAttribute("org.hibernate.tools.reveng.detect_many_to_many", true);
                    wc.setAttribute("org.hibernate.tools.reveng.detect_optimistc_lock", true);
                    boolean seam21 = seamProject.getRuntime().getVersion().compareTo((Enum)SeamVersion.SEAM_2_1) >= 0 || seamProject.getRuntime().getVersion().compareTo((Enum)SeamVersion.SEAM_2_2) >= 0;
                    wc.setAttribute("org.hibernate.tools.reveng.detect_one_to_one", seam21);
                }
                if ((seamRt = SeamGenerateEntitiesWizard.getRuntime(project)) == null) {
                    seamRt = SeamGenerateEntitiesWizard.getRuntime(project);
                }
                if (seamRt == null) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.SEAM_GENERATE_ENTITIES_WIZARD_CAN_NOT_FIND_SEAM_RUNTIME, (Object)project.getName())));
                }
                String seamTemplatesRoot = seamRt.getTemplatesDir();
                wc.setAttribute("org.hibernate.tools.templatepath", seamTemplatesRoot);
                wc.setAttribute("org.hibernate.tools.useOwnTemplates", true);
                wc.setAttribute("org.hibernate.tools.jdk5", true);
                wc.setAttribute("org.hibernate.tools.ejb3", true);
                ArrayList<String> exporters = new ArrayList<String>();
                if (isReverseEngineer) {
                    exporters.add("hbmtemplate0");
                }
                exporters.add("hbmtemplate1");
                exporters.add("hbmtemplate2");
                exporters.add("hbmtemplate3");
                exporters.add("hbmtemplate4");
                exporters.add("hbmtemplate5");
                exporters.add("hbmtemplate6");
                exporters.add("hbmtemplate7");
                exporters.add("hbmtemplate8");
                exporters.add("hbmtemplate9");
                wc.setAttribute("org.hibernate.tools.exporters", exporters);
                if (isReverseEngineer) {
                    wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate0", true);
                    wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate0.extension_id", "org.hibernate.tools.hbm2java");
                }
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate1", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate1.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate2", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate2.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate3", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate3.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate4", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate4.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate5", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate5.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate6", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate6.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate7", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate7.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate8", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate8.extension_id", "org.hibernate.tools.hbmtemplate");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate9", true);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate9.extension_id", "org.hibernate.tools.hbmtemplate");
                HashMap<String, String> hbmtemplateAttributes = new HashMap<String, String>();
                hbmtemplateAttributes.put("file_pattern", "{class-name}List.xhtml");
                hbmtemplateAttributes.put("template_name", "view/list.xhtml.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getViewsFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", SeamUIMessages.SEAM_GENERATE_ENTITIES_WIZARD_54);
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate1.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                hbmtemplateAttributes.put("file_pattern", "{class-name}.xhtml");
                hbmtemplateAttributes.put("template_name", "view/view.xhtml.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getViewsFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate2.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                hbmtemplateAttributes.put("file_pattern", "{class-name}.page.xml");
                hbmtemplateAttributes.put("template_name", "view/view.page.xml.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getViewsFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate3.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                hbmtemplateAttributes.put("file_pattern", "{class-name}Edit.xhtml");
                hbmtemplateAttributes.put("template_name", "view/edit.xhtml.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getViewsFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate4.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                hbmtemplateAttributes.put("file_pattern", "{class-name}Edit.page.xml");
                hbmtemplateAttributes.put("template_name", "view/edit.page.xml.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getViewsFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate5.properties", hbmtemplateAttributes);
                IEclipsePreferences seamFacetPrefs = SeamCorePlugin.getSeamPreferences((IProject)project);
                String actionpackage = seamFacetPrefs.get("action.package", "");
                String actionDir = actionpackage.replace('.', '/');
                hbmtemplateAttributes = new HashMap();
                if (seam2) {
                    hbmtemplateAttributes.put("actionPackage", actionpackage);
                    hbmtemplateAttributes.put("file_pattern", String.valueOf(actionDir) + "/{class-name}List.java");
                } else {
                    hbmtemplateAttributes.put("file_pattern", "{package-name}/{class-name}List.java");
                }
                hbmtemplateAttributes.put("template_name", "src/EntityList.java.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getActionFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate6.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                hbmtemplateAttributes.put("file_pattern", "{class-name}List.page.xml");
                hbmtemplateAttributes.put("template_name", "view/list.page.xml.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getViewsFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate7.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                if (seam2) {
                    hbmtemplateAttributes.put("actionPackage", actionpackage);
                    hbmtemplateAttributes.put("file_pattern", String.valueOf(actionDir) + "/{class-name}Home.java");
                } else {
                    hbmtemplateAttributes.put("file_pattern", "{package-name}/{class-name}Home.java");
                }
                hbmtemplateAttributes.put("template_name", "src/EntityHome.java.ftl");
                hbmtemplateAttributes.put("outputdir", seamProjectsSet.getActionFolder().getFullPath().toString());
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate8.properties", hbmtemplateAttributes);
                hbmtemplateAttributes = new HashMap();
                hbmtemplateAttributes.put("file_pattern", "menu.xhtml");
                hbmtemplateAttributes.put("template_name", "view/layout/menu.xhtml.ftl");
                hbmtemplateAttributes.put("outputdir", String.valueOf(seamProjectsSet.getViewsFolder().getFullPath().toString()) + "/layout");
                hbmtemplateAttributes.put("for_each", "entity");
                hbmtemplateAttributes.put("hibernatetool.util.toolclass", "org.hibernate.eclipse.launch.SeamUtil");
                wc.setAttribute("org.hibernate.tools.exporters.hbmtemplate9.properties", hbmtemplateAttributes);
                wc.doSave();
                if (params.containsKey("org.hibernate.tools.reveng.tables")) {
                    IPath revengPath = project.getLocation().append(".settings").append("gen-entities.hibernate.reveng.xml");
                    File location = revengPath.toFile();
                    FileUtil.writeFile((File)location, (String)((INamedElement)params.get("org.hibernate.tools.reveng.tables")).getValueAsString());
                    wc.setAttribute("org.hibernate.tools.revengfile", revengPath.toString());
                }
                launchManager.addLaunch(wc.launch("run", monitor));
                WebUtils.changeTimeStamp((IProject)project);
            }
            catch (CoreException e) {
                SeamCorePlugin.getDefault().showError(SeamUIMessages.SEAM_GENERATE_ENTITIES_WIZARD_CAN_NOT_GENERATE_SEAM_ENTITIES, (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        @Override
        public List<FileMapping> getFileMappings(Map<String, Object> vars) {
            return new ArrayList<FileMapping>();
        }
    };

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageContainer, "org.jboss.tools.seam.ui.generate_seam_entities");
    }

    public SeamGenerateEntitiesWizard() {
        super(GENERATE_SEAM_ENTITIES);
        this.setWindowTitle(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(SeamGenerateEntitiesWizard.class, (String)"SeamWebProjectWizBan.png"));
        this.addPage((IWizardPage)this.page1);
        this.addPage(this.page2);
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }

    static SeamRuntime getRuntime(IProject project) {
        if (project == null) {
            return null;
        }
        SeamRuntime seamRt = SeamRuntimeManager.getInstance().getRuntimeForProject(project);
        String runtimeName = SeamCorePlugin.getSeamPreferences((IProject)project).get("seam.runtime.name", "");
        if (!"".equals(runtimeName)) {
            seamRt = SeamRuntimeManager.getInstance().findRuntimeByName(runtimeName);
        }
        return seamRt;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            String ccName = this.page1.getConsoleCongigurationName();
            ConsoleConfiguration config = KnownConfigurations.getInstance().find(ccName);
            if (config != null) {
                config.reset();
            }
        }
        return result;
    }
}

