/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.seam.ui.SeamUIMessages;

public class ShowProjectSettingsAction
extends ButtonFieldEditor.ButtonPressedAction
implements PropertyChangeListener {
    IFieldEditor editor;
    IFieldEditor button;

    public ShowProjectSettingsAction() {
        super(SeamUIMessages.SHOW_PROJECT_SETTINGS_ACTION);
    }

    public void setEditor(IFieldEditor editor) {
        this.editor = editor;
        editor.addPropertyChangeListener((PropertyChangeListener)this);
        CompositeEditor c = (CompositeEditor)editor;
        List es = c.getEditors();
        this.button = (IFieldEditor)es.get(es.size() - 1);
    }

    public void run() {
        if (this.editor == null) {
            return;
        }
        IProject p = this.getSelectedProject();
        if (p == null) {
            return;
        }
        PreferenceDialog prefsdlg = PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IAdaptable)p, (String)"org.jboss.tools.seam.ui.propertyPages.SeamSettingsPreferencePage", (String[])new String[]{"org.jboss.tools.seam.ui.propertyPages.SeamSettingsPreferencePage"}, null);
        prefsdlg.open();
        Object value = this.editor.getValue();
        this.editor.setValueAsString("");
        this.editor.setValue(value);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled;
        IProject p = this.getSelectedProject();
        boolean bl = enabled = p != null;
        if (this.isEnabled() != enabled) {
            this.setEnabled(enabled);
            this.button.setEnabled(enabled);
        }
    }

    IProject getSelectedProject() {
        String s = this.editor.getValueAsString();
        if (s == null || s.length() == 0) {
            return null;
        }
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(s);
        if (p == null || !p.isAccessible()) {
            return null;
        }
        return p;
    }
}

