/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamResourceVisitor;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.java.JavaScanner;
import org.jboss.tools.seam.internal.core.scanner.lib.LibraryScanner;
import org.jboss.tools.seam.internal.core.scanner.xml.XMLScanner;

public class SeamCoreBuilder
extends IncrementalProjectBuilder {
    public static String BUILDER_ID = "org.jboss.tools.seam.core.seambuilder";
    SeamResourceVisitor resourceVisitor = null;

    SeamProject getSeamProject() {
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return (SeamProject)SeamCorePlugin.getSeamProject(p, false);
    }

    SeamResourceVisitor getResourceVisitor() {
        if (this.resourceVisitor == null) {
            SeamProject p = this.getSeamProject();
            this.resourceVisitor = new SeamResourceVisitor(p);
        }
        return this.resourceVisitor;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        SeamProject sp = this.getSeamProject();
        if (sp == null) {
            return null;
        }
        if (sp.hasNoStorage()) {
            kind = 6;
        }
        long begin = System.currentTimeMillis();
        sp.postponeFiring();
        try {
            sp.resolveStorage(kind != 6);
            if (sp.getClassPath().update()) {
                sp.getClassPath().process();
            } else if (sp.getClassPath().hasToUpdateProjectDependencies()) {
                sp.getClassPath().validateProjectDependencies();
            }
            TypeInfoCollector.cleanCache();
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
            long end = System.currentTimeMillis();
            sp.fullBuildTime += end - begin;
            try {
                sp.store();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError(NLS.bind((String)SeamCoreMessages.SeamCoreBuilder_1, (Object)sp.getProject().getName()), (Throwable)e);
            }
            sp.postBuild();
        }
        finally {
            sp.fireChanges();
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept(this.getResourceVisitor().getVisitor());
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
    }

    public static IFileScanner getXMLScanner() {
        return new XMLScanner();
    }

    public static IFileScanner getJavaScanner() {
        return new JavaScanner();
    }

    public static IFileScanner getLibraryScanner() {
        return new LibraryScanner();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SeamProject sp = this.getSeamProject();
        if (sp != null) {
            sp.clean();
        }
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return SeamCoreBuilder.this.getResourceVisitor().getVisitor().visit(resource);
                }
                case 2: {
                    SeamProject p = SeamCoreBuilder.this.getSeamProject();
                    if (p == null) break;
                    p.pathRemoved(resource.getFullPath());
                    break;
                }
                case 4: {
                    return SeamCoreBuilder.this.getResourceVisitor().getVisitor().visit(resource);
                }
            }
            return true;
        }
    }
}

