/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.project.facet;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamRuntimeListConverter {
    private static final String REGEXP_ESCAPE = "\\";
    private static final String COMMA = ",";
    private static final String EMPTY_STRING = "";
    private static final String FIELD_SEPARATOR = "|";
    private static final String DEFAULT = "default";
    private static final String VERSION = "version";
    private static final String HOME_DIR = "homeDir";
    private static final String NAME = "name";

    public Map<String, SeamRuntime> getMap(String input) {
        HashMap<String, SeamRuntime> result = new HashMap<String, SeamRuntime>();
        if (input == null || EMPTY_STRING.equals(input.trim())) {
            return result;
        }
        StringTokenizer runtimes = new StringTokenizer(input, COMMA);
        while (runtimes.hasMoreTokens()) {
            String runtime = runtimes.nextToken();
            String[] map = runtime.split("\\|");
            SeamRuntime rt = new SeamRuntime();
            int i = 0;
            while (i < map.length) {
                String value;
                String name = map[i];
                String string = value = i + 1 < map.length ? map[i + 1] : EMPTY_STRING;
                if (NAME.equals(name)) {
                    rt.setName(value);
                } else if (HOME_DIR.equals(name)) {
                    rt.setHomeDir(value);
                } else if (VERSION.equals(name)) {
                    rt.setVersion(SeamVersion.parseFromString(value));
                } else if (DEFAULT.equals(name)) {
                    rt.setDefault(Boolean.parseBoolean(value));
                }
                i += 2;
            }
            result.put(rt.getName(), rt);
        }
        return result;
    }

    public String getString(Map<String, SeamRuntime> runtimeMap) {
        StringBuffer buffer = new StringBuffer();
        SeamRuntime[] runtimes = runtimeMap.values().toArray(new SeamRuntime[runtimeMap.size()]);
        int i = 0;
        while (i < runtimes.length) {
            buffer.append(NAME).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getName());
            buffer.append(FIELD_SEPARATOR).append(VERSION).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getVersion().toString());
            buffer.append(FIELD_SEPARATOR).append(HOME_DIR).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getHomeDir());
            buffer.append(FIELD_SEPARATOR).append(DEFAULT).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].isDefault());
            if (i != runtimes.length - 1) {
                buffer.append(COMMA);
            }
            ++i;
        }
        return buffer.toString();
    }
}

