/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.jst.web.model.project.ext.store.XMLStoreHelper;
import org.jboss.tools.seam.core.IOpenableElement;
import org.jboss.tools.seam.core.ISeamDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSeamDeclaration
extends SeamObject
implements ISeamDeclaration,
ITextSourceReference,
IOpenableElement {
    public static final String PATH_OF_NAME = "name";
    protected String name;
    protected Map<String, IValueInfo> attributes = new HashMap<String, IValueInfo>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void open() {
    }

    public int getLength() {
        return 0;
    }

    public int getStartPosition() {
        return 0;
    }

    @Override
    public ITextSourceReference getLocationFor(String path) {
        final IValueInfo valueInfo = this.attributes.get(path);
        ITextSourceReference reference = new ITextSourceReference(){

            public int getLength() {
                return valueInfo != null ? valueInfo.getLength() : 0;
            }

            public int getStartPosition() {
                return valueInfo != null ? valueInfo.getStartPosition() : 0;
            }
        };
        return reference;
    }

    public void addAttribute(String path, IValueInfo value) {
        this.attributes.put(path, value);
    }

    public void setName(IValueInfo value) {
        this.attributes.put(PATH_OF_NAME, value);
        this.name = value == null ? null : value.getValue();
    }

    boolean stringsEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    @Override
    public AbstractSeamDeclaration clone() throws CloneNotSupportedException {
        AbstractSeamDeclaration c = (AbstractSeamDeclaration)super.clone();
        c.attributes = new HashMap<String, IValueInfo>();
        c.attributes.putAll(this.attributes);
        return c;
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List<Change> changes = super.merge(s);
        if (s instanceof AbstractSeamDeclaration) {
            AbstractSeamDeclaration d = (AbstractSeamDeclaration)s;
            this.attributes.clear();
            this.attributes.putAll(d.attributes);
        }
        return changes;
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        XModelObject old = this.pushModelObject(context);
        if (this.name != null) {
            element.setAttribute(PATH_OF_NAME, this.name);
        }
        XMLStoreHelper.saveMap((Element)element, this.attributes, (String)"attributes", (Properties)context);
        this.popModelObject(context, old);
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        XModelObject old = this.pushModelObject(context);
        if (element.hasAttribute(PATH_OF_NAME)) {
            this.name = element.getAttribute(PATH_OF_NAME);
        }
        XMLStoreHelper.loadMap((Element)element, this.attributes, (String)"attributes", (Properties)context);
        this.popModelObject(context, old);
    }

    protected XModelObject pushModelObject(Properties context) {
        XModelObject old = (XModelObject)context.get("model-object");
        if (this.id instanceof XModelObject) {
            context.put("model-object", this.id);
        }
        return old;
    }

    protected void popModelObject(Properties context, XModelObject old) {
        if (old != null) {
            context.put("model-object", old);
        } else {
            context.remove("model-object");
        }
    }

    @Override
    public Object getAdapter(Class cls) {
        IResource r;
        if (cls == IFile.class) {
            IFile f;
            if (this.getResource() instanceof IFile && (f = (IFile)this.getResource()) != null && f.exists()) {
                return f;
            }
        } else if (cls == IResource.class && (r = this.getResource()) != null && r.exists()) {
            return r;
        }
        return null;
    }
}

