/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.internal.core.AbstractContextVariable;
import org.jboss.tools.seam.internal.core.SeamJavaContextVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BijectedAttribute
extends SeamJavaContextVariable
implements IBijectedAttribute {
    protected BijectedAttributeType[] types = null;

    @Override
    public BijectedAttributeType[] getTypes() {
        return this.types;
    }

    @Override
    public boolean isOfType(BijectedAttributeType type) {
        if (this.types == null) {
            return false;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i] == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isContextVariable() {
        if (this.types == null || this.types.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].isOut()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTypes(BijectedAttributeType[] types) {
        this.types = types;
    }

    @Override
    public String getValue() {
        return this.getName();
    }

    public void setValue(String value) {
    }

    public void setValue(IValueInfo value) {
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        AbstractContextVariable f = (AbstractContextVariable)s;
        if (f instanceof BijectedAttribute) {
            BijectedAttribute sf = (BijectedAttribute)f;
            if (!this.typesAreEqual(this.types, sf.types)) {
                changes = Change.addChange(changes, (Change)new Change((Object)this, "types", (Object)this.types, (Object)sf.types));
                this.types = sf.types;
            }
        }
        return changes;
    }

    boolean typesAreEqual(BijectedAttributeType[] types1, BijectedAttributeType[] types2) {
        if (types1 == null || types2 == null) {
            return types2 == types1;
        }
        if (types1.length != types2.length) {
            return false;
        }
        int i = 0;
        while (i < types1.length) {
            if (types1[i] != types2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public BijectedAttribute clone() throws CloneNotSupportedException {
        BijectedAttribute c = (BijectedAttribute)super.clone();
        return c;
    }

    @Override
    public String getXMLName() {
        return "bijected-attribute";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.types != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.types.length) {
                sb.append(this.types[i].toString()).append(';');
                ++i;
            }
            element.setAttribute("attr-types", sb.toString());
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        String v;
        super.loadXML(element, context);
        if (element.hasAttribute("attr-types") && (v = element.getAttribute("attr-types")) != null && v.length() > 0) {
            String[] cs = v.split(";");
            ArrayList<BijectedAttributeType> list = new ArrayList<BijectedAttributeType>();
            int i = 0;
            while (i < cs.length) {
                list.add(BijectedAttributeType.valueOf(cs[i]));
                ++i;
            }
            this.types = list.toArray(new BijectedAttributeType[0]);
        }
    }
}

