/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamPackage;
import org.jboss.tools.seam.core.ISeamPropertiesDeclaration;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamPackage;
import org.jboss.tools.seam.internal.core.SeamPackageUtil;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamComponent
extends SeamObject
implements ISeamComponent {
    protected String name = null;
    Set<ISeamComponentDeclaration> allDeclarations = new HashSet<ISeamComponentDeclaration>();
    Set<ISeamJavaComponentDeclaration> javaDeclarations = new HashSet<ISeamJavaComponentDeclaration>();
    Set<ISeamXmlComponentDeclaration> xmlDeclarations = new HashSet<ISeamXmlComponentDeclaration>();
    Set<ISeamPropertiesDeclaration> propertyDeclarations = new HashSet<ISeamPropertiesDeclaration>();
    SeamPackage projectPackage = null;
    SeamPackage scopePackage = null;
    static Set<ISeamComponentMethod> EMPTY = new HashSet<ISeamComponentMethod>();

    @Override
    public Set<IBijectedAttribute> getBijectedAttributes() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration == null ? null : javaDeclaration.getBijectedAttributes();
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributesByName(String name) {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration == null ? null : javaDeclaration.getBijectedAttributesByName(name);
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributesByType(BijectedAttributeType type) {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration == null ? null : javaDeclaration.getBijectedAttributesByType(type);
    }

    @Override
    public String getClassName() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        if (javaDeclaration != null) {
            return javaDeclaration.getClassName();
        }
        Set<ISeamXmlComponentDeclaration> xml = this.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration d : xml) {
            if (d.getClassName() == null || d.getClassName().length() <= 0) continue;
            return d.getClassName();
        }
        return null;
    }

    @Override
    public ITextSourceReference getLocationFor(String path) {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        if (javaDeclaration != null) {
            return javaDeclaration.getLocationFor(path);
        }
        Set<ISeamXmlComponentDeclaration> xml = this.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration d : xml) {
            if (d.getLocationFor(path) == null) continue;
            return d.getLocationFor(path);
        }
        return null;
    }

    @Override
    public int getPrecedence() {
        Set<ISeamXmlComponentDeclaration> xml = this.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration d : xml) {
            String s = d.getPrecedence();
            if (s == null || s.length() == 0) continue;
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (xml.size() > 0) {
            return 20;
        }
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        if (javaDeclaration != null) {
            return javaDeclaration.getPrecedence();
        }
        return 20;
    }

    @Override
    public Set<ISeamComponentMethod> getMethods() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration == null ? EMPTY : javaDeclaration.getMethods();
    }

    @Override
    public Set<ISeamComponentMethod> getMethodsByType(SeamComponentMethodType type) {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration == null ? null : javaDeclaration.getMethodsByType(type);
    }

    @Override
    public Set<IRole> getRoles() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration == null ? null : javaDeclaration.getRoles();
    }

    @Override
    public boolean isEntity() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration != null && javaDeclaration.isEntity();
    }

    @Override
    public boolean isStateful() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration != null && javaDeclaration.isStateful();
    }

    @Override
    public boolean isStateless() {
        ISeamJavaComponentDeclaration javaDeclaration = this.getJavaDeclaration();
        return javaDeclaration != null && javaDeclaration.isStateless();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ScopeType getScope() {
        ISeamJavaComponentDeclaration java;
        ScopeType scopeType = null;
        for (ISeamXmlComponentDeclaration d : this.xmlDeclarations) {
            String s = d.getScopeAsString();
            if (s != null && s.length() > 0) {
                scopeType = d.getScope();
            }
            if (scopeType != null && scopeType != ScopeType.UNSPECIFIED) break;
        }
        if ((scopeType == null || scopeType == ScopeType.UNSPECIFIED) && (java = this.getJavaDeclaration()) != null) {
            scopeType = java.getScope();
        }
        if (scopeType == null) {
            scopeType = ScopeType.UNSPECIFIED;
        }
        return scopeType;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setScope(ScopeType type) {
    }

    @Override
    public List<ISeamProperty> getProperties(String propertyName) {
        ArrayList<ISeamProperty> list = new ArrayList<ISeamProperty>();
        Collection<ISeamProperty> ps = this.getProperties();
        for (ISeamProperty p : ps) {
            if (!propertyName.equals(p.getName())) continue;
            list.add(p);
        }
        return list;
    }

    @Override
    public Collection<ISeamProperty> getProperties() {
        HashSet<ISeamProperty> ps = new HashSet<ISeamProperty>();
        Set<ISeamXmlComponentDeclaration> xml = this.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration d : xml) {
            ps.addAll(d.getProperties());
        }
        Set<ISeamPropertiesDeclaration> pd = this.getPropertiesDeclarations();
        for (ISeamPropertiesDeclaration d : pd) {
            ps.addAll(d.getProperties());
        }
        return ps;
    }

    @Override
    public Set<ISeamComponentDeclaration> getAllDeclarations() {
        return this.allDeclarations;
    }

    @Override
    public ISeamJavaComponentDeclaration getJavaDeclaration() {
        if (this.javaDeclarations.isEmpty()) {
            return null;
        }
        return this.javaDeclarations.iterator().next();
    }

    @Override
    public Set<ISeamPropertiesDeclaration> getPropertiesDeclarations() {
        return this.propertyDeclarations;
    }

    @Override
    public Set<ISeamXmlComponentDeclaration> getXmlDeclarations() {
        return this.xmlDeclarations;
    }

    public void addDeclaration(ISeamComponentDeclaration declaration) {
        if (this.allDeclarations.contains(declaration)) {
            return;
        }
        this.allDeclarations.add(declaration);
        if (this.name.equals(declaration.getName())) {
            this.adopt(declaration);
        }
        if (declaration instanceof ISeamJavaComponentDeclaration) {
            this.javaDeclarations.add((ISeamJavaComponentDeclaration)declaration);
        } else if (declaration instanceof ISeamXmlComponentDeclaration) {
            this.xmlDeclarations.add((ISeamXmlComponentDeclaration)declaration);
        } else if (declaration instanceof ISeamPropertiesDeclaration) {
            this.propertyDeclarations.add((ISeamPropertiesDeclaration)declaration);
        }
        ((SeamComponentDeclaration)declaration).bindToComponent(this);
    }

    public void removeDeclaration(ISeamComponentDeclaration declaration) {
        if (!this.allDeclarations.contains(declaration)) {
            return;
        }
        this.allDeclarations.remove(declaration);
        if (declaration instanceof ISeamJavaComponentDeclaration) {
            this.javaDeclarations.remove(declaration);
        } else if (declaration instanceof ISeamXmlComponentDeclaration) {
            this.xmlDeclarations.remove(declaration);
        } else if (declaration instanceof ISeamPropertiesDeclaration) {
            this.propertyDeclarations.remove(declaration);
        }
        ((SeamComponentDeclaration)declaration).unbindFromComponent(this);
    }

    public String toString() {
        return "SeamComponent: " + this.getName();
    }

    @Override
    public SeamComponent clone() throws CloneNotSupportedException {
        return this;
    }

    public void setProjectPackage(SeamPackage p) {
        this.projectPackage = p;
    }

    public void setScopePackage(SeamPackage p) {
        this.scopePackage = p;
    }

    public List<Change> removeFromModel(List<Change> changes) {
        SeamScope pc = (SeamScope)this.getParent();
        if (pc != null) {
            pc.removeComponent(this);
            changes = Change.addChange(changes, (Change)new Change((Object)pc, null, (Object)this, null));
        }
        if (this.scopePackage != null) {
            this.removeFrom(this.scopePackage);
            changes = Change.addChange((List)changes, (Change)new Change((Object)this.scopePackage, null, (Object)this, null));
            this.scopePackage = null;
        }
        if (this.projectPackage != null) {
            this.removeFrom(this.projectPackage);
            changes = Change.addChange((List)changes, (Change)new Change((Object)this.projectPackage, null, (Object)this, null));
            this.projectPackage = null;
        }
        return changes;
    }

    public List<Change> revalidate(List<Change> changes) {
        SeamScope pn;
        SeamScope pc = (SeamScope)this.getParent();
        if (pc != (pn = (SeamScope)this.getSeamProject().getScope(this.getScope()))) {
            if (pc != null) {
                pc.removeComponent(this);
                changes = Change.addChange(changes, (Change)new Change((Object)pc, null, (Object)this, null));
            }
            this.setParent(pn);
            pn.addComponent(this);
            changes = Change.addChange((List)changes, (Change)new Change((Object)pn, null, null, (Object)this));
            if (this.scopePackage != null) {
                this.removeFrom(this.scopePackage);
                changes = Change.addChange((List)changes, (Change)new Change((Object)this.scopePackage, null, (Object)this, null));
                this.scopePackage = null;
            }
        }
        if (this.scopePackage != null && !this.scopePackage.getQualifiedName().equals(SeamPackageUtil.getPackageName(this))) {
            this.removeFrom(this.scopePackage);
            changes = Change.addChange((List)changes, (Change)new Change((Object)this.scopePackage, null, (Object)this, null));
            this.scopePackage = null;
        }
        if (this.scopePackage == null) {
            pn.validatePackage(this);
        }
        if (this.projectPackage != null && !this.projectPackage.getQualifiedName().equals(SeamPackageUtil.getPackageName(this))) {
            this.removeFrom(this.projectPackage);
            changes = Change.addChange((List)changes, (Change)new Change((Object)this.projectPackage, null, (Object)this, null));
            this.projectPackage = null;
        }
        if (this.projectPackage == null) {
            ((SeamProject)this.getSeamProject()).validatePackage(this);
        }
        return changes;
    }

    private void removeFrom(ISeamPackage p) {
        p.getComponents().remove(this);
        while (p != null && p.getComponents().size() + p.getPackages().size() == 0) {
            ISeamElement o = p.getParent();
            if (o instanceof ISeamPackage) {
                ISeamPackage q = (ISeamPackage)o;
                q.getPackages().remove(p);
                p = q;
                continue;
            }
            if (o instanceof SeamScope) {
                SeamScope s = (SeamScope)o;
                s.removePackage(p);
                p = null;
                continue;
            }
            if (!(o instanceof SeamProject)) continue;
            SeamProject project = (SeamProject)o;
            project.removePackage(p);
            p = null;
        }
    }
}

