/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.model.project.ext.store.XMLStoreHelper;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.AbstractContextVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeamJavaContextVariable
extends AbstractContextVariable
implements IJavaSourceReference {
    protected IMember javaSource = null;
    static String TAG_JAVA_SOURCE = "java-source";

    public IMember getSourceMember() {
        return this.javaSource;
    }

    public void setSourceMember(IMember javaSource) {
        this.javaSource = javaSource;
    }

    @Override
    public int getLength() {
        block4: {
            if (this.javaSource == null) {
                return 0;
            }
            try {
                if (this.javaSource.getSourceRange() != null) break block4;
                return 0;
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        return this.javaSource.getSourceRange().getLength();
    }

    @Override
    public IResource getResource() {
        return this.javaSource == null || this.javaSource.getTypeRoot().getResource() == null ? super.getResource() : this.javaSource.getTypeRoot().getResource();
    }

    @Override
    public int getStartPosition() {
        block4: {
            if (this.javaSource == null) {
                return 0;
            }
            try {
                if (this.javaSource.getSourceRange() != null) break block4;
                return 0;
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        return this.javaSource.getSourceRange().getOffset();
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List<Change> changes = super.merge(s);
        if (s instanceof SeamJavaContextVariable) {
            SeamJavaContextVariable sf = (SeamJavaContextVariable)s;
            this.javaSource = sf.javaSource;
            this.resource = sf.resource;
        }
        return changes;
    }

    @Override
    public SeamJavaContextVariable clone() throws CloneNotSupportedException {
        SeamJavaContextVariable c = (SeamJavaContextVariable)super.clone();
        return c;
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.javaSource instanceof IField) {
            XMLStoreHelper.saveField((Element)element, (IField)((IField)this.javaSource), (String)TAG_JAVA_SOURCE, (Properties)context);
        } else if (this.javaSource instanceof IMethod) {
            XMLStoreHelper.saveMethod((Element)element, (IMethod)((IMethod)this.javaSource), (String)TAG_JAVA_SOURCE, (Properties)context);
        } else if (this.javaSource instanceof IType) {
            Element ce = XMLUtilities.createElement((Element)element, (String)TAG_JAVA_SOURCE);
            ce.setAttribute("class", "type");
            XMLStoreHelper.saveType((Element)ce, (IType)((IType)this.javaSource), (Properties)context);
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        Element c = XMLUtilities.getUniqueChild((Element)element, (String)TAG_JAVA_SOURCE);
        if (c != null) {
            String cls = c.getAttribute("class");
            if ("field".equals(cls)) {
                this.javaSource = XMLStoreHelper.loadField((Element)c, (Properties)context);
            } else if ("method".equals(cls)) {
                this.javaSource = XMLStoreHelper.loadMethod((Element)c, (Properties)context);
            } else if ("type".equals(cls)) {
                this.javaSource = XMLStoreHelper.loadType((Element)c, (Properties)context);
            }
        }
    }

    @Override
    public void open() {
        if (this.javaSource == null) {
            return;
        }
        if (!this.javaSource.exists()) {
            ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
            d.showDialog("Warning", "Member " + this.javaSource.getElementName() + " does not exist.", new String[]{SpecialWizardSupport.OK}, null, 2);
            return;
        }
        try {
            JavaUI.openInEditor((IJavaElement)this.javaSource);
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

