/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamValue;
import org.jboss.tools.seam.core.event.ISeamValueList;
import org.jboss.tools.seam.core.event.ISeamValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamMessagesLoader {
    static Map<String, IResource> EMPTY = new HashMap<String, IResource>();
    Map<String, IResource> resources = EMPTY;
    Map<String, Long> timestamps = null;
    Set<String> keys = null;
    ISeamElement object;
    String resourceComponent;

    public SeamMessagesLoader(ISeamElement object, String resourceComponent) {
        this.object = object;
        this.resourceComponent = resourceComponent;
    }

    public void revalidate() {
        Map<String, IResource> resources2 = this.getResources();
        if (this.changed(resources2)) {
            this.timestamps = new HashMap<String, Long>();
            for (String n : resources2.keySet()) {
                IResource r = resources2.get(n);
                this.timestamps.put(n, r.getLocalTimeStamp());
            }
            this.resources = resources2;
            this.keys = null;
        }
    }

    private boolean changed(Map<String, IResource> resources2) {
        if (this.resources == resources2) {
            return false;
        }
        if (resources2.size() != this.resources.size()) {
            return true;
        }
        if (this.timestamps == null) {
            return true;
        }
        for (String s : resources2.keySet()) {
            IResource r2 = resources2.get(s);
            IResource r1 = this.resources.get(s);
            if (r1 == null || !r2.equals((Object)r1)) {
                return true;
            }
            long l1 = r1.getLocalTimeStamp();
            Long l2 = this.timestamps.get(s);
            if (l2 != null && l1 == l2) continue;
            return true;
        }
        return false;
    }

    public Map<String, IResource> getResources() {
        ISeamProject p = this.object.getSeamProject();
        if (p == null) {
            return EMPTY;
        }
        IResource[] srcs = EclipseResourceUtil.getJavaSourceRoots((IProject)p.getProject());
        ISeamComponent c = p.getComponent(this.resourceComponent);
        if (c == null) {
            return EMPTY;
        }
        ArrayList<String> names = new ArrayList<String>();
        Set<ISeamXmlComponentDeclaration> ds = c.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration d : ds) {
            String b;
            ISeamValueString s;
            ISeamValue v;
            ISeamProperty property = d.getProperty("bundleNames");
            if (property == null || (v = property.getValue()) == null) continue;
            if (v instanceof ISeamValueList) {
                List<ISeamValueString> vs = ((ISeamValueList)v).getValues();
                for (ISeamValueString s2 : vs) {
                    if (s2.getValue() == null) continue;
                    String b2 = s2.getValue().getValue();
                    names.add(b2);
                }
                continue;
            }
            if (!(v instanceof ISeamValueString) || (s = (ISeamValueString)v).getValue() == null || (b = s.getValue().getValue()) == null || b.length() == 0) continue;
            String[] bi = b.split(",");
            int i = 0;
            while (i < bi.length) {
                names.add(bi[i].trim());
                ++i;
            }
        }
        if (ds.isEmpty()) {
            names.add("messages");
        }
        return this.getResources(names, srcs);
    }

    public Collection<ISeamProperty> getProperties() {
        throw new IllegalStateException("Not implemented");
    }

    public Collection<String> getPropertyNames() {
        if (this.keys == null) {
            this.keys = new HashSet<String>();
            for (IResource r : this.resources.values()) {
                Properties properties;
                block17: {
                    IPath p = r.getLocation();
                    if (p == null) continue;
                    File f = p.toFile();
                    properties = new Properties();
                    FileInputStream is = null;
                    try {
                        try {
                            is = new FileInputStream(f);
                            properties.load(is);
                        }
                        catch (IOException iOException) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                Set<Object> s = properties.keySet();
                for (Object o : s) {
                    this.keys.add((String)o);
                }
            }
        }
        return this.keys;
    }

    private Map<String, IResource> getResources(List<String> names, IResource[] srcs) {
        HashMap<String, IResource> rs = new HashMap<String, IResource>();
        for (String name : names) {
            String p;
            String n = name.replace('.', '/');
            int k = n.lastIndexOf(47);
            String string = p = k < 0 ? null : n.substring(0, k);
            if (k >= 0) {
                n = n.substring(k + 1);
            }
            IResource result = null;
            int j = 0;
            while (j < srcs.length && result == null) {
                result = this.find(p, n, srcs[j]);
                ++j;
            }
            if (result == null) continue;
            rs.put(name, result);
        }
        return rs;
    }

    private IResource find(String pack, String name, IResource src) {
        if (!(src instanceof IContainer)) {
            return null;
        }
        IContainer c = (IContainer)src;
        if (pack != null) {
            c = c.getFolder((IPath)new Path(pack));
        }
        if (c == null || !c.exists()) {
            return null;
        }
        String suffix = ".properties";
        String name_ = String.valueOf(name) + "_";
        String name_p = String.valueOf(name) + suffix;
        IResource result = null;
        try {
            IResource[] rs = c.members();
            int i = 0;
            while (i < rs.length) {
                String n = rs[i].getName();
                if (name_p.equals(n)) {
                    return rs[i];
                }
                if (result == null && n.startsWith(name_) && n.endsWith(suffix)) {
                    result = rs[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return result;
    }
}

