/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.core.ISeamNamespace;
import org.w3c.dom.Element;

public class SeamNamespace
implements ISeamNamespace {
    static String ATTR_URI = "uri";
    static String ATTR_PACKAGE = "package";
    protected IPath source;
    protected String uri;
    protected String javaPackage;

    public IPath getSourcePath() {
        return this.source;
    }

    public String getURI() {
        return this.uri;
    }

    public String getPackage() {
        return this.javaPackage;
    }

    public void setSourcePath(IPath source) {
        this.source = source;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setPackage(String javaPackage) {
        this.javaPackage = javaPackage;
    }

    public Element toXML(Element parent) {
        Element element = XMLUtilities.createElement((Element)parent, (String)"namespace");
        if (this.source != null) {
            element.setAttribute("path", this.source.toString());
        }
        if (this.uri != null) {
            element.setAttribute(ATTR_URI, this.uri);
        }
        if (this.javaPackage != null) {
            element.setAttribute(ATTR_PACKAGE, this.javaPackage);
        }
        return element;
    }

    public void loadXML(Element element) {
        String s = element.getAttribute("path");
        if (s != null && s.length() > 0) {
            this.source = new Path(s);
        }
        this.uri = element.getAttribute(ATTR_URI);
        this.javaPackage = element.getAttribute(ATTR_PACKAGE);
    }
}

