/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamPackage;
import org.jboss.tools.seam.internal.core.SeamComponent;
import org.jboss.tools.seam.internal.core.SeamPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamPackageUtil {
    public static List<Change> revalidatePackages(ISeamElement parent, Map<String, SeamComponent> allComponents, Collection<ISeamComponent> components, Map<String, ISeamPackage> packages) {
        List<Change> changes = null;
        changes = SeamPackageUtil.checkPackages(allComponents, packages, changes);
        changes = SeamPackageUtil.fillPackages(parent, packages, components, changes);
        changes = SeamPackageUtil.cleanPackages(parent, packages, changes);
        return changes;
    }

    static List<Change> checkPackages(Map<String, SeamComponent> allComponents, Map<String, ISeamPackage> packages, List<Change> changes) {
        for (ISeamPackage p : packages.values()) {
            Iterator<ISeamComponent> cs = p.getComponents().iterator();
            while (cs.hasNext()) {
                ISeamComponent c = cs.next();
                String pkg = SeamPackageUtil.getPackageName(c);
                if (allComponents.get(c.getName()) != null && p.getQualifiedName().equals(pkg)) continue;
                cs.remove();
                changes = Change.addChange(changes, (Change)new Change((Object)p, null, (Object)c, null));
            }
            changes = SeamPackageUtil.checkPackages(allComponents, p.getPackages(), changes);
        }
        return changes;
    }

    static List<Change> fillPackages(ISeamElement parent, Map<String, ISeamPackage> packages, Collection<ISeamComponent> components, List<Change> changes) {
        for (ISeamComponent c : components) {
            String pkg = SeamPackageUtil.getPackageName(c);
            ISeamPackage p = SeamPackageUtil.findOrCreatePackage(parent, packages, pkg);
            if (p.getComponents().contains(c)) continue;
            p.getComponents().add(c);
            changes = Change.addChange(changes, (Change)new Change((Object)p, null, null, (Object)c));
        }
        return changes;
    }

    static List<Change> cleanPackages(ISeamElement parent, Map<String, ISeamPackage> packages, List<Change> changes) {
        Iterator<String> ps = packages.keySet().iterator();
        while (ps.hasNext()) {
            ISeamPackage p = packages.get(ps.next());
            changes = SeamPackageUtil.cleanPackages(p, p.getPackages(), changes);
            if (p.getComponents().size() != 0 || p.getPackages().size() != 0) continue;
            ps.remove();
            changes = Change.addChange(changes, (Change)new Change((Object)parent, null, (Object)p, null));
        }
        return changes;
    }

    static String getPackageName(ISeamComponent c) {
        String cls = c.getName();
        if (cls == null || cls.length() == 0) {
            return "(unspecified)";
        }
        if (cls.startsWith("${") || cls.startsWith("#{")) {
            return "(specified with EL)";
        }
        int d = cls.lastIndexOf(46);
        return d < 0 ? "(default package)" : cls.substring(0, d);
    }

    static ISeamPackage findPackage(ISeamElement parent, Map<String, ISeamPackage> packages, String qualifiedName) {
        return SeamPackageUtil.findOrCreatePackage(parent, packages, qualifiedName, false);
    }

    static ISeamPackage findOrCreatePackage(ISeamElement parent, Map<String, ISeamPackage> packages, String qualifiedName) {
        return SeamPackageUtil.findOrCreatePackage(parent, packages, qualifiedName, true);
    }

    static ISeamPackage findOrCreatePackage(ISeamElement parent, Map<String, ISeamPackage> packages, String qualifiedName, boolean create) {
        int i = qualifiedName.indexOf(46);
        String firstName = i < 0 ? qualifiedName : qualifiedName.substring(0, i);
        String tail = i < 0 ? null : qualifiedName.substring(i + 1);
        ISeamPackage p = packages.get(firstName);
        if (p == null) {
            if (!create) {
                return null;
            }
            SeamPackage pi = new SeamPackage(firstName);
            pi.setParent(parent);
            pi.setSourcePath(parent.getSourcePath());
            p = pi;
            packages.put(firstName, pi);
        }
        return tail != null ? SeamPackageUtil.findOrCreatePackage(p, p.getPackages(), tail) : p;
    }

    public static void collectAllPackages(Map<String, ISeamPackage> packages, Collection<ISeamPackage> list) {
        for (ISeamPackage p : packages.values()) {
            if (!p.getComponents().isEmpty()) {
                list.add(p);
            }
            SeamPackageUtil.collectAllPackages(p.getPackages(), list);
        }
    }
}

