/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.internal.validation.ProjectValidationContext;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamNamespace;
import org.jboss.tools.seam.core.ISeamPackage;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamScope;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamCoreBuilder;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamProjectChangeListener;
import org.jboss.tools.seam.core.event.SeamProjectChangeEvent;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.internal.core.AbstractContextVariable;
import org.jboss.tools.seam.internal.core.AbstractSeamDeclaration;
import org.jboss.tools.seam.internal.core.SeamAnnotatedFactory;
import org.jboss.tools.seam.internal.core.SeamComponent;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamContextShortVariable;
import org.jboss.tools.seam.internal.core.SeamJavaComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamMessages;
import org.jboss.tools.seam.internal.core.SeamMessagesComponent;
import org.jboss.tools.seam.internal.core.SeamNamespace;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamPackage;
import org.jboss.tools.seam.internal.core.SeamPackageUtil;
import org.jboss.tools.seam.internal.core.SeamPropertiesDeclaration;
import org.jboss.tools.seam.internal.core.SeamResourceVisitor;
import org.jboss.tools.seam.internal.core.SeamScope;
import org.jboss.tools.seam.internal.core.SeamXmlComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamXmlFactory;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.lib.ClassPath;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamProject
extends SeamObject
implements ISeamProject,
IProjectNature {
    IProject project;
    ClassPath classPath = new ClassPath(this);
    Set<IPath> sourcePaths = new HashSet<IPath>();
    Map<IPath, LoadedDeclarations> sourcePaths2 = new HashMap<IPath, LoadedDeclarations>();
    private boolean isStorageResolved = false;
    SeamScope[] scopes = new SeamScope[ScopeType.values().length];
    Map<ScopeType, SeamScope> scopesMap = new HashMap<ScopeType, SeamScope>();
    Set<SeamProject> dependsOn = new HashSet<SeamProject>();
    Set<SeamProject> usedBy = new HashSet<SeamProject>();
    Map<String, List<String>> imports = new HashMap<String, List<String>>();
    NamespaceStorage namespaces;
    ComponentStorage components;
    FactoryStorage factories;
    VariablesStorage variables;
    Map<String, ISeamPackage> packages;
    List<ISeamProjectChangeListener> listeners;
    ProjectValidationContext validationContext;
    IEclipsePreferences preferences;
    public long fullBuildTime;
    public List<Long> statistics;
    public static String MESSAGES_COMPONENT_NAME = "org.jboss.seam.core.messages";
    List<Change> postponedChanges;
    static String EXTERNAL_TOOL_BUILDER = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";

    public SeamProject() {
        this.createScopes();
        this.namespaces = new NamespaceStorage();
        this.components = new ComponentStorage();
        this.factories = new FactoryStorage();
        this.variables = new VariablesStorage();
        this.packages = new HashMap<String, ISeamPackage>();
        this.listeners = new ArrayList<ISeamProjectChangeListener>();
        this.preferences = null;
        this.postponedChanges = null;
    }

    public void configure() throws CoreException {
        this.addToBuildSpec(SeamCoreBuilder.BUILDER_ID);
        DesignTimeApplicationManager dtAppManager = DesignTimeApplicationManager.getInstance((IProject)this.project);
        if (dtAppManager != null) {
            dtAppManager.setVariableResolverProvider("org.jboss.tools.seam.el.variableresolver");
        }
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(SeamCoreBuilder.BUILDER_ID);
        DesignTimeApplicationManager dtAppManager = DesignTimeApplicationManager.getInstance((IProject)this.project);
        if (dtAppManager != null) {
            dtAppManager.setVariableResolverProvider(null);
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getRuntimeName() {
        IEclipsePreferences p = this.getSeamPreferences();
        return p.get("seam.runtime.name", null);
    }

    @Override
    public SeamRuntime getRuntime() {
        String parent = this.getParentProjectName();
        if (parent != null) {
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(parent);
            if (p == null || !p.isAccessible()) {
                return null;
            }
            ISeamProject sp = SeamCorePlugin.getSeamProject(p, false);
            return sp == null ? null : sp.getRuntime();
        }
        String runtimeName = this.getRuntimeName();
        return runtimeName == null ? null : SeamRuntimeManager.getInstance().findRuntimeByName(runtimeName);
    }

    @Override
    public String getParentProjectName() {
        IEclipsePreferences p = this.getSeamPreferences();
        return p == null ? null : p.get("seam.parent.project", null);
    }

    @Override
    public ISeamProject getParentProject() {
        String n = this.getParentProjectName();
        if (n == null || n.length() == 0) {
            return null;
        }
        IProject parent = ResourcesPlugin.getWorkspace().getRoot().getProject(n);
        return n == null ? null : SeamCorePlugin.getSeamProject(parent, true);
    }

    @Override
    public void setRuntimeName(String runtimeName) {
        boolean changed;
        IEclipsePreferences prefs = this.getSeamPreferences();
        String storedRuntimeName = this.getRuntimeName();
        boolean bl = storedRuntimeName == null ? runtimeName != null : (changed = !storedRuntimeName.equals(runtimeName));
        if (!changed) {
            return;
        }
        if (runtimeName == null) {
            prefs.remove("seam.runtime.name");
        } else {
            prefs.put("seam.runtime.name", runtimeName);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    @Override
    public ISeamScope[] getScopes() {
        return this.scopes;
    }

    @Override
    public SeamScope getScope(ScopeType scopeType) {
        return this.scopesMap.get(scopeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ISeamPackage> getPackages() {
        Map<String, ISeamPackage> map = this.packages;
        synchronized (map) {
            return this.packages.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(ISeamPackage p) {
        Map<String, ISeamPackage> map = this.packages;
        synchronized (map) {
            this.packages.remove(p.getName());
        }
    }

    @Override
    public Collection<ISeamPackage> getAllPackages() {
        ArrayList<ISeamPackage> list = new ArrayList<ISeamPackage>();
        SeamPackageUtil.collectAllPackages(this.packages, list);
        return list;
    }

    @Override
    public ISeamPackage getPackage(ISeamComponent c) {
        String pkg = SeamPackageUtil.getPackageName(c);
        return SeamPackageUtil.findPackage(this, this.packages, pkg);
    }

    @Override
    public ISeamProject getSeamProject() {
        return this;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.setSourcePath(project.getFullPath());
        this.resource = project;
        this.classPath.init();
    }

    public IEclipsePreferences getSeamPreferences() {
        if (this.preferences == null) {
            ProjectScope projectScope = new ProjectScope(this.project);
            this.preferences = projectScope.getNode("org.jboss.tools.seam.core");
        }
        return this.preferences;
    }

    public void addSeamProject(SeamProject p) {
        if (this.dependsOn.contains(p)) {
            return;
        }
        this.dependsOn.add(p);
        p.addDependentSeamProject(this);
        if (!p.isStorageResolved) {
            p.resolve();
        } else {
            Map<IPath, LoadedDeclarations> map = null;
            try {
                map = p.getAllDeclarations();
            }
            catch (CloneNotSupportedException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            for (IPath source : map.keySet()) {
                LoadedDeclarations ds = map.get(source);
                this.registerComponents(ds, source);
            }
        }
    }

    public Set<SeamProject> getSeamProjects() {
        return this.dependsOn;
    }

    public void addDependentSeamProject(SeamProject p) {
        this.usedBy.add(p);
    }

    @Override
    public Map<String, Set<ISeamNamespace>> getNamespaces() {
        return this.namespaces.namespacesByURI;
    }

    public void removeSeamProject(SeamProject p) {
        if (!this.dependsOn.contains(p)) {
            return;
        }
        p.usedBy.remove(this);
        this.dependsOn.remove(p);
        IPath[] ps = this.sourcePaths2.keySet().toArray(new IPath[0]);
        int i = 0;
        while (i < ps.length) {
            IPath pth = ps[i];
            if (p.getSourcePath().isPrefixOf(pth) || p.isPathLoaded(pth) && !EclipseResourceUtil.isJar((String)pth.toString())) {
                this.pathRemoved(pth);
            }
            ++i;
        }
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public void resolveStorage(boolean load) {
        if (this.isStorageResolved) {
            return;
        }
        if (load) {
            this.load();
        } else {
            this.isStorageResolved = true;
        }
    }

    @Override
    public void resolve() {
        this.resolveStorage(true);
    }

    public void load() {
        if (this.isStorageResolved) {
            return;
        }
        this.isStorageResolved = true;
        this.postponeFiring();
        try {
            boolean b = this.getClassPath().update();
            if (b) {
                this.getClassPath().validateProjectDependencies();
            }
            File file = this.getStorageFile();
            Element root = null;
            if (file != null && file.isFile() && (root = XMLUtilities.getElement((File)file, null)) != null) {
                this.loadProjectDependencies(root);
                this.loadNamespaces(root);
                if (XMLUtilities.getUniqueChild((Element)root, (String)"paths") != null) {
                    this.loadSourcePaths2(root);
                } else {
                    this.loadSourcePaths(root);
                }
            }
            if (b) {
                this.getClassPath().process();
            }
            if (root != null) {
                this.getValidationContext().load(root);
            }
        }
        finally {
            this.fireChanges();
        }
    }

    public void clean() {
        File file = this.getStorageFile();
        if (file != null && file.isFile()) {
            file.delete();
        }
        this.classPath.clean();
        this.postponeFiring();
        IPath[] ps = this.sourcePaths2.keySet().toArray(new IPath[0]);
        int i = 0;
        while (i < ps.length) {
            this.pathRemoved(ps[i]);
            ++i;
        }
        this.packages.clear();
        this.createScopes();
        this.fireChanges();
    }

    public long reload() {
        this.statistics = new ArrayList<Long>();
        this.classPath = new ClassPath(this);
        this.sourcePaths.clear();
        this.sourcePaths2.clear();
        this.isStorageResolved = false;
        this.dependsOn.clear();
        this.usedBy.clear();
        this.namespaces.clear();
        this.components.clear();
        this.factories.clear();
        this.variables.clear();
        this.imports.clear();
        this.packages.clear();
        this.createScopes();
        long begin = System.currentTimeMillis();
        this.classPath.init();
        this.resolve();
        long end = System.currentTimeMillis();
        return end - begin;
    }

    private void createScopes() {
        ScopeType[] types = ScopeType.values();
        int i = 0;
        while (i < this.scopes.length) {
            this.scopes[i] = new SeamScope(this, types[i]);
            this.scopesMap.put(types[i], this.scopes[i]);
            ++i;
        }
    }

    public void store() throws IOException {
        File file = this.getStorageFile();
        file.getParentFile().mkdirs();
        Element root = XMLUtilities.createDocumentElement((String)"seam-project");
        this.storeProjectDependencies(root);
        this.storeNamespaces(root);
        this.storeSourcePaths2(root);
        if (this.validationContext != null) {
            this.validationContext.store(root);
        }
        XMLUtilities.serialize((Element)root, (String)file.getAbsolutePath());
    }

    private void storeNamespaces(Element root) {
        Element namespacesElement = XMLUtilities.createElement((Element)root, (String)"namespaces");
        for (String uri : this.namespaces.namespacesByURI.keySet()) {
            Set<ISeamNamespace> s = this.namespaces.namespacesByURI.get(uri);
            for (ISeamNamespace n : s) {
                ((SeamNamespace)n).toXML(namespacesElement);
            }
        }
    }

    private void storeSourcePaths2(Element root) {
        Properties context = new Properties();
        Element sourcePathsElement = XMLUtilities.createElement((Element)root, (String)"paths");
        for (IPath path : this.sourcePaths2.keySet()) {
            List<String> imports;
            List<ISeamFactory> fs;
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (f != null && f.exists() && f.getProject() != this.project) continue;
            context.put("path", path);
            LoadedDeclarations ds = this.sourcePaths2.get(path);
            Element pathElement = XMLUtilities.createElement((Element)sourcePathsElement, (String)"path");
            pathElement.setAttribute("value", path.toString());
            List<ISeamComponentDeclaration> cs = ds.getComponents();
            if (cs != null && !cs.isEmpty()) {
                Element cse = XMLUtilities.createElement((Element)pathElement, (String)"components");
                for (ISeamComponentDeclaration d : cs) {
                    SeamObject o = (SeamObject)((Object)d);
                    o.toXML(cse, context);
                }
            }
            if ((fs = ds.getFactories()) != null && !fs.isEmpty()) {
                Element cse = XMLUtilities.createElement((Element)pathElement, (String)"factories");
                for (ISeamFactory d : fs) {
                    SeamObject o = (SeamObject)((Object)d);
                    o.toXML(cse, context);
                }
            }
            if ((imports = ds.getImports()) == null || imports.isEmpty()) continue;
            Element cse = XMLUtilities.createElement((Element)pathElement, (String)"imports");
            for (String d : imports) {
                Element e = XMLUtilities.createElement((Element)cse, (String)"import");
                e.setAttribute("value", d);
            }
        }
    }

    private void storeProjectDependencies(Element root) {
        Element dependsOnElement = XMLUtilities.createElement((Element)root, (String)"depends-on-projects");
        for (ISeamProject iSeamProject : this.dependsOn) {
            if (!iSeamProject.getProject().isAccessible()) continue;
            Element pathElement = XMLUtilities.createElement((Element)dependsOnElement, (String)"project");
            pathElement.setAttribute("name", iSeamProject.getProject().getName());
        }
        Element element = XMLUtilities.createElement((Element)root, (String)"used-by-projects");
        for (ISeamProject iSeamProject : this.usedBy) {
            if (!iSeamProject.getProject().isAccessible()) continue;
            Element pathElement = XMLUtilities.createElement((Element)element, (String)"project");
            pathElement.setAttribute("name", iSeamProject.getProject().getName());
        }
    }

    private void loadSourcePaths(Element root) {
        Element sourcePathsElement = XMLUtilities.getUniqueChild((Element)root, (String)"source-paths");
        if (sourcePathsElement == null) {
            return;
        }
        Element[] paths = XMLUtilities.getChildren((Element)sourcePathsElement, (String)"path");
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                IFile f;
                Path path;
                String p = paths[i].getAttribute("value");
                if (p != null && p.trim().length() != 0 && !this.sourcePaths.contains(path = new Path(p.trim())) && (f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)) != null && f.exists() && f.isSynchronized(0)) {
                    SeamResourceVisitor b = new SeamResourceVisitor(this);
                    b.visit((IResource)f);
                }
                ++i;
            }
        }
    }

    private void loadNamespaces(Element root) {
        Element namespacesElement = XMLUtilities.getUniqueChild((Element)root, (String)"namespaces");
        if (namespacesElement == null) {
            return;
        }
        Element[] ns = XMLUtilities.getChildren((Element)namespacesElement, (String)"namespace");
        int i = 0;
        while (i < ns.length) {
            SeamNamespace sn = new SeamNamespace();
            sn.loadXML(ns[i]);
            this.namespaces.addNamespace(sn);
            ++i;
        }
    }

    private void loadSourcePaths2(Element root) {
        Properties context = new Properties();
        context.put("seamProject", this);
        Element sourcePathsElement = XMLUtilities.getUniqueChild((Element)root, (String)"paths");
        if (sourcePathsElement == null) {
            return;
        }
        Element[] paths = XMLUtilities.getChildren((Element)sourcePathsElement, (String)"path");
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                IFile f;
                Path path;
                String p = paths[i].getAttribute("value");
                if (p != null && p.trim().length() != 0 && !this.sourcePaths2.containsKey(path = new Path(p.trim())) && (this.getClassPath().hasPath((IPath)path) || (f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)) != null && f.exists() && f.isSynchronized(0))) {
                    Element imports;
                    Element factories;
                    context.put("path", path);
                    long t1 = System.currentTimeMillis();
                    LoadedDeclarations ds = new LoadedDeclarations();
                    Element components = XMLUtilities.getUniqueChild((Element)paths[i], (String)"components");
                    if (components != null) {
                        Element[] cs = XMLUtilities.getChildren((Element)components, (String)"component");
                        int j = 0;
                        while (j < cs.length) {
                            String cls = cs[j].getAttribute("class");
                            SeamComponentDeclaration d = null;
                            if ("java".equals(cls)) {
                                d = new SeamJavaComponentDeclaration();
                            } else if ("xml".equals(cls)) {
                                d = new SeamXmlComponentDeclaration();
                            } else if ("properties".equals(cls)) {
                                d = new SeamPropertiesDeclaration();
                            }
                            if (d != null) {
                                ((AbstractSeamDeclaration)d).loadXML(cs[j], context);
                                ds.getComponents().add(d);
                            }
                            ++j;
                        }
                    }
                    if ((factories = XMLUtilities.getUniqueChild((Element)paths[i], (String)"factories")) != null) {
                        Element[] cs = XMLUtilities.getChildren((Element)factories, (String)"factory");
                        int j = 0;
                        while (j < cs.length) {
                            String cls = cs[j].getAttribute("class");
                            AbstractContextVariable d = null;
                            if ("xml".equals(cls)) {
                                d = new SeamXmlFactory();
                            } else if ("java".equals(cls)) {
                                d = new SeamAnnotatedFactory();
                            } else if ("messages".equals(cls)) {
                                d = new SeamMessages();
                            }
                            if (d != null) {
                                ((AbstractContextVariable)d).loadXML(cs[j], context);
                                ds.getFactories().add((ISeamFactory)((Object)d));
                            }
                            ++j;
                        }
                    }
                    if ((imports = XMLUtilities.getUniqueChild((Element)paths[i], (String)"imports")) != null) {
                        Element[] cs = XMLUtilities.getChildren((Element)imports, (String)"import");
                        int j = 0;
                        while (j < cs.length) {
                            String v = cs[j].getAttribute("value");
                            if (v != null && v.length() > 0) {
                                ds.getImports().add(v);
                            }
                            ++j;
                        }
                    }
                    this.getClassPath().pathLoaded((IPath)path);
                    Set<ISeamNamespace> ns = this.namespaces.getNamespacesBySource((IPath)path);
                    if (ns != null) {
                        ds.getNamespaces().addAll(ns);
                    }
                    this.registerComponents(ds, (IPath)path);
                    long t2 = System.currentTimeMillis();
                    if (this.statistics != null) {
                        this.statistics.add(new Long(t2 - t1));
                        if (t2 - t1 > 30L) {
                            System.out.println("--->" + this.statistics.size() + " " + (t2 - t1));
                            System.out.println("stop");
                        }
                    }
                }
                ++i;
            }
        }
        this.postBuild();
    }

    private void loadProjectDependencies(Element root) {
        Element usedElement;
        Element dependsOnElement = XMLUtilities.getUniqueChild((Element)root, (String)"depends-on-projects");
        if (dependsOnElement != null) {
            Element[] paths = XMLUtilities.getChildren((Element)dependsOnElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                SeamProject sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = (SeamProject)SeamCorePlugin.getSeamProject(project, false)) != null) {
                    this.dependsOn.add(sp);
                    sp.addDependentSeamProject(this);
                }
                ++i;
            }
        }
        if ((usedElement = XMLUtilities.getUniqueChild((Element)root, (String)"used-by-projects")) != null) {
            Element[] paths = XMLUtilities.getChildren((Element)usedElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                SeamProject sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = (SeamProject)SeamCorePlugin.getSeamProject(project, false)) != null) {
                    this.usedBy.add(sp);
                }
                ++i;
            }
        }
    }

    private File getStorageFile() {
        IPath path = SeamCorePlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName());
        return file;
    }

    public void clearStorage() {
        File f = this.getStorageFile();
        if (f != null && f.isFile()) {
            f.delete();
        }
    }

    public boolean hasNoStorage() {
        File f = this.getStorageFile();
        return f == null || !f.isFile();
    }

    public ProjectValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new ProjectValidationContext();
        }
        return this.validationContext;
    }

    public ISeamComponent getComponentByName(String name) {
        return this.components.getByName(name);
    }

    @Override
    public ISeamComponent[] getComponents() {
        return this.components.getAllComponentsArray();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void registerComponents(LoadedDeclarations ds, IPath source) {
        ns = ds.getNamespaces().toArray(new ISeamNamespace[0]);
        components = ds.getComponents().toArray(new ISeamComponentDeclaration[0]);
        factories = ds.getFactories().toArray(new ISeamFactory[0]);
        if (ns.length == 0 && components.length == 0 && factories.length == 0 && ds.getImports().isEmpty()) {
            this.pathRemoved(source);
            if (EclipseResourceUtil.isJar((String)source.toString())) {
                if (!this.sourcePaths.contains(source)) {
                    this.sourcePaths.add(source);
                }
                this.sourcePaths2.put(source, ds);
            }
            return;
        }
        if (!this.sourcePaths.contains(source)) {
            this.sourcePaths.add(source);
        }
        this.sourcePaths2.put(source, ds);
        if (ns.length > 0) {
            this.namespaces.addPath(source, ns);
        }
        if (!ds.getImports().isEmpty()) {
            this.setImports(source.toString(), ds.getImports());
        } else {
            this.removeImports(source.toString());
        }
        currentComponents = this.findComponentDeclarations(source);
        affectedComponents = new HashSet<SeamComponent>();
        addedComponents = null;
        i = 0;
        while (i < components.length) {
            loaded = (SeamComponentDeclaration)components[i];
            this.adopt((ISeamElement)loaded);
            current = (SeamComponentDeclaration)currentComponents.remove(loaded.getId());
            loaded.setSourcePath(source);
            name = this.getComponentName((SeamComponentDeclaration)loaded);
            oldName = this.getComponentName(current);
            nameChanged = current != null && this.stringsEqual(name, oldName) == false;
            c = this.getComponent(name);
            if (c != null) {
                affectedComponents.add(c);
            }
            oldClassName = c == null ? null : c.getClassName();
            loadedClassName = SeamProject.getClassName((ISeamComponentDeclaration)loaded);
            nameless = new HashSet<ISeamXmlComponentDeclaration>();
            if (current == null) ** GOTO lbl83
            currentClassName = SeamProject.getClassName(current);
            changes = current.merge((ISeamElement)loaded);
            if (this.isClassNameChanged(currentClassName, loadedClassName)) {
                this.components.onClassNameChanged(currentClassName, loadedClassName, current);
            }
            if (changes != null && !changes.isEmpty()) {
                cc = new Change((Object)c, null, null, null);
                cc.addChildren(changes);
                cchanges = Change.addChange(null, (Change)cc);
                this.fireChanges(cchanges);
            }
            if (!nameChanged) {
                if (loaded instanceof ISeamXmlComponentDeclaration) {
                    xml = (ISeamXmlComponentDeclaration)loaded;
                    this.onXMLLoadedDeclaration(c, oldClassName, xml);
                }
            } else {
                old = new HashMap<Object, ISeamComponentDeclaration>();
                old.put(current.getId(), current);
                oc = this.getComponent(oldName);
                if (oc != null) {
                    var27_38 = xds = oc.getXmlDeclarations().toArray(new ISeamXmlComponentDeclaration[0]);
                    var26_35 = xds.length;
                    var25_33 = 0;
                    while (var25_33 < var26_35) {
                        x = var27_38[var25_33];
                        n = x.getName();
                        if (loadedClassName != null && loadedClassName.equals(x.getClassName()) && (n == null || n.length() == 0)) {
                            old.put(((SeamXmlComponentDeclaration)x).getId(), x);
                            nameless.add(x);
                        }
                        ++var25_33;
                    }
                }
                this.componentDeclarationsRemoved(old);
                loaded = current;
                current = null;
                c = this.getComponent(name);
                if (c != null) {
                    affectedComponents.add(c);
                }
lbl83:
                // 4 sources

                this.components.addDeclaration((SeamComponentDeclaration)loaded);
                if (c == null && name != null) {
                    scopeType = loaded.getScope();
                    c = this.newComponent(name, scopeType);
                    affectedComponents.add(c);
                    this.components.addComponent(c);
                    this.addVariable(c);
                    c.addDeclaration((ISeamComponentDeclaration)loaded);
                    if (nameless != null && nameless.size() > 0) {
                        for (ISeamComponentDeclaration d : nameless) {
                            c.addDeclaration(d);
                        }
                    }
                    addedComponents = Change.addChange(addedComponents, (Change)new Change((Object)this, null, null, (Object)c));
                } else if (c != null) {
                    c.addDeclaration((ISeamComponentDeclaration)loaded);
                    changes = Change.addChange(null, (Change)new Change((Object)c, null, null, loaded));
                    this.fireChanges(changes);
                }
                if (loaded instanceof ISeamJavaComponentDeclaration) {
                    jd = (SeamJavaComponentDeclaration)loaded;
                    cs = this.getComponentsByClass(jd.getClassName());
                    for (ISeamComponent ci : cs) {
                        if (ci == c) continue;
                        cii = (SeamComponent)ci;
                        cii.addDeclaration((ISeamComponentDeclaration)loaded);
                        changes = Change.addChange(null, (Change)new Change((Object)ci, null, null, loaded));
                        this.fireChanges(changes);
                        affectedComponents.add(cii);
                    }
                    empty = this.components.getByName("");
                    if (empty != null && name != null && name.length() > 0) {
                        var26_36 = xds = empty.getXmlDeclarations().toArray(new ISeamXmlComponentDeclaration[0]);
                        var25_33 = xds.length;
                        changes = 0;
                        while (changes < var25_33) {
                            x = var26_36[changes];
                            if (jd.getClassName().equals(x.getClassName())) {
                                empty.removeDeclaration(x);
                                changes = Change.addChange(null, (Change)new Change((Object)empty, null, (Object)x, null));
                                c.addDeclaration(x);
                                changes = Change.addChange((List)changes, (Change)new Change((Object)empty, null, null, (Object)x));
                                this.fireChanges(changes);
                            }
                            ++changes;
                        }
                    }
                    if (oldClassName != null && this.isClassNameChanged(oldClassName, loadedClassName)) {
                        nameless.clear();
                        old = new HashMap<Object, ISeamComponentDeclaration>();
                        var27_38 = xds = c.getXmlDeclarations().toArray(new ISeamXmlComponentDeclaration[0]);
                        var26_35 = xds.length;
                        var25_33 = 0;
                        while (var25_33 < var26_35) {
                            x = var27_38[var25_33];
                            n = x.getName();
                            if (oldClassName.equals(x.getClassName()) && (n == null || n.length() == 0)) {
                                old.put(((SeamXmlComponentDeclaration)x).getId(), x);
                                nameless.add(x);
                            }
                            ++var25_33;
                        }
                        this.componentDeclarationsRemoved(old);
                        if (nameless.size() > 0) {
                            if (empty == null) {
                                empty = this.newComponent("", ((ISeamXmlComponentDeclaration)nameless.iterator().next()).getScope());
                                affectedComponents.add(empty);
                                this.components.addComponent(empty);
                            }
                            changes = null;
                            for (ISeamXmlComponentDeclaration d : nameless) {
                                empty.addDeclaration(d);
                                changes = Change.addChange(changes, (Change)new Change((Object)empty, null, null, (Object)d));
                            }
                            this.fireChanges(changes);
                        }
                    }
                } else if (loaded instanceof ISeamXmlComponentDeclaration) {
                    xml = (ISeamXmlComponentDeclaration)loaded;
                    this.onXMLLoadedDeclaration(c, oldClassName, xml);
                }
            }
            ++i;
        }
        for (ISeamComponent c : affectedComponents) {
            sc = (SeamComponent)c;
            addedComponents = sc.revalidate(addedComponents);
        }
        this.fireChanges(addedComponents);
        this.componentDeclarationsRemoved(currentComponents);
        currentFactories = this.findFactoryDeclarations(source);
        addedFactories = null;
        i = 0;
        while (i < factories.length) {
            loaded = (AbstractContextVariable)factories[i];
            current = (AbstractContextVariable)currentFactories.remove(loaded.getId());
            if (current != null && current.getClass() != loaded.getClass()) {
                this.factories.removeFactory((ISeamFactory)current);
                current = null;
            }
            if (current != null) {
                changes = current.merge(loaded);
                this.fireChanges(changes);
            } else {
                if (factories[i].getParent() == null) {
                    this.adopt(factories[i]);
                }
                this.factories.addFactory(factories[i]);
                addedFactories = Change.addChange(addedFactories, (Change)new Change((Object)this, null, null, (Object)loaded));
            }
            ++i;
        }
        this.fireChanges(addedFactories);
        this.factoryDeclarationsRemoved(currentFactories);
        this.variables.revalidate(source);
        try {
            this.registerComponentsInDependentProjects(ds, source);
        }
        catch (CloneNotSupportedException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private String getComponentName(SeamComponentDeclaration d) {
        SeamJavaComponentDeclaration jd;
        String className;
        if (d == null) {
            return null;
        }
        String name = d.getName();
        if ((name == null || name.length() == 0) && d instanceof SeamXmlComponentDeclaration && (className = SeamProject.getClassName(d)) != null && className.length() > 0 && (jd = this.components.getJavaDeclaration(className)) != null) {
            name = jd.getName();
        }
        return name;
    }

    private static String getClassName(ISeamComponentDeclaration d) {
        if (d instanceof ISeamJavaComponentDeclaration) {
            return ((ISeamJavaComponentDeclaration)d).getClassName();
        }
        if (d instanceof ISeamXmlComponentDeclaration) {
            return ((ISeamXmlComponentDeclaration)d).getClassName();
        }
        return null;
    }

    public void registerComponentsInDependentProjects(LoadedDeclarations ds, IPath source) throws CloneNotSupportedException {
        if (this.usedBy.isEmpty()) {
            return;
        }
        if (EclipseResourceUtil.isJar((String)source.toString())) {
            return;
        }
        for (SeamProject p : this.usedBy) {
            p.resolve();
            LoadedDeclarations ds1 = new LoadedDeclarations();
            for (ISeamNamespace n : ds.getNamespaces()) {
                ds1.getNamespaces().add(n);
            }
            for (ISeamComponentDeclaration d : ds.getComponents()) {
                ds1.getComponents().add(d.clone());
            }
            for (ISeamFactory f : ds.getFactories()) {
                ds1.getFactories().add(f.clone());
            }
            ds1.getImports().addAll(ds.getImports());
            p.registerComponents(ds1, source);
        }
    }

    boolean stringsEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private boolean isClassNameChanged(String oldClassName, String newClassName) {
        if (oldClassName == null || oldClassName.length() == 0) {
            return false;
        }
        if (newClassName == null || newClassName.length() == 0) {
            return false;
        }
        return !oldClassName.equals(newClassName);
    }

    private void onXMLLoadedDeclaration(SeamComponent c, String oldClassName, ISeamXmlComponentDeclaration xml) {
        SeamJavaComponentDeclaration j;
        String className = xml.getClassName();
        List changes = null;
        if (this.isClassNameChanged(oldClassName, className)) {
            ISeamComponentDeclaration[] ds1 = c.getAllDeclarations().toArray(new ISeamComponentDeclaration[0]);
            int i1 = 0;
            while (i1 < ds1.length) {
                ISeamJavaComponentDeclaration jcd;
                if (ds1[i1] instanceof ISeamJavaComponentDeclaration && !(jcd = (ISeamJavaComponentDeclaration)ds1[i1]).getClassName().equals(className) && !c.getName().equals(jcd.getName())) {
                    c.removeDeclaration(jcd);
                    changes = Change.addChange((List)changes, (Change)new Change((Object)c, null, (Object)jcd, null));
                }
                ++i1;
            }
        }
        if ((j = this.components.getJavaDeclaration(className)) != null && !c.getAllDeclarations().contains(j)) {
            c.addDeclaration(j);
            changes = Change.addChange(changes, (Change)new Change((Object)c, null, null, (Object)j));
        }
        if (changes != null) {
            c.revalidate(changes);
        }
        this.fireChanges(changes);
    }

    public boolean isPathLoaded(IPath source) {
        return this.sourcePaths2.containsKey(source);
    }

    public void pathRemoved(IPath source) {
        if (!this.sourcePaths.contains(source) && !this.sourcePaths2.containsKey(source)) {
            return;
        }
        this.sourcePaths.remove(source);
        this.sourcePaths2.remove(source);
        this.namespaces.removePath(source);
        this.removeImports(source.toString());
        List<Change> changes = null;
        Set<SeamComponentDeclaration> ds = this.components.getDeclarationsBySource(source);
        if (ds != null) {
            for (SeamComponentDeclaration d : ds) {
                HashSet<SeamComponent> cs = new HashSet<SeamComponent>();
                cs.addAll(d.getComponents());
                for (SeamComponent c : cs) {
                    c.removeDeclaration(d);
                    changes = Change.addChange((List)changes, (Change)new Change((Object)c, null, (Object)d, null));
                    if (!this.isComponentEmpty(c)) continue;
                    changes = this.removeEmptyComponent(c);
                }
            }
        }
        this.components.removePath(source);
        this.fireChanges(changes);
        changes = null;
        Set<ISeamFactory> fs = this.factories.removePath(source);
        if (fs != null) {
            for (ISeamFactory f : fs) {
                changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)f, null));
            }
        }
        this.fireChanges(changes);
        this.firePathRemovedToDependentProjects(source);
    }

    public void firePathRemovedToDependentProjects(IPath source) {
        if (this.usedBy.isEmpty()) {
            return;
        }
        if (EclipseResourceUtil.isJar((String)source.toString())) {
            return;
        }
        for (SeamProject p : this.usedBy) {
            p.resolve();
            p.pathRemoved(source);
        }
    }

    public Map<Object, ISeamComponentDeclaration> findComponentDeclarations(IPath source) {
        HashMap<Object, ISeamComponentDeclaration> map = new HashMap<Object, ISeamComponentDeclaration>();
        Set<SeamComponentDeclaration> ds = this.components.getDeclarationsBySource(source);
        if (ds != null) {
            for (ISeamComponentDeclaration iSeamComponentDeclaration : ds) {
                SeamComponentDeclaration di = (SeamComponentDeclaration)iSeamComponentDeclaration;
                map.put(di.getId(), di);
            }
        }
        return map;
    }

    void componentDeclarationsRemoved(Map<Object, ISeamComponentDeclaration> removed) {
        if (removed == null || removed.isEmpty()) {
            return;
        }
        List changes = null;
        for (ISeamComponentDeclaration declaration : removed.values()) {
            SeamComponentDeclaration d = (SeamComponentDeclaration)declaration;
            this.components.removeDeclaration(d);
            HashSet<SeamComponent> sc = new HashSet<SeamComponent>();
            sc.addAll(d.getComponents());
            for (SeamComponent c : sc) {
                ISeamComponentDeclaration d1;
                c.removeDeclaration(d);
                changes = Change.addChange(changes, (Change)new Change((Object)c, null, (Object)d, null));
                Set<ISeamComponentDeclaration> ds = c.getAllDeclarations();
                if (ds.size() == 1 && (d1 = ds.iterator().next()) instanceof ISeamJavaComponentDeclaration && !c.getName().equals(d1.getName())) {
                    c.removeDeclaration(d1);
                    changes = Change.addChange(changes, (Change)new Change((Object)c, null, (Object)d1, null));
                }
                if (!this.isComponentEmpty(c)) continue;
                changes = this.removeEmptyComponent(c);
            }
        }
        this.fireChanges(changes);
    }

    private List<Change> removeEmptyComponent(SeamComponent c) {
        this.components.removeComponent(c);
        List changes = c.removeFromModel(null);
        this.removeVariable(c);
        changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)c, null));
        return changes;
    }

    private boolean isComponentEmpty(SeamComponent c) {
        if (c.getAllDeclarations().isEmpty()) {
            return true;
        }
        for (ISeamComponentDeclaration d : c.getAllDeclarations()) {
            if (!c.getName().equals(d.getName())) continue;
            return false;
        }
        return true;
    }

    public Map<Object, ISeamFactory> findFactoryDeclarations(IPath source) {
        HashMap<Object, ISeamFactory> map = new HashMap<Object, ISeamFactory>();
        Set<ISeamFactory> fs = this.factories.getFactoriesBySource(source);
        if (fs != null) {
            for (ISeamFactory c : fs) {
                AbstractContextVariable ci = (AbstractContextVariable)((Object)c);
                map.put(ci.getId(), c);
            }
        }
        return map;
    }

    void factoryDeclarationsRemoved(Map<Object, ISeamFactory> removed) {
        if (removed == null || removed.isEmpty()) {
            return;
        }
        Iterator<ISeamFactory> iterator = removed.values().iterator();
        List changes = null;
        while (iterator.hasNext()) {
            ISeamFactory c = iterator.next();
            this.factories.removeFactory(c);
            this.removeVariable(c);
            changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)c, null));
        }
        this.fireChanges(changes);
    }

    @Override
    public Set<ISeamComponent> getComponentsByClass(String className) {
        HashSet<ISeamComponent> result = new HashSet<ISeamComponent>();
        Set<SeamComponentDeclaration> ds = this.components.getDeclarationsByClasName(className);
        if (ds == null) {
            return result;
        }
        for (SeamComponentDeclaration d : ds) {
            for (ISeamComponent iSeamComponent : d.getComponents()) {
                if (result.contains(iSeamComponent) || iSeamComponent.getSeamProject() != this || !className.equals(iSeamComponent.getClassName())) continue;
                result.add(iSeamComponent);
            }
        }
        return result;
    }

    @Override
    public Set<ISeamComponent> getComponentsByScope(ScopeType type) {
        return this.getComponentsByScope(type, false);
    }

    @Override
    public Set<ISeamComponent> getComponentsByScope(ScopeType type, boolean addVisibleScopes) {
        HashSet<ISeamComponent> result = new HashSet<ISeamComponent>();
        for (SeamComponent component : this.components.allComponents.values()) {
            if (!this.isVisibleInScope(component, type, addVisibleScopes)) continue;
            result.add(component);
        }
        return result;
    }

    @Override
    public void addComponent(ISeamComponent component) {
        this.components.addComponent(component);
    }

    @Override
    public void removeComponent(ISeamComponent component) {
        this.components.removeComponent(component);
    }

    @Override
    public Set<ISeamContextVariable> getVariables() {
        return this.variables.getVariablesCopy();
    }

    @Override
    public void addVariable(ISeamContextVariable v) {
        this.variables.add(v);
    }

    @Override
    public void removeVariable(ISeamContextVariable v) {
        this.variables.remove(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImports(String source, List<String> paths) {
        if (this.equalLists(this.imports.get(source), paths)) {
            return;
        }
        VariablesStorage variablesStorage = this.variables;
        synchronized (variablesStorage) {
            this.variables.allVariablesPlusShort = null;
            this.variables.byName = null;
        }
        this.imports.put(source, paths);
    }

    private boolean equalLists(List<String> s1, List<String> s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.size() != s2.size()) {
            return false;
        }
        int i = 0;
        while (i < s1.size()) {
            if (!s1.get(i).equals(s2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImports(String source) {
        if (!this.imports.containsKey(source)) {
            return;
        }
        VariablesStorage variablesStorage = this.variables;
        synchronized (variablesStorage) {
            this.variables.allVariablesPlusShort = null;
        }
        this.imports.remove(source);
    }

    @Override
    public Set<ISeamContextVariable> getVariables(boolean includeShortNames) {
        if (!includeShortNames) {
            return this.variables.getVariablesCopy();
        }
        return this.variables.getVariablesPlusShort();
    }

    public boolean isImportedPackage(String packageName) {
        for (String s : this.imports.keySet()) {
            List<String> list = this.imports.get(s);
            if (!list.contains(packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ISeamContextVariable> getVariablesByName(String name) {
        return this.variables.getByName(name);
    }

    @Override
    public Set<ISeamContextVariable> getVariablesByScope(ScopeType scope) {
        return this.getVariablesByScope(scope, false);
    }

    @Override
    public Set<ISeamContextVariable> getVariablesByScope(ScopeType scope, boolean addVisibleScopes) {
        HashSet<ISeamContextVariable> result = new HashSet<ISeamContextVariable>();
        for (ISeamContextVariable v : this.getVariables(true)) {
            if (!this.isVisibleInScope(v, scope, addVisibleScopes)) continue;
            result.add(v);
        }
        return result;
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributes() {
        ISeamJavaComponentDeclaration[] ds;
        HashSet<IBijectedAttribute> result = new HashSet<IBijectedAttribute>();
        ISeamJavaComponentDeclaration[] iSeamJavaComponentDeclarationArray = ds = this.components.getJavaDeclarationsArray();
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamJavaComponentDeclaration d = iSeamJavaComponentDeclarationArray[n2];
            Set<IBijectedAttribute> as = d.getBijectedAttributes();
            if (as != null) {
                result.addAll(as);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributesByType(BijectedAttributeType type) {
        ISeamJavaComponentDeclaration[] ds;
        HashSet<IBijectedAttribute> result = new HashSet<IBijectedAttribute>();
        ISeamJavaComponentDeclaration[] iSeamJavaComponentDeclarationArray = ds = this.components.getJavaDeclarationsArray();
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamJavaComponentDeclaration d = iSeamJavaComponentDeclarationArray[n2];
            Set<IBijectedAttribute> as = d.getBijectedAttributesByType(type);
            if (as != null) {
                result.addAll(as);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributesByName(String name, BijectedAttributeType type) {
        ISeamJavaComponentDeclaration[] ds;
        HashSet<IBijectedAttribute> result = new HashSet<IBijectedAttribute>();
        ISeamJavaComponentDeclaration[] iSeamJavaComponentDeclarationArray = ds = this.components.getJavaDeclarationsArray();
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamJavaComponentDeclaration d = iSeamJavaComponentDeclarationArray[n2];
            Set<IBijectedAttribute> as = d.getBijectedAttributes();
            for (IBijectedAttribute a : as) {
                if (name != null && !name.equals(a.getName()) || type != null && !a.isOfType(type)) continue;
                result.add(a);
            }
            ++n2;
        }
        return result;
    }

    private boolean isVisibleInScope(ISeamContextVariable v, ScopeType scope, boolean addVisibleScopes) {
        if (scope == v.getScope()) {
            return true;
        }
        return addVisibleScopes && scope != null && v.getScope() != null && v.getScope().getPriority() >= scope.getPriority();
    }

    @Override
    public void addFactory(ISeamFactory factory) {
        this.factories.addFactory(factory);
    }

    @Override
    public ISeamFactory[] getFactories() {
        return this.factories.getAllFactoriesArray();
    }

    @Override
    public Set<ISeamFactory> getFactories(String name, ScopeType scope) {
        HashSet<ISeamFactory> result = new HashSet<ISeamFactory>();
        ISeamFactory[] iSeamFactoryArray = this.getFactories();
        int n = iSeamFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamFactory f = iSeamFactoryArray[n2];
            if (name.equals(f.getName()) && scope.equals(f.getScope())) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Set<ISeamFactory> getFactoriesByName(String name) {
        HashSet<ISeamFactory> result = new HashSet<ISeamFactory>();
        ISeamFactory[] iSeamFactoryArray = this.getFactories();
        int n = iSeamFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamFactory f = iSeamFactoryArray[n2];
            if (name.equals(f.getName())) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Set<ISeamFactory> getFactoriesByScope(ScopeType scope) {
        return this.getFactoriesByScope(scope, false);
    }

    @Override
    public Set<ISeamFactory> getFactoriesByScope(ScopeType scope, boolean addVisibleScopes) {
        HashSet<ISeamFactory> result = new HashSet<ISeamFactory>();
        ISeamFactory[] iSeamFactoryArray = this.getFactories();
        int n = iSeamFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamFactory f = iSeamFactoryArray[n2];
            if (this.isVisibleInScope(f, scope, addVisibleScopes)) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Set<ISeamFactory> getFactoriesByPath(IPath path) {
        HashSet<ISeamFactory> result = new HashSet<ISeamFactory>();
        Set<ISeamFactory> fs = this.factories.getFactoriesBySource(path);
        if (fs != null) {
            result.addAll(fs);
        }
        return result;
    }

    @Override
    public void removeFactory(ISeamFactory factory) {
        this.factories.removeFactory(factory);
        this.removeVariable(factory);
    }

    public ISeamJavaComponentDeclaration[] getAllJavaComponentDeclarations() {
        return this.components.getJavaDeclarationsArray();
    }

    public ISeamJavaComponentDeclaration getJavaComponentDeclaration(String className) {
        return this.components.getJavaDeclaration(className);
    }

    public Set<ISeamJavaComponentDeclaration> findJavaDeclarations(IPath source) {
        HashSet<ISeamJavaComponentDeclaration> set = new HashSet<ISeamJavaComponentDeclaration>();
        ISeamJavaComponentDeclaration[] iSeamJavaComponentDeclarationArray = this.components.getJavaDeclarationsArray();
        int n = iSeamJavaComponentDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamJavaComponentDeclaration d = iSeamJavaComponentDeclarationArray[n2];
            if (source.equals((Object)d.getSourcePath())) {
                set.add(d);
            }
            ++n2;
        }
        return set;
    }

    @Override
    public SeamComponent getComponent(String name) {
        return this.components.getByName(name);
    }

    SeamComponent newComponent(String name, ScopeType scopeType) {
        SeamComponent c = MESSAGES_COMPONENT_NAME.equals(name) ? new SeamMessagesComponent() : new SeamComponent();
        c.setName(name);
        c.setId(name);
        c.setParent(this.getScope(scopeType));
        this.getScope(scopeType).addComponent(c);
        return c;
    }

    public void postponeFiring() {
        if (this.postponedChanges == null) {
            this.postponedChanges = new ArrayList<Change>();
        }
    }

    public void fireChanges() {
        if (this.postponedChanges == null) {
            return;
        }
        List<Change> changes = this.postponedChanges;
        this.postponedChanges = null;
        this.fireChanges(changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChanges(List<Change> changes) {
        if (changes == null || changes.isEmpty()) {
            return;
        }
        if (this.postponedChanges != null) {
            this.postponedChanges.addAll(changes);
            return;
        }
        SeamProjectChangeEvent event = new SeamProjectChangeEvent(this, changes);
        ISeamProjectChangeListener[] ls = null;
        SeamProject seamProject = this;
        synchronized (seamProject) {
            ls = this.listeners.toArray(new ISeamProjectChangeListener[0]);
        }
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                ls[i].projectChanged(event);
                ++i;
            }
        }
        SeamCorePlugin.fire(event);
    }

    @Override
    public synchronized void addSeamProjectListener(ISeamProjectChangeListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeSeamProjectListener(ISeamProjectChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Set<ISeamComponent> getComponentsByPath(IPath path) {
        HashSet<ISeamComponent> result = new HashSet<ISeamComponent>();
        Set<SeamComponentDeclaration> ds = this.components.getDeclarationsBySource(path);
        if (ds != null) {
            for (SeamComponentDeclaration d : ds) {
                Set<SeamComponent> cs = d.getComponents();
                for (SeamComponent c : cs) {
                    if (c.getSeamProject() != this) continue;
                    result.add(c);
                }
            }
        }
        return result;
    }

    @Override
    public Set<ISeamContextVariable> getVariablesByPath(IPath path) {
        return this.variables.getByPath(path);
    }

    void revalidate() {
    }

    /*
     * WARNING - void declaration
     */
    Map<IPath, LoadedDeclarations> getAllDeclarations() throws CloneNotSupportedException {
        HashMap<IPath, LoadedDeclarations> map = new HashMap<IPath, LoadedDeclarations>();
        ISeamComponent[] iSeamComponentArray = this.getComponents();
        int n = iSeamComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamComponent c = iSeamComponentArray[n2];
            for (ISeamComponentDeclaration iSeamComponentDeclaration : c.getAllDeclarations()) {
                IPath p = iSeamComponentDeclaration.getSourcePath();
                if (p == null || EclipseResourceUtil.isJar((String)p.toString())) continue;
                LoadedDeclarations ds = (LoadedDeclarations)map.get(p);
                if (ds == null) {
                    ds = new LoadedDeclarations();
                    map.put(p, ds);
                }
                ds.getComponents().add(iSeamComponentDeclaration.clone());
            }
            ++n2;
        }
        for (String uri : this.namespaces.namespacesByURI.keySet()) {
            Set<ISeamNamespace> s = this.namespaces.namespacesByURI.get(uri);
            for (ISeamNamespace iSeamNamespace : s) {
                IPath p = iSeamNamespace.getSourcePath();
                if (p == null || EclipseResourceUtil.isJar((String)p.toString())) continue;
                LoadedDeclarations ds = (LoadedDeclarations)map.get(p);
                if (ds == null) {
                    ds = new LoadedDeclarations();
                    map.put(p, ds);
                }
                ds.getNamespaces().add(iSeamNamespace);
            }
        }
        ISeamFactory[] iSeamFactoryArray = this.getFactories();
        int s = iSeamFactoryArray.length;
        int n3 = 0;
        while (n3 < s) {
            ISeamFactory f = iSeamFactoryArray[n3];
            IPath iPath = f.getSourcePath();
            if (iPath != null && !EclipseResourceUtil.isJar((String)iPath.toString())) {
                LoadedDeclarations ds = (LoadedDeclarations)map.get(iPath);
                if (ds == null) {
                    ds = new LoadedDeclarations();
                    map.put(iPath, ds);
                }
                ds.getFactories().add(f.clone());
            }
            ++n3;
        }
        for (String s2 : this.imports.keySet()) {
            void var5_9;
            Path p = new Path(s2);
            if (p == null || EclipseResourceUtil.isJar((String)p.toString())) continue;
            LoadedDeclarations loadedDeclarations = (LoadedDeclarations)map.get(p);
            if (loadedDeclarations == null) {
                LoadedDeclarations loadedDeclarations2 = new LoadedDeclarations();
                map.put((IPath)p, loadedDeclarations2);
            }
            var5_9.getImports().addAll((Collection<String>)this.imports.get(s2));
        }
        return map;
    }

    public void postBuild() {
        SeamComponent m;
        if (this.factories.messages != null) {
            this.factories.messages.revalidate();
        }
        if ((m = this.getComponent(MESSAGES_COMPONENT_NAME)) instanceof SeamMessagesComponent) {
            ((SeamMessagesComponent)m).revalidate();
        }
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand command = null;
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length && command == null) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
            }
            ++i;
        }
        if (command == null) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] oldCommands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            Object handle;
            String builderName = commands[i].getBuilderName();
            if (builderName.equals(builderID) || builderName.equals(EXTERNAL_TOOL_BUILDER) && (handle = commands[i].getArguments().get(LAUNCH_CONFIG_HANDLE)) != null && handle.toString().indexOf(builderID) >= 0) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public void validatePackage(SeamComponent c) {
        SeamPackage p = (SeamPackage)SeamPackageUtil.findOrCreatePackage(this, this.packages, SeamPackageUtil.getPackageName(c));
        c.setProjectPackage(p);
        p.getComponents().add(c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComponentStorage {
        private Set<ISeamComponent> allComponentsSet = new HashSet<ISeamComponent>();
        Map<String, SeamComponent> allComponents = new HashMap<String, SeamComponent>();
        Map<String, SeamJavaComponentDeclaration> javaDeclarations = new HashMap<String, SeamJavaComponentDeclaration>();
        ISeamJavaComponentDeclaration[] javaDeclarationsArray = null;
        Map<IPath, Set<SeamComponentDeclaration>> declarationsBySource = new HashMap<IPath, Set<SeamComponentDeclaration>>();
        Map<String, Set<SeamComponentDeclaration>> declarationsByClassName = new HashMap<String, Set<SeamComponentDeclaration>>();

        ComponentStorage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.allComponentsSet;
            synchronized (object) {
                this.allComponentsSet.clear();
            }
            this.allComponents.clear();
            object = this.javaDeclarations;
            synchronized (object) {
                this.javaDeclarations.clear();
                this.javaDeclarationsArray = null;
            }
            this.declarationsBySource.clear();
            this.declarationsByClassName.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISeamComponent[] getAllComponentsArray() {
            Set<ISeamComponent> set = this.allComponentsSet;
            synchronized (set) {
                return SeamProject.this.components.allComponentsSet.toArray(new ISeamComponent[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISeamJavaComponentDeclaration[] getJavaDeclarationsArray() {
            ISeamJavaComponentDeclaration[] result = this.javaDeclarationsArray;
            if (result == null) {
                Map<String, SeamJavaComponentDeclaration> map = this.javaDeclarations;
                synchronized (map) {
                    this.javaDeclarationsArray = new ISeamJavaComponentDeclaration[this.javaDeclarations.values().size()];
                    result = this.javaDeclarationsArray;
                    int i = 0;
                    for (ISeamJavaComponentDeclaration iSeamJavaComponentDeclaration : this.javaDeclarations.values()) {
                        this.javaDeclarationsArray[i++] = iSeamJavaComponentDeclaration;
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SeamComponent getByName(String name) {
            if (name == null) {
                return null;
            }
            Set<ISeamComponent> set = this.allComponentsSet;
            synchronized (set) {
                return this.allComponents.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponent(ISeamComponent c) {
            Set<ISeamComponent> set = this.allComponentsSet;
            synchronized (set) {
                this.allComponentsSet.remove(c);
            }
            this.allComponents.remove(c.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(ISeamComponent c) {
            Set<ISeamComponent> set = this.allComponentsSet;
            synchronized (set) {
                this.allComponentsSet.add(c);
            }
            this.allComponents.put(c.getName(), (SeamComponent)c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDeclaration(SeamComponentDeclaration d) {
            ISeamXmlComponentDeclaration xd;
            String string;
            IPath path = d.getSourcePath();
            Set<SeamComponentDeclaration> sc = this.declarationsBySource.get(path);
            if (sc == null) {
                sc = new HashSet<SeamComponentDeclaration>();
                this.declarationsBySource.put(path, sc);
            }
            sc.add(d);
            if (d instanceof ISeamJavaComponentDeclaration) {
                SeamJavaComponentDeclaration jd = (SeamJavaComponentDeclaration)d;
                for (ISeamContextVariable iSeamContextVariable : jd.getDeclaredVariables()) {
                    SeamProject.this.addVariable(iSeamContextVariable);
                }
                Map<String, SeamJavaComponentDeclaration> map = this.javaDeclarations;
                synchronized (map) {
                    this.javaDeclarations.put(jd.getClassName(), jd);
                    this.javaDeclarationsArray = null;
                }
                this.addDeclaration(jd.getClassName(), jd);
            } else if (d instanceof ISeamXmlComponentDeclaration && (string = (xd = (ISeamXmlComponentDeclaration)((Object)d)).getClassName()) != null && string.length() > 0) {
                this.addDeclaration(string, d);
            }
        }

        public void removeDeclaration(SeamComponentDeclaration d) {
            IPath path = d.getSourcePath();
            Set<SeamComponentDeclaration> sc = this.declarationsBySource.get(path);
            if (sc != null) {
                sc.remove(d);
                if (sc.isEmpty()) {
                    this.declarationsBySource.remove(path);
                }
            }
            this.removeDeclarationWithClass(d);
        }

        public Set<SeamComponentDeclaration> getDeclarationsBySource(IPath path) {
            return this.declarationsBySource.get(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SeamJavaComponentDeclaration getJavaDeclaration(String className) {
            Map<String, SeamJavaComponentDeclaration> map = this.javaDeclarations;
            synchronized (map) {
                return this.javaDeclarations.get(className);
            }
        }

        public Set<SeamComponentDeclaration> getDeclarationsByClasName(String className) {
            return this.declarationsByClassName.get(className);
        }

        public void removePath(IPath path) {
            Set<SeamComponentDeclaration> sd = this.declarationsBySource.get(path);
            if (sd == null) {
                return;
            }
            for (SeamComponentDeclaration d : sd) {
                this.removeDeclarationWithClass(d);
            }
            this.declarationsBySource.remove(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeDeclarationWithClass(SeamComponentDeclaration d) {
            ISeamXmlComponentDeclaration xd;
            String className;
            if (d instanceof ISeamJavaComponentDeclaration) {
                SeamJavaComponentDeclaration jd = (SeamJavaComponentDeclaration)d;
                Map<String, SeamJavaComponentDeclaration> map = this.javaDeclarations;
                synchronized (map) {
                    this.javaDeclarations.remove(jd.getClassName());
                    this.javaDeclarationsArray = null;
                }
                for (ISeamContextVariable v : jd.getDeclaredVariables()) {
                    SeamProject.this.removeVariable(v);
                }
                this.removeDeclaration(jd.getClassName(), d);
            } else if (d instanceof ISeamXmlComponentDeclaration && (className = (xd = (ISeamXmlComponentDeclaration)((Object)d)).getClassName()) != null && className.length() > 0) {
                this.removeDeclaration(className, d);
            }
        }

        public void onClassNameChanged(String oldClassName, String newClassName, SeamComponentDeclaration d) {
            if (oldClassName != null) {
                this.removeDeclaration(oldClassName, d);
            }
            if (newClassName != null) {
                this.addDeclaration(newClassName, d);
            }
        }

        private void addDeclaration(String className, SeamComponentDeclaration d) {
            Set<SeamComponentDeclaration> sc = this.declarationsByClassName.get(className);
            if (sc == null) {
                sc = new HashSet<SeamComponentDeclaration>();
                this.declarationsByClassName.put(className, sc);
            }
            sc.add(d);
        }

        private void removeDeclaration(String className, SeamComponentDeclaration d) {
            Set<SeamComponentDeclaration> sc = this.declarationsByClassName.get(className);
            if (sc != null) {
                sc.remove(d);
                if (sc.isEmpty()) {
                    this.declarationsByClassName.remove(className);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FactoryStorage {
        private Set<ISeamFactory> allFactories = new HashSet<ISeamFactory>();
        private ISeamFactory[] allFactoriesArray = null;
        Map<IPath, Set<ISeamFactory>> factoriesBySource = new HashMap<IPath, Set<ISeamFactory>>();
        SeamMessages messages = null;

        FactoryStorage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Set<ISeamFactory> set = this.allFactories;
            synchronized (set) {
                this.allFactories.clear();
                this.allFactoriesArray = null;
            }
            this.factoriesBySource.clear();
            this.messages = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISeamFactory[] getAllFactoriesArray() {
            ISeamFactory[] result = this.allFactoriesArray;
            if (result == null) {
                Set<ISeamFactory> set = this.allFactories;
                synchronized (set) {
                    this.allFactoriesArray = this.allFactories.toArray(new ISeamFactory[0]);
                    result = this.allFactoriesArray;
                }
            }
            return result;
        }

        public Set<ISeamFactory> getFactoriesBySource(IPath path) {
            return this.factoriesBySource.get(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFactory(ISeamFactory f) {
            Set<ISeamFactory> set = this.allFactories;
            synchronized (set) {
                this.allFactories.add(f);
                this.allFactoriesArray = null;
            }
            IPath path = f.getSourcePath();
            if (path != null) {
                Set<ISeamFactory> fs = this.factoriesBySource.get(path);
                if (fs == null) {
                    fs = new HashSet<ISeamFactory>();
                    this.factoriesBySource.put(path, fs);
                }
                fs.add(f);
            }
            SeamProject.this.addVariable(f);
            if (f instanceof SeamMessages) {
                this.messages = (SeamMessages)f;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeFactory(ISeamFactory f) {
            Set<ISeamFactory> set = this.allFactories;
            synchronized (set) {
                this.allFactories.remove(f);
                this.allFactoriesArray = null;
            }
            IPath path = f.getSourcePath();
            if (path != null) {
                Set<ISeamFactory> fs = this.factoriesBySource.get(path);
                if (fs != null) {
                    fs.remove(f);
                }
                if (fs.isEmpty()) {
                    this.factoriesBySource.remove(fs);
                }
            }
            SeamProject.this.removeVariable(f);
            if (f == this.messages) {
                this.messages = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<ISeamFactory> removePath(IPath path) {
            Set<ISeamFactory> fs = this.factoriesBySource.get(path);
            if (fs == null) {
                return null;
            }
            for (ISeamFactory f : fs) {
                Set<ISeamFactory> set = this.allFactories;
                synchronized (set) {
                    this.allFactories.remove(f);
                    this.allFactoriesArray = null;
                }
                SeamProject.this.removeVariable(f);
                if (f != this.messages) continue;
                this.messages = null;
            }
            this.factoriesBySource.remove(path);
            return fs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NamespaceStorage {
        Map<IPath, Set<ISeamNamespace>> namespacesBySource = new HashMap<IPath, Set<ISeamNamespace>>();
        Map<String, Set<ISeamNamespace>> namespacesByURI = new HashMap<String, Set<ISeamNamespace>>();

        NamespaceStorage() {
        }

        public void clear() {
            this.namespacesBySource.clear();
            this.namespacesByURI.clear();
        }

        public Set<ISeamNamespace> getNamespacesBySource(IPath path) {
            return this.namespacesBySource.get(path);
        }

        public void addPath(IPath source, ISeamNamespace[] ns) {
            Set<ISeamNamespace> sd = this.namespacesBySource.get(source);
            if (sd == null && ns.length == 0) {
                return;
            }
            if (ns.length == 0) {
                this.removePath(source);
            } else {
                this.removePath(source);
                int i = 0;
                while (i < ns.length) {
                    this.addNamespace(ns[i]);
                    ++i;
                }
            }
        }

        public void addNamespace(ISeamNamespace n) {
            IPath path;
            String uri = n.getURI();
            if (uri != null) {
                Set<ISeamNamespace> s = this.namespacesByURI.get(uri);
                if (s == null) {
                    s = new HashSet<ISeamNamespace>();
                    this.namespacesByURI.put(n.getURI(), s);
                }
                s.add(n);
            }
            if ((path = n.getSourcePath()) != null) {
                Set<ISeamNamespace> fs = this.namespacesBySource.get(path);
                if (fs == null) {
                    fs = new HashSet<ISeamNamespace>();
                    this.namespacesBySource.put(path, fs);
                }
                fs.add(n);
            }
        }

        public void removePath(IPath path) {
            Set<ISeamNamespace> sd = this.namespacesBySource.get(path);
            if (sd == null) {
                return;
            }
            for (ISeamNamespace d : sd) {
                if (d.getURI() == null) continue;
                this.namespacesByURI.remove(d.getURI());
            }
            this.namespacesBySource.remove(path);
        }

        public void removeNamespace(ISeamNamespace n) {
            this.namespacesByURI.remove(n.getURI());
            IPath path = n.getSourcePath();
            if (path != null) {
                Set<ISeamNamespace> fs = this.namespacesBySource.get(path);
                if (fs != null) {
                    fs.remove(n);
                }
                if (fs.isEmpty()) {
                    this.namespacesBySource.remove(fs);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VariablesStorage {
        Set<ISeamContextVariable> allVariables = new HashSet<ISeamContextVariable>();
        Set<ISeamContextVariable> allVariablesCopy = null;
        Set<ISeamContextVariable> allVariablesPlusShort = null;
        Map<IPath, Set<ISeamContextVariable>> byPath = null;
        Map<String, Set<ISeamContextVariable>> byName = null;

        VariablesStorage() {
        }

        public void clear() {
            this.allVariables.clear();
            this.clearCopies();
        }

        synchronized void clearCopies() {
            this.allVariablesCopy = null;
            this.allVariablesPlusShort = null;
            this.byName = null;
            this.byPath = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<ISeamContextVariable> getVariablesCopy() {
            Set<ISeamContextVariable> vs = this.allVariablesCopy;
            if (vs == null) {
                VariablesStorage variablesStorage = this;
                synchronized (variablesStorage) {
                    this.allVariablesCopy = new HashSet<ISeamContextVariable>();
                    this.allVariablesCopy.addAll(this.allVariables);
                    vs = this.allVariablesCopy;
                }
            }
            return vs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<ISeamContextVariable> getVariablesPlusShort() {
            Set<ISeamContextVariable> vs = this.getVariablesCopy();
            Set<ISeamContextVariable> result = this.allVariablesPlusShort;
            if (result != null) {
                return result;
            }
            VariablesStorage variablesStorage = this;
            synchronized (variablesStorage) {
                result = new HashSet<ISeamContextVariable>();
                result.addAll(vs);
                for (ISeamContextVariable v : vs) {
                    String packageName;
                    String n = v.getName();
                    int i = n.lastIndexOf(46);
                    if (i < 0 || !SeamProject.this.isImportedPackage(packageName = n.substring(0, i))) continue;
                    result.add(new SeamContextShortVariable(v));
                }
                this.allVariablesPlusShort = result;
            }
            return result;
        }

        public synchronized void add(ISeamContextVariable v) {
            if (this.allVariables.contains(v)) {
                return;
            }
            this.clearCopies();
            this.allVariables.add(v);
        }

        public synchronized void remove(ISeamContextVariable v) {
            if (!this.allVariables.contains(v)) {
                return;
            }
            this.clearCopies();
            this.allVariables.remove(v);
        }

        public synchronized void revalidate(IPath path) {
            this.byPath = null;
            this.byName = null;
        }

        private void create() {
            this.byName = new HashMap<String, Set<ISeamContextVariable>>();
            this.byPath = new HashMap<IPath, Set<ISeamContextVariable>>();
            Set<ISeamContextVariable> q = this.getVariablesPlusShort();
            for (ISeamContextVariable v : q) {
                if (v instanceof ISeamComponent) {
                    ISeamComponent c = (ISeamComponent)v;
                    for (ISeamComponentDeclaration d : c.getAllDeclarations()) {
                        SeamComponentDeclaration di = (SeamComponentDeclaration)d;
                        this.addForPath(di.getSourcePath(), v);
                    }
                } else {
                    IResource variableResource = v.getResource();
                    if (variableResource != null) {
                        this.addForPath(variableResource.getFullPath(), v);
                    }
                }
                String n = v.getName();
                Set<ISeamContextVariable> s = this.byName.get(n);
                if (s == null) {
                    s = new HashSet<ISeamContextVariable>();
                    this.byName.put(n, s);
                }
                s.add(v);
            }
        }

        private void addForPath(IPath p, ISeamContextVariable v) {
            if (p == null) {
                return;
            }
            Set<ISeamContextVariable> s = this.byPath.get(p);
            if (s == null) {
                s = new HashSet<ISeamContextVariable>();
                this.byPath.put(p, s);
            }
            s.add(v);
        }

        public synchronized Set<ISeamContextVariable> getByName(String n) {
            if (this.byName == null) {
                this.create();
            }
            return this.byName.get(n);
        }

        public synchronized Set<ISeamContextVariable> getByPath(IPath p) {
            if (this.byPath == null) {
                this.create();
            }
            return this.byPath.get(p);
        }
    }
}

