/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamPropertiesDeclaration;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamProperty;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamPropertiesDeclaration
extends SeamComponentDeclaration
implements ISeamPropertiesDeclaration {
    protected Map<String, ISeamProperty> properties = new HashMap<String, ISeamProperty>();

    @Override
    public void addProperty(ISeamProperty property) {
        this.properties.put(property.getName(), property);
        this.adopt(property);
    }

    @Override
    public List<ISeamProperty> getProperties(String propertyName) {
        ArrayList<ISeamProperty> list = new ArrayList<ISeamProperty>();
        ISeamProperty p = this.properties.get(propertyName);
        if (p != null) {
            list.add(p);
        }
        return list;
    }

    @Override
    public Collection<ISeamProperty> getProperties() {
        return this.properties.values();
    }

    @Override
    public ISeamProperty getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public void removeProperty(ISeamProperty property) {
        this.properties.remove(property.getName());
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        SeamProperty p2;
        SeamProperty p1;
        List changes = super.merge(s);
        SeamPropertiesDeclaration pd = (SeamPropertiesDeclaration)s;
        Change children = new Change((Object)this, null, null, null);
        String[] names = this.properties.keySet().toArray(new String[0]);
        int i = 0;
        while (i < names.length) {
            p1 = (SeamProperty)this.properties.get(names[i]);
            p2 = (SeamProperty)pd.properties.get(names[i]);
            if (p2 == null) {
                changes = Change.addChange((List)changes, (Change)new Change((Object)this, null, (Object)p1, null));
                this.properties.remove(names[i]);
            } else {
                String oldName = p1.getName();
                List<Change> cc = p1.merge(p2);
                if (cc != null && !cc.isEmpty()) {
                    children.addChildren(cc);
                }
                if (oldName != null && !oldName.equals(p1.getName())) {
                    this.properties.remove(oldName);
                    this.addProperty(p1);
                }
            }
            ++i;
        }
        names = pd.properties.keySet().toArray(new String[0]);
        i = 0;
        while (i < names.length) {
            p1 = (SeamProperty)this.properties.get(names[i]);
            p2 = (SeamProperty)pd.properties.get(names[i]);
            if (p1 == null) {
                changes = Change.addChange((List)changes, (Change)new Change((Object)this, null, null, (Object)p2));
                this.addProperty(p2);
            }
            ++i;
        }
        changes = Change.addChange(changes, (Change)children);
        return changes;
    }

    @Override
    public void open() {
        if (this.id instanceof XModelObject) {
            XModelObject o = (XModelObject)this.id;
            FindObjectHelper.findModelObject((XModelObject)o, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else if (this.getResource() instanceof IFile) {
            IFile f = (IFile)this.getResource();
            if (f == null || !f.exists()) {
                ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
                d.showDialog("Warning", "File " + this.getSourcePath() + " does not exist.", new String[]{SpecialWizardSupport.OK}, null, 2);
                return;
            }
            try {
                IWorkbench workbench = SeamCorePlugin.getDefault().getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)f);
                }
            }
            catch (PartInitException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    @Override
    public SeamPropertiesDeclaration clone() throws CloneNotSupportedException {
        SeamPropertiesDeclaration c = (SeamPropertiesDeclaration)super.clone();
        c.properties = new HashMap<String, ISeamProperty>();
        for (String name : this.properties.keySet()) {
            ISeamProperty p = this.properties.get(name).clone();
            c.addProperty(p);
        }
        return c;
    }

    @Override
    public String getXMLClass() {
        return "properties";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        XModelObject old = this.pushModelObject(context);
        for (String name : this.properties.keySet()) {
            SeamProperty p = (SeamProperty)this.properties.get(name);
            p.toXML(element, context);
        }
        this.popModelObject(context, old);
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        XModelObject old = this.pushModelObject(context);
        Element[] cs = XMLUtilities.getChildren((Element)element, (String)"property");
        int i = 0;
        while (i < cs.length) {
            SeamProperty p = new SeamProperty();
            p.loadXML(cs[i], context);
            this.addProperty(p);
            ++i;
        }
        this.popModelObject(context, old);
    }
}

