/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.event.ISeamValue;
import org.jboss.tools.seam.internal.core.AbstractSeamDeclaration;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamValueList;
import org.jboss.tools.seam.internal.core.SeamValueMap;
import org.jboss.tools.seam.internal.core.SeamValueString;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamProperty
extends AbstractSeamDeclaration
implements ISeamProperty {
    protected ISeamValue value;

    @Override
    public ISeamValue getValue() {
        return this.value;
    }

    @Override
    public void setValue(ISeamValue value) {
        this.value = value;
        if (value != null) {
            this.adopt((SeamObject)((Object)value));
        }
    }

    @Override
    public int getLength() {
        IValueInfo info = (IValueInfo)this.attributes.get("name");
        if (info != null) {
            return info.getLength();
        }
        return 0;
    }

    @Override
    public int getStartPosition() {
        IValueInfo info = (IValueInfo)this.attributes.get("name");
        if (info != null) {
            return info.getStartPosition();
        }
        return 0;
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamProperty d = (SeamProperty)s;
        if (!this.stringsEqual(this.name, d.name)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "name", (Object)this.name, (Object)d.name));
            this.name = d.name;
        }
        if (this.value == null) {
            if (d.value != null) {
                this.setValue(d.value);
                changes = Change.addChange((List)changes, (Change)new Change((Object)this, "value", null, (Object)this.value));
            }
        } else if (d.value == null) {
            if (this.value != null) {
                changes = Change.addChange((List)changes, (Change)new Change((Object)this, "value", (Object)this.value, null));
            }
            this.value = null;
        } else if (!this.value.getClass().getName().equals(d.value.getClass().getName())) {
            ISeamValue old = this.value;
            this.setValue(d.value);
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "value", (Object)old, (Object)this.value));
        } else {
            List<Change> cs = ((SeamObject)((Object)this.value)).merge((SeamObject)((Object)d.value));
            if (cs != null && !cs.isEmpty()) {
                Change c = new Change((Object)this, "value", (Object)this.value, (Object)this.value);
                c.addChildren(cs);
                changes = Change.addChange((List)changes, (Change)c);
            }
        }
        return changes;
    }

    @Override
    boolean stringsEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    @Override
    public SeamProperty clone() throws CloneNotSupportedException {
        SeamProperty c = (SeamProperty)super.clone();
        c.value = this.value == null ? null : this.value.clone();
        return c;
    }

    @Override
    public String getXMLName() {
        return "property";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        XModelObject old = this.pushModelObject(context);
        if (this.value instanceof SeamObject) {
            SeamObject o = (SeamObject)((Object)this.value);
            o.toXML(element, context);
        }
        this.popModelObject(context, old);
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        XModelObject old = this.pushModelObject(context);
        Element c = XMLUtilities.getUniqueChild((Element)element, (String)"value");
        if (c != null) {
            SeamObject v = null;
            String cls = c.getAttribute("class");
            v = "map".equals(cls) ? new SeamValueMap() : ("list".equals(cls) ? new SeamValueList() : new SeamValueString());
            if (v != null) {
                ((SeamObject)v).loadXML(c, context);
                this.setValue((ISeamValue)((Object)v));
            }
        }
        this.popModelObject(context, old);
    }
}

