/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.Seam2ProjectCreator;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamProjectCreator;

public class Seam2FacetInstallDelegate
extends SeamFacetAbstractInstallDelegate {
    public static final AntCopyUtils.FileSet JBOSS_EAR_CONTENT = new AntCopyUtils.FileSet().include("jboss-seam.jar");
    public static final AntCopyUtils.FileSet JBOSS_EAR_LIB = new AntCopyUtils.FileSet().include("antlr-runtime.jar").include("commons-beanutils.*\\.jar").include("drools-compiler.*\\.jar").include("drools-core.*\\.jar").include("drools-api.*\\.jar").include("jboss-el.*.jar").include("jboss-seam-remoting\\.jar").include("mvel.*\\.jar").include("jbpm-jpdl.*\\.jar").include("richfaces-api.*\\.jar");
    public static final AntCopyUtils.FileSet JBOSS_WAR_LIB_FILESET_WAR_CONFIG = new AntCopyUtils.FileSet().include("ajax4jsf.*\\.jar").include("richfaces.*\\.jar").include("antlr-runtime.*\\.jar").include("commons-beanutils.*\\.jar").include("commons-digester.*\\.jar").include("commons-jci-core.*\\.jar").include("commons-jci-janino.*\\.jar").include("drools-compiler.*\\.jar").include("drools-core.*\\.jar").include("drools-api.*\\.jar").include("core.jar").include("jboss-seam-debug\\.jar").include("jboss-seam-ioc\\.jar").include("jboss-seam-mail\\.jar").include("jboss-seam-pdf\\.jar").include("jboss-seam-remoting\\.jar").include("jboss-seam-ui\\.jar").include("jboss-seam-excel\\.jar").include("jboss-seam\\.jar").include("jbpm.*\\.jar").include("jsf-facelets\\.jar").include("oscache.*\\.jar").include("stringtemplate.*\\.jar").include("mvel.*\\.jar").include("jboss-el.jar").include("jxl\\.jar").include("itext.*\\.jar").include("jfreechart.*\\.jar").include("jcommon.*\\.jar");
    public static final AntCopyUtils.FileSet JBOSS_WAR_LIB_FILESET_EAR_CONFIG = new AntCopyUtils.FileSet().include("richfaces-impl\\.jar").include("richfaces-ui\\.jar").include("commons-digester\\.jar").include("jboss-seam-debug\\.jar").include("jboss-seam-ioc\\.jar").include("jboss-seam-mail\\.jar").include("jboss-seam-pdf\\.jar").include("jboss-seam-ui\\.jar").include("jboss-seam-excel\\.jar").include("jxl\\.jar").include("itext.*\\.jar").include("jfreechart.*\\.jar").include("jcommon.*\\.jar").include("jsf-facelets\\.jar");
    public static String DROOLS_LIB_SEAM_RELATED_PATH = "lib";

    protected void doExecuteForEjb(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        super.doExecuteForEjb(project, fv, model, monitor);
        IResource src = this.getSrcFolder(project);
        if (src != null && this.seamHomeFolder != null) {
            File srcFile = src.getLocation().toFile();
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "security.drl"), srcFile, false);
        }
    }

    protected void copyFilesToWarProject(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        super.copyFilesToWarProject(project, fv, model, monitor);
        File droolsLibFolder = new File(this.seamHomePath, DROOLS_LIB_SEAM_RELATED_PATH);
        if (Seam2FacetInstallDelegate.isWarConfiguration(model)) {
            if (!SeamCorePlugin.getDefault().hasM2Facet(project)) {
                AntCopyUtils.copyFiles(this.seamHomeFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_WAR_LIB_FILESET_WAR_CONFIG).dir(this.seamHomeFolder)));
                AntCopyUtils.copyFiles(this.seamLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_WAR_LIB_FILESET_WAR_CONFIG).dir(this.seamLibFolder)));
            }
            IContainer source = this.warActionSrcRootFolder.getUnderlyingFolder();
            File actionsSrc = new File(project.getLocation().toFile(), source.getFullPath().removeFirstSegments(1).toString());
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "seam.properties"), actionsSrc, true);
            if (!SeamCorePlugin.getDefault().hasM2Facet(project)) {
                AntCopyUtils.copyFiles(droolsLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_WAR_LIB_FILESET_WAR_CONFIG).dir(droolsLibFolder)));
            }
        } else if (!SeamCorePlugin.getDefault().hasM2Facet(project)) {
            AntCopyUtils.copyFiles(this.seamHomeFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_WAR_LIB_FILESET_EAR_CONFIG).dir(this.seamHomeFolder)));
            AntCopyUtils.copyFiles(this.seamLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_WAR_LIB_FILESET_EAR_CONFIG).dir(this.seamLibFolder)));
            AntCopyUtils.copyFiles(droolsLibFolder, this.webLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_WAR_LIB_FILESET_EAR_CONFIG).dir(droolsLibFolder)));
        }
    }

    protected void fillEarContents() {
        File droolsLibFolder = new File(this.seamHomePath, DROOLS_LIB_SEAM_RELATED_PATH);
        AntCopyUtils.copyFiles(this.seamHomeFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(this.seamHomeFolder)), false);
        AntCopyUtils.copyFiles(this.seamLibFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(this.seamLibFolder)), false);
        AntCopyUtils.copyFiles(this.seamLibFolder, this.earLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_LIB).dir(this.seamLibFolder)), false);
        AntCopyUtils.copyFiles(droolsLibFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(droolsLibFolder)), false);
        AntCopyUtils.copyFiles(this.seamGenResFolder, this.earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(JBOSS_EAR_CONTENT).dir(this.seamGenResFolder)), false);
    }

    protected void configureFacesConfigXml(IProject project, IProgressMonitor monitor, String webConfigName) {
        FacesConfigArtifactEdit facesConfigEdit = null;
        try {
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)webConfigName);
            FacesConfigType facesConfig = facesConfigEdit.getFacesConfig();
            EList applications = facesConfig.getApplication();
            ApplicationType applicationType = null;
            boolean applicationExists = false;
            if (applications.size() <= 0) {
                applicationType = FacesConfigFactory.eINSTANCE.createApplicationType();
            } else {
                applicationType = (ApplicationType)applications.get(0);
                applicationExists = true;
            }
            boolean localeConfigExists = false;
            for (ApplicationType application : applications) {
                EList localeConfigs = application.getLocaleConfig();
                if (localeConfigs.isEmpty()) continue;
                localeConfigExists = true;
                break;
            }
            if (!localeConfigExists) {
                LocaleConfigType locale = FacesConfigFactory.eINSTANCE.createLocaleConfigType();
                DefaultLocaleType defaultLocale = FacesConfigFactory.eINSTANCE.createDefaultLocaleType();
                defaultLocale.setTextContent("en");
                locale.setDefaultLocale(defaultLocale);
                SupportedLocaleType supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("bg");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("de");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("en");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("fr");
                locale.getSupportedLocale().add((Object)supportedLocale);
                supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent("tr");
                locale.getSupportedLocale().add((Object)supportedLocale);
                applicationType.getLocaleConfig().add((Object)locale);
            }
            boolean viewHandlerExists = false;
            block4: for (ApplicationType application : applications) {
                EList viewHandlers = application.getViewHandler();
                for (ViewHandlerType viewHandlerType : viewHandlers) {
                    if (!"com.sun.facelets.FaceletViewHandler".equals(viewHandlerType.getTextContent().trim())) continue;
                    viewHandlerExists = true;
                    continue block4;
                }
            }
            if (!viewHandlerExists) {
                ViewHandlerType viewHandler = FacesConfigFactory.eINSTANCE.createViewHandlerType();
                viewHandler.setTextContent("com.sun.facelets.FaceletViewHandler");
                applicationType.getViewHandler().add((Object)viewHandler);
            }
            if (!applicationExists) {
                facesConfig.getApplication().add((Object)applicationType);
            }
            facesConfigEdit.save(monitor);
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
            }
        }
    }

    protected void configure(WebApp webApp) {
        this.createOrUpdateContextParam(webApp, ORG_RICHFACES_SKIN, ORG_RICHFACES_SKIN_VALUE);
        this.createOrUpdateListener(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMLISTENER);
        this.createOrUpdateFilter(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_NAME, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER);
        this.createOrUpdateFilterMapping(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_NAME, ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_MAPPING_VALUE);
        this.createOrUpdateServlet(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_NAME);
        this.createOrUpdateServletMapping(webApp, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_NAME, ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_VALUE);
        this.createOrUpdateContextParam(webApp, FACELETS_DEVELOPMENT, "true");
        this.createOrUpdateContextParam(webApp, JAVAX_FACES_DEFAULT_SUFFIX, JAVAX_FACES_DEFAULT_SUFFIX_VALUE);
        this.addSecurityConstraint(webApp);
    }

    protected SeamProjectCreator getProjectCreator(IDataModel model, IProject project) {
        return new Seam2ProjectCreator(model, project);
    }
}

