/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.util.Map;
import org.apache.tools.ant.types.FilterSet;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SeamFacetFilterSetFactory {
    public static FilterSet JDBC_TEMPLATE = new FilterSet();
    public static FilterSet PROJECT_TEMPLATE;
    public static FilterSet FILTERS_TEMPLATE;
    public static FilterSet HIBERNATE_DIALECT_TEMPLATE;

    static {
        JDBC_TEMPLATE.addFilter("jdbcUrl", "${hibernate.connection.url}");
        JDBC_TEMPLATE.addFilter("driverClass", "${hibernate.connection.driver_class}");
        JDBC_TEMPLATE.addFilter("username", "${hibernate.connection.username}");
        JDBC_TEMPLATE.addFilter("password", "${hibernate.connection.password}");
        JDBC_TEMPLATE.addFilter("catalogProperty", "${catalog.property}");
        JDBC_TEMPLATE.addFilter("schemaProperty", "${schema.property}");
        PROJECT_TEMPLATE = new FilterSet();
        PROJECT_TEMPLATE.addFilter("projectName", "${project.name}");
        PROJECT_TEMPLATE.addFilter("jbossHome", "${jboss.home}");
        PROJECT_TEMPLATE.addFilter("hbm2ddl", "${hibernate.hbm2ddl.auto}");
        PROJECT_TEMPLATE.addFilter("driverJar", "${driver.file}");
        PROJECT_TEMPLATE.addFilter("debug", "true");
        PROJECT_TEMPLATE.addFilter("skin", "blueSky");
        PROJECT_TEMPLATE.addFilter("connectionProfile", "${seam.project.connection.profile}");
        FILTERS_TEMPLATE = new FilterSet();
        FILTERS_TEMPLATE.addFilter("interfaceName", "${interface.name}");
        FILTERS_TEMPLATE.addFilter("beanName", "${bean.name}");
        FILTERS_TEMPLATE.addFilter("entityName", "${entity.name}");
        FILTERS_TEMPLATE.addFilter("methodName", "${method.name}");
        FILTERS_TEMPLATE.addFilter("componentName", "${component.name}");
        FILTERS_TEMPLATE.addFilter("pageName", "${page.name}");
        FILTERS_TEMPLATE.addFilter("masterPageName", "${masterPage.name}");
        FILTERS_TEMPLATE.addFilter("actionPackage", "${action.package}");
        FILTERS_TEMPLATE.addFilter("modelPackage", "${model.package}");
        FILTERS_TEMPLATE.addFilter("testPackage", "${test.package}");
        FILTERS_TEMPLATE.addFilter("listName", "${component.name}List");
        FILTERS_TEMPLATE.addFilter("homeName", "${component.name}Home");
        FILTERS_TEMPLATE.addFilter("query", "${query.text}");
        HIBERNATE_DIALECT_TEMPLATE = new FilterSet();
        HIBERNATE_DIALECT_TEMPLATE.addFilter("hibernate.dialect", "${hibernate.dialect}");
    }

    public static FilterSet createJdbcFilterSet(IDataModel values, boolean encodeValuesForPropertyFiles) {
        return SeamFacetFilterSetFactory.applyProperties((FilterSet)JDBC_TEMPLATE.clone(), values, encodeValuesForPropertyFiles);
    }

    public static FilterSet createProjectFilterSet(IDataModel values, boolean encodeValuesForPropertyFiles) {
        return SeamFacetFilterSetFactory.applyProperties((FilterSet)PROJECT_TEMPLATE.clone(), values, encodeValuesForPropertyFiles);
    }

    public static FilterSet createFiltersFilterSet(IDataModel values, boolean encodeValuesForPropertyFiles) {
        return SeamFacetFilterSetFactory.applyProperties((FilterSet)FILTERS_TEMPLATE.clone(), values, encodeValuesForPropertyFiles);
    }

    public static FilterSet createHibernateDialectFilterSet(IDataModel values, boolean encodeValuesForPropertyFiles) {
        return SeamFacetFilterSetFactory.applyProperties((FilterSet)HIBERNATE_DIALECT_TEMPLATE.clone(), values, encodeValuesForPropertyFiles);
    }

    public static FilterSet createFiltersFilterSet(Map values, boolean encodeValuesForPropertyFiles) {
        return SeamFacetFilterSetFactory.applyProperties((FilterSet)FILTERS_TEMPLATE.clone(), values, false);
    }

    public static FilterSet createJdbcFilterSet(IDataModel values) {
        return SeamFacetFilterSetFactory.createJdbcFilterSet(values, false);
    }

    public static FilterSet createProjectFilterSet(IDataModel values) {
        return SeamFacetFilterSetFactory.createProjectFilterSet(values, false);
    }

    public static FilterSet createFiltersFilterSet(IDataModel values) {
        return SeamFacetFilterSetFactory.createFiltersFilterSet(values, false);
    }

    public static FilterSet createHibernateDialectFilterSet(IDataModel values) {
        return SeamFacetFilterSetFactory.createHibernateDialectFilterSet(values, false);
    }

    public static FilterSet createFiltersFilterSet(Map values) {
        return SeamFacetFilterSetFactory.createFiltersFilterSet(values, false);
    }

    private static FilterSet applyProperties(FilterSet template, IDataModel values, boolean encodeValuesForPropertyFiles) {
        FilterSet result = new FilterSet();
        for (Object filter : template.getFilterHash().keySet()) {
            String value = template.getFilterHash().get(filter).toString();
            for (Object property : values.getAllProperties()) {
                if (!value.contains("${" + property.toString() + "}")) continue;
                Object propertyValue = values.getProperty(property.toString());
                if (encodeValuesForPropertyFiles && propertyValue != null) {
                    propertyValue = propertyValue.toString().replace("\\", "\\\\");
                }
                value = value.replace("${" + property.toString() + "}", propertyValue == null ? "" : propertyValue.toString());
            }
            result.addFilter(filter.toString(), value);
        }
        return result;
    }

    private static FilterSet applyProperties(FilterSet template, Map values, boolean encodeValuesForPropertyFiles) {
        FilterSet result = new FilterSet();
        for (Object filter : template.getFilterHash().keySet()) {
            String value = template.getFilterHash().get(filter).toString();
            for (Object property : values.keySet()) {
                if (!value.contains("${" + property.toString() + "}")) continue;
                Object propertyValue = values.get(property.toString());
                if (encodeValuesForPropertyFiles && propertyValue != null) {
                    propertyValue = propertyValue.toString().replace("\\", "\\\\");
                }
                value = value.replace("${" + property.toString() + "}", propertyValue == null ? "" : propertyValue.toString());
            }
            result.addFilter(filter.toString(), value);
        }
        return result;
    }
}

