/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamFacetProjectCreationDataModelProvider
extends WebFacetProjectCreationDataModelProvider {
    public static IStatus OK_STATUS = new Status(0, "org.jboss.tools.seam.core", 0, "OK", null);

    public Object getDefaultProperty(String propertyName) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            return "__d_u_m_m_y__for__bug206541__";
        }
        return super.getDefaultProperty(propertyName);
    }

    public void init() {
        IDialogSettings u;
        String deployImplType;
        super.init();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel seamFacet = DataModelFactory.createDataModel((IDataModelProvider)new SeamFacetInstallDataModelProvider());
        map.add(seamFacet);
        seamFacet.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("seam.project.deployment.runtime".equals(event.getPropertyName())) {
                    SeamFacetProjectCreationDataModelProvider.this.setProperty("seam.project.deployment.runtime", event.getProperty());
                    SeamFacetProjectCreationDataModelProvider.this.model.notifyPropertyChange("seam.project.deployment.runtime", 2);
                    SeamFacetProjectCreationDataModelProvider.this.model.notifyPropertyChange("seam.project.deployment.target", 4);
                } else if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(event.getPropertyName())) {
                    SeamFacetProjectCreationDataModelProvider.this.setProperty("project.name", event.getProperty());
                }
            }
        });
        Collection requiredFacets = (Collection)this.getProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION");
        requiredFacets.add(ProjectFacetsManager.getProjectFacet((String)seamFacet.getStringProperty("IFacetDataModelProperties.FACET_ID")));
        this.setProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION", requiredFacets);
        IDialogSettings s = JSFUiPlugin.getDefault().getDialogSettings();
        IDialogSettings r = s.getSection("org.eclipse.jst.jsf.ui.jsfFacetInstall");
        if (r == null) {
            r = s.addNewSection("org.eclipse.jst.jsf.ui.jsfFacetInstall");
        }
        if ((deployImplType = r.get("deployImplType")) == null || !deployImplType.endsWith("_SUPPLIED")) {
            r.put("deployImplType", "SERVER_SUPPLIED");
        }
        if ((u = r.getSection("urlMappings")) == null) {
            u = r.addNewSection("urlMappings");
        }
        u.put("pattern", new String[]{"*.seam"});
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            List<IServer> servers;
            IServer server;
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel seamFacet = map.getFacetDataModel("jst.seam");
            seamFacet.setProperty("seam.project.deployment.runtime", propertyValue);
            if (propertyValue != null && !this.validateServer(server = (IServer)this.model.getProperty("seam.project.deployment.target")).isOK() && (servers = SeamFacetProjectCreationDataModelProvider.getServers(SeamFacetProjectCreationDataModelProvider.getRuntimeName(propertyValue))) != null && !servers.isEmpty()) {
                this.setProperty("seam.project.deployment.target", servers.get(0));
            }
        } else if (propertyName.equals("seam.project.deployment.target")) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel seamFacet = map.getFacetDataModel("jst.seam");
            seamFacet.setProperty("seam.project.deployment.target", propertyValue);
        } else if (propertyName.equals("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
            this.model.setProperty("project.name", propertyValue);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("seam.project.deployment.target");
        names.add("seam.project.deployment.runtime");
        names.add("project.name");
        return names;
    }

    public static DataModelPropertyDescriptor[] getServerPropertyDescriptors(String runtimeName) {
        List<IServer> list = SeamFacetProjectCreationDataModelProvider.getServers(runtimeName);
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size() + 1];
        Iterator<IServer> iterator = list.iterator();
        int i = 0;
        while (i < descriptors.length - 1) {
            IServer server = iterator.next();
            descriptors[i] = new DataModelPropertyDescriptor((Object)server, server.getName());
            ++i;
        }
        descriptors[descriptors.length - 1] = new DataModelPropertyDescriptor(null, "<None>");
        if (descriptors.length > 2) {
            Arrays.sort(descriptors, 0, descriptors.length - 2, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                    DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                    return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                }
            });
        }
        return descriptors;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("seam.project.deployment.target".equals(propertyName)) {
            Object rt = this.getProperty("seam.project.deployment.runtime");
            String primaryName = SeamFacetProjectCreationDataModelProvider.getRuntimeName(rt);
            return SeamFacetProjectCreationDataModelProvider.getServerPropertyDescriptors(primaryName);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    private static List<IServer> getServers(String runtimeName) {
        ArrayList<IServer> list = new ArrayList<IServer>();
        if (runtimeName != null && runtimeName != null) {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                String serverRuntimeName;
                IServer server = iServerArray[n2];
                IRuntime runtime = server.getRuntime();
                if (runtime != null && runtimeName.equals(serverRuntimeName = runtime.getName())) {
                    list.add(server);
                }
                ++n2;
            }
        }
        return list;
    }

    public IStatus validate(String propertyName) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
        IServer server;
        IStatus status = super.validate(propertyName);
        if (status != null && !status.isOK()) {
            return status;
        }
        if ("seam.project.deployment.target".equals(propertyName) && !(status = this.validateServer(server = (IServer)this.model.getProperty("seam.project.deployment.target"))).isOK()) {
            return status;
        }
        if ("seam.project.deployment.runtime".equals(propertyName) && !(status = this.validateRuntime(runtime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)this.model.getProperty("seam.project.deployment.runtime"))).isOK()) {
            return status;
        }
        return OK_STATUS;
    }

    private IStatus validateServer(Object serverObject) {
        IServer s;
        if (serverObject == null) {
            return SeamCorePlugin.createErrorStatus(SeamCoreMessages.ERROR_JBOSS_AS_TARGET_SERVER_IS_EMPTY, null);
        }
        IServer iServer = s = serverObject instanceof IServer ? (IServer)serverObject : null;
        if (s == null) {
            return SeamCorePlugin.createErrorStatus(SeamCoreMessages.ERROR_JBOSS_AS_TARGET_SERVER_UNKNOWN, null);
        }
        Object rt = this.getProperty("seam.project.deployment.runtime");
        String primaryRuntimeName = SeamFacetProjectCreationDataModelProvider.getRuntimeName(rt);
        List<IServer> servers = SeamFacetProjectCreationDataModelProvider.getServers(primaryRuntimeName);
        if (servers.isEmpty()) {
            return SeamCorePlugin.createErrorStatus(SeamCoreMessages.ERROR_JBOSS_AS_TARGET_SERVER_NO_SERVERS_DEFINED, null);
        }
        for (IServer server : servers) {
            if (!s.equals(server)) continue;
            return OK_STATUS;
        }
        return SeamCorePlugin.createErrorStatus(SeamCoreMessages.ERROR_JBOSS_AS_TARGET_SERVER_INCOMPATIBLE, null);
    }

    private static String getRuntimeName(Object rt) {
        if (rt == null) {
            return null;
        }
        String rtName = null;
        if (rt instanceof org.eclipse.wst.common.project.facet.core.runtime.IRuntime) {
            rtName = ((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt).getName();
        } else if (rt instanceof IRuntime) {
            rtName = ((IRuntime)rt).getName();
        }
        return rtName;
    }

    IStatus validateRuntime(Object runtimeObject) {
        if (runtimeObject == null) {
            return SeamCorePlugin.createErrorStatus(SeamCoreMessages.ERROR_JBOSS_AS_TARGET_RUNTIME_IS_EMPTY, null);
        }
        if (SeamFacetProjectCreationDataModelProvider.getRuntimeName(runtimeObject) == null) {
            return SeamCorePlugin.createErrorStatus(SeamCoreMessages.ERROR_JBOSS_AS_TARGET_RUNTIME_UNKNOWN, null);
        }
        return OK_STATUS;
    }

    public static String getServerName(IDataModel model) {
        Object serverObject = model.getProperty("seam.project.deployment.target");
        if (!(serverObject instanceof IServer)) {
            return "";
        }
        IServer server = (IServer)serverObject;
        return server.getName() == null ? "" : server.getName();
    }

    public static void setServerName(IDataModel model, String serverName) {
        IServer[] servers;
        if (serverName == null) {
            return;
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (serverName.equals(server.getName())) {
                model.setProperty("seam.project.deployment.target", (Object)server);
                return;
            }
            ++n2;
        }
    }
}

