/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.util.ResourcesUtils;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetFilterSetFactory;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.WtpUtils;
import org.osgi.service.prefs.BackingStoreException;

public class SeamProjectCreator {
    protected static final String TEST_WAR_PROFILE = "test-war";
    protected static final String TEST_EAR_PROFILE = "test";
    protected static final String DEV_WAR_PROFILE = "dev-war";
    protected static final String DEV_EAR_PROFILE = "dev";
    private static AntCopyUtils.FileSet JBOSS_TEST_LIB_FILESET = new AntCopyUtils.FileSet().include("testng-.*-jdk15\\.jar").include("myfaces-api-.*\\.jar").include("myfaces-impl-.*\\.jar").include("servlet-api\\.jar").include("hibernate-all\\.jar").include("jboss-ejb3-all\\.jar").include("thirdparty-all\\.jar").exclude(".*/CVS").exclude(".*/\\.svn");
    protected IDataModel model;
    protected IProject seamWebProject;
    protected SeamRuntime seamRuntime;
    protected String seamHomePath;
    protected File seamHomeFolder;
    protected File seamLibFolder;
    protected File seamGenHomeFolder;
    protected String earProjectName;
    protected String ejbProjectName;
    protected String testProjectName;
    protected File earProjectFolder;
    protected File ejbProjectFolder;
    protected File earContentsFolder;
    protected FilterSet filtersFilterSet;
    protected File seamGenResFolder;
    protected File persistenceFile;
    protected File hibernateConsoleLaunchFile;
    protected File hibernateConsolePropsFile;
    protected FilterSet jdbcFilterSet;
    protected FilterSet encodedJdbcFilterSet;
    protected FilterSet projectFilterSet;
    protected FilterSet encodedProjectFilterSet;
    protected FilterSetCollection viewFilterSetCollection;
    protected FilterSetCollection hibernateDialectFilterSet;
    protected File dataSourceDsFile;
    protected File ejbTemplateDir;
    protected AntCopyUtils.FileSet excludeCvsSvn;
    protected FilterSet ejbFilterSet;
    protected File webMetaInf;
    protected File ejbMetaInf;
    protected File droolsLibFolder;

    public SeamProjectCreator(IDataModel model, IProject seamWebProject) {
        this.model = model;
        this.seamWebProject = seamWebProject;
        this.earProjectName = String.valueOf(seamWebProject.getName()) + "-ear";
        this.ejbProjectName = String.valueOf(seamWebProject.getName()) + "-ejb";
        this.testProjectName = String.valueOf(seamWebProject.getName()) + "-test";
        this.seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(model.getProperty("seam.runtime.name").toString());
        if (this.seamRuntime == null) {
            throw new RuntimeException("Can't get seam runtime " + model.getProperty("seam.runtime.name").toString());
        }
        this.seamHomePath = this.seamRuntime.getHomeDir();
        this.seamHomeFolder = new File(this.seamHomePath);
        this.seamLibFolder = new File(this.seamHomePath, SeamFacetAbstractInstallDelegate.SEAM_LIB_RELATED_PATH);
        this.seamGenHomeFolder = new File(this.seamHomePath, "seam-gen");
        this.filtersFilterSet = SeamFacetFilterSetFactory.createFiltersFilterSet(model);
        this.seamGenResFolder = new File(this.seamGenHomeFolder, "resources");
        this.persistenceFile = new File(this.seamGenResFolder, "META-INF/persistence-" + (SeamFacetAbstractInstallDelegate.isWarConfiguration(model) ? DEV_WAR_PROFILE : DEV_EAR_PROFILE) + ".xml");
        try {
            this.hibernateConsoleLaunchFile = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "hibernatetools/hibernate-console.launch");
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        this.hibernateConsolePropsFile = new File(this.seamGenHomeFolder, "hibernatetools/hibernate-console.properties");
        this.dataSourceDsFile = new File(this.seamGenResFolder, "datasource-ds.xml");
        IVirtualComponent component = ComponentCore.createComponent((IProject)seamWebProject);
        IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        IContainer webRootFolder = webRootVirtFolder.getUnderlyingFolder();
        File webContentFolder = webRootFolder.getLocation().toFile();
        this.webMetaInf = new File(webContentFolder, "META-INF");
        this.earProjectFolder = new File(seamWebProject.getLocation().removeLastSegments(1).toFile(), this.earProjectName);
        this.earContentsFolder = new File(this.earProjectFolder, "EarContent");
        this.ejbProjectFolder = new File(seamWebProject.getLocation().removeLastSegments(1).toFile(), this.ejbProjectName);
        this.ejbMetaInf = new File(this.ejbProjectFolder, "ejbModule/META-INF");
        this.jdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model);
        this.encodedJdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model, true);
        this.projectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model);
        this.encodedProjectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model, true);
        this.viewFilterSetCollection = new FilterSetCollection();
        this.viewFilterSetCollection.addFilterSet(this.jdbcFilterSet);
        this.viewFilterSetCollection.addFilterSet(this.projectFilterSet);
        this.hibernateDialectFilterSet = new FilterSetCollection();
        this.hibernateDialectFilterSet.addFilterSet(this.encodedJdbcFilterSet);
        this.hibernateDialectFilterSet.addFilterSet(this.encodedProjectFilterSet);
        this.hibernateDialectFilterSet.addFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(model, true));
        try {
            this.ejbTemplateDir = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ejb");
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        this.excludeCvsSvn = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.CVS_SVN).dir(this.ejbTemplateDir);
        this.ejbFilterSet = new FilterSet();
        this.ejbFilterSet.addFilter("projectName", seamWebProject.getName());
        this.ejbFilterSet.addFilter("runtimeName", WtpUtils.getServerRuntimeName(seamWebProject));
        if (model.getProperty("driver.file") != null) {
            File driver = new File(((String[])model.getProperty("driver.file"))[0]);
            this.ejbFilterSet.addFilter("driverJar", " " + driver.getName() + "\n");
        } else {
            this.ejbFilterSet.addFilter("driverJar", "");
        }
        this.droolsLibFolder = new File(this.seamHomePath, SeamFacetInstallDelegate.DROOLS_LIB_SEAM_RELATED_PATH);
    }

    public SeamVersion getVersion() {
        String seamVersionString = this.getModel().getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString();
        return SeamVersion.parseFromString(seamVersionString);
    }

    public IDataModel getModel() {
        return this.model;
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    protected AntCopyUtils.FileSet getJBossTestLibFileset() {
        return JBOSS_TEST_LIB_FILESET;
    }

    protected AntCopyUtils.FileSet getJbossEarContent() {
        return SeamFacetInstallDelegate.JBOSS_EAR_CONTENT;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        String level;
        String consoleName;
        boolean testProjectCreated = this.createTestProject();
        String string = consoleName = SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model) ? this.seamWebProject.getName() : this.ejbProjectName;
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            this.createEjbProject();
            this.createEarProject();
            try {
                File[] earJars = this.earContentsFolder.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        if (SeamCorePlugin.getDefault().hasM2Facet(SeamProjectCreator.this.seamWebProject)) {
                            return false;
                        }
                        return name.lastIndexOf(".jar") > 0;
                    }
                });
                String earJarsStr = "";
                File[] fileArray = earJars;
                int n = earJars.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    earJarsStr = String.valueOf(earJarsStr) + " " + file.getName() + " \n";
                    ++n2;
                }
                FilterSetCollection manifestFilterCol = new FilterSetCollection(this.projectFilterSet);
                FilterSet manifestFilter = new FilterSet();
                manifestFilter.addFilter("earLibs", earJarsStr);
                manifestFilterCol.addFilterSet(manifestFilter);
                AntCopyUtils.copyFileToFolder(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "war/META-INF/MANIFEST.MF"), this.webMetaInf, manifestFilterCol, true);
                AntCopyUtils.copyFileToFolder(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ejb/ejbModule/META-INF/MANIFEST.MF"), this.ejbMetaInf, manifestFilterCol, true);
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        SeamFacetAbstractInstallDelegate.toggleHibernateOnProject(this.seamWebProject, consoleName);
        String wsPath = this.seamWebProject.getLocation().removeLastSegments(1).toFile().getAbsoluteFile().getPath();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            IProject ejbProjectToBeImported = wsRoot.getProject(this.ejbProjectName);
            ResourcesUtils.importExistingProject((IProject)ejbProjectToBeImported, (String)(String.valueOf(wsPath) + "/" + this.ejbProjectName), (String)this.ejbProjectName, (IProgressMonitor)monitor, (boolean)false);
            level = JavaFacetUtils.getCompilerLevel((IProject)this.seamWebProject);
            String ejbLevel = JavaFacetUtils.getCompilerLevel((IProject)ejbProjectToBeImported);
            if (!ejbLevel.equals(level)) {
                JavaFacetUtils.setCompilerLevel((IProject)ejbProjectToBeImported, (String)level);
            }
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, JavaFacetUtils.compilerLevelToFacet((String)level), null);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ejbProjectToBeImported);
            facetedProject.modify(Collections.singleton(action), null);
            SeamFacetAbstractInstallDelegate.toggleHibernateOnProject(ejbProjectToBeImported, consoleName);
            IProjectFacet sf = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
            IProjectFacetVersion pfv = ProjectFacetsManager.create((IProject)ejbProjectToBeImported).getInstalledVersion(sf);
            ClasspathHelper.addClasspathEntries((IProject)ejbProjectToBeImported, (IProjectFacetVersion)pfv);
            WtpUtils.reconfigure(ejbProjectToBeImported, monitor);
            IProject earProjectToBeImported = wsRoot.getProject(this.earProjectName);
            ResourcesUtils.importExistingProject((IProject)earProjectToBeImported, (String)(String.valueOf(wsPath) + "/" + this.earProjectName), (String)this.earProjectName, (IProgressMonitor)monitor, (boolean)false);
            this.configureJBossAppXml();
            WtpUtils.reconfigure(earProjectToBeImported, monitor);
        }
        IProject testProjectToBeImported = null;
        if (testProjectCreated) {
            testProjectToBeImported = wsRoot.getProject(this.testProjectName);
            ResourcesUtils.importExistingProject((IProject)testProjectToBeImported, (String)(String.valueOf(wsPath) + "/" + this.testProjectName), (String)this.testProjectName, (IProgressMonitor)monitor, (boolean)true);
            level = JavaFacetUtils.getCompilerLevel((IProject)this.seamWebProject);
            String testLevel = JavaFacetUtils.getCompilerLevel((IProject)testProjectToBeImported);
            if (!testLevel.equals(level)) {
                JavaFacetUtils.setCompilerLevel((IProject)testProjectToBeImported, (String)level);
            }
            testProjectToBeImported.refreshLocal(2, monitor);
            SeamFacetAbstractInstallDelegate.toggleHibernateOnProject(testProjectToBeImported, consoleName);
        }
        this.createSeamProjectPreferenes();
        WtpUtils.reconfigure(this.seamWebProject, monitor);
        if (testProjectToBeImported != null) {
            WtpUtils.reconfigure(testProjectToBeImported, monitor);
        }
    }

    protected boolean createTestProject() {
        this.model.setProperty("seam.test.project", (Object)this.testProjectName);
        if (!((Boolean)this.model.getProperty("seam.test.project.creating")).booleanValue()) {
            return false;
        }
        File testProjectDir = new File(this.seamWebProject.getLocation().removeLastSegments(1).toFile(), this.testProjectName);
        testProjectDir.mkdir();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.seamWebProject);
        IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        File testLibDir = new File(testProjectDir, "lib");
        File embededEjbDir = new File(testProjectDir, "embedded-ejb");
        File testSrcDir = new File(testProjectDir, "test-src");
        FilterSet filterSet = new FilterSet();
        filterSet.addFilter("projectName", this.seamWebProject.getName());
        filterSet.addFilter("runtimeName", WtpUtils.getServerRuntimeName(this.seamWebProject));
        filterSet.addFilter("webRootFolder", webRootVirtFolder.getUnderlyingFolder().getFullPath().removeFirstSegments(1).toString());
        AntCopyUtils.FileSet includeLibs = new AntCopyUtils.FileSet(this.getJBossTestLibFileset()).dir(new File(this.seamRuntime.getHomeDir(), "lib"));
        File[] libs = includeLibs.getDir().listFiles(new AntCopyUtils.FileSetFileFilter(includeLibs));
        StringBuffer testLibraries = new StringBuffer();
        File[] fileArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            testLibraries.append("\t<classpathentry kind=\"lib\" path=\"lib/" + file.getName() + "\"/>\n");
            ++n2;
        }
        StringBuffer requiredProjects = new StringBuffer();
        requiredProjects.append("\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/" + this.seamWebProject.getName() + "\"/>");
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            requiredProjects.append("\n\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/" + this.ejbProjectName + "\"/>");
        }
        filterSet.addFilter("testLibraries", testLibraries.toString());
        filterSet.addFilter("requiredProjects", requiredProjects.toString());
        File testTemplateDir = null;
        try {
            testTemplateDir = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), TEST_EAR_PROFILE);
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
        AntCopyUtils.FileSet excludeCvsSvn = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.CVS_SVN).dir(testTemplateDir);
        AntCopyUtils.copyFilesAndFolders(testTemplateDir, testProjectDir, new AntCopyUtils.FileSetFileFilter(excludeCvsSvn), new FilterSetCollection(filterSet), true);
        excludeCvsSvn.dir(new File(this.seamRuntime.getHomeDir(), "embedded-ejb/conf"));
        AntCopyUtils.copyFiles(new File(this.seamRuntime.getHomeDir(), "embedded-ejb/conf"), embededEjbDir, new AntCopyUtils.FileSetFileFilter(excludeCvsSvn));
        AntCopyUtils.copyFiles(new File(this.seamRuntime.getHomeDir(), "lib"), testLibDir, new AntCopyUtils.FileSetFileFilter(includeLibs));
        SeamFacetAbstractInstallDelegate.createComponentsProperties(testSrcDir, "", Boolean.TRUE);
        return true;
    }

    protected boolean createTestProject(String testProjectName) {
        if (testProjectName == null) {
            throw new IllegalArgumentException("Test project name must not be null");
        }
        this.testProjectName = testProjectName;
        return this.createTestProject();
    }

    protected void createEjbProject(String ejbProjectName) {
        if (ejbProjectName == null) {
            throw new IllegalArgumentException("EJB project name must not be null");
        }
        this.ejbProjectName = ejbProjectName;
        this.createEjbProject();
    }

    protected void createEjbProject() {
        this.model.setProperty("seam.ejb.project", (Object)this.ejbProjectName);
        this.ejbProjectFolder.mkdir();
        AntCopyUtils.copyFilesAndFolders(this.ejbTemplateDir, this.ejbProjectFolder, new AntCopyUtils.FileSetFileFilter(this.excludeCvsSvn), new FilterSetCollection(this.ejbFilterSet), true);
        AntCopyUtils.copyFileToFile(new File(this.seamGenHomeFolder, "src/Authenticator.java"), new File(this.ejbProjectFolder, "ejbModule/" + this.model.getProperty("action.package").toString().replace('.', '/') + "/" + "Authenticator.java"), new FilterSetCollection(this.filtersFilterSet), true);
        AntCopyUtils.copyFileToFile(this.persistenceFile, new File(this.ejbProjectFolder, "ejbModule/META-INF/persistence.xml"), this.viewFilterSetCollection, true);
        SeamFacetAbstractInstallDelegate.createComponentsProperties(new File(this.ejbProjectFolder, "ejbModule"), this.earProjectName, false);
        AntCopyUtils.FileSet ejbSrcResourcesSet = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.JBOOS_EJB_WEB_INF_CLASSES_SET).dir(this.seamGenResFolder);
        AntCopyUtils.copyFilesAndFolders(this.seamGenResFolder, new File(this.ejbProjectFolder, "ejbModule"), new AntCopyUtils.FileSetFileFilter(ejbSrcResourcesSet), this.viewFilterSetCollection, true);
        AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/ejb-jar.xml"), new File(this.ejbProjectFolder, "ejbModule/META-INF/"), this.viewFilterSetCollection, true);
        FilterSet ejbFilterSet = new FilterSet();
        ejbFilterSet.addFilter("projectName", this.ejbProjectFolder.getName());
        ejbFilterSet.addFilter("connectionProfile", this.model.getStringProperty("seam.project.connection.profile"));
        AntCopyUtils.copyFileToFile(this.hibernateConsoleLaunchFile, new File(this.ejbProjectFolder, String.valueOf(this.getLaunchCfgName(this.ejbProjectFolder.getName())) + ".launch"), new FilterSetCollection(ejbFilterSet), true);
        AntCopyUtils.copyFileToFolder(this.hibernateConsolePropsFile, this.ejbProjectFolder, this.hibernateDialectFilterSet, true);
    }

    protected String getLaunchCfgName(String baseName) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(baseName);
    }

    protected void createEarProject() {
        this.model.setProperty("seam.ear.project", (Object)this.earProjectName);
        this.earProjectFolder.mkdir();
        File earContentsFolder = new File(this.earProjectFolder, "EarContent");
        FilterSet earFilterSet = new FilterSet();
        earFilterSet.addFilter("projectName", String.valueOf(this.earProjectFolder.getName()) + ".ear");
        AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/jboss-app.xml"), new File(earContentsFolder, "META-INF"), new FilterSetCollection(earFilterSet), true);
        try {
            AntCopyUtils.copyFilesAndFolders(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ear"), this.earProjectFolder, new AntCopyUtils.FileSetFileFilter(this.excludeCvsSvn), new FilterSetCollection(this.ejbFilterSet), true);
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        AntCopyUtils.copyFiles(this.seamHomeFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.seamHomeFolder)));
        AntCopyUtils.copyFiles(this.seamLibFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.seamLibFolder)));
        AntCopyUtils.copyFiles(this.droolsLibFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.droolsLibFolder)));
        AntCopyUtils.copyFiles(this.seamGenResFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.seamGenResFolder)));
        File resources = new File(this.earProjectFolder, "resources");
        AntCopyUtils.copyFileToFile(this.dataSourceDsFile, new File(resources, String.valueOf(this.seamWebProject.getName()) + "-ds.xml"), this.viewFilterSetCollection, true);
    }

    protected void createSeamProjectPreferenes() {
        ProjectScope projectScope = new ProjectScope(this.seamWebProject);
        IEclipsePreferences prefs = projectScope.getNode("org.jboss.tools.seam.core");
        String testSrcPath = this.seamWebProject.getFullPath().removeLastSegments(1).append(this.testProjectName).append("test-src").toString();
        prefs.put("seam.test.creating", ((Boolean)this.model.getProperty("seam.test.project.creating")).toString());
        prefs.put("seam.test.project", this.testProjectName);
        prefs.put("test.sources", testSrcPath);
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            prefs.put("seam.ejb.project", this.ejbProjectName);
            prefs.put("seam.ear.project", this.earProjectName);
            String srcPath = this.seamWebProject.getFullPath().removeLastSegments(1).append(this.ejbProjectName).append("ejbModule").toString();
            prefs.put("model.sources", srcPath);
            prefs.put("action.sources", srcPath);
        } else {
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.seamWebProject);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer sourceFolder = rootFolder.getFolder((IPath)new Path("/WEB-INF/classes")).getUnderlyingFolder();
            IContainer parentFolder = sourceFolder.getParent();
            IPath srcRootFolder = parentFolder.getFullPath();
            IPath srcFolder = sourceFolder.getFullPath();
            IPath model = srcRootFolder.append("main");
            IPath action = srcRootFolder.append("hot");
            IResource modelFolder = parentFolder.findMember("main");
            IResource actionFolder = parentFolder.findMember("hot");
            if (modelFolder == null || !modelFolder.exists() || actionFolder == null || !actionFolder.exists()) {
                model = srcFolder;
                action = srcFolder;
            }
            prefs.put("model.sources", model.toString());
            prefs.put("action.sources", action.toString());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void configureJBossAppXml() {
    }
}

