/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoader;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;
import org.jboss.tools.seam.internal.core.scanner.lib.LibraryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPath {
    SeamProject project;
    XModel model = null;
    List<String> paths = null;
    Map<IPath, String> paths2 = new HashMap<IPath, String>();
    Set<String> processedPaths = new HashSet<String>();
    static String[] SYSTEM_JARS = new String[]{"rt.jar", "jsse.jar", "jce.jar", "charsets.jar"};
    static Set<String> SYSTEM_JAR_SET = new HashSet<String>();

    static {
        int i = 0;
        while (i < SYSTEM_JARS.length) {
            SYSTEM_JAR_SET.add(SYSTEM_JARS[i]);
            ++i;
        }
    }

    public ClassPath(SeamProject project) {
        this.project = project;
    }

    public SeamProject getProject() {
        return this.project;
    }

    public void init() {
        this.model = InnerModelHelper.createXModel((IProject)this.project.getProject());
    }

    public boolean update() {
        List newPaths = null;
        try {
            newPaths = EclipseResourceUtil.getClassPath((IProject)this.project.getProject());
            List jre = EclipseResourceUtil.getJREClassPath((IProject)this.project.getProject());
            if (jre != null) {
                newPaths.removeAll(jre);
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        catch (IOException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        if (this.paths == null && newPaths == null) {
            return false;
        }
        if (newPaths == null || this.paths == null || this.paths.size() != newPaths.size()) {
            this.paths = newPaths;
        } else {
            boolean b = false;
            int i = 0;
            while (i < this.paths.size() && !b) {
                if (!this.paths.get(i).equals(newPaths.get(i))) {
                    b = true;
                }
                ++i;
            }
            if (!b) {
                return false;
            }
            this.paths = newPaths;
        }
        this.createMap();
        XModelObject object = this.model.getByPath("FileSystems");
        XModelObject[] fs = object.getChildren("FileSystemJar");
        HashSet<XModelObject> fss = new HashSet<XModelObject>();
        int i = 0;
        while (i < fs.length) {
            fss.add(fs[i]);
            ++i;
        }
        i = 0;
        while (i < this.paths.size()) {
            String fileName;
            String path = this.paths.get(i);
            if (EclipseResourceUtil.isJar((String)path) && !SYSTEM_JAR_SET.contains(fileName = new File(path).getName())) {
                String jsname = "lib-" + fileName;
                XModelObject o = this.model.getByPath("FileSystems").getChildByPath(jsname);
                if (o != null) {
                    fss.remove(o);
                } else {
                    o = object.getModel().createModelObject("FileSystemJar", null);
                    o.setAttributeValue("name", jsname);
                    o.setAttributeValue("location", path);
                    o.set(FileSystemsLoader.IS_ADDED_TO_CLASSPATH, "true");
                    object.addChild(o);
                }
            }
            ++i;
        }
        for (XModelObject o : fss) {
            String path = XModelObjectUtil.expand((String)o.getAttributeValue("location"), (XModel)o.getModel(), null);
            if ("true".equals(o.get(FileSystemsLoader.IS_ADDED_TO_CLASSPATH))) {
                o.removeFromParent();
                continue;
            }
            if (new File(path).exists()) continue;
            o.removeFromParent();
        }
        return true;
    }

    private void createMap() {
        this.paths2.clear();
        if (this.paths != null) {
            for (String p : this.paths) {
                this.paths2.put((IPath)new Path(p), p);
            }
        }
    }

    public void process() {
        Iterator<String> it = this.processedPaths.iterator();
        while (it.hasNext()) {
            String p = it.next();
            if (this.paths.contains(p)) continue;
            this.project.pathRemoved((IPath)new Path(p));
            it.remove();
        }
        int i = 0;
        while (i < this.paths.size()) {
            String p = this.paths.get(i);
            if (!this.processedPaths.contains(p)) {
                this.processedPaths.add(p);
                LibraryScanner scanner = new LibraryScanner();
                scanner.setClassPath(this);
                String fileName = new File(p).getName();
                if (!SYSTEM_JAR_SET.contains(fileName)) {
                    String jsname = "lib-" + fileName;
                    XModelObject o = this.model.getByPath("FileSystems").getChildByPath(jsname);
                    if (o != null) {
                        LoadedDeclarations c = null;
                        try {
                            if (scanner.isLikelyComponentSource(o)) {
                                c = scanner.parse(o, (IPath)new Path(p), this.project);
                            }
                        }
                        catch (ScannerException e) {
                            SeamCorePlugin.getDefault().logError(e);
                        }
                        if (c == null) {
                            c = new LoadedDeclarations();
                        }
                        if (c != null) {
                            this.componentsLoaded(c, (IPath)new Path(p));
                        }
                    }
                }
            }
            ++i;
        }
        this.validateProjectDependencies();
    }

    public void validateProjectDependencies() {
        List<SeamProject> ps = null;
        try {
            ps = this.getSeamProjects(this.project.getProject());
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        if (ps != null) {
            Set<SeamProject> set = this.project.getSeamProjects();
            HashSet<SeamProject> removable = new HashSet<SeamProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (SeamProject p : ps) {
                this.project.addSeamProject(p);
            }
            for (SeamProject p : removable) {
                this.project.removeSeamProject(p);
            }
        }
    }

    public boolean hasToUpdateProjectDependencies() {
        List<SeamProject> ps = null;
        try {
            ps = this.getSeamProjects(this.project.getProject());
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        if (ps != null) {
            Set<SeamProject> set = this.project.getSeamProjects();
            HashSet<SeamProject> removable = new HashSet<SeamProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            Iterator<SeamProject> iterator = ps.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
            iterator = removable.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
        }
        return false;
    }

    void componentsLoaded(LoadedDeclarations c, IPath path) {
        if (c == null) {
            return;
        }
        this.project.registerComponents(c, path);
    }

    List<SeamProject> getSeamProjects(IProject project) throws CoreException {
        ArrayList<SeamProject> list = new ArrayList<SeamProject>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < es.length) {
            ISeamProject sp;
            IProject p;
            if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible() && (sp = SeamCorePlugin.getSeamProject(p, false)) != null) {
                list.add((SeamProject)sp);
            }
            ++i;
        }
        return list;
    }

    public void pathLoaded(IPath path) {
        String p = this.paths2.get(path);
        if (p != null) {
            this.processedPaths.add(p);
        }
    }

    public boolean hasPath(IPath path) {
        return this.paths2.get(path) != null;
    }

    public void clean() {
        this.paths = null;
        if (this.paths2 != null) {
            this.paths2.clear();
        }
        this.processedPaths.clear();
    }
}

