/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.lib;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.internal.core.SeamNamespace;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;
import org.jboss.tools.seam.internal.core.scanner.lib.ClassPath;
import org.jboss.tools.seam.internal.core.scanner.lib.TypeScanner;
import org.jboss.tools.seam.internal.core.scanner.xml.PropertiesScanner;
import org.jboss.tools.seam.internal.core.scanner.xml.XMLScanner;

public class LibraryScanner
implements IFileScanner {
    ClassPath classPath = null;
    IPath sourcePath = null;

    public void setClassPath(ClassPath classPath) {
        this.classPath = classPath;
    }

    public boolean isRelevant(IFile f) {
        return EclipseResourceUtil.isJar((String)f.getName());
    }

    public boolean isLikelyComponentSource(IFile f) {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return false;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (o == null) {
            return false;
        }
        if (!o.getModelEntity().getName().equals("FileSystemJar")) {
            ((FileSystemsImpl)o.getModel().getByPath("FileSystems")).updateOverlapped();
            o = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (o == null || !o.getModelEntity().getName().equals("FileSystemJar")) {
                return false;
            }
        }
        return this.isLikelyComponentSource(o);
    }

    public LoadedDeclarations parse(IFile f, ISeamProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return null;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (o == null) {
            return null;
        }
        if (!o.getModelEntity().getName().equals("FileSystemJar")) {
            ((FileSystemsImpl)o.getModel().getByPath("FileSystems")).updateOverlapped();
            o = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (o == null || !o.getModelEntity().getName().equals("FileSystemJar")) {
                return null;
            }
        }
        return this.parse(o, f.getFullPath(), sp);
    }

    public boolean isLikelyComponentSource(XModelObject o) {
        if (o == null) {
            return false;
        }
        if (o.getChildByPath("seam.properties") != null) {
            return true;
        }
        if (o.getChildByPath("META-INF/seam.properties") != null) {
            return true;
        }
        return o.getChildByPath("META-INF/components.xml") != null;
    }

    public LoadedDeclarations parse(XModelObject o, IPath path, ISeamProject sp) throws ScannerException {
        PropertiesScanner scanner;
        LoadedDeclarations ds1;
        LoadedDeclarations ds12;
        XModelObject componentsXML;
        if (o == null) {
            return null;
        }
        this.sourcePath = path;
        XModelObject seamProperties = o.getChildByPath("META-INF/seam.properties");
        if (seamProperties == null) {
            seamProperties = o.getChildByPath("seam.properties");
        }
        if ((componentsXML = o.getChildByPath("META-INF/components.xml")) == null && seamProperties == null) {
            return null;
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        try {
            this.processJavaClasses(o, ds);
        }
        catch (JavaModelException e) {
            throw new ScannerException(SeamCoreMessages.LIBRARY_SCANNER_CANNOT_PROCESS_JAVA_CLASSES, e);
        }
        if (componentsXML != null && (ds12 = new XMLScanner().parse(componentsXML, path, sp)) != null) {
            ds.add(ds12);
        }
        if (seamProperties != null && (ds1 = (scanner = new PropertiesScanner()).parse(seamProperties, path)) != null) {
            ds.add(ds1);
        }
        return ds;
    }

    protected void processJavaClasses(XModelObject o, LoadedDeclarations ds) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)this.classPath.getProject().getProject());
        String location = o.getAttributeValue("location");
        location = XModelObjectUtil.expand((String)location, (XModel)o.getModel(), null);
        IFile[] fs = ModelPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(location));
        IPackageFragmentRoot root = null;
        if (fs != null) {
            int i = 0;
            while (i < fs.length && root == null) {
                root = javaProject.findPackageFragmentRoot(fs[i].getFullPath());
                ++i;
            }
        }
        if (root == null) {
            root = javaProject.findPackageFragmentRoot((IPath)new Path(location));
        }
        if (root == null) {
            return;
        }
        this.process((IParent)root, ds);
    }

    protected void process(IParent element, LoadedDeclarations ds) throws JavaModelException {
        IClassFile typeRoot;
        if (element == null) {
            return;
        }
        IJavaElement[] es = element.getChildren();
        String prefix = null;
        int i = 0;
        while (i < es.length) {
            if (es[i] instanceof IClassFile) {
                typeRoot = (IClassFile)es[i];
                if (es[i].getElementName().equals("package-info.class")) {
                    prefix = this.processPackageInfo(typeRoot, ds);
                    break;
                }
            }
            ++i;
        }
        i = 0;
        while (i < es.length) {
            if (es[i] instanceof IPackageFragment) {
                this.process((IParent)((IPackageFragment)es[i]), ds);
            } else if (es[i] instanceof IClassFile) {
                typeRoot = (IClassFile)es[i];
                if (!es[i].getElementName().equals("package-info.class")) {
                    this.processWithClassReader(typeRoot, ds, prefix);
                }
            }
            ++i;
        }
    }

    void processWithClassReader(IClassFile typeRoot, LoadedDeclarations ds, String prefix) {
        IType type = typeRoot.getType();
        ClassFileReader reader = this.getReader(type, typeRoot);
        if (reader == null) {
            return;
        }
        LoadedDeclarations ds1 = null;
        TypeScanner scanner = new TypeScanner();
        if (!scanner.isLikelyComponentSource(reader)) {
            return;
        }
        ds1 = scanner.parse(type, reader, this.sourcePath);
        if (ds1 != null) {
            ds.add(ds1);
        }
    }

    String processPackageInfo(IClassFile typeRoot, LoadedDeclarations ds) {
        IType type = typeRoot.getType();
        ClassFileReader reader = this.getReader(type, typeRoot);
        if (reader == null) {
            return null;
        }
        IBinaryAnnotation[] as = reader.getAnnotations();
        IBinaryAnnotation namespaceAnnotation = LibraryScanner.getNamespaceAnnotation(as);
        if (namespaceAnnotation == null) {
            return null;
        }
        String uri = TypeScanner.getValue(namespaceAnnotation, "value");
        String prefix = TypeScanner.getValue(namespaceAnnotation, "prefix");
        if (uri == null) {
            return null;
        }
        String className = type.getFullyQualifiedName();
        int i = className.indexOf(".package-info");
        if (i < 0) {
            return null;
        }
        String packageName = className.substring(0, i);
        SeamNamespace n = new SeamNamespace();
        n.setSourcePath(this.sourcePath);
        n.setURI(uri);
        n.setPackage(packageName);
        ds.getNamespaces().add(n);
        return prefix;
    }

    static IBinaryAnnotation getNamespaceAnnotation(IBinaryAnnotation[] as) {
        if (as != null) {
            int i = 0;
            while (i < as.length) {
                String type = TypeScanner.getTypeName(as[i]);
                if (type != null && type.equals("org.jboss.seam.annotations.Namespace")) {
                    return as[i];
                }
                ++i;
            }
        }
        return null;
    }

    private ClassFileReader getReader(IType type, IClassFile typeRoot) {
        String className = type.getFullyQualifiedName();
        byte[] bs = null;
        try {
            bs = typeRoot.getBytes();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        try {
            return ClassFileReader.read((InputStream)new ByteArrayInputStream(bs), (String)className, (boolean)false);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

