/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.util.JRProperties;
import org.jdesktop.layout.GroupLayout;

public class HtmlExportParametersPanel
extends AbstractExportParametersPanel {
    private JButton jButtonImagesDirectory;
    private JCheckBox jCheckBoxFrameAsNestedTables;
    private JCheckBox jCheckBoxRemoveEmptySpace;
    private JCheckBox jCheckBoxSaveImages;
    private JCheckBox jCheckBoxUseImagesToAlign;
    private JCheckBox jCheckBoxWhiteBackground;
    private JCheckBox jCheckBoxWrapBreakWord;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabelHTMLFooter;
    private JLabel jLabelHeader;
    private JLabel jLabelImagesDirectory;
    private JLabel jLabelImagesDirectory1;
    private JLabel jLabelSizeUnit;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaHtmlBetweenPages;
    private JTextArea jTextAreaHtmlFooter;
    private JTextArea jTextAreaHtmlHeader;
    private JTextField jTextFieldImagesDirectory;
    private JTextField jTextFieldImagesDirectory1;

    public HtmlExportParametersPanel() {
        this.initComponents();
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                HtmlExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                HtmlExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                HtmlExportParametersPanel.this.notifyChange();
            }
        };
        this.jTextFieldImagesDirectory.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldImagesDirectory1.getDocument().addDocumentListener(textfieldListener);
        this.jTextAreaHtmlBetweenPages.getDocument().addDocumentListener(textfieldListener);
        this.jTextAreaHtmlFooter.getDocument().addDocumentListener(textfieldListener);
        this.jTextAreaHtmlHeader.getDocument().addDocumentListener(textfieldListener);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelTitle.setText(I18n.getString("HtmlExportParametersPanel.jLabelTitle.text"));
        this.jCheckBoxSaveImages.setText(I18n.getString("HtmlExportParametersPanel.jCheckBoxSaveImages.text"));
        this.jLabelImagesDirectory.setText(I18n.getString("HtmlExportParametersPanel.jLabelImagesDirectory.text"));
        this.jButtonImagesDirectory.setText(I18n.getString("HtmlExportParametersPanel.jButtonImagesDirectory.text"));
        this.jLabelImagesDirectory1.setText(I18n.getString("HtmlExportParametersPanel.jLabelImagesDirectory1.text"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("HtmlExportParametersPanel.jPanel1.TabConstraints.tabTitle"));
        this.jLabelHeader.setText(I18n.getString("HtmlExportParametersPanel.jLabelHeader.text"));
        this.jLabelHTMLFooter.setText(I18n.getString("HtmlExportParametersPanel.jLabelHTMLFooter.text"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("HtmlExportParametersPanel.jPanel2.TabConstraints.tabTitle"));
        this.jLabel1.setText(I18n.getString("HtmlExportParametersPanel.jLabel1.text"));
        this.jTabbedPane1.setTitleAt(2, I18n.getString("HtmlExportParametersPanel.jPanel3.TabConstraints.tabTitle"));
        this.jCheckBoxRemoveEmptySpace.setText(I18n.getString("HtmlExportParametersPanel.jCheckBoxRemoveEmptySpace.text"));
        this.jCheckBoxWhiteBackground.setText(I18n.getString("HtmlExportParametersPanel.jCheckBoxWhiteBackground.text"));
        this.jCheckBoxUseImagesToAlign.setText(I18n.getString("HtmlExportParametersPanel.jCheckBoxUseImagesToAlign.text"));
        this.jCheckBoxWrapBreakWord.setText(I18n.getString("HtmlExportParametersPanel.jCheckBoxWrapBreakWord.text"));
        this.jLabelSizeUnit.setText(I18n.getString("HtmlExportParametersPanel.jLabelSizeUnit.text"));
        this.jCheckBoxFrameAsNestedTables.setText(I18n.getString("HtmlExportParametersPanel.jCheckBoxFrameAsNestedTables.text"));
        this.jTabbedPane1.setTitleAt(3, I18n.getString("HtmlExportParametersPanel.jPanel4.TabConstraints.tabTitle"));
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jCheckBoxSaveImages = new JCheckBox();
        this.jLabelImagesDirectory = new JLabel();
        this.jTextFieldImagesDirectory = new JTextField();
        this.jButtonImagesDirectory = new JButton();
        this.jTextFieldImagesDirectory1 = new JTextField();
        this.jLabelImagesDirectory1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaHtmlHeader = new JTextArea();
        this.jLabelHeader = new JLabel();
        this.jLabelHTMLFooter = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaHtmlFooter = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaHtmlBetweenPages = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jCheckBoxWhiteBackground = new JCheckBox();
        this.jCheckBoxWrapBreakWord = new JCheckBox();
        this.jLabelSizeUnit = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jCheckBoxRemoveEmptySpace = new JCheckBox();
        this.jCheckBoxUseImagesToAlign = new JCheckBox();
        this.jCheckBoxFrameAsNestedTables = new JCheckBox();
        this.jLabelTitle.setFont(new Font("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 1, 12));
        this.jLabelTitle.setText("HTML\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u30d1\u30e9\u30e1\u30fc\u30bf");
        this.jCheckBoxSaveImages.setText("Save images to disk");
        this.jCheckBoxSaveImages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jCheckBoxSaveImagesActionPerformed(evt);
            }
        });
        this.jLabelImagesDirectory.setText("Images directory");
        this.jButtonImagesDirectory.setText("Browse");
        this.jButtonImagesDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jButtonImagesDirectoryActionPerformed(evt);
            }
        });
        this.jLabelImagesDirectory1.setText("Images URI");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxSaveImages).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelImagesDirectory).add((Component)this.jLabelImagesDirectory1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldImagesDirectory1, -1, 441, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jTextFieldImagesDirectory, -1, 363, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonImagesDirectory))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxSaveImages).add(13, 13, 13).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelImagesDirectory).add((Component)this.jButtonImagesDirectory).add((Component)this.jTextFieldImagesDirectory, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelImagesDirectory1).add((Component)this.jTextFieldImagesDirectory1, -2, -1, -2)).add(10, 10, 10)));
        this.jTabbedPane1.addTab("Images", this.jPanel1);
        this.jTextAreaHtmlHeader.setColumns(20);
        this.jTextAreaHtmlHeader.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaHtmlHeader);
        this.jLabelHeader.setText("HTML header");
        this.jLabelHTMLFooter.setText("HTML footer");
        this.jTextAreaHtmlFooter.setColumns(20);
        this.jTextAreaHtmlFooter.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaHtmlFooter);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 530, Short.MAX_VALUE).add((Component)this.jLabelHeader).add((Component)this.jLabelHTMLFooter).add(2, (Component)this.jScrollPane2, -1, 530, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelHeader).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 71, -2).addPreferredGap(0).add((Component)this.jLabelHTMLFooter).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 71, -2).addContainerGap(17, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Header and Footer", this.jPanel2);
        this.jTextAreaHtmlBetweenPages.setColumns(20);
        this.jTextAreaHtmlBetweenPages.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextAreaHtmlBetweenPages);
        this.jLabel1.setText("HTML between pages");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 530, Short.MAX_VALUE).add((Component)this.jLabel1)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(3, 3, 3).add((Component)this.jScrollPane3, -1, 177, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Between pages", this.jPanel3);
        this.jCheckBoxWhiteBackground.setText("White background");
        this.jCheckBoxWhiteBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jCheckBoxWhiteBackgroundActionPerformed(evt);
            }
        });
        this.jCheckBoxWrapBreakWord.setText("Wrap Break Word");
        this.jCheckBoxWrapBreakWord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jCheckBoxWrapBreakWordActionPerformed(evt);
            }
        });
        this.jLabelSizeUnit.setText("Size Unit");
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"px", "pt"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("HTML  specific options"));
        this.jCheckBoxRemoveEmptySpace.setText("Remove empty space between rows");
        this.jCheckBoxRemoveEmptySpace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jCheckBoxRemoveEmptySpaceActionPerformed(evt);
            }
        });
        this.jCheckBoxUseImagesToAlign.setText("Use images to align");
        this.jCheckBoxUseImagesToAlign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jCheckBoxUseImagesToAlignActionPerformed(evt);
            }
        });
        this.jCheckBoxFrameAsNestedTables.setText("Frames as nested tables");
        this.jCheckBoxFrameAsNestedTables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlExportParametersPanel.this.jCheckBoxFrameAsNestedTablesActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jCheckBoxRemoveEmptySpace).add((Component)this.jCheckBoxUseImagesToAlign).add((Component)this.jCheckBoxFrameAsNestedTables)).addContainerGap(26, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jCheckBoxRemoveEmptySpace).addPreferredGap(0).add((Component)this.jCheckBoxUseImagesToAlign).addPreferredGap(0).add((Component)this.jCheckBoxFrameAsNestedTables)));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.jCheckBoxWhiteBackground).add((Component)this.jCheckBoxWrapBreakWord).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabelSizeUnit).addPreferredGap(0).add((Component)this.jComboBox1, -2, -1, -2)).add((Component)this.jPanel5, -2, -1, -2)).add(301, 301, 301)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxWhiteBackground).addPreferredGap(0).add((Component)this.jCheckBoxWrapBreakWord).addPreferredGap(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabelSizeUnit).add((Component)this.jComboBox1, -2, -1, -2)).addPreferredGap(1).add((Component)this.jPanel5, -2, -1, -2).addContainerGap(41, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Other", this.jPanel4);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(399, Short.MAX_VALUE)).add(2, (Component)this.jSeparator1, -1, 559, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -1, 559, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jTabbedPane1, -1, 240, Short.MAX_VALUE)));
    }

    private void jCheckBoxSaveImagesActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jButtonImagesDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldImagesDirectory.setText(jfc.getSelectedFile().getPath());
        }
        this.notifyChange();
    }

    private void jCheckBoxRemoveEmptySpaceActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxWhiteBackgroundActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxUseImagesToAlignActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxWrapBreakWordActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jCheckBoxFrameAsNestedTablesActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    public void load() {
        this.setInit(true);
        Preferences pref = IReportManager.getPreferences();
        this.jCheckBoxFrameAsNestedTables.setSelected(pref.getBoolean("net.sf.jasperreports.export.html.frames.as.nested.tables", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.frames.as.nested.tables")));
        this.jCheckBoxRemoveEmptySpace.setSelected(pref.getBoolean("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.remove.emtpy.space.between.rows")));
        this.jCheckBoxSaveImages.setSelected(pref.getBoolean("net.sf.jasperreports.export.html.saveImages", true));
        this.jCheckBoxUseImagesToAlign.setSelected(pref.getBoolean("net.sf.jasperreports.export.html.using.images.to.align", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.using.images.to.align")));
        this.jCheckBoxWhiteBackground.setSelected(pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.white.page.background")));
        this.jCheckBoxWrapBreakWord.setSelected(pref.getBoolean("net.sf.jasperreports.export.html.wrap.break.word", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.wrap.break.word")));
        this.jTextFieldImagesDirectory.setText(pref.get("net.sf.jasperreports.export.html.imagesDirectory", ""));
        this.jTextFieldImagesDirectory1.setText(pref.get("net.sf.jasperreports.export.html.imagesUri", ""));
        this.jTextAreaHtmlBetweenPages.setText(pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", ""));
        this.jTextAreaHtmlFooter.setText(pref.get("net.sf.jasperreports.export.html.htmlFooter", ""));
        this.jTextAreaHtmlHeader.setText(pref.get("net.sf.jasperreports.export.html.htmlHeader", ""));
        this.jComboBox1.setSelectedItem(pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")));
        this.setInit(false);
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        pref.putBoolean("net.sf.jasperreports.export.html.frames.as.nested.tables", this.jCheckBoxFrameAsNestedTables.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", this.jCheckBoxRemoveEmptySpace.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.html.saveImages", this.jCheckBoxSaveImages.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.html.using.images.to.align", this.jCheckBoxUseImagesToAlign.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.xls.white.page.background", this.jCheckBoxWhiteBackground.isSelected());
        pref.putBoolean("net.sf.jasperreports.export.html.wrap.break.word", this.jCheckBoxWrapBreakWord.isSelected());
        pref.put("net.sf.jasperreports.export.html.imagesDirectory", this.jTextFieldImagesDirectory.getText());
        pref.put("net.sf.jasperreports.export.html.imagesUri", this.jTextFieldImagesDirectory1.getText());
        pref.put("net.sf.jasperreports.export.html.htmlBetweenPages", this.jTextAreaHtmlBetweenPages.getText());
        pref.put("net.sf.jasperreports.export.html.htmlFooter", this.jTextAreaHtmlFooter.getText());
        pref.put("net.sf.jasperreports.export.html.htmlHeader", this.jTextAreaHtmlHeader.getText());
        pref.put("net.sf.jasperreports.export.html.size.unit", this.jComboBox1.getSelectedItem() + "");
    }

    public boolean valid() {
        return true;
    }

    public String getDisplayName() {
        return I18n.getString("HtmlExportParametersPanel.title");
    }
}

