/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.toolbars;

import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.openide.util.NbBundle;

public class FontListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel jLabelFontName;
    private JLabel jLabelSample;

    public FontListCellRenderer() {
        this.initComponents();
    }

    public void setFontInfo(String name, Font font) {
        this.jLabelSample.setFont(font);
        if (font == null || name.length() == 0) {
            this.jLabelSample.setText(" ");
        } else {
            this.jLabelSample.setText("\u30b5\u30f3\u30d7\u30eb");
        }
        this.jLabelFontName.setText(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color c;
        if (value != null) {
            if ((value + "").equals("--")) {
                JSeparator separator = new JSeparator();
                Dimension size = new Dimension(1, 14);
                separator.setPreferredSize(size);
                return separator;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(IReportManager.getJRExtensionsClassLoader());
                Font f = JRFontUtil.getAwtFontFromBundles((String)("" + value), (int)0, (int)12, null, (boolean)true);
                if (f == null) {
                    f = new Font("" + value, 0, 12);
                }
                this.setFontInfo("" + value, f);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        if (!isSelected) {
            c = UIManager.getColor("List.background");
            if (c != null) {
                this.setBackground(c);
            }
            if ((c = UIManager.getColor("List.foreground")) != null) {
                this.jLabelFontName.setForeground(c);
                this.jLabelSample.setForeground(c);
            }
        } else {
            c = UIManager.getColor("List.selectionBackground");
            if (c != null) {
                this.setBackground(c);
            }
            if ((c = UIManager.getColor("List.selectionForeground")) != null) {
                this.jLabelFontName.setForeground(c);
                this.jLabelSample.setForeground(c);
            }
        }
        return this;
    }

    private void initComponents() {
        this.jLabelFontName = new JLabel();
        this.jLabelSample = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabelFontName.setText(NbBundle.getMessage(FontListCellRenderer.class, (String)"FontListCellRenderer.jLabelFontName.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jLabelFontName, gridBagConstraints);
        this.jLabelSample.setFont(new Font("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 0, 14));
        this.jLabelSample.setHorizontalAlignment(4);
        this.jLabelSample.setText(NbBundle.getMessage(FontListCellRenderer.class, (String)"FontListCellRenderer.jLabelSample.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.jLabelSample, gridBagConstraints);
    }
}

