/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.wizards.CustomChooserWizardPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;

public final class CustomChooserVisualPanel
extends JPanel {
    private String extension = ".jrxml";
    private CustomChooserWizardPanel panel = null;
    private JButton jButtonDirectory;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextFieldDirectory;
    private JTextField jTextFieldFileName;
    private JTextField jTextFieldReportName;

    public CustomChooserVisualPanel(CustomChooserWizardPanel panel) {
        this.initComponents();
        this.panel = panel;
        this.jTextFieldReportName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CustomChooserVisualPanel.this.updateFileName();
                CustomChooserVisualPanel.this.getPanel().fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                CustomChooserVisualPanel.this.updateFileName();
                CustomChooserVisualPanel.this.getPanel().fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                CustomChooserVisualPanel.this.updateFileName();
                CustomChooserVisualPanel.this.getPanel().fireChangeEvent();
            }
        });
        this.jTextFieldDirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CustomChooserVisualPanel.this.updateFileName();
                CustomChooserVisualPanel.this.getPanel().fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                CustomChooserVisualPanel.this.updateFileName();
                CustomChooserVisualPanel.this.getPanel().fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                CustomChooserVisualPanel.this.updateFileName();
                CustomChooserVisualPanel.this.getPanel().fireChangeEvent();
            }
        });
    }

    public String getName() {
        return I18n.getString("CustomChooserVisualPanel.Name.NameLocation");
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jTextFieldReportName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldDirectory = new JTextField();
        this.jButtonDirectory = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldFileName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLabel2.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)"\u30ec\u30dd\u30fc\u30c8\u540d\uff1a");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 4, 4);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 10);
        this.add((Component)this.jTextFieldReportName, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"\u5834\u6240\uff1a");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 4, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 10);
        this.add((Component)this.jTextFieldDirectory, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDirectory, (String)"\u53c2\u7167");
        this.jButtonDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomChooserVisualPanel.this.jButtonDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 4, 10);
        this.add((Component)this.jButtonDirectory, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)"\u30d5\u30a1\u30a4\u30eb\uff1a");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 4);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextFieldFileName.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.jTextFieldFileName, gridBagConstraints);
    }

    private void jButtonDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        int status = fileChooser.showSaveDialog(this);
        if (status == 0) {
            File selectedDir = fileChooser.getSelectedFile();
            this.jTextFieldDirectory.setText(selectedDir.getPath());
        }
    }

    public CustomChooserWizardPanel getPanel() {
        return this.panel;
    }

    public void setPanel(CustomChooserWizardPanel panel) {
        this.panel = panel;
    }

    public void setTargetDirectory(String dir) {
        this.jTextFieldDirectory.setText(dir);
        this.updateFileName();
    }

    public void setReportName(String name) {
        if (name == null) {
            name = "";
        }
        this.jTextFieldReportName.setText(name);
        this.updateFileName();
    }

    public String getTargetDirectory() {
        return this.jTextFieldDirectory.getText();
    }

    public String getReportName() {
        return this.jTextFieldReportName.getText();
    }

    public String getFileName() {
        return this.jTextFieldFileName.getText();
    }

    private void updateFileName() {
        String dir = this.jTextFieldDirectory.getText();
        String fname = this.jTextFieldReportName.getText().trim();
        if (!fname.endsWith(this.getExtension())) {
            fname = fname + this.getExtension();
        }
        File finalFile = new File(dir, fname);
        this.jTextFieldFileName.setText(finalFile.getPath());
    }

    public void validateForm() throws IllegalArgumentException {
        if (this.jTextFieldReportName.getText().trim().length() == 0) {
            throw new IllegalArgumentException(I18n.getString("CustomChooserVisualPanel.Message.Exception"));
        }
        if (this.jTextFieldDirectory.getText().trim().length() == 0) {
            throw new IllegalArgumentException(I18n.getString("CustomChooserVisualPanel.Message.Exception2"));
        }
        String dir = this.jTextFieldDirectory.getText();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            throw new IllegalArgumentException(I18n.getString("CustomChooserVisualPanel.Message.Exception3"));
        }
        String fname = this.jTextFieldReportName.getText().trim();
        File finalFile = new File(dir, fname = fname + this.getExtension());
        if (finalFile.exists()) {
            throw new IllegalArgumentException(I18n.getString("CustomChooserVisualPanel.Message.Exception4", (Object)fname));
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
        this.updateFileName();
        this.getPanel().fireChangeEvent();
    }

    void setNameLabel(String string) {
        this.jLabel2.setText(string);
    }
}

