/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.CDATASectionImpl;
import org.netbeans.modules.xml.text.syntax.dom.CommentImpl;
import org.netbeans.modules.xml.text.syntax.dom.DocumentTypeImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.ProcessingInstructionImpl;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.ErrorManager;

public class XMLDocumentModelProvider
implements DocumentModelProvider {
    public static final String XML_TAG = "tag";
    public static final String XML_EMPTY_TAG = "empty_tag";
    public static final String XML_CONTENT = "content";
    public static final String XML_PI = "pi";
    public static final String XML_CDATA = "cdata";
    public static final String XML_DOCTYPE = "doctype";
    public static final String XML_COMMENT = "comment";
    public static final String XML_ERROR = "error";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.measure");

    public void updateModel(DocumentModel.DocumentModelModificationTransaction documentModelModificationTransaction, DocumentModel documentModel, DocumentModel.DocumentChange[] documentChangeArray) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        long l = System.currentTimeMillis();
        if (debug) {
            System.out.println("\n\n\n\n\n");
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure((DocumentElement)documentModel.getRootElement());
        }
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        for (int i = 0; i < documentChangeArray.length; ++i) {
            Object object;
            Object badLocationException;
            DocumentElement documentElement;
            DocumentElement documentElement2;
            int n;
            block37: {
                DocumentModel.DocumentChange documentChange = documentChangeArray[i];
                n = documentChange.getChangeStart().getOffset();
                int n2 = documentChange.getChangeLength();
                documentElement = documentElement2 = documentModel.getLeafElementForOffset(n);
                if (debug) {
                    System.out.println("");
                }
                if (debug) {
                    System.out.println(documentChange);
                }
                try {
                    if (debug) {
                        System.out.println("inserted text:'" + documentModel.getDocument().getText(n, n2) + "'");
                    }
                }
                catch (BadLocationException badLocationException2) {
                    // empty catch block
                }
                if (debug) {
                    System.out.println("leaf = " + documentElement2);
                }
                XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)((BaseDocument)documentModel.getDocument()).getSyntaxSupport();
                boolean bl = false;
                boolean bl2 = false;
                try {
                    for (badLocationException = xMLSyntaxSupport.getTokenChain(n, n + 1); badLocationException != null && badLocationException.getOffset() < n + n2; badLocationException = badLocationException.getNext()) {
                        if (badLocationException.getTokenID() == XMLTokenIDs.TEXT || badLocationException.getTokenID() == XMLTokenIDs.DECLARATION || badLocationException.getTokenID() == XMLTokenIDs.BLOCK_COMMENT || badLocationException.getTokenID() == XMLTokenIDs.PI_CONTENT || badLocationException.getTokenID() == XMLTokenIDs.CDATA_SECTION) {
                            bl = true;
                        } else {
                            if (badLocationException.getTokenID() != XMLTokenIDs.ARGUMENT && badLocationException.getTokenID() != XMLTokenIDs.OPERATOR && badLocationException.getTokenID() != XMLTokenIDs.VALUE) continue;
                            bl2 = true;
                        }
                        break;
                    }
                }
                catch (BadLocationException badLocationException3) {
                    ErrorManager.getDefault().notify(16, (Throwable)badLocationException3);
                }
                if (bl && (documentElement2.getType().equals(XML_CONTENT) || documentElement2.getType().equals(XML_DOCTYPE) || documentElement2.getType().equals(XML_PI) || documentElement2.getType().equals(XML_COMMENT) || documentElement2.getType().equals(XML_CDATA))) {
                    if (debug) {
                        System.out.println("ONLY CONTENT UPDATE!!!");
                    }
                    documentModelModificationTransaction.updateDocumentElementText(documentElement2);
                    if (documentChange.getChangeLength() == 1) continue;
                }
                if ((bl2 || documentChange.getChangeType() == 1) && (documentElement2.getType().equals(XML_TAG) || documentElement2.getType().equals(XML_EMPTY_TAG))) {
                    if (debug) {
                        System.out.println("POSSIBLE ATTRIBS UPDATE!!!");
                    }
                    try {
                        badLocationException = xMLSyntaxSupport.getElementChain(documentElement2.getStartOffset() + 1);
                        if (!(badLocationException instanceof Tag) && !(badLocationException instanceof EmptyTag)) break block37;
                        Map map = this.createAttributesMap((Tag)badLocationException);
                        object = documentElement2.getAttributes();
                        boolean bl3 = false;
                        if (object.getAttributeCount() == map.size()) {
                            for (String string : map.keySet()) {
                                String string2 = (String)map.get(string);
                                if (string == null || string2 == null || object.containsAttribute(string, string2)) continue;
                                bl3 = true;
                                break;
                            }
                        } else {
                            bl3 = true;
                        }
                        if (bl3) {
                            documentModelModificationTransaction.updateDocumentElementAttribs(documentElement2, map);
                        }
                    }
                    catch (BadLocationException badLocationException4) {
                        ErrorManager.getDefault().notify(16, (Throwable)badLocationException4);
                    }
                }
            }
            if (documentElement2.getStartOffset() == documentElement2.getEndOffset() || n == documentElement2.getStartOffset() || n == documentElement2.getEndOffset()) {
                documentElement = documentElement2.getParentElement();
            } else if (documentElement2.getType().equals(XML_CONTENT)) {
                while ((documentElement = documentElement.getParentElement()) != null && documentElement.getType().equals(XML_CONTENT)) {
                }
                if (documentElement == null) {
                    documentElement = documentModel.getRootElement();
                }
            }
            if (documentElement == null) {
                documentElement = documentModel.getRootElement();
            }
            badLocationException = arrayList.iterator();
            boolean bl = false;
            while (badLocationException.hasNext()) {
                object = (DocumentElement)badLocationException.next();
                if (!object.equals((Object)documentElement) && !documentModel.isDescendantOf((DocumentElement)object, documentElement)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = new ArrayList();
            for (DocumentElement documentElement3 : arrayList) {
                if (!documentModel.isDescendantOf(documentElement, documentElement3)) continue;
                ((ArrayList)object).add(documentElement3);
            }
            arrayList.removeAll((Collection<?>)object);
            arrayList.add(documentElement);
            if (debug) {
                System.out.println("===================================================================");
            }
            if (debug) {
                System.out.println("change happened in " + documentElement2);
            }
            if (!debug) continue;
            System.out.println("we will regenerate its parent " + documentElement);
        }
        for (DocumentElement documentElement : arrayList) {
            this.generateDocumentElements(documentModelModificationTransaction, documentModel, documentElement);
        }
        if (measure) {
            System.out.println("[xmlmodel] generated in " + (System.currentTimeMillis() - l));
        }
    }

    private void generateDocumentElements(DocumentModel.DocumentModelModificationTransaction documentModelModificationTransaction, DocumentModel documentModel, DocumentElement documentElement) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        int n = documentElement.getStartOffset();
        int n2 = documentElement.getEndOffset();
        BaseDocument baseDocument = (BaseDocument)documentModel.getDocument();
        XMLSyntaxSupport xMLSyntaxSupport = new XMLSyntaxSupport(baseDocument);
        if (debug) {
            System.out.println("[XMLDocumentModelProvider] regenerating " + documentElement);
        }
        TreeSet<DocumentElement> treeSet = new TreeSet<DocumentElement>(DocumentModel.ELEMENTS_COMPARATOR);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            Stack<SyntaxElement> stack = new Stack<SyntaxElement>();
            Object object4 = xMLSyntaxSupport.getElementChain(Math.min(baseDocument.getLength(), n + 1));
            while (object4 != null && this.getSyntaxElementEndOffset((SyntaxElement)object4) <= n2) {
                if (object4 instanceof SyntaxElement.Error) {
                    if (debug) {
                        System.out.println("Error found! => adding error element.");
                    }
                    object3 = baseDocument.getText(((SyntaxElement)object4).getElementOffset(), ((SyntaxElement)object4).getElementLength());
                    treeSet.add(documentModelModificationTransaction.addDocumentElement((String)object3, XML_ERROR, Collections.EMPTY_MAP, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                }
                if (object4 instanceof StartTag) {
                    object3 = (StartTag)object4;
                    object2 = DocumentModelUtils.findElement((DocumentModel)documentModel, (int)((SyntaxElement)object4).getElementOffset(), (String)((Tag)object3).getTagName(), (String)XML_TAG);
                    if (object2 != null && !object2.equals((Object)documentElement) && (object = xMLSyntaxSupport.getElementChain(Math.min(baseDocument.getLength(), object2.getEndOffset() + 1))) instanceof EndTag && ((EndTag)object).getTagName().equals(((Tag)object3).getTagName())) {
                        if (debug) {
                            System.out.println("found existing element " + object2 + " => skipping");
                        }
                        object4 = ((SyntaxElement)object).getNext();
                        arrayList.add(object2);
                        continue;
                    }
                    stack.push((SyntaxElement)object4);
                } else if (object4 instanceof EndTag) {
                    if (!stack.isEmpty()) {
                        object3 = (StartTag)stack.peek();
                        if (((EndTag)object4).getTagName().equals(((Tag)object3).getTagName())) {
                            object2 = this.createAttributesMap((Tag)object3);
                            treeSet.add(documentModelModificationTransaction.addDocumentElement(((Tag)object3).getTagName(), XML_TAG, (Map)object2, ((SyntaxElement)object3).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                            stack.pop();
                        } else {
                            object2 = new ArrayList();
                            boolean bl = false;
                            while (!stack.isEmpty()) {
                                SyntaxElement syntaxElement = (SyntaxElement)stack.pop();
                                ((ArrayList)object2).add(syntaxElement);
                                Tag tag = (Tag)syntaxElement;
                                Tag tag2 = (Tag)object4;
                                if (!(syntaxElement instanceof StartTag) || !tag.getTagName().equals(tag2.getTagName())) continue;
                                Map map = this.createAttributesMap((StartTag)syntaxElement);
                                treeSet.add(documentModelModificationTransaction.addDocumentElement(tag.getTagName(), XML_TAG, map, tag.getElementOffset(), this.getSyntaxElementEndOffset(tag2)));
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                for (int i = ((ArrayList)object2).size() - 1; i >= 0; --i) {
                                    stack.push((SyntaxElement)((ArrayList)object2).get(i));
                                }
                            }
                        }
                    }
                } else if (object4 instanceof EmptyTag) {
                    object3 = this.createAttributesMap((Tag)object4);
                    treeSet.add(documentModelModificationTransaction.addDocumentElement(((EmptyTag)object4).getTagName(), XML_EMPTY_TAG, (Map)object3, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                } else if (object4 instanceof CDATASectionImpl) {
                    treeSet.add(documentModelModificationTransaction.addDocumentElement(XML_CDATA, XML_CDATA, Collections.EMPTY_MAP, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                } else if (object4 instanceof ProcessingInstructionImpl) {
                    object3 = ((ProcessingInstructionImpl)object4).getNodeName();
                    if (object3 != null) {
                        treeSet.add(documentModelModificationTransaction.addDocumentElement((String)object3, XML_PI, Collections.EMPTY_MAP, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                    }
                } else if (object4 instanceof DocumentTypeImpl) {
                    object3 = ((DocumentTypeImpl)object4).getName();
                    if (object3 != null) {
                        treeSet.add(documentModelModificationTransaction.addDocumentElement((String)object3, XML_DOCTYPE, Collections.EMPTY_MAP, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                    }
                } else if (object4 instanceof CommentImpl) {
                    treeSet.add(documentModelModificationTransaction.addDocumentElement(XML_COMMENT, XML_COMMENT, Collections.EMPTY_MAP, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                } else {
                    treeSet.add(documentModelModificationTransaction.addDocumentElement("...", XML_CONTENT, Collections.EMPTY_MAP, ((SyntaxElement)object4).getElementOffset(), this.getSyntaxElementEndOffset((SyntaxElement)object4)));
                }
                try {
                    object3 = null;
                    int n3 = 0;
                    while ((object3 = xMLSyntaxSupport.getElementChain(((SyntaxElement)object4).getElementOffset() + ((SyntaxElement)object4).getElementLength() + ++n3)) != null && ((SyntaxElement)object4).getElementOffset() >= ((SyntaxElement)object3).getElementOffset()) {
                    }
                    object4 = object3;
                }
                catch (BadLocationException badLocationException) {
                    object4 = null;
                }
            }
            object3 = this.getDescendantsOfNotSkippedElements(documentElement, arrayList);
            object3.add(documentElement);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (DocumentElement)object2.next();
                if (treeSet.contains(object)) continue;
                documentModelModificationTransaction.removeDocumentElement((DocumentElement)object, false);
                if (!debug) continue;
                System.out.println("[xml model] removed element " + object);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new DocumentModelException("Error occurred during generation of Document elements", (Throwable)badLocationException);
        }
    }

    private List getDescendantsOfNotSkippedElements(DocumentElement documentElement, List list) {
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        for (DocumentElement documentElement2 : documentElement.getChildren()) {
            if (list.contains(documentElement2)) continue;
            arrayList.add(documentElement2);
            arrayList.addAll(this.getDescendantsOfNotSkippedElements(documentElement2, list));
        }
        return arrayList;
    }

    private int getSyntaxElementEndOffset(SyntaxElement syntaxElement) {
        return syntaxElement.getElementOffset() + syntaxElement.getElementLength() - 1;
    }

    private Map createAttributesMap(Tag tag) {
        if (tag.getAttributes().getLength() == 0) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(tag.getAttributes().getLength());
        for (int i = 0; i < tag.getAttributes().getLength(); ++i) {
            AttrImpl attrImpl = (AttrImpl)tag.getAttributes().item(i);
            linkedHashMap.put(attrImpl.getName(), attrImpl.getValue());
        }
        return linkedHashMap;
    }
}

