/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.parsers;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.netbeans.api.xml.parsers.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SAXEntityParser
implements XMLReader {
    private static final long RANDOM = System.currentTimeMillis();
    private static final String FAKE_SYSTEM_ID = "NetBeans:Fake-System-ID-" + RANDOM;
    private static final String FAKE_PUBLIC_ID = "-//NetBeans//Fake Public ID " + RANDOM + "//EN";
    private final XMLReader peer;
    private final boolean generalEntity;
    private boolean used = false;

    public SAXEntityParser(XMLReader xMLReader) {
        this(xMLReader, true);
    }

    public SAXEntityParser(XMLReader xMLReader, boolean bl) {
        if (xMLReader == null) {
            throw new NullPointerException();
        }
        this.peer = xMLReader;
        this.generalEntity = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        Object object;
        Object object2;
        Object object3;
        if (inputSource == null) {
            throw new NullPointerException();
        }
        Object object4 = this;
        synchronized (object4) {
            this.checkUsed();
            this.used = true;
        }
        object4 = inputSource.getSystemId();
        if (object4 == null) {
            object3 = Util.THIS.getErrorManager();
            if (object3.isLoggable(16)) {
                object2 = new StringWriter();
                object = new PrintWriter((Writer)object2);
                new IllegalArgumentException("WARNING: Missing system ID may cause serious errors while resolving relative references!").printStackTrace((PrintWriter)object);
                ((PrintWriter)object).flush();
                object3.log(16, ((StringWriter)object2).getBuffer().toString());
            }
        }
        object3 = this.peer.getEntityResolver();
        this.peer.setEntityResolver(new ER((EntityResolver)object3, inputSource));
        object2 = this.peer.getErrorHandler();
        if (object2 != null) {
            this.peer.setErrorHandler(new EH((ErrorHandler)object2));
        }
        if (((InputSource)(object = this.wrapInputSource(inputSource))).getSystemId() == null) {
            ((InputSource)object).setSystemId((String)object4);
        }
        if (((InputSource)object).getPublicId() == null) {
            ((InputSource)object).setPublicId(FAKE_PUBLIC_ID);
        }
        this.peer.parse((InputSource)object);
    }

    protected InputSource wrapInputSource(InputSource inputSource) {
        String string;
        String string2 = inputSource.getSystemId();
        InputSource inputSource2 = new InputSource(FAKE_SYSTEM_ID);
        if (this.generalEntity) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<!DOCTYPE fakeDocument" + RANDOM + " [\n");
            String string3 = " PUBLIC '" + FAKE_PUBLIC_ID + "' '" + string2 + "'";
            stringBuffer.append("<!ENTITY fakeEntity" + RANDOM + string3 + ">\n");
            stringBuffer.append("]>\n");
            stringBuffer.append("<fakeDocument" + RANDOM + ">\n");
            stringBuffer.append("&fakeEntity" + RANDOM + ";\n");
            stringBuffer.append("</fakeDocument" + RANDOM + ">\n");
            string = stringBuffer.toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = " PUBLIC '" + FAKE_PUBLIC_ID + "' '" + string2 + "'";
            stringBuffer.append("<!DOCTYPE fakeDocument" + RANDOM + string4 + ">\n");
            stringBuffer.append("<fakeDocument" + RANDOM + "/>\n");
            string = stringBuffer.toString();
        }
        inputSource2.setCharacterStream(new StringReader(string));
        return inputSource2;
    }

    protected boolean propagateException(SAXParseException sAXParseException) {
        if (sAXParseException == null) {
            return false;
        }
        return !FAKE_SYSTEM_ID.equals(sAXParseException.getSystemId());
    }

    public ContentHandler getContentHandler() {
        return this.peer.getContentHandler();
    }

    public DTDHandler getDTDHandler() {
        return this.peer.getDTDHandler();
    }

    public EntityResolver getEntityResolver() {
        return this.peer.getEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.peer.getErrorHandler();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.peer.getFeature(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.peer.getProperty(string);
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.peer.setContentHandler(contentHandler);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.peer.setDTDHandler(dTDHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.peer.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.peer.setErrorHandler(errorHandler);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.peer.setFeature(string, bl);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.peer.setProperty(string, object);
    }

    private synchronized void checkUsed() {
        if (this.used) {
            throw new IllegalStateException();
        }
    }

    private class EH
    implements ErrorHandler {
        private final ErrorHandler peer;

        public EH(ErrorHandler errorHandler) {
            this.peer = errorHandler;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (SAXEntityParser.this.propagateException(sAXParseException)) {
                this.peer.error(sAXParseException);
            } else {
                Util.THIS.debug("SAXEntityParser: filtering out:", sAXParseException);
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            if (SAXEntityParser.this.propagateException(sAXParseException)) {
                this.peer.fatalError(sAXParseException);
            } else {
                Util.THIS.debug("SAXEntityParser: filtering out:", sAXParseException);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (SAXEntityParser.this.propagateException(sAXParseException)) {
                this.peer.warning(sAXParseException);
            } else {
                Util.THIS.debug("SAXEntityParser: filtering out:", sAXParseException);
            }
        }
    }

    private class ER
    implements EntityResolver {
        private boolean entityResolved;
        private final EntityResolver peer;
        private final InputSource entity;

        public ER(EntityResolver entityResolver, InputSource inputSource) {
            this.peer = entityResolver;
            this.entity = inputSource;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            Util.THIS.debug("SAXEntityParser:resolving PID: " + string + " SID: " + string2);
            if (this.isFirstRequest()) {
                Util.THIS.debug("SAXEntityParser:redirecting to " + this.entity + " SID: " + this.entity.getSystemId());
                if (this.peer != null && this.entity.getByteStream() == null && this.entity.getCharacterStream() == null) {
                    return this.peer.resolveEntity(this.entity.getPublicId(), this.entity.getSystemId());
                }
                return this.entity;
            }
            if (this.peer == null) {
                return null;
            }
            return this.peer.resolveEntity(string, string2);
        }

        private synchronized boolean isFirstRequest() {
            if (!this.entityResolved) {
                this.entityResolved = true;
                return true;
            }
            return false;
        }
    }
}

