/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;

public class XlsxParagraphHelper
extends BaseHelper {
    private static final String HORIZONTAL_ALIGN_LEFT = "left";
    private static final String HORIZONTAL_ALIGN_RIGHT = "right";
    private static final String HORIZONTAL_ALIGN_CENTER = "center";
    private static final String HORIZONTAL_ALIGN_JUSTIFY = "justify";
    private boolean pageBreak = false;

    public XlsxParagraphHelper(Writer writer, boolean pageBreak) {
        super(writer);
        this.pageBreak = pageBreak;
    }

    public void exportProps(JRStyle style) {
        this.exportPropsHeader(null);
        this.exportAlignment(XlsxParagraphHelper.getHorizontalAlignment(style.getOwnHorizontalAlignmentValue()));
        this.exportPropsFooter();
    }

    public void exportProps(JRPrintText text) {
        this.exportPropsHeader(text.getStyle() == null ? null : text.getStyle().getName());
        this.exportAlignment(XlsxParagraphHelper.getHorizontalAlignment(text.getOwnHorizontalAlignmentValue()));
        this.exportPropsFooter();
    }

    private void exportPropsHeader(String styleNameReference) {
        this.write("      <w:pPr>\n");
        if (styleNameReference != null) {
            this.write("        <w:pStyle w:val=\"" + styleNameReference + "\"/>\n");
        }
        if (this.pageBreak) {
            this.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
    }

    private void exportAlignment(String horizontalAlignment) {
        if (horizontalAlignment != null) {
            this.write("   <w:jc w:val=\"" + horizontalAlignment + "\" />\n");
        }
    }

    private void exportPropsFooter() {
        this.write("      </w:pPr>\n");
    }

    public void exportEmptyParagraph() {
        this.write("     <w:p><w:pPr>\n");
        if (this.pageBreak) {
            this.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
        this.write("     </w:pPr></w:p>\n");
    }

    public static String getHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        if (horizontalAlignment != null) {
            switch (horizontalAlignment) {
                case RIGHT: {
                    return HORIZONTAL_ALIGN_RIGHT;
                }
                case CENTER: {
                    return HORIZONTAL_ALIGN_CENTER;
                }
                case JUSTIFIED: {
                    return HORIZONTAL_ALIGN_JUSTIFY;
                }
            }
            return HORIZONTAL_ALIGN_LEFT;
        }
        return null;
    }
}

