/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.validation;

import com.jaspersoft.ireport.jasperserver.validation.ElementValidationItem;
import com.jaspersoft.ireport.jasperserver.validation.ImageElementValidationItem;
import com.jaspersoft.ireport.jasperserver.validation.SubReportElementValidationItem;
import com.jaspersoft.ireport.jasperserver.validation.TemplateElementValidationItem;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AlignedTableCellRenderer
extends DefaultTableCellRenderer {
    private int alignment = 4;
    static ImageIcon imageIcon;
    static ImageIcon subreportIcon;
    static ImageIcon unknownIcon;
    static ImageIcon linkIcon;
    static ImageIcon templateIcon;

    public AlignedTableCellRenderer() {
        this(4);
    }

    public AlignedTableCellRenderer(int alignment) {
        if (subreportIcon == null) {
            subreportIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/ui/resources/subreport-16.png"));
        }
        if (imageIcon == null) {
            imageIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/ui/resources/image-16.png"));
        }
        if (templateIcon == null) {
            templateIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/style-16.png"));
        }
        if (unknownIcon == null) {
            unknownIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/unknow.png"));
        }
        if (linkIcon == null) {
            linkIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/link.png"));
        }
        this.alignment = alignment;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            ((JLabel)c).setHorizontalAlignment(this.getAlignment());
            if (value instanceof ElementValidationItem && ((ElementValidationItem)value).isStoreAsLink()) {
                ((JLabel)c).setIcon(linkIcon);
                ((JLabel)c).setText("Linked resource");
            } else if (value instanceof ImageElementValidationItem) {
                ((JLabel)c).setIcon(imageIcon);
                ((JLabel)c).setText("Image");
            } else if (value instanceof SubReportElementValidationItem) {
                ((JLabel)c).setIcon(subreportIcon);
                ((JLabel)c).setText("Subreport");
            } else if (value instanceof TemplateElementValidationItem) {
                ((JLabel)c).setIcon(templateIcon);
                ((JLabel)c).setText("Template");
            } else if (value instanceof ElementValidationItem) {
                ((JLabel)c).setIcon(unknownIcon);
                ((JLabel)c).setText("Other resource type");
            }
        }
        return c;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
}

