/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.wizard;

import com.jaspersoft.ireport.components.table.wizard.TableWizardPanel1;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.crosstab.wizard.DatasetListCellRenderer;
import com.jaspersoft.ireport.designer.undo.AddDatasetUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.DatasetWizardIterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class TableVisualPanel1
extends JPanel {
    private TableWizardPanel1 wizardPanel = null;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JComboBox jComboBoxDataset;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelNoDatasets;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JSpinner jSpinner1;

    public TableVisualPanel1(TableWizardPanel1 wizardPanel) {
        this.initComponents();
        this.wizardPanel = wizardPanel;
        this.jComboBoxDataset.setRenderer(new DatasetListCellRenderer());
        this.updateDatasets();
        if (this.jComboBoxDataset.getItemCount() > 0) {
            this.jRadioButton1.setSelected(true);
        } else {
            this.jRadioButton2.setSelected(true);
        }
    }

    public String getName() {
        return "\u65b0\u3057\u3044\u30c6\u30fc\u30d6\u30eb";
    }

    public void updateDatasets() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.jComboBoxDataset.getModel();
        model.removeAllElements();
        JasperDesign design = IReportManager.getInstance().getActiveReport();
        if (design == null) {
            return;
        }
        List datasets = design.getDatasetsList();
        for (int i = 0; i < datasets.size(); ++i) {
            model.addElement(datasets.get(i));
        }
        if (this.jComboBoxDataset.getItemCount() > 0) {
            this.jComboBoxDataset.setSelectedIndex(0);
        }
        this.updateOptions();
        this.jComboBoxDataset.updateUI();
    }

    public void validateForm() {
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jComboBoxDataset = new JComboBox();
        this.jLabelNoDatasets = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setEnabled(false);
        this.jRadioButton1.setLabel(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jRadioButton1.label"));
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableVisualPanel1.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setActionCommand(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jRadioButton2.actionCommand"));
        this.jRadioButton2.setLabel(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jRadioButton2.label"));
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableVisualPanel1.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jComboBoxDataset.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxDataset.setEnabled(false);
        this.jComboBoxDataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableVisualPanel1.this.jComboBoxDatasetActionPerformed(evt);
            }
        });
        this.jLabelNoDatasets.setForeground(new Color(153, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.jLabelNoDatasets, (String)NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jLabelNoDatasets.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jLabel2.text"));
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(1), null, (Number)1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jLabel3.text"));
        this.jButton1.setLabel(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jButton1.label"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableVisualPanel1.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(27, 27, 27).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jSpinner1, -2, 53, -2)))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButton2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButton1)).add((GroupLayout.Group)layout.createSequentialGroup().add(27, 27, 27).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jComboBoxDataset, -2, 208, -2).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()).add((Component)this.jLabelNoDatasets, -1, 342, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(25, 25, 25).add((Component)this.jRadioButton1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxDataset, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((Component)this.jLabelNoDatasets).add(30, 30, 30).add((Component)this.jRadioButton2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jSpinner1, -2, -1, -2)).addPreferredGap(1).add((Component)this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        this.jRadioButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jRadioButton1.AccessibleContext.accessibleName"));
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jLabel2.AccessibleContext.accessibleName"));
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.getWizardPanel().updateWizardPanels();
        this.getWizardPanel().fireChangeEvent();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.getWizardPanel().updateWizardPanels();
        this.getWizardPanel().fireChangeEvent();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            boolean cancelled;
            DatasetWizardIterator iterator = new DatasetWizardIterator();
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
            iterator.initialize(wizardDescriptor, this.getJasperDesign());
            wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
            wizardDescriptor.setTitle("New Dataset");
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
            if (!cancelled) {
                JRDesignDataset newDataset = new JRDesignDataset(false);
                newDataset.setName((String)wizardDescriptor.getProperty("dataset_name"));
                ArrayList selectedFields = (ArrayList)wizardDescriptor.getProperty("selectedFields");
                ArrayList groupFields = (ArrayList)wizardDescriptor.getProperty("groupFields");
                String query = (String)wizardDescriptor.getProperty("query");
                String queryLanguage = (String)wizardDescriptor.getProperty("queryLanguage");
                if (selectedFields == null) {
                    selectedFields = new ArrayList();
                }
                if (groupFields == null) {
                    groupFields = new ArrayList();
                }
                for (JRDesignField f : selectedFields) {
                    newDataset.addField((JRField)f);
                }
                if (query != null) {
                    JRDesignQuery designQuery = new JRDesignQuery();
                    designQuery.setText(query);
                    if (queryLanguage != null) {
                        designQuery.setLanguage(queryLanguage);
                    }
                    newDataset.setQuery(designQuery);
                }
                for (int i = 0; i < groupFields.size(); ++i) {
                    JRDesignGroup g = new JRDesignGroup();
                    g.setName(((JRDesignField)groupFields.get(i)).getName());
                    g.setExpression((JRExpression)Misc.createExpression((String)((JRDesignField)groupFields.get(i)).getValueClassName(), (String)("$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}")));
                    newDataset.addGroup(g);
                }
                this.getJasperDesign().addDataset(newDataset);
                AddDatasetUndoableEdit edit = new AddDatasetUndoableEdit(newDataset, this.getJasperDesign());
                IReportManager.getInstance().addUndoableEdit((UndoableEdit)edit);
                this.updateDatasets();
                this.jComboBoxDataset.setSelectedItem(newDataset);
                this.jRadioButton1.setSelected(true);
                this.jRadioButton2.setSelected(false);
            }
        }
        catch (JRException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void jComboBoxDatasetActionPerformed(ActionEvent evt) {
    }

    public void updateOptions() {
        if (this.jComboBoxDataset.getItemCount() > 0) {
            this.jRadioButton1.setEnabled(true);
            this.jComboBoxDataset.setEnabled(true);
            this.jLabelNoDatasets.setText(" ");
        } else {
            this.jComboBoxDataset.setEnabled(false);
            this.jRadioButton1.setEnabled(false);
            this.jLabelNoDatasets.setText(NbBundle.getMessage(TableVisualPanel1.class, (String)"TableVisualPanel1.jLabelNoDatasets.text"));
        }
    }

    public JasperDesign getJasperDesign() {
        return (JasperDesign)this.getWizardPanel().getWizard().getProperty("jasperdesign");
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        this.getWizardPanel().getWizard().putProperty("table_type", (Object)(this.jRadioButton1.isSelected() ? 0 : 1));
        this.getWizardPanel().getWizard().putProperty("dataset", this.jComboBoxDataset.getSelectedItem());
        if (this.jComboBoxDataset.getSelectedItem() != null) {
            ArrayList<JRDesignField> list = new ArrayList<JRDesignField>();
            List fieldsList = ((JRDesignDataset)this.jComboBoxDataset.getSelectedItem()).getFieldsList();
            for (int i = 0; i < fieldsList.size(); ++i) {
                list.add((JRDesignField)fieldsList.get(i));
            }
            this.getWizardPanel().getWizard().putProperty("discoveredFields", list);
            this.getWizardPanel().getWizard().putProperty("discoveredFieldsNeedRefresh", (Object)"true");
        }
        this.getWizardPanel().getWizard().putProperty("columns", this.jSpinner1.getValue());
    }

    public TableWizardPanel1 getWizardPanel() {
        return this.wizardPanel;
    }

    public boolean isFinishPanel() {
        return this.jRadioButton2.isSelected();
    }
}

