/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import org.netbeans.lib.editor.util.GapList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OffsetGapList<E>
extends GapList<E> {
    private int offsetGapStart;
    private int offsetGapLength = 0x3FFFFFFF;

    public OffsetGapList() {
        this(10);
    }

    public OffsetGapList(int n) {
        super(n);
    }

    protected abstract int elementRawOffset(E var1);

    protected abstract void setElementRawOffset(E var1, int var2);

    protected int elementOffset(E e) {
        return this.raw2Offset(this.elementRawOffset(e));
    }

    protected int elementOffset(int n) {
        return this.elementOffset(this.get(n));
    }

    public void defaultInsertUpdate(int n, int n2) {
        assert (n2 >= 0);
        if (n != this.offsetGapStart()) {
            this.moveOffsetGap(n, this.findElementIndex(n));
        }
        this.updateOffsetGapLength(-n2);
        this.updateOffsetGapStart(n2);
    }

    public void defaultRemoveUpdate(int n, int n2) {
        Object e;
        assert (n2 >= 0);
        int n3 = this.findElementIndex(n);
        if (n != this.offsetGapStart()) {
            this.moveOffsetGap(n, n3);
        }
        int n4 = this.size();
        int n5 = n + this.offsetGapLength + n2;
        while (n3 < n4 && this.elementRawOffset(e = this.get(n3++)) < n5) {
            this.setElementRawOffset(e, n5);
        }
        this.updateOffsetGapLength(n2);
    }

    protected final void moveOffsetGap(int n, int n2) {
        if (n < this.offsetGapStart) {
            Object e;
            int n3;
            int n4 = this.size();
            for (int i = n2; i < n4 && (n3 = this.elementRawOffset(e = this.get(i))) < this.offsetGapStart; ++i) {
                this.setElementRawOffset(e, n3 + this.offsetGapLength);
            }
        } else {
            Object e;
            int n5;
            for (int i = n2 - 1; i >= 0 && (n5 = this.elementRawOffset(e = this.get(i))) >= this.offsetGapStart; --i) {
                this.setElementRawOffset(e, n5 - this.offsetGapLength);
            }
        }
        this.offsetGapStart = n;
    }

    protected final int offsetGapStart() {
        return this.offsetGapStart;
    }

    protected final void updateOffsetGapStart(int n) {
        this.offsetGapStart += n;
    }

    protected final int offsetGapLength() {
        return this.offsetGapLength;
    }

    protected final void updateOffsetGapLength(int n) {
        this.offsetGapLength += n;
        assert (this.offsetGapLength >= 0);
    }

    protected final int findElementIndex(int n) {
        int n2 = 0;
        int n3 = this.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.elementOffset(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            while (n4 > 0) {
                if (this.elementOffset(--n4) >= n) continue;
                ++n4;
                break;
            }
            n2 = n4;
            break;
        }
        return n2;
    }

    protected void updateElementOffsetAdd(E e) {
        int n = this.elementRawOffset(e);
        if (n >= this.offsetGapStart) {
            this.setElementRawOffset(e, n + this.offsetGapLength);
        }
    }

    protected void updateElementOffsetRemove(E e) {
        int n = this.elementRawOffset(e);
        if (n >= this.offsetGapStart) {
            this.setElementRawOffset(e, n - this.offsetGapLength);
        }
    }

    protected final int raw2Offset(int n) {
        return n < this.offsetGapStart ? n : n - this.offsetGapLength;
    }

    protected final int offset2raw(int n) {
        return n < this.offsetGapStart ? n : n + this.offsetGapLength;
    }

    @Override
    protected void consistencyCheck() {
        super.consistencyCheck();
        if (this.offsetGapLength < 0) {
            this.consistencyError("offsetGapLength < 0");
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            Object e = this.get(i);
            int n4 = this.elementRawOffset(e);
            int n5 = this.raw2Offset(n4);
            if (n4 < n) {
                this.consistencyError("Invalid rawOffset=" + n4 + " >= lastRawOffset=" + n + " at index=" + i);
            }
            if (n5 < n2) {
                this.consistencyError("Invalid offset=" + n5 + " >= lastOffset=" + n2 + " at index=" + i);
            }
            n = n4;
            n2 = n5;
        }
    }

    @Override
    protected String dumpInternals() {
        return super.dumpInternals() + ", offGap(s=" + this.offsetGapStart + ", l=" + this.offsetGapLength + ")";
    }
}

