/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.awt.DropDownButtonFactory;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public final class NavigationHistoryBackAction
extends TextAction
implements ContextAwareAction,
Presenter.Toolbar,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(NavigationHistoryBackAction.class.getName());
    private final JTextComponent component;
    private final NavigationHistory.Waypoint waypoint;
    private final JPopupMenu popupMenu;

    public NavigationHistoryBackAction() {
        this(null, null, null);
    }

    private NavigationHistoryBackAction(JTextComponent jTextComponent, NavigationHistory.Waypoint waypoint, String string) {
        super("jump-list-prev");
        this.component = jTextComponent;
        this.waypoint = waypoint;
        if (waypoint != null) {
            this.putValue("Name", string);
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip", (Object)string));
            this.popupMenu = null;
        } else if (jTextComponent != null) {
            this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/editor/resources/navigate_back_16.png")));
            this.popupMenu = new JPopupMenu();
            this.update();
            NavigationHistory navigationHistory = NavigationHistory.getNavigations();
            navigationHistory.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)navigationHistory));
        } else {
            this.popupMenu = null;
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip_simple"));
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        JTextComponent jTextComponent = NavigationHistoryBackAction.findComponent(lookup);
        return new NavigationHistoryBackAction(jTextComponent, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NavigationHistory.Waypoint waypoint;
        JTextComponent jTextComponent = this.component != null ? this.component : this.getTextComponent(actionEvent);
        NavigationHistory navigationHistory = NavigationHistory.getNavigations();
        if (null == navigationHistory.getCurrentWaypoint()) {
            try {
                navigationHistory.markWaypoint(jTextComponent, jTextComponent.getCaret().getDot(), true, false);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, "Can't mark current position", badLocationException);
            }
        }
        NavigationHistory.Waypoint waypoint2 = waypoint = this.waypoint != null ? navigationHistory.navigateTo(this.waypoint) : navigationHistory.navigateBack();
        if (waypoint != null) {
            NavigationHistoryBackAction.show(waypoint);
        }
    }

    public Component getToolbarPresenter() {
        if (this.popupMenu != null) {
            JButton jButton = DropDownButtonFactory.createDropDownButton((Icon)((ImageIcon)this.getValue("SmallIcon")), (JPopupMenu)this.popupMenu);
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
            jButton.setAction(this);
            return jButton;
        }
        return new JButton(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.update();
    }

    private void update() {
        String string;
        List list = NavigationHistory.getNavigations().getPreviousWaypoints();
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
            int n = 0;
            string = null;
            NavigationHistory.Waypoint waypoint = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                NavigationHistory.Waypoint waypoint2 = (NavigationHistory.Waypoint)list.get(i);
                String string2 = NavigationHistoryBackAction.getWaypointName(waypoint2);
                if (string2 == null) continue;
                if (string == null || !string2.equals(string)) {
                    if (string != null) {
                        this.popupMenu.add(new NavigationHistoryBackAction(this.component, waypoint, n > 1 ? string + ":" + n : string));
                    }
                    string = string2;
                    waypoint = waypoint2;
                    n = 1;
                    continue;
                }
                ++n;
            }
            if (string != null) {
                this.popupMenu.add(new NavigationHistoryBackAction(this.component, waypoint, n > 1 ? string + ":" + n : string));
            }
        }
        if (!list.isEmpty()) {
            NavigationHistory.Waypoint waypoint = (NavigationHistory.Waypoint)list.get(list.size() - 1);
            string = NavigationHistoryBackAction.getWaypointName(waypoint);
            if (string != null) {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip", (Object)string));
            } else {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip_simple"));
            }
            this.setEnabled(true);
        } else {
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip_simple"));
            this.setEnabled(false);
        }
    }

    static void show(NavigationHistory.Waypoint waypoint) {
        JTextComponent jTextComponent;
        final int n = waypoint.getOffset();
        if (n < 0) {
            return;
        }
        Lookup lookup = NavigationHistoryBackAction.findLookupFor(waypoint);
        if (lookup != null) {
            jTextComponent = (EditorCookie)lookup.lookup(EditorCookie.class);
            final LineCookie lineCookie = (LineCookie)lookup.lookup(LineCookie.class);
            StyledDocument styledDocument = null;
            if (jTextComponent != null && lineCookie != null) {
                try {
                    styledDocument = jTextComponent.openDocument();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Can't open document", iOException);
                }
            }
            if (styledDocument instanceof BaseDocument) {
                final boolean[] blArray = new boolean[1];
                final BaseDocument baseDocument = (BaseDocument)styledDocument;
                styledDocument.render(new Runnable(){

                    public void run() {
                        Element element = baseDocument.getParagraphElement(0).getParentElement();
                        int n3 = element.getElementIndex(n);
                        if (n3 != -1) {
                            Element element2 = element.getElement(n3);
                            int n2 = n - element2.getStartOffset();
                            Line line = lineCookie.getLineSet().getCurrent(n3);
                            if (line != null) {
                                line.show(4, n2);
                                blArray[0] = true;
                            }
                        }
                    }
                });
                if (blArray[0]) {
                    return;
                }
            }
        }
        if ((jTextComponent = waypoint.getComponent()) != null) {
            jTextComponent.setCaretPosition(n);
            jTextComponent.requestFocusInWindow();
        }
    }

    private static Lookup findLookupFor(NavigationHistory.Waypoint waypoint) {
        FileObject fileObject;
        Serializable serializable;
        JTextComponent jTextComponent = waypoint.getComponent();
        if (jTextComponent != null) {
            for (serializable = jTextComponent; serializable != null; serializable = ((Component)serializable).getParent()) {
                if (!(serializable instanceof Lookup.Provider) || (fileObject = ((Lookup.Provider)serializable).getLookup()) == null) continue;
                return fileObject;
            }
        }
        FileObject fileObject2 = fileObject = (serializable = waypoint.getUrl()) == null ? null : URLMapper.findFileObject((URL)serializable);
        if (fileObject != null) {
            try {
                return DataObject.find((FileObject)fileObject).getLookup();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.WARNING, "Can't get DataObject for " + fileObject, dataObjectNotFoundException);
            }
        }
        return null;
    }

    static String getWaypointName(NavigationHistory.Waypoint waypoint) {
        URL uRL = waypoint.getUrl();
        if (uRL != null) {
            String string = uRL.getPath();
            int n = string.lastIndexOf(47);
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }
        return null;
    }

    static JTextComponent findComponent(Lookup lookup) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return (JTextComponent)lookup.lookup(JTextComponent.class);
    }
}

