/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.xml;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Unmarshaller {
    protected static final Log log = LogFactory.getLog(Unmarshaller.class);
    private String encoding = "UTF-8";

    public static String readPCDATA(Node textNode) {
        return Unmarshaller.readPCDATA(textNode, true);
    }

    public static String readPCDATA(Node textNode, boolean trim) {
        short nt;
        Node ns;
        Node child_child;
        int ck;
        NodeList list_child = textNode.getChildNodes();
        for (ck = 0; ck < list_child.getLength(); ++ck) {
            child_child = list_child.item(ck);
            ns = child_child.getNextSibling();
            if (ns != null) {
                child_child = ns;
            }
            if ((nt = child_child.getNodeType()) != 4) continue;
            if (trim) {
                return child_child.getNodeValue().trim();
            }
            return child_child.getNodeValue();
        }
        for (ck = 0; ck < list_child.getLength(); ++ck) {
            child_child = list_child.item(ck);
            ns = child_child.getNextSibling();
            if (ns != null) {
                child_child = ns;
            }
            if ((nt = child_child.getNodeType()) != 3) continue;
            if (trim) {
                return child_child.getNodeValue().trim();
            }
            return child_child.getNodeValue();
        }
        return "";
    }

    public static Object unmarshal(Class c, StringReader sr) throws Exception {
        Unmarshaller u = new Unmarshaller();
        return u.unmarshal(sr);
    }

    public static Object unmarshalXml(String xmlString) throws Exception {
        Unmarshaller u = new Unmarshaller();
        return u.unmarshal(xmlString);
    }

    public Object unmarshal(String xml) throws Exception {
        StringReader sreader = new StringReader(xml);
        return this.unmarshal(sreader);
    }

    public Object unmarshal(StringReader sreader) throws Exception {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource input_source = new InputSource(sreader);
            Document document = docBuilder.parse(input_source);
            Element rootNode = document.getDocumentElement();
            if (rootNode.getNodeName().equals("request")) {
                return this.readRequest(rootNode);
            }
            if (rootNode.getNodeName().equals("operationResult")) {
                return this.readOperationResult(rootNode);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return null;
    }

    private Request readRequest(Node requestNode) {
        Request request = new Request();
        NamedNodeMap nodeAttributes = requestNode.getAttributes();
        if (nodeAttributes.getNamedItem("operationName") != null) {
            request.setOperationName(nodeAttributes.getNamedItem("operationName").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("locale") != null) {
            request.setLocale(nodeAttributes.getNamedItem("locale").getNodeValue());
        }
        NodeList childsOfChild = requestNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("argument")) {
                request.getArguments().add(this.readArgument(child_child));
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("resourceDescriptor")) continue;
            request.setResourceDescriptor(this.readResourceDescriptor(child_child));
        }
        return request;
    }

    private Argument readArgument(Node argumentNode) {
        Argument argument = new Argument();
        NamedNodeMap nodeAttributes = argumentNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            argument.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        argument.setValue(Unmarshaller.readPCDATA(argumentNode));
        return argument;
    }

    private ResourceDescriptor readResourceDescriptor(Node rpNode) {
        ResourceDescriptor rd = new ResourceDescriptor();
        NamedNodeMap nodeAttributes = rpNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            rd.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("wsType") != null) {
            rd.setWsType(nodeAttributes.getNamedItem("wsType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("uriString") != null) {
            rd.setUriString(nodeAttributes.getNamedItem("uriString").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isNew") != null) {
            rd.setIsNew(nodeAttributes.getNamedItem("isNew").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = rpNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("label")) {
                rd.setLabel(Unmarshaller.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("description")) {
                rd.setDescription(Unmarshaller.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("creationDate")) {
                Date creationDate = this.readCreationDate(child_child);
                if (creationDate == null) continue;
                rd.setCreationDate(creationDate);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("resourceProperty")) {
                rd.setResourceProperty(this.readResourceProperty(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("resourceDescriptor")) {
                rd.getChildren().add(this.readResourceDescriptor(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("parameter")) continue;
            rd.getParameters().add(this.readResourceParameter(child_child));
        }
        return rd;
    }

    protected Date readCreationDate(Node node) {
        Date creationDate = null;
        String dateStr = Unmarshaller.readPCDATA(node, true);
        if (dateStr.length() > 0) {
            try {
                long timestamp = Long.parseLong(dateStr);
                creationDate = new Date(timestamp);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Error parsing resource creation date timestamp \"" + dateStr + "\"");
            }
        }
        return creationDate;
    }

    private ResourceProperty readResourceProperty(Node rpNode) {
        ResourceProperty rp = new ResourceProperty(null);
        NamedNodeMap nodeAttributes = rpNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            rp.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        NodeList childsOfChild = rpNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("value")) {
                rp.setValue(Unmarshaller.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("resourceProperty")) continue;
            rp.getProperties().add(this.readResourceProperty(child_child));
        }
        return rp;
    }

    private ListItem readResourceParameter(Node rpNode) {
        ListItem rp = new ListItem();
        NamedNodeMap nodeAttributes = rpNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            rp.setLabel(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isListItem") != null) {
            rp.setIsListItem(nodeAttributes.getNamedItem("isListItem").getNodeValue().equals("true"));
        }
        rp.setValue(Unmarshaller.readPCDATA(rpNode));
        return rp;
    }

    private OperationResult readOperationResult(Node operationResultNode) {
        OperationResult or = new OperationResult();
        NamedNodeMap nodeAttributes = operationResultNode.getAttributes();
        if (nodeAttributes.getNamedItem("version") != null) {
            or.setVersion(nodeAttributes.getNamedItem("version").getNodeValue());
        }
        NodeList childsOfChild = operationResultNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("returnCode")) {
                or.setReturnCode(Integer.parseInt(Unmarshaller.readPCDATA(child_child)));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("returnMessage")) {
                or.setMessage(Unmarshaller.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("resourceDescriptor")) continue;
            or.getResourceDescriptors().add(this.readResourceDescriptor(child_child));
        }
        return or;
    }
}

