/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogEntryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapper;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapperDOMImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogWriteModelImpl
extends CatalogModelImpl
implements CatalogWriteModel {
    public static final String PROPERTY_CHANGE_PROPERTY_KEY = "CatalogModelImpl.PropertyChange.Property";
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static Logger logger = Logger.getLogger(CatalogWriteModelImpl.class.getName());
    private Model.State currentStateOfCatalog;
    private CatalogFileWrapper catalogWrapper = null;
    boolean unitTestSaveStrategy = false;

    protected CatalogWriteModelImpl(Project project) throws IOException {
        super(project);
    }

    protected CatalogWriteModelImpl(FileObject fileObject) throws IOException {
        super(fileObject);
    }

    public CatalogWriteModelImpl(File file) throws IOException {
        super(file);
        this.unitTestSaveStrategy = true;
    }

    public CatalogWriteModelImpl() {
    }

    @Override
    public URI searchURI(URI uRI) {
        File file;
        if (uRI == null) {
            return null;
        }
        this.bootStrapCatalog();
        URI uRI2 = null;
        if (this.catalogFileObject != null && (file = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            try {
                uRI2 = this.resolveUsingApacheCatalog(file, uRI.toString());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (CatalogModelException catalogModelException) {
                return null;
            }
        }
        return uRI2;
    }

    @Override
    public Model.State getState() {
        return this.currentStateOfCatalog;
    }

    @Override
    public synchronized void addURI(URI uRI, FileObject fileObject) throws IOException {
        URI uRI2 = FileUtil.toFile((FileObject)fileObject).toURI();
        this.addURI(uRI, uRI2);
    }

    @Override
    public synchronized void addURI(URI uRI, URI uRI2) throws IOException {
        if (this.catalogFileObject == null) {
            return;
        }
        this.removeURI(uRI);
        this.bootStrapCatalog();
        URI uRI3 = FileUtil.toFile((FileObject)this.catalogFileObject).toURI();
        String string = Utilities.relativize(uRI3, uRI2);
        CatalogEntryImpl catalogEntryImpl = new CatalogEntryImpl(CatalogElement.system, uRI.toString(), string);
        this.catalogWrapper.addSystem(catalogEntryImpl);
    }

    public String toString() {
        return "This Public Catalog FO:" + this.catalogFileObject;
    }

    @Override
    public synchronized void removeURI(URI uRI) throws IOException {
        logger.finer("ENTRING:" + uRI);
        if (this.catalogFileObject == null) {
            return;
        }
        this.bootStrapCatalog();
        List<CatalogEntry> list = this.catalogWrapper.getSystems();
        if (list == null) {
            return;
        }
        CatalogEntry catalogEntry = null;
        for (CatalogEntry catalogEntry2 : list) {
            if (!catalogEntry2.getSource().equals(uRI.toString())) continue;
            catalogEntry = catalogEntry2;
        }
        logger.finer("Removing Value: " + catalogEntry);
        if (catalogEntry == null) {
            return;
        }
        int n = list.indexOf(catalogEntry);
        this.catalogWrapper.deleteSystem(n);
        if (list.size() == 1) {
            logger.finer("There are no more entries so removing catalog file");
        }
        logger.finer("RETURN: " + list.size());
    }

    @Override
    public Collection<CatalogEntry> getCatalogEntries() {
        if (this.catalogFileObject == null) {
            return Collections.emptyList();
        }
        this.bootStrapCatalog();
        List<CatalogEntry> list = this.catalogWrapper.getSystems();
        if (list == null) {
            return Collections.emptyList();
        }
        for (CatalogEntry catalogEntry : list) {
            ((CatalogEntryImpl)catalogEntry).setCatalogModel(this);
        }
        return list;
    }

    @Override
    public boolean isWellformed() {
        this.bootStrapCatalog();
        this.currentStateOfCatalog = this.catalogWrapper.getCatalogState();
        return this.currentStateOfCatalog != Model.State.NOT_WELL_FORMED;
    }

    @Override
    public FileObject getCatalogFileObject() {
        return this.catalogFileObject;
    }

    @Override
    public void addPropertychangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(PROPERTY_CHANGE_PROPERTY_KEY, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(PROPERTY_CHANGE_PROPERTY_KEY, propertyChangeListener);
    }

    private synchronized void bootStrapCatalog() {
        if (this.catalogWrapper == null) {
            try {
                this.catalogWrapper = CatalogFileWrapperDOMImpl.getInstance(this.catalogFileObject, this.unitTestSaveStrategy);
                if (this.catalogWrapper == null) {
                    throw new IllegalStateException("Could not get CatalogFileWrapper");
                }
                this.currentStateOfCatalog = this.catalogWrapper.getCatalogState();
                this.catalogWrapper.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        CatalogWriteModelImpl.this.pcs.firePropertyChange(propertyChangeEvent);
                        CatalogWriteModelImpl.this.currentStateOfCatalog = CatalogWriteModelImpl.this.catalogWrapper.getCatalogState();
                    }
                });
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        if (this.catalogWrapper != null && this.catalogWrapper.getCatalogState() == Model.State.NOT_WELL_FORMED) {
            throw new IllegalStateException("Catalog file not wellformed");
        }
    }

    @Override
    public void addNextCatalog(URI uRI, boolean bl) throws IOException {
        if (this.catalogFileObject == null) {
            return;
        }
        String string = uRI.toString();
        if (uRI.isAbsolute() && bl) {
            string = Utilities.relativize(FileUtil.toFile((FileObject)this.catalogFileObject).toURI(), uRI);
        }
        try {
            this.removeNextCatalog(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bootStrapCatalog();
        CatalogEntryImpl catalogEntryImpl = new CatalogEntryImpl(CatalogElement.nextCatalog, string, null);
        this.catalogWrapper.addNextCatalog(catalogEntryImpl);
    }

    @Override
    public void removeNextCatalog(URI uRI) throws IOException {
        logger.finer("ENTRING:" + uRI);
        if (this.catalogFileObject == null) {
            return;
        }
        this.bootStrapCatalog();
        List<CatalogEntry> list = this.catalogWrapper.getNextCatalogs();
        if (list == null) {
            return;
        }
        CatalogEntry catalogEntry = null;
        for (CatalogEntry catalogEntry2 : list) {
            if (!catalogEntry2.getSource().equals(uRI.toString())) continue;
            catalogEntry = catalogEntry2;
        }
        logger.finer("Removing Value: " + catalogEntry);
        if (catalogEntry == null) {
            return;
        }
        int n = list.indexOf(catalogEntry);
        this.catalogWrapper.deleteNextCatalog(n);
        if (list.size() == 1) {
            logger.finer("There are no more entries so removing catalog file");
        }
        logger.finer("RETURN: " + list.size());
    }
}

