/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Cube;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.BatchTestCase;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

public class TestCalculatedMembers
extends BatchTestCase {
    public TestCalculatedMembers() {
    }

    public TestCalculatedMembers(String name) {
        super(name);
    }

    public void testCalculatedMemberInCube() {
        this.assertExprReturns("[Measures].[Profit]", "$339,610.90");
        this.assertQueryReturns("select {[Measures].[Avg Salary], [Measures].[Org Salary]} ON columns,\n{([Time].[1997], [Store].[All Stores], [Employees].[All Employees])} ON rows\nfrom [HR]\nwhere [Pay Type].[Hourly]", TestCalculatedMembers.fold("Axis #0:\n{[Pay Type].[All Pay Types].[Hourly]}\nAxis #1:\n{[Measures].[Avg Salary]}\n{[Measures].[Org Salary]}\nAxis #2:\n{[Time].[1997], [Store].[All Stores], [Employees].[All Employees]}\nRow #0: $40.31\nRow #0: $11,406.75\n"));
    }

    public void testCalculatedMemberInCubeViaApi() {
        Cube salesCube = this.getSalesCube("Sales");
        salesCube.createCalculatedMember("<CalculatedMember name='Profit2'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'/>");
        String s = this.executeExpr("[Measures].[Profit2]");
        Assert.assertEquals((String)"339,610.90", (String)s);
        try {
            salesCube.createCalculatedMember("<CalculatedMember name='Profit2'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'/>");
            throw new AssertionFailedError("expected error, got none");
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            if (!msg.equals("Mondrian Error:Calculated member '[Measures].[Profit2]' already exists in cube 'Sales'")) {
                throw e;
            }
            return;
        }
    }

    public void testCalculatedMemberInCubeWithSpace() {
        TestContext testContext = TestContext.createSubstitutingCube("Warehouse and Sales", null, "<CalculatedMember name='Profit With Spaces'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'/>");
        Cell s = testContext.executeExprRaw("[Measures].[Profit With Spaces]", "Warehouse and Sales");
        Assert.assertEquals((String)"339,610.90", (String)s.getFormattedValue());
    }

    public void testCalculatedMemberInCubeWithProps() {
        Cube salesCube = this.getSalesCube("Sales");
        salesCube.createCalculatedMember("<CalculatedMember name='Profit3'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'>    <CalculatedMemberProperty name='FORMAT_STRING' value='#'/></CalculatedMember>");
        Result result = TestContext.instance().executeQuery("select {[Measures].[Profit3]} on columns from Sales");
        String s = result.getCell(new int[]{0}).getFormattedValue();
        Assert.assertEquals((String)"339611", (String)s);
        try {
            salesCube.createCalculatedMember("<CalculatedMember name='Profit4'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'>    <CalculatedMemberProperty name='FORMAT_STRING' /></CalculatedMember>");
            throw new AssertionFailedError("expected error, got none");
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            if (!msg.equals("Mondrian Error:Member property must have a value or an expression. (Property 'FORMAT_STRING' of member 'Profit4' of cube 'Sales'.)")) {
                throw e;
            }
            try {
                salesCube.createCalculatedMember("<CalculatedMember name='Profit4'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'>    <CalculatedMemberProperty name='FORMAT_STRING' value='#' expression='\"#\"' /></CalculatedMember>");
                throw new AssertionFailedError("expected error, got none");
            }
            catch (RuntimeException e2) {
                msg = e2.getMessage();
                if (!msg.equals("Mondrian Error:Member property must not have both a value and an expression. (Property 'FORMAT_STRING' of member 'Profit4' of cube 'Sales'.)")) {
                    throw e2;
                }
                try {
                    salesCube.createCalculatedMember("<CalculatedMember name='Profit4'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]'>    <CalculatedMemberProperty name='FORMAT_STRING' expression='1 + [FooBar]' /></CalculatedMember>");
                    throw new AssertionFailedError("expected error, got none");
                }
                catch (RuntimeException e3) {
                    msg = e3.getMessage();
                    if (!msg.equals("Mondrian Error:Named set in cube 'Sales' has bad formula")) {
                        throw e3;
                    }
                    MondrianProperties.instance().IgnoreInvalidMembers.set(true);
                    salesCube.createCalculatedMember("<CalculatedMember name='Profit4'  dimension='Measures'  formula='[Measures].[Store Sales]-[Measures].[Store Cost]+     [Measures].[FooBar]'></CalculatedMember>");
                    result = TestContext.instance().executeQuery("select {[Measures].[Profit4]} on columns from Sales");
                    s = result.getCell(new int[]{0}).getFormattedValue();
                    Assert.assertEquals((String)"339,610.90", (String)s);
                    MondrianProperties.instance().IgnoreInvalidMembers.set(false);
                    return;
                }
            }
        }
    }

    private Cube getSalesCube(String cubeName) {
        Cube[] cubes;
        for (Cube cube : cubes = this.getConnection().getSchema().getSchemaReader().getCubes()) {
            if (!cube.getName().equals(cubeName)) continue;
            return cube;
        }
        return null;
    }

    public void testCalculatedMemberInCubeAndQuery() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Profit Change]" + nl + " AS '[Measures].[Profit] - ([Measures].[Profit], [Time].PrevMember)'" + nl + "SELECT {[Measures].[Profit], [Measures].[Profit Change]} ON COLUMNS," + nl + " {[Time].[1997].[Q2].children} ON ROWS" + nl + "FROM [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Profit]}" + nl + "{[Measures].[Profit Change]}" + nl + "Axis #2:" + nl + "{[Time].[1997].[Q2].[4]}" + nl + "{[Time].[1997].[Q2].[5]}" + nl + "{[Time].[1997].[Q2].[6]}" + nl + "Row #0: $25,766.55" + nl + "Row #0: $-4,289.24" + nl + "Row #1: $26,673.73" + nl + "Row #1: $907.18" + nl + "Row #2: $27,261.76" + nl + "Row #2: $588.03" + nl);
    }

    public void testQueryCalculatedMemberOverridesCube() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Profit]" + nl + " AS '(Measures.[Store Sales] - Measures.[Store Cost])', FORMAT_STRING='#,###' " + nl + "SELECT {[Measures].[Profit]} ON COLUMNS," + nl + " {[Time].[1997].[Q2]} ON ROWS" + nl + "FROM [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Profit]}" + nl + "Axis #2:" + nl + "{[Time].[1997].[Q2]}" + nl + "Row #0: 79,702" + nl);
        this.assertQueryReturns("SELECT {[Measures].[Profit]} ON COLUMNS," + nl + " {[Time].[1997].[Q2]} ON ROWS" + nl + "FROM [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Profit]}" + nl + "Axis #2:" + nl + "{[Time].[1997].[Q2]}" + nl + "Row #0: $79,702.05" + nl);
    }

    public void _testWhole() {
        this.executeQuery("with\nmember [Measures].[Total Store Sales by Product Name] as\n  'Sum([Product].[Product Name].members, [Measures].[Store Sales])'\n\nmember [Measures].[Average Store Sales by Product Name] as\n  'Avg([Product].[Product Name].allmembers, [Measures].[Store Sales])'\n\nmember [Measures].[Number of Product Name members] as\n  'Count([Product].[Product Name].members)'\n\nmember [Measures].[Standard Deviation of Store Sales for Product Name] as\n  'Stddev([Product].[Product Name].members, [Measures].[Store Sales])'\n\nmember [Measures].[Variance between Store Sales and Store Cost] as\n  '[Measures].[Store Sales] - [Measures].[Store Cost]'\n\nmember [Measures].[% Variance between Store Sales and Store Cost] as\n  'iif([Measures].[Store Cost] = 0, 1, [Measures].[Store Sales] / [Measures].[Store Cost])'\n, format_string='Percent'\n\nmember [Measures].[% Difference between Store Sales and Store Cost] as\n  'iif([Measures].[Store Sales] = 0, -1, ([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Sales])'\n, format_string='Percent'\n\nmember [Measures].[% Markup between Store Sales and Store Cost] as\n  'iif([Measures].[Store Cost] = 0, 1, ([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost])'\n, format_string='Percent'\n\nmember [Measures].[Growth of Store Sales since previous period] as\n  '[Measures].[Store Sales] - ([Measures].[Store Sales], ParallelPeriod([Time].CurrentMember.level, 1))'\n\nmember [Measures].[% Growth of Store Sales since previous period] as\n  'iif(([Measures].[Store Sales], ParallelPeriod([Time].CurrentMember.level, 1)) = 0, 1, ([Measures].[Store Sales] - ([Measures].[Store Sales], ParallelPeriod([Time].CurrentMember.level, 1))) / ([Measures].[Store Sales], ParallelPeriod([Time].CurrentMember.level, 1)))'\n, format_string='Percent'\n\nmember [Measures].[Growth of Store Sales since previous year] as\n  '[Measures].[Store Sales] - ([Measures].[Store Sales], ParallelPeriod([Time].[Year], 1))'\n\nmember [Measures].[% Growth of Store Sales since previous year] as\n  'iif(([Measures].[Store Sales], ParallelPeriod([Time].[Year], 1)) = 0, 1, ([Measures].[Store Sales] - ([Measures].[Store Sales], ParallelPeriod([Time].[Year], 1))) / ([Measures].[Store Sales], ParallelPeriod([Time].[Year], 1)))'\n, format_string='Percent'\n\nmember [Measures].[Store Sales as % of parent Store] as\n  'iif(([Measures].[Store Sales], [Store].CurrentMember.Parent) = 0, 1, [Measures].[Store Sales] / ([Measures].[Store Sales], [Store].CurrentMember.Parent))'\n, format_string='Percent'\n\nmember [Measures].[Store Sales as % of all Store] as\n  'iif(([Measures].[Store Sales], [Store].Members.Item(0)) = 0, 1, [Measures].[Store Sales] / ([Measures].[Store Sales], [Store].Members.Item(0)))'\n, format_string='Percent'\n\nmember [Measures].[Total Store Sales, period to date] as\n 'sum(PeriodsToDate([Time].CurrentMember.Parent.Level), [Measures].[Store Sales])'\n\nmember [Measures].[Total Store Sales, Quarter to date] as\n 'sum(PeriodsToDate([Time].[Quarter]), [Measures].[Store Sales])'\n\nmember [Measures].[Average Store Sales, period to date] as\n 'avg(PeriodsToDate([Time].CurrentMember.Parent.Level), [Measures].[Store Sales])'\n\nmember [Measures].[Average Store Sales, Quarter to date] as\n 'avg(PeriodsToDate([Time].[Quarter]), [Measures].[Store Sales])'\n\nmember [Measures].[Rolling Total of Store Sales over previous 3 periods] as\n 'sum([Time].CurrentMember.Lag(2) : [Time].CurrentMember, [Measures].[Store Sales])'\n\nmember [Measures].[Rolling Average of Store Sales over previous 3 periods] as\n 'avg([Time].CurrentMember.Lag(2) : [Time].CurrentMember, [Measures].[Store Sales])'\n\nselect\n CrossJoin(\n  {[Time].[1997], [Time].[1997].[Q2]},\n  {[Store].[All Stores], \n   [Store].[USA],\n   [Store].[USA].[CA],\n   [Store].[USA].[CA].[San Francisco]}) on columns,\n AddCalculatedMembers([Measures].members) on rows\n from Sales");
        this.executeQuery("with\nmember [Measures].[Total Store Sales, Quarter to date] as\n 'sum(PeriodsToDate([Time].[Quarter]), [Measures].[Store Sales])'\n\nmember [Measures].[Average Store Sales, period to date] as\n 'avg(PeriodsToDate([Time].CurrentMember.Parent.Level), [Measures].[Store Sales])'\n\nmember [Measures].[Average Store Sales, Quarter to date] as\n 'avg(PeriodsToDate([Time].[Quarter]), [Measures].[Store Sales])'\n\nmember [Measures].[Rolling Total of Store Sales over previous 3 periods] as\n 'sum([Time].CurrentMember.Lag(2) : [Time].CurrentMember, [Measures].[Store Sales])'\n\nmember [Measures].[Rolling Average of Store Sales over previous 3 periods] as\n 'avg([Time].CurrentMember.Lag(2) : [Time].CurrentMember, [Measures].[Store Sales])'\n\nselect\n CrossJoin(\n  {[Store].[USA].[CA],\n   [Store].[USA].[CA].[San Francisco]},\n  [Time].[Month].members) on columns,\n AddCalculatedMembers([Measures].members) on rows\n from Sales");
    }

    public void testCalculatedMemberCaption() {
        String mdx = "select {[Measures].[Profit Growth]} on columns from Sales";
        Result result = TestContext.instance().executeQuery(mdx);
        Axis axis0 = result.getAxes()[0];
        Position pos0 = axis0.getPositions().get(0);
        Member profGrowth = (Member)pos0.get(0);
        String caption = profGrowth.getCaption();
        Assert.assertEquals((String)caption, (String)"Gewinn-Wachstum");
    }

    public void testCalcMemberIsSetFails() {
        String queryString = "with member [Measures].[Foo] as ' Filter([Product].members, 1 <> 0) 'select {[Measures].[Foo]} on columns from [Sales]";
        String pattern = "Member expression 'Filter([Product].Members, (1.0 <> 0.0))' must not be a set";
        this.assertThrows(queryString, pattern);
        queryString = "with member [Measures].[Foo] as ' ([Measures].[Unit Sales], [Gender].[F]) 'select {[Measures].[Foo]} on columns from [Sales]";
        Result result = this.executeQuery(queryString);
        Util.discard((Object)result);
        this.assertExprThrows("[Customers].[Country]", "Member expression '[Customers].[Country]' must not be a set");
        this.assertExprReturns("[Customers]", "266,773");
        this.assertExprReturns("[Customers].[USA]", "266,773");
        this.assertExprReturns("([Customers].[USA], [Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer])", "1,683");
        this.assertExprThrows("{([Customers].[USA], [Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer])}", "Member expression '{([Customers].[All Customers].[USA], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer])}' must not be a set");
        this.assertExprThrows("{([Customers].[USA], [Product].[Food]),([Customers].[USA], [Product].[Drink])}", "{([Customers].[All Customers].[USA], [Product].[All Products].[Food]), ([Customers].[All Customers].[USA], [Product].[All Products].[Drink])}' must not be a set");
        this.assertExprThrows("{[Product].[Food]}", "Member expression '{[Product].[All Products].[Food]}' must not be a set");
    }

    public void testBracketInCalcMemberName() {
        this.assertQueryReturns("with member [Measures].[has a [bracket]] in it] as \n' [Measures].CurrentMember.Name '\nselect {[Measures].[has a [bracket]] in it]} on columns\nfrom [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[has a [bracket]] in it]}\nRow #0: Unit Sales\n"));
    }

    public void testNpeInIif() {
        this.assertQueryReturns(TestCalculatedMembers.fold("WITH MEMBER [Measures].[Foo] AS ' 1 / [Measures].[Unit Sales] ',\n  FORMAT_STRING=IIf([Measures].[Foo] < .3, \"|0.0|style=red\",\"0.0\")\nSELECT {[Store].[USA].[WA].children} on columns\nFROM Sales\nWHERE ([Time].[1997].[Q4].[12],\n [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer],\n [Measures].[Foo])"), TestCalculatedMembers.fold("Axis #0:\n{[Time].[1997].[Q4].[12], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer], [Measures].[Foo]}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\n{[Store].[All Stores].[USA].[WA].[Bremerton]}\n{[Store].[All Stores].[USA].[WA].[Seattle]}\n{[Store].[All Stores].[USA].[WA].[Spokane]}\n{[Store].[All Stores].[USA].[WA].[Tacoma]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla]}\n{[Store].[All Stores].[USA].[WA].[Yakima]}\nRow #0: Infinity\nRow #0: Infinity\nRow #0: 0.5\nRow #0: Infinity\nRow #0: |0.1|style=red\nRow #0: Infinity\nRow #0: |0.3|style=red\n"));
    }

    public void testBracketInCubeCalcMemberName() {
        String cubeName = "Sales_BracketInCubeCalcMemberName";
        String s = "<Cube name=\"Sales_BracketInCubeCalcMemberName\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Gender\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <CalculatedMember\n      name=\"With a [bracket] inside it\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\"[Measures].[Unit Sales] * 10\">\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.00\"/>\n  </CalculatedMember>\n</Cube>";
        TestContext testContext = TestContext.create(null, s, null, null, null, null);
        testContext.assertThrows(TestCalculatedMembers.fold("select {[Measures].[With a [bracket] inside it]} on columns,\n {[Gender].Members} on rows\nfrom [Sales_BracketInCubeCalcMemberName]"), "Syntax error at line 1, column 38, token 'inside'");
        testContext.assertQueryReturns(TestCalculatedMembers.fold("select {[Measures].[With a [bracket]] inside it]} on columns,\n {[Gender].Members} on rows\nfrom [Sales_BracketInCubeCalcMemberName]"), TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[With a [bracket]] inside it]}\nAxis #2:\n{[Gender].[F]}\n{[Gender].[M]}\nRow #0: $1,315,580.00\nRow #1: $1,352,150.00\n"));
    }

    public void testPropertyReferencesCalcMember() {
        this.assertQueryReturns("with member [Measures].[Foo] as ' [Measures].[Unit Sales] * 2 ', FORMAT_STRING=IIf([Measures].[Foo] < 600000, \"|#,##0|style=red\",\"#,##0\")  select {[Measures].[Foo]} on columns from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: |533,546|style=red\n"));
    }

    public void testCalcMemberWithQuote() {
        this.assertThrows("with member [Measures].[Foo] as ' \"quoted string with 'apostrophe' in it\" ' select {[Measures].[Foo]} on columns from [Sales]", "Syntax error at line 1, column 57, token 'apostrophe'");
        this.assertQueryReturns("with member [Measures].[Foo] as ' \"quoted string with ''apostrophe'' in it\" ' select {[Measures].[Foo]} on columns from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: quoted string with 'apostrophe' in it\n"));
        this.assertQueryReturns("with member [Measures].[Foo] as ' \"quoted string with \"\"double-quote\"\" in it\" ' select {[Measures].[Foo]} on columns from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: quoted string with \"double-quote\" in it\n"));
        this.assertQueryReturns("with member [Measures].[Foo] as \"quoted string with 'apos' in it\" select {[Measures].[Foo]} on columns from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: quoted string with 'apos' in it\n"));
        this.assertQueryReturns("with member [Measures].[Foo] as ' ''quoted string and ''''apos''''.'' ' select {[Measures].[Foo]} on columns from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: quoted string and 'apos'.\n"));
        this.assertQueryReturns("with member [Measures].[Foo] as ' \"quoted string and ''apos''.\" ' select {[Measures].[Foo]} on columns from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: quoted string and 'apos'.\n"));
        this.assertQueryReturns("with member [Measures].[Colored Profit] as  ' [Measures].[Store Sales] - [Measures].[Store Cost] ',   FORMAT_STRING = Iif([Measures].[Colored Profit] < 0, '|($#,##0.00)|style=red', '|$#,##0.00|style=green') select {[Measures].[Colored Profit]} on columns, {[Product].Children} on rows from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Colored Profit]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: |$29,358.98|style=green\nRow #1: |$245,764.87|style=green\nRow #2: |$64,487.05|style=green\n"));
        this.assertQueryReturns("with member [Measures].[Colored Profit] as  ' [Measures].[Store Sales] - [Measures].[Store Cost] ',   FORMAT_STRING = Iif([Measures].[Colored Profit] < 0, \"|($#,##0.00)|style=red\", \"|$#,##0.00|style=green\") select {[Measures].[Colored Profit]} on columns, {[Product].Children} on rows from [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Colored Profit]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: |$29,358.98|style=green\nRow #1: |$245,764.87|style=green\nRow #2: |$64,487.05|style=green\n"));
    }

    public void testQuoteInCalcMember() {
        String cubeName = "Sales_Bug1410383";
        String s = "<Cube name=\"Sales_Bug1410383\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Gender\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <CalculatedMember\n      name=\"Apos in dq\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\" &quot;an 'apos' in dq&quot; \" />\n  <CalculatedMember\n      name=\"Dq in dq\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\" &quot;a &quot;&quot;dq&quot;&quot; in dq&quot; \" />\n  <CalculatedMember\n      name=\"Apos in apos\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\" &apos;an &apos;&apos;apos&apos;&apos; in apos&apos; \" />\n  <CalculatedMember\n      name=\"Dq in apos\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\" &apos;a &quot;dq&quot; in apos&apos; \" />\n  <CalculatedMember\n      name=\"Colored Profit\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\" [Measures].[Store Sales] - [Measures].[Store Cost] \">\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" expression=\"Iif([Measures].[Colored Profit] &lt; 0, '|($#,##0.00)|style=red', '|$#,##0.00|style=green')\"/>\n  </CalculatedMember>\n</Cube>";
        TestContext.create(null, s, null, null, null, null).assertQueryReturns("select {[Measures].[Apos in dq], [Measures].[Dq in dq], [Measures].[Apos in apos], [Measures].[Dq in apos], [Measures].[Colored Profit]} on columns,\n {[Gender].Members} on rows\nfrom [Sales_Bug1410383]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Apos in dq]}\n{[Measures].[Dq in dq]}\n{[Measures].[Apos in apos]}\n{[Measures].[Dq in apos]}\n{[Measures].[Colored Profit]}\nAxis #2:\n{[Gender].[F]}\n{[Gender].[M]}\nRow #0: an 'apos' in dq\nRow #0: a \"dq\" in dq\nRow #0: an 'apos' in apos\nRow #0: a \"dq\" in apos\nRow #0: |$168,448.73|style=green\nRow #1: an 'apos' in dq\nRow #1: a \"dq\" in dq\nRow #1: an 'apos' in apos\nRow #1: a \"dq\" in apos\nRow #1: |$171,162.17|style=green\n"));
    }

    public void testChildrenOfCalcMembers() {
        this.assertQueryReturns("with member [Time].[# Months Product Sold] as 'Count(Descendants([Time].LastSibling, [Time].[Month]), EXCLUDEEMPTY)'\nselect Crossjoin([Time].[# Months Product Sold].Children,\n     [Store].[All Stores].Children) ON COLUMNS,\n   [Product].[All Products].Children ON ROWS from [Sales] where [Measures].[Unit Sales]", TestCalculatedMembers.fold("Axis #0:\n{[Measures].[Unit Sales]}\nAxis #1:\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\n"));
    }

    public void testNonCharacterMembers() {
        this.assertQueryReturns("with member [Has Coffee Bar].[Maybe] as " + nl + "'SUM([Has Coffee Bar].members)' " + nl + "SELECT {[Has Coffee Bar].[Maybe]} on rows, " + nl + "{[Measures].[Store Sqft]} on columns " + nl + "FROM [Store]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sqft]}\nAxis #2:\n{[Has coffee bar].[Maybe]}\nRow #0: 1,143,192\n"));
    }

    public void testFormatString() {
        this.assertQueryReturns("WITH MEMBER [Customers].[Highly Profitable States]" + nl + "AS 'SUM(FILTER([Customers].[USA].children,([Measures].[Profit] > 90000)))'" + nl + "MEMBER [Customers].[Plain States]" + nl + " AS 'SUM([Customers].[USA].children)', SOLVE_ORDER = 5, FORMAT_STRING='#,###'" + nl + "SELECT {[Measures].[Store Sales], [Measures].[Profit]} ON COLUMNS," + nl + "UNION([Customers].[USA].children,{[Customers].[Highly Profitable States],[Customers].[Plain States]}) ON ROWS" + nl + "FROM [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Profit]}\nAxis #2:\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[USA].[OR]}\n{[Customers].[All Customers].[USA].[WA]}\n{[Customers].[Highly Profitable States]}\n{[Customers].[Plain States]}\nRow #0: 159,167.84\nRow #0: $95,637.41\nRow #1: 142,277.07\nRow #1: $85,504.57\nRow #2: 263,793.22\nRow #2: $158,468.91\nRow #3: 422,961.06\nRow #3: $254,106.33\nRow #4: 565,238\nRow #4: 339,611\n"));
    }

    public void testNegativeSolveOrder() {
        this.assertQueryReturns("with member measures.blah as 'measures.[unit sales]', SOLVE_ORDER = -6 select {measures.[unit sales], measures.blah} on 0 from sales", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[blah]}\nRow #0: 266,773\nRow #0: 266,773\n"));
        this.assertQueryReturns("with member [Product].[Foo] as ' 1 ', SOLVE_ORDER = -6\n member [Gender].[Bar] as ' 2 ', SOLVE_ORDER = 3\nselect {[Measures].[Unit Sales]} on 0,\n {[Product].[Foo], [Product].[Drink]} *\n {[Gender].[M], [Gender].[Bar]} on 1\nfrom [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[Foo], [Gender].[All Gender].[M]}\n{[Product].[Foo], [Gender].[Bar]}\n{[Product].[All Products].[Drink], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Drink], [Gender].[Bar]}\nRow #0: 1\nRow #1: 2\nRow #2: 12,395\nRow #3: 2\n"));
    }

    public void testCalcMemberCustomFormatterInQuery() {
        this.assertQueryReturns("with member [Measures].[Foo] as ' [Measures].[Unit Sales] * 2 ',\n CELL_FORMATTER='mondrian.test.FooBarCellFormatter' \nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Store].Children} on rows\nfrom [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Foo]}\nAxis #2:\n{[Store].[All Stores].[Canada]}\n{[Store].[All Stores].[Mexico]}\n{[Store].[All Stores].[USA]}\nRow #0: \nRow #0: foo1.2345E-8bar\nRow #1: \nRow #1: foo1.2345E-8bar\nRow #2: 266,773\nRow #2: foo533546.0bar\n"));
    }

    public void testCalcMemberCustomFormatterInQueryNegative() {
        this.assertThrows("with member [Measures].[Foo] as ' [Measures].[Unit Sales] * 2 ',\n CELL_FORMATTER='mondrian.test.NonExistentCellFormatter' \nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Store].Children} on rows\nfrom [Sales]", "Failed to load formatter class 'mondrian.test.NonExistentCellFormatter' for member '[Measures].[Foo]'.");
    }

    public void testCalcMemberCustomFormatterInQueryNegative2() {
        String query = "with member [Measures].[Foo] as ' [Measures].[Unit Sales] * 2 ',\n CELL_FORMATTER='java.lang.String' \nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Store].Children} on rows\nfrom [Sales]";
        this.assertThrows(query, "Failed to load formatter class 'java.lang.String' for member '[Measures].[Foo]'.");
        this.assertThrows(query, "java.lang.ClassCastException: java.lang.String");
    }

    public void testCalcMemberCustomFormatterInNonMeasureInQuery() {
        this.assertQueryReturns("with member [Store].[CA or OR] as ' Aggregate({[Store].[USA].[CA], [Store].[USA].[OR]}) ',\n CELL_FORMATTER='mondrian.test.FooBarCellFormatter'\nselect {[Store].[USA], [Store].[CA or OR]} on columns\nfrom [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[CA or OR]}\nRow #0: 266,773\nRow #0: 142,407\n"));
    }

    public void testCalcMemberCustomFormatterInSchema() {
        String cubeName = "Sales";
        TestContext testContext = TestContext.createSubstitutingCube(cubeName, null, "<CalculatedMember\n    name=\"Profit Formatted\"\n    dimension=\"Measures\"\n    visible=\"false\"\n    formula=\"[Measures].[Store Sales]-[Measures].[Store Cost]\">\n  <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.00\"/>\n  <CalculatedMemberProperty name=\"CELL_FORMATTER\" value=\"mondrian.test.FooBarCellFormatter\"/>\n</CalculatedMember>\n");
        testContext.assertQueryReturns("select {[Measures].[Unit Sales], [Measures].[Profit Formatted]} on 0,\n {[Store].Children} on rows\nfrom [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Profit Formatted]}\nAxis #2:\n{[Store].[All Stores].[Canada]}\n{[Store].[All Stores].[Mexico]}\n{[Store].[All Stores].[USA]}\nRow #0: \nRow #0: foo1.2345E-8bar\nRow #1: \nRow #1: foo1.2345E-8bar\nRow #2: 266,773\nRow #2: foo339610.89639999997bar\n"));
    }

    public void testCalcMemberCustomFormatterInSchemaNegative() {
        String cubeName = "Sales";
        TestContext testContext = TestContext.createSubstitutingCube(cubeName, null, "  <CalculatedMember\n    name=\"Profit Formatted\"\n    dimension=\"Measures\"\n    visible=\"false\"\n    formula=\"[Measures].[Store Sales]-[Measures].[Store Cost]\">\n  <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.00\"/>\n  <CalculatedMemberProperty name=\"CELL_FORMATTER\" value=\"mondrian.test.NonExistentCellFormatter\"/>\n</CalculatedMember>\n");
        testContext.assertThrows("select {[Measures].[Unit Sales], [Measures].[Profit Formatted]} on 0,\n {[Store].Children} on rows\nfrom [Sales]", "Failed to load formatter class 'mondrian.test.NonExistentCellFormatter' for member '[Measures].[Profit Formatted]'.");
    }

    public void testStrToSetInCubeCalcMember() {
        String cubeName = "Sales";
        TestContext testContext = TestContext.createSubstitutingCube(cubeName, null, "<CalculatedMember\n    name=\"My Tuple\"\n    dimension=\"Measures\"\n    visible=\"false\"\n    formula=\"StrToTuple('([Gender].[M], [Marital Status].[S])', [Gender], [Marital Status])\"/>\n");
        String desiredResult = TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[My Tuple]}\nRow #0: 68,755\n");
        testContext.assertQueryReturns("select {[Measures].[My Tuple]} on 0 from [Sales]", desiredResult);
        TestContext.instance().assertQueryReturns("with member [Measures].[My Tuple] as\n 'StrToTuple(\"([Gender].[M], [Marital Status].[S])\", [Gender], [Marital Status])'\nselect {[Measures].[My Tuple]} on 0 from [Sales]", desiredResult);
    }

    public void testCreateCalculatedMember() {
        String query = "WITH MEMBER [Product].[Calculated Member] as 'AGGREGATE({})'\nSELECT {[Measures].[Unit Sales]} on 0\nFROM [Sales]\nWHERE ([Product].[Calculated Member])";
        String derbySQL = "select \"product_class\".\"product_family\" from \"product\" as \"product\", \"product_class\" as \"product_class\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and UPPER(\"product_class\".\"product_family\") = UPPER('Calculated Member') group by \"product_class\".\"product_family\" order by \"product_class\".\"product_family\" ASC";
        String mysqlSQL = "select `product_class`.`product_family` as `c0` from `product` as `product`, `product_class` as `product_class` where `product`.`product_class_id` = `product_class`.`product_class_id` and UPPER(`product_class`.`product_family`) = UPPER('Calculated Member') group by `product_class`.`product_family` order by ISNULL(`product_class`.`product_family`), `product_class`.`product_family` ASC";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySQL, derbySQL), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSQL, mysqlSQL)};
        this.assertQuerySqlOrNot(this.getTestContext(), query, patterns, true, true, true);
    }

    public void testSetIncludesSelf() {
        this.assertQueryReturns("with set [Top Products] as ' [Product].Children '\nmember [Product].[Top Product Total] as ' Aggregate([Top Products]) '\nselect {[Product].[Food], [Product].[Top Product Total]} on 0, [Gender].Members on 1\nfrom [Sales]", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Food]}\n{[Product].[Top Product Total]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 191,940\nRow #0: 266,773\nRow #1: 94,814\nRow #1: 131,558\nRow #2: 97,126\nRow #2: 135,215\n"));
    }

    public void testNegativeSolveOrderForCalMemberWithFilter() {
        String mdx = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Education Level],[*BASE_MEMBERS_Product])' Set [*METRIC_CJ_SET] as 'Filter([*NATIVE_CJ_SET],[Measures].[*Unit Sales_SEL~SUM] > 10000.0)' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0]}' Set [*BASE_MEMBERS_Education Level] as '{[Education Level].[All Education Levels].[Bachelors Degree],[Education Level].[All Education Levels].[Graduate Degree]}' Set [*NATIVE_MEMBERS_Education Level] as 'Generate([*NATIVE_CJ_SET], {[Education Level].CurrentMember})' Set [*METRIC_MEMBERS_Education Level] as 'Generate([*METRIC_CJ_SET], {[Education Level].CurrentMember})' Set [*BASE_MEMBERS_Product] as '{[Product].[All Products].[Food],[Product].[All Products].[Non-Consumable]}' Set [*NATIVE_MEMBERS_Product] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Set [*METRIC_MEMBERS_Product] as 'Generate([*METRIC_CJ_SET], {[Product].CurrentMember})' Member [Measures].[*Unit Sales_SEL~SUM] as '([Measures].[Unit Sales],[Education Level].CurrentMember,[Product].CurrentMember)', SOLVE_ORDER=200 Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Unit Sales]', FORMAT_STRING = '#,##0', SOLVE_ORDER=300 Member [Education Level].[*CTX_MEMBER_SEL~SUM] as 'Sum([*METRIC_MEMBERS_Education Level])', SOLVE_ORDER=-100 Member [Product].[*CTX_MEMBER_SEL~SUM] as 'Sum(Filter([*METRIC_MEMBERS_Product], [Measures].[*Unit Sales_SEL~SUM] > 10000.0))', SOLVE_ORDER=-200 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Union(NonEmptyCrossJoin({[Education Level].[*CTX_MEMBER_SEL~SUM]},{[Product].[*CTX_MEMBER_SEL~SUM]}),Generate([*METRIC_CJ_SET], {([Education Level].CurrentMember,[Product].CurrentMember)})) on rows From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[*FORMATTED_MEASURE_0]}\nAxis #2:\n{[Education Level].[*CTX_MEMBER_SEL~SUM], [Product].[*CTX_MEMBER_SEL~SUM]}\n{[Education Level].[All Education Levels].[Bachelors Degree], [Product].[All Products].[Food]}\n{[Education Level].[All Education Levels].[Bachelors Degree], [Product].[All Products].[Non-Consumable]}\n{[Education Level].[All Education Levels].[Graduate Degree], [Product].[All Products].[Food]}\nRow #0: 73,671\nRow #1: 49,365\nRow #2: 13,051\nRow #3: 11,255\n";
        this.assertQueryReturns(mdx, TestCalculatedMembers.fold(result));
    }

    public void testNegativeSolveOrderForCalMemberWithFilters2() {
        String mdx = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Education Level],[*BASE_MEMBERS_Product])' Set [*METRIC_CJ_SET] as 'Filter([*NATIVE_CJ_SET],[Measures].[*Unit Sales_SEL~SUM] > 10000.0)' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0]}' Set [*BASE_MEMBERS_Education Level] as '{[Education Level].[All Education Levels].[Bachelors Degree],[Education Level].[All Education Levels].[Graduate Degree]}' Set [*NATIVE_MEMBERS_Education Level] as 'Generate([*NATIVE_CJ_SET], {[Education Level].CurrentMember})' Set [*METRIC_MEMBERS_Education Level] as 'Generate([*METRIC_CJ_SET], {[Education Level].CurrentMember})' Set [*BASE_MEMBERS_Product] as '{[Product].[All Products].[Food],[Product].[All Products].[Non-Consumable]}' Set [*NATIVE_MEMBERS_Product] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Set [*METRIC_MEMBERS_Product] as 'Generate([*METRIC_CJ_SET], {[Product].CurrentMember})' Member [Measures].[*Unit Sales_SEL~SUM] as '([Measures].[Unit Sales],[Education Level].CurrentMember,[Product].CurrentMember)', SOLVE_ORDER=200 Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Unit Sales]', FORMAT_STRING = '#,##0', SOLVE_ORDER=300 Member [Education Level].[*CTX_MEMBER_SEL~SUM] as 'Sum([*METRIC_MEMBERS_Education Level])', SOLVE_ORDER=-200 Member [Product].[*CTX_MEMBER_SEL~SUM] as 'Sum(Filter([*METRIC_MEMBERS_Product], [Measures].[*Unit Sales_SEL~SUM] > 10000.0))', SOLVE_ORDER=-100 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Union(NonEmptyCrossJoin({[Education Level].[*CTX_MEMBER_SEL~SUM]},{[Product].[*CTX_MEMBER_SEL~SUM]}),Generate([*METRIC_CJ_SET], {([Education Level].CurrentMember,[Product].CurrentMember)})) on rows From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[*FORMATTED_MEASURE_0]}\nAxis #2:\n{[Education Level].[*CTX_MEMBER_SEL~SUM], [Product].[*CTX_MEMBER_SEL~SUM]}\n{[Education Level].[All Education Levels].[Bachelors Degree], [Product].[All Products].[Food]}\n{[Education Level].[All Education Levels].[Bachelors Degree], [Product].[All Products].[Non-Consumable]}\n{[Education Level].[All Education Levels].[Graduate Degree], [Product].[All Products].[Food]}\nRow #0: 76,661\nRow #1: 49,365\nRow #2: 13,051\nRow #3: 11,255\n";
        this.assertQueryReturns(mdx, TestCalculatedMembers.fold(result));
    }

    public void testNonTopLevelCalculatedMember() {
        this.assertQueryReturns("with member [Product].[Test] as '[Product].[Food]' select {[Measures].[Unit Sales]} on columns, {[Product].[Test]} on rows from Sales", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[Test]}\nRow #0: 191,940\n"));
        this.assertQueryReturns("with member [Product].[Food].[Test] as '[Product].[Food]' select {[Measures].[Unit Sales]} on columns, {[Product].[Food].[Test]} on rows from Sales", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Test]}\nRow #0: 191,940\n"));
    }

    public void testCalculatedMemberChildren() {
        this.assertQueryReturns("with member [Product].[Test] as '[Product].[Food]' select {[Measures].[Unit Sales]} on columns, [Product].[Test].children on rows from Sales", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n"));
        this.assertQueryReturns("with member [Product].[Food].[Test] as '[Product].[Food]' select {[Measures].[Unit Sales]} on columns, [Product].[Food].[Test].children on rows from Sales", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n"));
    }

    public void testCalculatedMemberMSASCompatibility() {
        this.assertQueryReturns("with member gender.calculated as 'gender.m' member  gender.[All Gender].calculated as 'gender.m' member measures.countChildren as 'gender.calculated.children.Count' member measures.parentIsAll as 'gender.calculated.Parent IS gender.[All Gender]' member measures.levelOrdinal as 'gender.calculated.Level.Ordinal' member measures.definedOnAllLevelOrdinal as 'gender.[all gender].calculated.Level.Ordinal' member measures.definedOnAllLevelParentIsAll as 'gender.[all gender].calculated.Parent IS gender.[All Gender]' member measures.definedOnAllLevelChildren as 'gender.[all gender].calculated.Children.Count' member measures.definedOnAllLevelSiblings as 'gender.[all gender].calculated.Siblings.Count' select {   measures.[countChildren],   measures.parentIsAll,   measures.levelOrdinal,   measures.definedOnAllLevelOrdinal,   measures.definedOnAllLevelParentIsAll,   measures.definedOnAllLevelChildren,   measures.definedOnAllLevelSiblings } on 0 from sales", TestCalculatedMembers.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[countChildren]}\n{[Measures].[parentIsAll]}\n{[Measures].[levelOrdinal]}\n{[Measures].[definedOnAllLevelOrdinal]}\n{[Measures].[definedOnAllLevelParentIsAll]}\n{[Measures].[definedOnAllLevelChildren]}\n{[Measures].[definedOnAllLevelSiblings]}\nRow #0: 0\nRow #0: false\nRow #0: 0\nRow #0: 1\nRow #0: true\nRow #0: 0\nRow #0: 2\n"));
    }
}

