/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FactTemplateError;
import org.drools.compiler.FieldTemplateError;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.ImportError;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleBuildError;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.builder.DroolsBuildMarker;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.lang.ExpanderException;
import org.drools.template.parser.DecisionTableParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DroolsBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.drools.eclipse.droolsbuilder";

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        if (iProject == null || !iProject.isAccessible()) {
            return new IProject[0];
        }
        try {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (n == 6) {
                this.fullBuild(iProgressMonitor);
            } else {
                IResourceDelta iResourceDelta = this.getDelta(this.getProject());
                if (iResourceDelta == null) {
                    this.fullBuild(iProgressMonitor);
                } else {
                    this.incrementalBuild(iResourceDelta, iProgressMonitor);
                }
            }
        }
        catch (CoreException coreException) {
            IMarker iMarker = iProject.createMarker("org.drools.eclipse.problem");
            iMarker.setAttribute("message", (Object)("Drools\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306e\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff1a " + coreException.getLocalizedMessage()));
            iMarker.setAttribute("severity", 2);
        }
        return this.getRequiredProjects(iProject);
    }

    protected void fullBuild(IProgressMonitor iProgressMonitor) throws CoreException {
        this.removeProblemsFor((IResource)this.getProject());
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            String[] stringArray;
            if ("DROOLS/Drools".equals(iClasspathEntryArray[n].getPath().toString()) && ((stringArray = DroolsRuntimeManager.getDroolsRuntimeJars(this.getProject())) == null || stringArray.length == 0)) {
                String string = DroolsRuntimeManager.getDroolsRuntime(this.getProject());
                IMarker iMarker = this.getProject().createMarker("org.drools.eclipse.problem");
                if (string == null) {
                    iMarker.setAttribute("message", (Object)"Drools\u30e9\u30f3\u30bf\u30a4\u30e0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                } else {
                    iMarker.setAttribute("message", (Object)("Drools\u30e9\u30f3\u30bf\u30a4\u30e0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 " + string));
                }
                iMarker.setAttribute("severity", 2);
                return;
            }
            ++n;
        }
        this.getProject().accept((IResourceVisitor)new DroolsBuildVisitor());
    }

    protected void incrementalBuild(IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean("Drools.BuildAll");
        if (bl) {
            this.fullBuild(iProgressMonitor);
        } else {
            iResourceDelta.accept((IResourceDeltaVisitor)new DroolsBuildDeltaVisitor());
        }
    }

    protected boolean parseResource(IResource iResource, boolean bl) {
        block35: {
            try {
                if (!".guvnorinfo".equals(iResource.getName())) break block35;
                return false;
            }
            catch (JavaModelException javaModelException) {}
        }
        DroolsBuildMarker[] droolsBuildMarkerArray = JavaCore.create((IProject)iResource.getProject());
        if (!droolsBuildMarkerArray.getOutputLocation().equals((Object)droolsBuildMarkerArray.getPath()) && droolsBuildMarkerArray.getOutputLocation().isPrefixOf(iResource.getFullPath())) {
            return false;
        }
        if (!iResource.exists()) {
            this.removeProblemsFor(iResource);
            DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
            return false;
        }
        if (iResource instanceof IFile && ("drl".equals(iResource.getFileExtension()) || "dslr".equals(iResource.getFileExtension()) || ".package".equals(iResource.getName()))) {
            this.removeProblemsFor(iResource);
            try {
                if (bl) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
                }
                droolsBuildMarkerArray = this.parseDRLFile((IFile)iResource, new String(Util.getResourceContentsAsCharArray((IFile)iResource)));
                int n = 0;
                while (n < droolsBuildMarkerArray.length) {
                    this.createMarker(iResource, droolsBuildMarkerArray[n].getText(), droolsBuildMarkerArray[n].getLine());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
                this.createMarker(iResource, throwable.getMessage(), -1);
            }
            return false;
        }
        if (iResource instanceof IFile && "xls".equals(iResource.getFileExtension())) {
            this.removeProblemsFor(iResource);
            try {
                if (bl) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
                }
                droolsBuildMarkerArray = this.parseXLSFile((IFile)iResource);
                int n = 0;
                while (n < droolsBuildMarkerArray.length) {
                    this.createMarker(iResource, droolsBuildMarkerArray[n].getText(), droolsBuildMarkerArray[n].getLine());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                this.createMarker(iResource, throwable.getMessage(), -1);
            }
            return false;
        }
        if (iResource instanceof IFile && "csv".equals(iResource.getFileExtension())) {
            this.removeProblemsFor(iResource);
            try {
                if (bl) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
                }
                droolsBuildMarkerArray = this.parseCSVFile((IFile)iResource);
                int n = 0;
                while (n < droolsBuildMarkerArray.length) {
                    this.createMarker(iResource, droolsBuildMarkerArray[n].getText(), droolsBuildMarkerArray[n].getLine());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                this.createMarker(iResource, throwable.getMessage(), -1);
            }
            return false;
        }
        if (iResource instanceof IFile && "brl".equals(iResource.getFileExtension())) {
            this.removeProblemsFor(iResource);
            try {
                if (bl) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
                }
                droolsBuildMarkerArray = this.parseBRLFile((IFile)iResource);
                int n = 0;
                while (n < droolsBuildMarkerArray.length) {
                    this.createMarker(iResource, droolsBuildMarkerArray[n].getText(), droolsBuildMarkerArray[n].getLine());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                this.createMarker(iResource, throwable.getMessage(), -1);
            }
            return false;
        }
        if (iResource instanceof IFile && "rf".equals(iResource.getFileExtension())) {
            this.removeProblemsFor(iResource);
            try {
                if (bl) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
                }
                droolsBuildMarkerArray = this.parseRuleFlowFile((IFile)iResource);
                int n = 0;
                while (n < droolsBuildMarkerArray.length) {
                    this.createMarker(iResource, droolsBuildMarkerArray[n].getText(), droolsBuildMarkerArray[n].getLine());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                this.createMarker(iResource, throwable.getMessage(), -1);
            }
            return false;
        }
        if (iResource instanceof IFile && "bpmn".equals(iResource.getFileExtension())) {
            this.removeProblemsFor(iResource);
            try {
                if (bl) {
                    DroolsEclipsePlugin.getDefault().invalidateResource(iResource);
                }
                droolsBuildMarkerArray = this.parseRuleFlowFile((IFile)iResource);
                int n = 0;
                while (n < droolsBuildMarkerArray.length) {
                    this.createMarker(iResource, droolsBuildMarkerArray[n].getText(), droolsBuildMarkerArray[n].getLine());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                this.createMarker(iResource, throwable.getMessage(), -1);
            }
            return false;
        }
        return true;
    }

    private DroolsBuildMarker[] parseDRLFile(IFile iFile, String string) {
        ArrayList<DroolsBuildMarker> arrayList = new ArrayList<DroolsBuildMarker>();
        try {
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseResource((IResource)iFile, true);
            this.markParseErrors(arrayList, dRLInfo.getParserErrors());
            this.markOtherErrors(arrayList, dRLInfo.getBuilderErrors());
        }
        catch (DroolsParserException droolsParserException) {
            Throwable throwable = droolsParserException.getCause();
            if (throwable instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)throwable;
                arrayList.add(new DroolsBuildMarker(recognitionException.getMessage(), recognitionException.line));
            }
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null || string2.trim().equals("")) {
                string2 = "\u30a8\u30e9\u30fc\uff1a " + exception.getClass().getName();
            }
            arrayList.add(new DroolsBuildMarker(string2));
        }
        return arrayList.toArray(new DroolsBuildMarker[arrayList.size()]);
    }

    private DroolsBuildMarker[] parseXLSFile(IFile iFile) {
        ArrayList<DroolsBuildMarker> arrayList = new ArrayList<DroolsBuildMarker>();
        try {
            SpreadsheetCompiler spreadsheetCompiler = new SpreadsheetCompiler();
            String string = spreadsheetCompiler.compile(iFile.getContents(), InputType.XLS);
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseXLSResource(string, (IResource)iFile);
            this.markParseErrors(arrayList, dRLInfo.getParserErrors());
            this.markOtherErrors(arrayList, dRLInfo.getBuilderErrors());
        }
        catch (DroolsParserException droolsParserException) {
            Throwable throwable = droolsParserException.getCause();
            if (throwable instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)throwable;
                arrayList.add(new DroolsBuildMarker(recognitionException.getMessage(), recognitionException.line));
            }
        }
        catch (DecisionTableParseException decisionTableParseException) {
            if (!"No RuleTable's were found in spreadsheet.".equals(decisionTableParseException.getMessage())) {
                throw decisionTableParseException;
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "\u30a8\u30e9\u30fc\uff1a " + exception.getClass().getName();
            }
            arrayList.add(new DroolsBuildMarker(string));
        }
        return arrayList.toArray(new DroolsBuildMarker[arrayList.size()]);
    }

    private DroolsBuildMarker[] parseCSVFile(IFile iFile) {
        ArrayList<DroolsBuildMarker> arrayList = new ArrayList<DroolsBuildMarker>();
        try {
            SpreadsheetCompiler spreadsheetCompiler = new SpreadsheetCompiler();
            String string = spreadsheetCompiler.compile(iFile.getContents(), InputType.CSV);
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseXLSResource(string, (IResource)iFile);
            this.markParseErrors(arrayList, dRLInfo.getParserErrors());
            this.markOtherErrors(arrayList, dRLInfo.getBuilderErrors());
        }
        catch (DroolsParserException droolsParserException) {
            Throwable throwable = droolsParserException.getCause();
            if (throwable instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)throwable;
                arrayList.add(new DroolsBuildMarker(recognitionException.getMessage(), recognitionException.line));
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "\u30a8\u30e9\u30fc\uff1a " + exception.getClass().getName();
            }
            arrayList.add(new DroolsBuildMarker(string));
        }
        return arrayList.toArray(new DroolsBuildMarker[arrayList.size()]);
    }

    private DroolsBuildMarker[] parseBRLFile(IFile iFile) {
        ArrayList<DroolsBuildMarker> arrayList = new ArrayList<DroolsBuildMarker>();
        try {
            String string = DroolsBuilder.convertToString(iFile.getContents());
            RuleModel ruleModel = BRXMLPersistence.getInstance().unmarshal(string);
            String string2 = BRDRLPersistence.getInstance().marshal(ruleModel);
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseBRLResource(string2, (IResource)iFile);
            this.markParseErrors(arrayList, dRLInfo.getParserErrors());
            this.markOtherErrors(arrayList, dRLInfo.getBuilderErrors());
        }
        catch (DroolsParserException droolsParserException) {
            Throwable throwable = droolsParserException.getCause();
            if (throwable instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)throwable;
                arrayList.add(new DroolsBuildMarker(recognitionException.getMessage(), recognitionException.line));
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "\u30a8\u30e9\u30fc\uff1a " + exception.getClass().getName();
            }
            arrayList.add(new DroolsBuildMarker(string));
        }
        return arrayList.toArray(new DroolsBuildMarker[arrayList.size()]);
    }

    private DroolsBuildMarker[] parseGDSTFile(IFile iFile) {
        ArrayList<DroolsBuildMarker> arrayList = new ArrayList<DroolsBuildMarker>();
        try {
            String string = DroolsBuilder.convertToString(iFile.getContents());
            GuidedDecisionTable guidedDecisionTable = GuidedDTXMLPersistence.getInstance().unmarshal(string);
            String string2 = GuidedDTDRLPersistence.getInstance().marshal(guidedDecisionTable);
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseGDSTResource(string2, (IResource)iFile);
            this.markParseErrors(arrayList, dRLInfo.getParserErrors());
            this.markOtherErrors(arrayList, dRLInfo.getBuilderErrors());
        }
        catch (DroolsParserException droolsParserException) {
            Throwable throwable = droolsParserException.getCause();
            if (throwable instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)throwable;
                arrayList.add(new DroolsBuildMarker(recognitionException.getMessage(), recognitionException.line));
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "\u30a8\u30e9\u30fc\uff1a " + exception.getClass().getName();
            }
            arrayList.add(new DroolsBuildMarker(string));
        }
        return arrayList.toArray(new DroolsBuildMarker[arrayList.size()]);
    }

    protected DroolsBuildMarker[] parseRuleFlowFile(IFile iFile) {
        if (!iFile.exists()) {
            return new DroolsBuildMarker[0];
        }
        ArrayList<DroolsBuildMarker> arrayList = new ArrayList<DroolsBuildMarker>();
        try {
            String string = DroolsBuilder.convertToString(iFile.getContents());
            ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().parseProcess(string, (IResource)iFile);
            if (processInfo != null) {
                this.markParseErrors(arrayList, processInfo.getErrors());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = exception.getMessage();
            if (string == null || string.trim().equals("")) {
                string = "\u30a8\u30e9\u30fc\uff1a " + exception.getClass().getName();
            }
            arrayList.add(new DroolsBuildMarker(string));
        }
        return arrayList.toArray(new DroolsBuildMarker[arrayList.size()]);
    }

    protected static String convertToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = inputStreamReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    protected void markParseErrors(List list, List list2) {
        for (Object e : list2) {
            ParserError parserError;
            if (e instanceof ParserError) {
                parserError = (ParserError)e;
                list.add(new DroolsBuildMarker(parserError.getMessage(), parserError.getRow()));
                continue;
            }
            if (e instanceof ExpanderException) {
                parserError = (ExpanderException)e;
                list.add(new DroolsBuildMarker(parserError.getMessage(), -1));
                continue;
            }
            list.add(new DroolsBuildMarker(e.toString()));
        }
    }

    private void markOtherErrors(List list, DroolsError[] droolsErrorArray) {
        int n = 0;
        while (n < droolsErrorArray.length) {
            int n2;
            CompilationProblem[] compilationProblemArray;
            GlobalError globalError;
            DroolsError droolsError = droolsErrorArray[n];
            if (droolsError instanceof GlobalError) {
                globalError = (GlobalError)droolsError;
                list.add(new DroolsBuildMarker("Global error: " + globalError.getGlobal(), -1));
            } else if (droolsError instanceof RuleBuildError) {
                globalError = (RuleBuildError)droolsError;
                if (globalError.getObject() instanceof CompilationProblem[]) {
                    compilationProblemArray = (CompilationProblem[])globalError.getObject();
                    n2 = 0;
                    while (n2 < compilationProblemArray.length) {
                        list.add(new DroolsBuildMarker(compilationProblemArray[n2].getMessage(), globalError.getLine()));
                        ++n2;
                    }
                } else {
                    list.add(new DroolsBuildMarker(String.valueOf(globalError.getRule().getName()) + ":" + globalError.getMessage(), globalError.getLine()));
                }
            } else if (droolsError instanceof ParserError) {
                globalError = (ParserError)droolsError;
                list.add(new DroolsBuildMarker(globalError.getMessage(), globalError.getRow()));
            } else if (droolsError instanceof FunctionError) {
                globalError = (FunctionError)droolsError;
                if (globalError.getObject() instanceof CompilationProblem[]) {
                    compilationProblemArray = (CompilationProblem[])globalError.getObject();
                    n2 = 0;
                    while (n2 < compilationProblemArray.length) {
                        list.add(new DroolsBuildMarker(compilationProblemArray[n2].getMessage(), globalError.getErrorLines()[n2]));
                        ++n2;
                    }
                } else {
                    list.add(new DroolsBuildMarker(String.valueOf(globalError.getFunctionDescr().getName()) + ":" + globalError.getMessage(), -1));
                }
            } else if (droolsError instanceof FieldTemplateError) {
                list.add(new DroolsBuildMarker(droolsError.getMessage(), ((FieldTemplateError)droolsError).getLine()));
            } else if (droolsError instanceof FactTemplateError) {
                list.add(new DroolsBuildMarker(droolsError.getMessage(), ((FactTemplateError)droolsError).getLine()));
            } else if (droolsError instanceof ImportError) {
                list.add(new DroolsBuildMarker("ImportError: " + droolsError.getMessage()));
            } else if (droolsError instanceof DescrBuildError) {
                list.add(new DroolsBuildMarker("BuildError: " + droolsError.getMessage(), ((DescrBuildError)droolsError).getLine()));
            } else {
                list.add(new DroolsBuildMarker("Unknown DroolsError " + droolsError.getClass() + ": " + droolsError));
            }
            ++n;
        }
    }

    protected void createMarker(final IResource iResource, final String string, final int n) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    IMarker iMarker = iResource.createMarker("org.drools.eclipse.problem");
                    iMarker.setAttribute("message", (Object)string);
                    iMarker.setAttribute("severity", 2);
                    iMarker.setAttribute("lineNumber", n);
                }
            };
            iResource.getWorkspace().run(iWorkspaceRunnable, null, 1, null);
        }
        catch (CoreException coreException) {
            DroolsEclipsePlugin.log(coreException);
        }
    }

    protected void removeProblemsFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                iResource.deleteMarkers("org.drools.eclipse.problem", false, 2);
            }
        }
        catch (CoreException coreException) {
            DroolsEclipsePlugin.log(coreException);
        }
    }

    private IProject[] getRequiredProjects(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
            int n = 0;
            int n2 = iClasspathEntryArray.length;
            while (n < n2) {
                IProject iProject2;
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                if (iClasspathEntry.getEntryKind() == 2 && (iProject2 = iProject.getWorkspace().getRoot().getProject(iClasspathEntry.getPath().lastSegment())) != null && !arrayList.contains(iProject2)) {
                    arrayList.add(iProject2);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    private class DroolsBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        private DroolsBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            return DroolsBuilder.this.parseResource(iResourceDelta.getResource(), false);
        }
    }

    private class DroolsBuildVisitor
    implements IResourceVisitor {
        private DroolsBuildVisitor() {
        }

        public boolean visit(IResource iResource) {
            return DroolsBuilder.this.parseResource(iResource, true);
        }
    }
}

