/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.core;

import java.util.Map;
import org.drools.eclipse.core.ActivationGroup;
import org.drools.eclipse.core.AgendaGroup;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.Expander;
import org.drools.eclipse.core.Function;
import org.drools.eclipse.core.Global;
import org.drools.eclipse.core.Import;
import org.drools.eclipse.core.Package;
import org.drools.eclipse.core.Process;
import org.drools.eclipse.core.Query;
import org.drools.eclipse.core.Rule;
import org.drools.eclipse.core.RuleAttribute;
import org.drools.eclipse.core.RuleFlowGroup;
import org.drools.eclipse.core.RuleGroup;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.Template;
import org.eclipse.core.resources.IFile;

public class DroolsModelBuilder {
    public static RuleSet createRuleSet() {
        return new RuleSet();
    }

    public static Package createPackage(String string, int n, int n2) {
        Package package_ = new Package(null, string);
        package_.setFile(null, n, n2);
        return package_;
    }

    public static Package addPackage(RuleSet ruleSet, String string, int n, int n2) {
        Package package_ = new Package(ruleSet, string);
        package_.setFile(null, n, n2);
        ruleSet.addPackage(package_);
        return package_;
    }

    public static void removePackage(Package package_) {
        RuleSet ruleSet = package_.getParentRuleSet();
        if (ruleSet != null) {
            ruleSet.removePackage(package_.getPackageName());
        }
    }

    public static void clearRuleSet(RuleSet ruleSet) {
        ruleSet.clear();
    }

    public static Rule addRule(Package package_, String string, IFile iFile, int n, int n2, Map map) {
        Rule rule = new Rule(package_, string);
        rule.setFile(iFile, n, n2);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                RuleAttribute ruleAttribute = new RuleAttribute(rule, string2, string3);
                ruleAttribute.setFile(iFile, n, n2);
                rule.addAttribute(ruleAttribute);
                RuleGroup ruleGroup = null;
                if (string2.equals("agenda-group")) {
                    ruleGroup = package_.getGroup(string3, 13);
                    if (ruleGroup != null) {
                        ruleGroup.addRule(rule);
                    } else {
                        ruleGroup = new AgendaGroup(package_, rule, string3);
                    }
                }
                if (string2.equals("ruleflow-group")) {
                    ruleGroup = package_.getGroup(string3, 14);
                    if (ruleGroup != null) {
                        ruleGroup.addRule(rule);
                    } else {
                        ruleGroup = new RuleFlowGroup(package_, rule, string3);
                    }
                }
                if (string2.equals("activation-group")) {
                    ruleGroup = package_.getGroup(string3, 12);
                    if (ruleGroup != null) {
                        ruleGroup.addRule(rule);
                    } else {
                        ruleGroup = new ActivationGroup(package_, rule, string3);
                    }
                }
                if (ruleGroup == null) continue;
                rule.setGroup(ruleGroup);
                ruleGroup.setFile(iFile, n, n2);
            }
            if (rule.getGroup() == null) {
                package_.getDefaultGroup().addRule(rule);
            }
        }
        package_.addRule(rule);
        return rule;
    }

    public static void removeRule(Rule rule) {
        Package package_ = rule.getParentPackage();
        if (package_ != null) {
            package_.removeRule(rule);
            if (package_.getChildren().length == 0) {
                DroolsModelBuilder.removePackage(package_);
            }
        }
    }

    public static Function addFunction(Package package_, String string, IFile iFile, int n, int n2) {
        Function function = new Function(package_, string);
        function.setFile(iFile, n, n2);
        package_.addFunction(function);
        return function;
    }

    public static void removeFunction(Function function) {
        Package package_ = function.getParentPackage();
        if (package_ != null) {
            package_.removeFunction(function);
        }
    }

    public static void addExpander(Package package_, String string, IFile iFile, int n, int n2) {
        Expander expander = new Expander(package_, string);
        expander.setFile(iFile, n, n2);
        package_.addExpander(expander);
    }

    public static void removeExpander(Expander expander) {
        Package package_ = expander.getParentPackage();
        if (package_ != null) {
            package_.removeExpander(expander);
        }
    }

    public static void addImport(Package package_, String string, IFile iFile, int n, int n2) {
        Import import_ = new Import(package_, string);
        import_.setFile(iFile, n, n2);
        package_.addImport(import_);
    }

    public static void removeImport(Import import_) {
        Package package_ = import_.getParentPackage();
        if (package_ != null) {
            package_.removeImport(import_);
        }
    }

    public static Global addGlobal(Package package_, String string, IFile iFile, int n, int n2) {
        Global global = new Global(package_, string);
        global.setFile(iFile, n, n2);
        package_.addGlobal(global);
        return global;
    }

    public static void removeGlobal(Global global) {
        Package package_ = global.getParentPackage();
        if (package_ != null) {
            package_.removeGlobal(global);
        }
    }

    public static Query addQuery(Package package_, String string, IFile iFile, int n, int n2) {
        Query query = new Query(package_, string);
        query.setFile(iFile, n, n2);
        package_.addQuery(query);
        return query;
    }

    public static void removeQuery(Query query) {
        Package package_ = query.getParentPackage();
        if (package_ != null) {
            package_.removeQuery(query);
        }
    }

    public static Template addTemplate(Package package_, String string, IFile iFile, int n, int n2) {
        Template template = new Template(package_, string);
        template.setFile(iFile, n, n2);
        package_.addTemplate(template);
        return template;
    }

    public static void removeTemplate(Template template) {
        Package package_ = template.getParentPackage();
        if (package_ != null) {
            package_.removeTemplate(template);
        }
    }

    public static Process addProcess(Package package_, String string, IFile iFile) {
        Process process = new Process(package_, string);
        process.setFile(iFile, -1, -1);
        package_.addProcess(process);
        return process;
    }

    public static void removeProcess(Process process) {
        Package package_ = process.getParentPackage();
        if (package_ != null) {
            package_.removeProcess(process);
        }
    }

    public static void removeElement(DroolsElement droolsElement) {
        switch (droolsElement.getType()) {
            case 0: {
                DroolsModelBuilder.clearRuleSet((RuleSet)droolsElement);
                break;
            }
            case 1: {
                DroolsModelBuilder.removePackage((Package)droolsElement);
                break;
            }
            case 2: {
                DroolsModelBuilder.removeRule((Rule)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Rule)droolsElement).getParentPackage());
                break;
            }
            case 3: {
                DroolsModelBuilder.removeQuery((Query)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Query)droolsElement).getParentPackage());
                break;
            }
            case 4: {
                DroolsModelBuilder.removeFunction((Function)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Function)droolsElement).getParentPackage());
                break;
            }
            case 5: {
                DroolsModelBuilder.removeTemplate((Template)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Template)droolsElement).getParentPackage());
                break;
            }
            case 6: {
                DroolsModelBuilder.removeExpander((Expander)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Expander)droolsElement).getParentPackage());
                break;
            }
            case 7: {
                DroolsModelBuilder.removeGlobal((Global)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Global)droolsElement).getParentPackage());
                break;
            }
            case 10: {
                DroolsModelBuilder.removeProcess((Process)droolsElement);
                DroolsModelBuilder.removePackageIfEmpty(((Process)droolsElement).getParentPackage());
            }
        }
    }

    private static void removePackageIfEmpty(Package package_) {
        if (package_.getChildren().length == 0) {
            DroolsModelBuilder.removePackage(package_);
        }
    }
}

