/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.core.ui;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.core.ui.DroolsFilter;
import org.drools.eclipse.core.ui.FilterAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class FilterActionGroup
extends ActionGroup {
    private FilterAction[] filterActions;
    private DroolsFilter filter;
    public int i;
    private StructuredViewer viewer;
    private String viewerId;

    public FilterActionGroup(StructuredViewer structuredViewer, String string) {
        this.viewer = structuredViewer;
        this.viewerId = string;
        this.filter = new DroolsFilter();
        this.filterActions = new FilterAction[]{this.addFilterForType(1, "\u30eb\u30fc\u30eb\u3092\u96a0\u3059", "DroolsRule"), this.addFilterForType(2, "\u30af\u30a8\u30ea\u30fc\u3092\u96a0\u3059", "DroolsQuery"), this.addFilterForType(4, "\u95a2\u6570\u3092\u96a0\u3059", "Method"), this.addFilterForType(16, "\u30b0\u30ed\u30fc\u30d0\u30eb\u3092\u96a0\u3059", "Global"), this.addFilterForType(8, "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u96a0\u3059", "Class"), this.addFilterForType(32, "\u5b9f\u884c\u8a08\u753b\uff0f\u30eb\u30fc\u30eb\u30d5\u30ed\u30fc\u30b0\u30eb\u30fc\u30d7\u3092\u96a0\u3059", "RuleFlowGroup")};
        structuredViewer.addFilter((ViewerFilter)this.filter);
    }

    private FilterAction addFilterForType(int n, String string, String string2) {
        boolean bl = DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean(this.getPreferenceKey(n));
        if (bl) {
            this.filter.addFilter(n);
        }
        FilterAction filterAction = new FilterAction(this, string, n, bl, string2);
        filterAction.setToolTipText(string);
        return filterAction;
    }

    private String getPreferenceKey(int n) {
        return "DroolsFilterActionGroup." + this.viewerId + '.' + String.valueOf(n);
    }

    public void setFilter(int n, boolean bl) {
        this.setDroolsFilters(new int[]{n}, new boolean[]{bl}, true);
    }

    private void setDroolsFilters(int[] nArray, boolean[] blArray, boolean bl) {
        if (nArray.length == 0) {
            return;
        }
        Assert.isTrue((nArray.length == blArray.length ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            boolean bl2 = blArray[n];
            IPreferenceStore iPreferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
            boolean bl3 = false;
            int n3 = 0;
            while (n3 < this.filterActions.length) {
                int n4 = this.filterActions[n3].getFilterType();
                if (n4 == n2) {
                    this.filterActions[n3].setChecked(bl2);
                    bl3 = true;
                    iPreferenceStore.setValue(this.getPreferenceKey(n2), bl2);
                }
                ++n3;
            }
            if (bl3) {
                if (bl2) {
                    this.filter.addFilter(n2);
                } else {
                    this.filter.removeFilter(n2);
                }
            }
            ++n;
        }
        if (bl) {
            this.viewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    FilterActionGroup.this.viewer.refresh();
                }
            });
            this.viewer.getControl().setRedraw(true);
        }
    }

    public boolean hasDroolsFilter(int n) {
        return this.filter.hasFilter(n);
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.contributeToToolBar(iActionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        int n = 0;
        while (n < this.filterActions.length) {
            iToolBarManager.add((IAction)this.filterActions[n]);
            ++n;
        }
    }
}

