/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.drools.audit.event.ActivationLogEvent;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.ObjectLogEvent;
import org.drools.audit.event.RuleBaseLogEvent;
import org.drools.audit.event.RuleFlowGroupLogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.debug.AuditViewContentProvider;
import org.drools.eclipse.debug.actions.DeleteLogAction;
import org.drools.eclipse.debug.actions.FileAuditDropAdapter;
import org.drools.eclipse.debug.actions.OpenLogAction;
import org.drools.eclipse.debug.actions.RefreshLogAction;
import org.drools.eclipse.debug.actions.ShowEventCauseAction;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditView
extends AbstractDebugView {
    private static final String LOG_FILE_NAME = "LogFileName";
    private static final String CAUSE_EVENT_COLOR = "CauseEventColor";
    private String logFileName;
    private IAction deleteAction;
    private IAction refreshAction;
    private boolean drools4 = false;

    protected Viewer createViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite);
        treeViewer.setContentProvider((IContentProvider)new AuditViewContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new AuditLabelProvider());
        treeViewer.setUseHashlookup(true);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AuditView.this.getViewer().refresh();
            }
        });
        int n = 3;
        Transfer[] transferArray = new Transfer[]{FileTransfer.getInstance()};
        treeViewer.addDropSupport(n, transferArray, (DropTargetListener)new FileAuditDropAdapter((Viewer)treeViewer, this));
        return treeViewer;
    }

    public void setLogFile(String string) {
        this.logFileName = string;
        this.refresh();
        this.deleteAction.setEnabled(string != null);
        this.refreshAction.setEnabled(string != null);
    }

    public void refresh() {
        this.drools4 = false;
        if (this.logFileName == null) {
            this.getViewer().setInput(null);
            return;
        }
        ArrayList<LogEvent> arrayList = new ArrayList<LogEvent>();
        try {
            XStream xStream = new XStream();
            ObjectInputStream objectInputStream = xStream.createObjectInputStream((Reader)new FileReader(this.logFileName));
            try {
                Object object;
                while (true) {
                    if ((object = objectInputStream.readObject()) instanceof LogEvent) {
                        arrayList.add((LogEvent)object);
                        continue;
                    }
                    if (!(object instanceof List)) break;
                    this.drools4 = true;
                    arrayList.addAll((List)object);
                }
                throw new IllegalArgumentException("Unexpected element in log: " + object);
            }
            catch (StreamException streamException) {
                if (!(streamException.getCause() instanceof EOFException)) {
                    throw streamException;
                }
            }
            catch (EOFException eOFException) {
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setLogFile(null);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        if (this.drools4) {
            this.getViewer().setInput((Object)this.createDrools4EventList(arrayList));
        } else {
            this.getViewer().setInput(this.createEventList(arrayList));
        }
        ((TreeViewer)this.getViewer()).expandAll();
    }

    protected List<Event> createEventList(List<LogEvent> list) {
        Iterator<LogEvent> iterator = list.iterator();
        ArrayList<Event> arrayList = new ArrayList<Event>();
        Stack<Event> stack = new Stack<Event>();
        ArrayList<Event> arrayList2 = new ArrayList<Event>();
        HashMap<String, Event> hashMap = new HashMap<String, Event>();
        HashMap<Long, Event> hashMap2 = new HashMap<Long, Event>();
        while (iterator.hasNext()) {
            LogEvent logEvent = iterator.next();
            Event event = new Event(logEvent.getType());
            switch (logEvent.getType()) {
                case 1: {
                    ObjectLogEvent objectLogEvent = (ObjectLogEvent)logEvent;
                    event.setString("Object inserted (" + objectLogEvent.getFactId() + "): " + objectLogEvent.getObjectToString());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    event.addSubEvents(arrayList2);
                    arrayList2.clear();
                    hashMap2.put(new Long(((ObjectLogEvent)logEvent).getFactId()), event);
                    break;
                }
                case 2: {
                    ObjectLogEvent objectLogEvent = (ObjectLogEvent)logEvent;
                    event.setString("Object updated (" + objectLogEvent.getFactId() + "): " + objectLogEvent.getObjectToString());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    event.addSubEvents(arrayList2);
                    arrayList2.clear();
                    Event event2 = (Event)hashMap2.get(new Long(((ObjectLogEvent)logEvent).getFactId()));
                    if (event2 == null) break;
                    event.setCauseEvent(event2);
                    break;
                }
                case 3: {
                    ObjectLogEvent objectLogEvent = (ObjectLogEvent)logEvent;
                    event.setString("Object removed (" + objectLogEvent.getFactId() + "): " + objectLogEvent.getObjectToString());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    event.addSubEvents(arrayList2);
                    arrayList2.clear();
                    Event event2 = (Event)hashMap2.get(new Long(((ObjectLogEvent)logEvent).getFactId()));
                    if (event2 == null) break;
                    event.setCauseEvent(event2);
                    break;
                }
                case 4: {
                    ActivationLogEvent activationLogEvent = (ActivationLogEvent)logEvent;
                    event.setString("Activation created: Rule " + activationLogEvent.getRule() + " " + activationLogEvent.getDeclarations());
                    arrayList2.add(event);
                    hashMap.put(((ActivationLogEvent)logEvent).getActivationId(), event);
                    break;
                }
                case 5: {
                    ActivationLogEvent activationLogEvent = (ActivationLogEvent)logEvent;
                    event.setString("Activation cancelled: Rule " + activationLogEvent.getRule() + " " + activationLogEvent.getDeclarations());
                    arrayList2.add(event);
                    event.setCauseEvent((Event)hashMap.get(((ActivationLogEvent)logEvent).getActivationId()));
                    break;
                }
                case 6: {
                    ActivationLogEvent activationLogEvent = (ActivationLogEvent)logEvent;
                    event.setString("Activation executed: Rule " + activationLogEvent.getRule() + " " + activationLogEvent.getDeclarations());
                    arrayList.add(event);
                    stack.push(event);
                    event.setCauseEvent((Event)hashMap.get(((ActivationLogEvent)logEvent).getActivationId()));
                    break;
                }
                case 7: {
                    stack.pop();
                    break;
                }
                case 8: {
                    RuleFlowLogEvent ruleFlowLogEvent = (RuleFlowLogEvent)logEvent;
                    event.setString("Process started: " + ruleFlowLogEvent.getProcessName() + "[" + ruleFlowLogEvent.getProcessId() + "]");
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 9: {
                    stack.pop();
                    break;
                }
                case 10: {
                    RuleFlowLogEvent ruleFlowLogEvent = (RuleFlowLogEvent)logEvent;
                    event.setString("Process completed: " + ruleFlowLogEvent.getProcessName() + "[" + ruleFlowLogEvent.getProcessId() + "]");
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 11: {
                    stack.pop();
                    break;
                }
                case 24: {
                    RuleFlowNodeLogEvent ruleFlowNodeLogEvent = (RuleFlowNodeLogEvent)logEvent;
                    event.setString("Process node triggered: " + ruleFlowNodeLogEvent.getNodeName() + " in process " + ruleFlowNodeLogEvent.getProcessName() + "[" + ruleFlowNodeLogEvent.getProcessId() + "]");
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 25: {
                    stack.pop();
                    break;
                }
                case 12: {
                    RuleFlowGroupLogEvent ruleFlowGroupLogEvent = (RuleFlowGroupLogEvent)logEvent;
                    event.setString("RuleFlow Group activated: " + ruleFlowGroupLogEvent.getGroupName() + "[size=" + ruleFlowGroupLogEvent.getSize() + "]");
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 13: {
                    stack.pop();
                    break;
                }
                case 14: {
                    RuleFlowGroupLogEvent ruleFlowGroupLogEvent = (RuleFlowGroupLogEvent)logEvent;
                    event.setString("RuleFlow Group deactivated: " + ruleFlowGroupLogEvent.getGroupName() + "[size=" + ruleFlowGroupLogEvent.getSize() + "]");
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 15: {
                    stack.pop();
                    break;
                }
                case 16: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Package added: " + ruleBaseLogEvent.getPackageName());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 17: {
                    stack.pop();
                    break;
                }
                case 18: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Package removed: " + ruleBaseLogEvent.getPackageName());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 19: {
                    stack.pop();
                    break;
                }
                case 20: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Rule added: " + ruleBaseLogEvent.getRuleName());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 21: {
                    if (stack.isEmpty()) break;
                    Event event3 = (Event)stack.pop();
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                    break;
                }
                case 22: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event.setString("Rule removed: " + ruleBaseLogEvent.getRuleName());
                    if (!stack.isEmpty()) {
                        ((Event)stack.peek()).addSubEvent(event);
                    } else {
                        arrayList.add(event);
                    }
                    stack.push(event);
                    break;
                }
                case 23: {
                    if (stack.isEmpty()) break;
                    Event event3 = (Event)stack.pop();
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                    break;
                }
            }
        }
        return arrayList;
    }

    protected List createDrools4EventList(List list) {
        Iterator iterator = list.iterator();
        ArrayList<Event> arrayList = new ArrayList<Event>();
        Event event = null;
        Event event2 = null;
        ArrayList<Event> arrayList2 = new ArrayList<Event>();
        HashMap<String, Event> hashMap = new HashMap<String, Event>();
        HashMap<Long, Event> hashMap2 = new HashMap<Long, Event>();
        while (iterator.hasNext()) {
            LogEvent logEvent = (LogEvent)iterator.next();
            Event event3 = new Event(logEvent.getType());
            switch (logEvent.getType()) {
                case 1: {
                    ObjectLogEvent objectLogEvent = (ObjectLogEvent)logEvent;
                    event3.setString("Object inserted (" + objectLogEvent.getFactId() + "): " + objectLogEvent.getObjectToString());
                    if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                    hashMap2.put(new Long(((ObjectLogEvent)logEvent).getFactId()), event3);
                    break;
                }
                case 2: {
                    ObjectLogEvent objectLogEvent = (ObjectLogEvent)logEvent;
                    event3.setString("Object updated (" + objectLogEvent.getFactId() + "): " + objectLogEvent.getObjectToString());
                    if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                    Event event4 = (Event)hashMap2.get(new Long(((ObjectLogEvent)logEvent).getFactId()));
                    if (event4 == null) break;
                    event3.setCauseEvent(event4);
                    break;
                }
                case 3: {
                    ObjectLogEvent objectLogEvent = (ObjectLogEvent)logEvent;
                    event3.setString("Object removed (" + objectLogEvent.getFactId() + "): " + objectLogEvent.getObjectToString());
                    if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                    Event event4 = (Event)hashMap2.get(new Long(((ObjectLogEvent)logEvent).getFactId()));
                    if (event4 == null) break;
                    event3.setCauseEvent(event4);
                    break;
                }
                case 4: {
                    ActivationLogEvent activationLogEvent = (ActivationLogEvent)logEvent;
                    event3.setString("Activation created: Rule " + activationLogEvent.getRule() + " " + activationLogEvent.getDeclarations());
                    arrayList2.add(event3);
                    hashMap.put(((ActivationLogEvent)logEvent).getActivationId(), event3);
                    break;
                }
                case 5: {
                    ActivationLogEvent activationLogEvent = (ActivationLogEvent)logEvent;
                    event3.setString("Activation cancelled: Rule " + activationLogEvent.getRule() + " " + activationLogEvent.getDeclarations());
                    arrayList2.add(event3);
                    event3.setCauseEvent((Event)hashMap.get(((ActivationLogEvent)logEvent).getActivationId()));
                    break;
                }
                case 6: {
                    ActivationLogEvent activationLogEvent = (ActivationLogEvent)logEvent;
                    event3.setString("Activation executed: Rule " + activationLogEvent.getRule() + " " + activationLogEvent.getDeclarations());
                    arrayList.add(event3);
                    event = event3;
                    event3.setCauseEvent((Event)hashMap.get(((ActivationLogEvent)logEvent).getActivationId()));
                    break;
                }
                case 7: {
                    event = null;
                    break;
                }
                case 8: {
                    RuleFlowLogEvent ruleFlowLogEvent = (RuleFlowLogEvent)logEvent;
                    event3.setString("RuleFlow started: " + ruleFlowLogEvent.getProcessName() + "[" + ruleFlowLogEvent.getProcessId() + "]");
                    if (event != null) {
                        event.addSubEvent(event3);
                        break;
                    }
                    arrayList.add(event3);
                    break;
                }
                case 9: {
                    RuleFlowLogEvent ruleFlowLogEvent = (RuleFlowLogEvent)logEvent;
                    event3.setString("RuleFlow completed: " + ruleFlowLogEvent.getProcessName() + "[" + ruleFlowLogEvent.getProcessId() + "]");
                    if (event != null) {
                        event.addSubEvent(event3);
                        break;
                    }
                    arrayList.add(event3);
                    break;
                }
                case 10: {
                    RuleFlowGroupLogEvent ruleFlowGroupLogEvent = (RuleFlowGroupLogEvent)logEvent;
                    event3.setString("RuleFlowGroup activated: " + ruleFlowGroupLogEvent.getGroupName() + "[size=" + ruleFlowGroupLogEvent.getSize() + "]");
                    if (event != null) {
                        event.addSubEvent(event3);
                        break;
                    }
                    arrayList.add(event3);
                    break;
                }
                case 11: {
                    RuleFlowGroupLogEvent ruleFlowGroupLogEvent = (RuleFlowGroupLogEvent)logEvent;
                    event3.setString("RuleFlowGroup deactivated: " + ruleFlowGroupLogEvent.getGroupName() + "[size=" + ruleFlowGroupLogEvent.getSize() + "]");
                    if (event != null) {
                        event.addSubEvent(event3);
                        break;
                    }
                    arrayList.add(event3);
                    break;
                }
                case 12: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event3.setString("Package added: " + ruleBaseLogEvent.getPackageName());
                    if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event2 = event3;
                    break;
                }
                case 13: {
                    event2 = null;
                    break;
                }
                case 14: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event3.setString("Package removed: " + ruleBaseLogEvent.getPackageName());
                    if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event2 = event3;
                    break;
                }
                case 15: {
                    event2 = null;
                    break;
                }
                case 17: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event3.setString("Rule added: " + ruleBaseLogEvent.getRuleName());
                    if (event2 != null) {
                        event2.addSubEvent(event3);
                    } else if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                    break;
                }
                case 19: {
                    RuleBaseLogEvent ruleBaseLogEvent = (RuleBaseLogEvent)logEvent;
                    event3.setString("Rule removed: " + ruleBaseLogEvent.getRuleName());
                    if (event2 != null) {
                        event2.addSubEvent(event3);
                    } else if (event != null) {
                        event.addSubEvent(event3);
                    } else {
                        arrayList.add(event3);
                    }
                    event3.addSubEvents(arrayList2);
                    arrayList2.clear();
                }
            }
        }
        return arrayList;
    }

    public void deleteLog() {
        if (this.logFileName != null) {
            File file = new File(this.logFileName);
            try {
                file.delete();
                this.setLogFile(null);
                this.refresh();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                DroolsEclipsePlugin.log(throwable);
            }
        }
    }

    protected void becomesVisible() {
        this.refresh();
    }

    protected String getHelpContextId() {
        return null;
    }

    public Event getSelectedEvent() {
        Object object;
        ISelection iSelection = this.getViewer().getSelection();
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof Event) {
            return (Event)object;
        }
        return null;
    }

    public void showEvent(Event event) {
        ((TreeViewer)this.getViewer()).reveal((Object)event);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        Event event;
        Event event2 = this.getSelectedEvent();
        if (event2 != null && (event = event2.getCauseEvent()) != null) {
            iMenuManager.add(this.getAction("ShowEventCause"));
        }
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void createActions() {
        this.deleteAction = new DeleteLogAction(this);
        this.setAction("ClearLog", this.deleteAction);
        this.deleteAction.setEnabled(this.logFileName != null);
        this.refreshAction = new RefreshLogAction(this);
        this.setAction("RefreshLog", this.refreshAction);
        this.refreshAction.setEnabled(this.logFileName != null);
        Action action = new OpenLogAction(this);
        this.setAction("OpenLog", (IAction)action);
        action = new ShowEventCauseAction(this);
        this.setAction("ShowEventCause", (IAction)action);
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add(this.getAction("OpenLog"));
        iToolBarManager.add(this.getAction("RefreshLog"));
        iToolBarManager.add(this.getAction("ClearLog"));
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString(LOG_FILE_NAME, this.logFileName);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        if (iMemento != null) {
            this.logFileName = iMemento.getString(LOG_FILE_NAME);
        }
    }

    public class AuditLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Color getForeground(Object object) {
            return null;
        }

        public Color getBackground(Object object) {
            Event event = AuditView.this.getSelectedEvent();
            if (event != null && object.equals(event.getCauseEvent())) {
                Color color = DroolsEclipsePlugin.getDefault().getColor(AuditView.CAUSE_EVENT_COLOR);
                if (color == null) {
                    color = new Color((Device)AuditView.this.getControl().getDisplay(), 0, 255, 0);
                    DroolsEclipsePlugin.getDefault().setColor(AuditView.CAUSE_EVENT_COLOR, color);
                }
                return color;
            }
            return null;
        }

        public Image getImage(Object object) {
            if (object instanceof Event) {
                int n = ((Event)object).getType();
                if (AuditView.this.drools4) {
                    switch (n) {
                        case 1: {
                            return DroolsPluginImages.getImage("Insert");
                        }
                        case 2: {
                            return DroolsPluginImages.getImage("Update");
                        }
                        case 3: {
                            return DroolsPluginImages.getImage("RetractO");
                        }
                        case 4: {
                            return DroolsPluginImages.getImage("CreateActivation");
                        }
                        case 5: {
                            return DroolsPluginImages.getImage("CancelActivation");
                        }
                        case 6: {
                            return DroolsPluginImages.getImage("ExecuteActivation");
                        }
                        case 8: {
                            return DroolsPluginImages.getImage("RuleFlow");
                        }
                        case 9: {
                            return DroolsPluginImages.getImage("RuleFlow");
                        }
                        case 24: {
                            return DroolsPluginImages.getImage("RuleFlowNodeTriggered");
                        }
                        case 10: {
                            return DroolsPluginImages.getImage("RuleFlowGroup");
                        }
                        case 11: {
                            return DroolsPluginImages.getImage("RuleFlowGroup");
                        }
                        case 12: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                        case 14: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                        case 17: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                        case 19: {
                            return DroolsPluginImages.getImage("Drools");
                        }
                    }
                }
                switch (n) {
                    case 1: {
                        return DroolsPluginImages.getImage("Insert");
                    }
                    case 2: {
                        return DroolsPluginImages.getImage("Update");
                    }
                    case 3: {
                        return DroolsPluginImages.getImage("RetractO");
                    }
                    case 4: {
                        return DroolsPluginImages.getImage("CreateActivation");
                    }
                    case 5: {
                        return DroolsPluginImages.getImage("CancelActivation");
                    }
                    case 6: {
                        return DroolsPluginImages.getImage("ExecuteActivation");
                    }
                    case 8: {
                        return DroolsPluginImages.getImage("RuleFlow");
                    }
                    case 10: {
                        return DroolsPluginImages.getImage("RuleFlow");
                    }
                    case 24: {
                        return DroolsPluginImages.getImage("RuleFlowNodeTriggered");
                    }
                    case 12: {
                        return DroolsPluginImages.getImage("RuleFlowGroup");
                    }
                    case 14: {
                        return DroolsPluginImages.getImage("RuleFlowGroup");
                    }
                    case 16: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                    case 18: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                    case 20: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                    case 22: {
                        return DroolsPluginImages.getImage("Drools");
                    }
                }
                return null;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Event {
        private String toString;
        private int type;
        private List<Event> subEvents = new ArrayList<Event>();
        private Event causeEvent;

        public Event(int n) {
            this.type = n;
        }

        public void setString(String string) {
            this.toString = string;
        }

        public String toString() {
            return this.toString;
        }

        public int getType() {
            return this.type;
        }

        public void addSubEvent(Event event) {
            this.subEvents.add(event);
        }

        public void addSubEvents(Collection<Event> collection) {
            this.subEvents.addAll(collection);
        }

        public Object[] getSubEvents() {
            return this.subEvents.toArray();
        }

        public boolean hasSubEvents() {
            return !this.subEvents.isEmpty();
        }

        public void setCauseEvent(Event event) {
            this.causeEvent = event;
        }

        public Event getCauseEvent() {
            return this.causeEvent;
        }
    }
}

