/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.flow.common.editor.ProcessExtension;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ProcessEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ProcessEditPartFactory;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.drools.process.core.Process;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ProcessInstanceViewer
extends ViewPart
implements ISelectionListener {
    private CTabFolder tabFolder;
    private Map<String, ProcessInstanceTabItem> processInstanceTabItems = new HashMap<String, ProcessInstanceTabItem>();

    public void createPartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.tabFolder = new CTabFolder(composite, 64);
        this.tabFolder.setBorderVisible(true);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
    }

    public void setFocus() {
    }

    public void showProcessInstance(String string, String string2, List list, String string3) {
        this.processInstanceTabItems.put(string, new ProcessInstanceTabItem(this.tabFolder, string, string2, list, string3));
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
    }

    private IJavaProject getJavaProject(String string) {
        IProject iProject;
        if (string != null && (string = string.trim()).length() > 0 && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)) != null) {
            try {
                IJavaProject iJavaProject;
                if (iProject.getNature("org.eclipse.jdt.core.javanature") != null && (iJavaProject = JavaCore.create((IProject)iProject)).exists()) {
                    return iJavaProject;
                }
            }
            catch (CoreException coreException) {
                DroolsEclipsePlugin.log(coreException);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessInstanceTabItem {
        private GraphicalViewer graphicalViewer;
        private CTabItem tabItem;
        private String projectName;

        public ProcessInstanceTabItem(CTabFolder cTabFolder, String string, String string2, List<String> list, String string3) {
            IConfigurationElement[] iConfigurationElementArray;
            this.projectName = string3;
            this.tabItem = new CTabItem(cTabFolder, 0);
            ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().getProcessInfo(string2);
            if (processInfo == null) {
                throw new IllegalArgumentException("Could not find process with id " + string2);
            }
            this.tabItem.setText(String.valueOf(string) + " = " + processInfo.getProcess().getName() + "[" + processInfo.getProcessId() + "]");
            Composite composite = new Composite((Composite)cTabFolder, 0);
            composite.setLayout((Layout)new FillLayout());
            this.tabItem.setControl((Control)composite);
            this.graphicalViewer = new ScrollingGraphicalViewer();
            this.graphicalViewer.createControl(composite);
            this.graphicalViewer.getControl().setBackground(ColorConstants.listBackground);
            this.graphicalViewer.setRootEditPart((RootEditPart)new ScalableRootEditPart());
            IJavaProject iJavaProject = ProcessInstanceViewer.this.getJavaProject(string3);
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.drools.eclipse.processExtension");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement object = iConfigurationElementArray2[n2];
                try {
                    ProcessExtension processExtension = (ProcessExtension)object.createExecutableExtension("className");
                    Process process = (Process)processInfo.getProcess();
                    if (processExtension.acceptsProcess(process.getType())) {
                        ProcessEditPartFactory processEditPartFactory = processExtension.getProcessEditPartFactory();
                        processEditPartFactory.setProject(iJavaProject);
                        this.graphicalViewer.setEditPartFactory((EditPartFactory)processEditPartFactory);
                        ProcessWrapper processWrapper = processExtension.getProcessWrapperBuilder().getProcessWrapper((org.drools.definition.process.Process)process, iJavaProject);
                        this.graphicalViewer.setContents((Object)processWrapper);
                        break;
                    }
                }
                catch (CoreException coreException) {
                    DroolsEclipsePlugin.log(coreException);
                }
                ++n2;
            }
            for (String string4 : list) {
                this.handleNodeInstanceSelection(string4);
            }
            cTabFolder.setSelection(this.tabItem);
        }

        private void handleNodeInstanceSelection(String string) {
            boolean bl = false;
            for (ElementEditPart elementEditPart : ((ProcessEditPart)this.graphicalViewer.getContents()).getChildren()) {
                if (!((ElementWrapper)elementEditPart.getModel()).getId().equals(string)) continue;
                ((ElementFigure)elementEditPart.getFigure()).setSelected(true);
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Could not find node with id " + string);
            }
        }

        public CTabItem getTabItem() {
            return this.tabItem;
        }
    }
}

