/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsThread;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DroolsStackFrame
extends JDIStackFrame {
    protected static final String HANDLE_SUFIX = "__Handle__";
    protected static final String DROOLS_VAR_NAME = "drools";
    private static final String CONSEQUENCE_SIGNATURE = "(Lorg/drools/spi/KnowledgeHelper";

    public DroolsStackFrame(JDIThread jDIThread, StackFrame stackFrame, int n) {
        super(jDIThread, stackFrame, n);
    }

    public boolean isExecutingRule() {
        try {
            if ("consequence".equals(this.getMethodName()) && this.getSignature().startsWith(CONSEQUENCE_SIGNATURE)) {
                return true;
            }
        }
        catch (DebugException debugException) {
            DroolsEclipsePlugin.log(debugException);
        }
        return false;
    }

    public DRLInfo.RuleInfo getExecutingRuleInfo() {
        try {
            String string = this.getMethodName();
            String string2 = this.getSignature();
            String string3 = this.getDeclaringTypeName();
            if ("consequence".equals(string) && string2.startsWith(CONSEQUENCE_SIGNATURE)) {
                return DroolsEclipsePlugin.getDefault().getRuleInfoByClass(string3);
            }
        }
        catch (DebugException debugException) {
            DroolsEclipsePlugin.log(debugException);
        }
        return null;
    }

    public DRLInfo.FunctionInfo getExecutingFunctionInfo() {
        try {
            return DroolsEclipsePlugin.getDefault().getFunctionInfoByClass(this.getDeclaringTypeName());
        }
        catch (DebugException debugException) {
            DroolsEclipsePlugin.log(debugException);
            return null;
        }
    }

    protected JDIStackFrame bind(StackFrame stackFrame, int n) {
        JDIStackFrame jDIStackFrame = super.bind(stackFrame, n);
        if (jDIStackFrame != null && jDIStackFrame != this) {
            jDIStackFrame = DroolsThread.createCustomFrame((DroolsThread)this.getThread(), n, stackFrame);
        }
        return jDIStackFrame;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] iVariableArray = super.getVariables();
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>((iVariableArray.length - 1) / 2);
        int n = 0;
        while (n < iVariableArray.length) {
            String string = iVariableArray[n].getName();
            if (!string.equals(DROOLS_VAR_NAME) && !string.endsWith(HANDLE_SUFIX)) {
                arrayList.add(iVariableArray[n]);
            }
            ++n;
        }
        iVariableArray = arrayList.toArray(new IVariable[arrayList.size()]);
        return iVariableArray;
    }

    public IJavaVariable[] getLocalVariables() throws DebugException {
        IJavaVariable[] iJavaVariableArray = super.getLocalVariables();
        return iJavaVariableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            DRLInfo.RuleInfo ruleInfo = this.getExecutingRuleInfo();
            if (ruleInfo != null) {
                return ruleInfo.getConsequenceDrlLineNumber() + (super.getLineNumber() - ruleInfo.getConsequenceJavaLineNumber() - 1);
            }
            DRLInfo.FunctionInfo functionInfo = this.getExecutingFunctionInfo();
            if (functionInfo != null) {
                return functionInfo.getDrlLineNumber() + (super.getLineNumber() - functionInfo.getJavaLineNumber());
            }
        }
        return super.getLineNumber();
    }

    public StackFrame getUnderlyingStackFrame() throws DebugException {
        return super.getUnderlyingStackFrame();
    }

    protected void setUnderlyingStackFrame(StackFrame stackFrame) {
        super.setUnderlyingStackFrame(stackFrame);
    }

    public void stepOver() throws DebugException {
        super.stepOver();
    }
}

