/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsStackFrame;
import org.drools.eclipse.debug.core.MVELStackFrame;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DroolsThread
extends JDIThread {
    public DroolsThread(JDIDebugTarget jDIDebugTarget, ThreadReference threadReference) throws ObjectCollectedException {
        super(jDIDebugTarget, threadReference);
    }

    protected synchronized List computeStackFrames(boolean bl) throws DebugException {
        List list = this.getInternalfStackFrames();
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                list.clear();
            } else if (bl) {
                DroolsStackFrame droolsStackFrame;
                List list2 = this.getInternalUnderlyingFrames();
                int n = list.size();
                int n2 = list2.size();
                int n3 = n - n2;
                int n4 = 0;
                while (n4 < n3) {
                    DroolsStackFrame droolsStackFrame2 = (DroolsStackFrame)((Object)list.remove(0));
                    droolsStackFrame2.bind(null, -1);
                    ++n4;
                }
                n4 = n2 - n;
                int n5 = n;
                int n6 = n4 - 1;
                while (n6 >= 0) {
                    StackFrame stackFrame = (StackFrame)list2.get(n6);
                    droolsStackFrame = DroolsThread.createCustomFrame(this, n5, stackFrame);
                    list.add(0, droolsStackFrame);
                    ++n5;
                    --n6;
                }
                n6 = Math.min(n2, n);
                int n7 = n2 - 1;
                n5 = 0;
                while (n5 < n6) {
                    StackFrame stackFrame;
                    droolsStackFrame = (DroolsStackFrame)((Object)list.get(n7));
                    DroolsStackFrame droolsStackFrame3 = (DroolsStackFrame)droolsStackFrame.bind(stackFrame = (StackFrame)list2.get(n7), n5);
                    if (droolsStackFrame3 != droolsStackFrame) {
                        list.set(n7, droolsStackFrame3);
                    }
                    --n7;
                    ++n5;
                }
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        this.setInternalfRefreshChildren(false);
        return list;
    }

    public static final synchronized DroolsStackFrame createCustomFrame(DroolsThread droolsThread, int n, StackFrame stackFrame) {
        Location location = stackFrame.location();
        DroolsStackFrame droolsStackFrame = location.declaringType().name().equals("org.drools.base.mvel.MVELDebugHandler") && location.method().name().equals("onBreak") ? new MVELStackFrame(droolsThread, stackFrame, n) : new DroolsStackFrame(droolsThread, stackFrame, n);
        return droolsStackFrame;
    }

    public synchronized void stepOver() throws DebugException {
        if (!(this.getTopStackFrame() instanceof MVELStackFrame)) {
            super.stepOver();
            return;
        }
        MVELStackFrame mVELStackFrame = (MVELStackFrame)this.getTopStackFrame();
        if (!this.canStepOver() || !mVELStackFrame.canStepOver()) {
            return;
        }
        if (!this.setRemoteOnBreakReturn(1)) {
            return;
        }
        this.setRunning(true);
        this.preserveStackFrames();
        this.fireEvent(new DebugEvent((Object)this, 1, 2));
        try {
            this.getUnderlyingThread().resume();
        }
        catch (RuntimeException runtimeException) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_stepping, runtimeException.toString()), runtimeException);
        }
    }

    private boolean setRemoteOnBreakReturn(int n) throws DebugException {
        JDIStackFrame jDIStackFrame = (JDIStackFrame)this.getTopStackFrame();
        if (jDIStackFrame == null || !(jDIStackFrame instanceof MVELStackFrame)) {
            return false;
        }
        Iterator<ReferenceType> iterator = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
        ReferenceType referenceType = iterator.next();
        int n2 = n;
        ReferenceType referenceType2 = referenceType;
        Method method = referenceType2.methodsByName("setOnBreakReturn").iterator().next();
        ArrayList<IntegerValue> arrayList = new ArrayList<IntegerValue>();
        IntegerValue integerValue = this.getVM().mirrorOf(n2);
        arrayList.add(integerValue);
        try {
            ClassType classType = (ClassType)referenceType;
            classType.invokeMethod(this.getUnderlyingThread(), method, arrayList, 1);
        }
        catch (Exception exception) {
            DroolsEclipsePlugin.log(exception);
            return false;
        }
        return true;
    }

    public synchronized void resume() throws DebugException {
        this.setRemoteOnBreakReturn(0);
        super.resume();
    }

    protected synchronized void disposeStackFrames() {
        super.disposeStackFrames();
    }

    protected void terminated() {
        super.terminated();
    }

    protected void removeCurrentBreakpoint(IBreakpoint iBreakpoint) {
        super.removeCurrentBreakpoint(iBreakpoint);
    }

    protected synchronized void suspendedByVM() {
        super.suspendedByVM();
    }

    protected synchronized void resumedByVM() throws DebugException {
        super.resumedByVM();
    }

    protected void setRunning(boolean bl) {
        super.setRunning(bl);
    }

    public void setInternalfRefreshChildren(boolean bl) {
        try {
            Field field = JDIThread.class.getDeclaredField("fRefreshChildren");
            field.setAccessible(true);
            field.set((Object)this, bl);
        }
        catch (Exception exception) {}
    }

    public List getInternalfStackFrames() {
        try {
            Field field = JDIThread.class.getDeclaredField("fStackFrames");
            field.setAccessible(true);
            return (List)field.get((Object)this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List getInternalUnderlyingFrames() throws DebugException {
        try {
            java.lang.reflect.Method method = JDIThread.class.getDeclaredMethod("getUnderlyingFrames", null);
            method.setAccessible(true);
            return (List)method.invoke((Object)this, null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

