/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.VariableWrapper;
import org.drools.eclipse.debug.core.DroolsDebugTarget;
import org.drools.eclipse.debug.core.DroolsLineBreakpoint;
import org.drools.eclipse.debug.core.DroolsStackFrame;
import org.drools.eclipse.debug.core.DroolsThread;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDILocalVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public class MVELStackFrame
extends DroolsStackFrame {
    private final MVELStackFrameContext ctxCache = new MVELStackFrameContext();
    private static final IJavaReferenceType REF_TYPE = new IJavaReferenceType(){

        public IJavaFieldVariable getField(String string) throws DebugException {
            return null;
        }

        public IJavaClassObject getClassObject() throws DebugException {
            return null;
        }

        public String[] getAvailableStrata() throws DebugException {
            return null;
        }

        public String getDefaultStratum() throws DebugException {
            return "MVEL";
        }

        public String[] getDeclaredFieldNames() throws DebugException {
            return null;
        }

        public String[] getAllFieldNames() throws DebugException {
            return null;
        }

        public IJavaObject getClassLoaderObject() throws DebugException {
            return null;
        }

        public String getGenericSignature() throws DebugException {
            return null;
        }

        public String getSourceName() throws DebugException {
            return null;
        }

        public String[] getSourceNames(String string) throws DebugException {
            return null;
        }

        public String[] getSourcePaths(String string) throws DebugException {
            return null;
        }

        public IJavaObject[] getInstances(long l) throws DebugException {
            return null;
        }

        public String getName() throws DebugException {
            return null;
        }

        public String getSignature() throws DebugException {
            return null;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return null;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public long getInstanceCount() throws DebugException {
            return 0L;
        }
    };

    public MVELStackFrame(DroolsThread droolsThread, StackFrame stackFrame, int n) {
        super(droolsThread, stackFrame, n);
    }

    public DRLInfo.RuleInfo getExecutingRuleInfo() {
        try {
            String string = this.getDeclaringTypeName();
            return DroolsEclipsePlugin.getDefault().getRuleInfoByClass(string);
        }
        catch (DebugException debugException) {
            DroolsEclipsePlugin.log(debugException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariable[] getVariables() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            if (!this.isSuspended()) {
                return new IVariable[0];
            }
            IVariable[] iVariableArray = this.ctxCache.getCacheVariables();
            if (iVariableArray != null) {
                return iVariableArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(0);
            Method method = this.getUnderlyingMethod();
            method.declaringType();
            try {
                String string;
                Object object;
                LocalVariable localVariable;
                LocalVariable localVariable2 = localVariable = method.variables().get(0);
                JDILocalVariable jDILocalVariable = new JDILocalVariable((JDIStackFrame)this, localVariable2);
                IValue iValue = DebugUtil.getValueByExpression("return getFactory().getKnownVariables().toArray(new String[0]);", jDILocalVariable.getValue());
                JDIObjectValue jDIObjectValue = (JDIObjectValue)iValue;
                if (jDIObjectValue != null && ((ArrayReference)jDIObjectValue.getUnderlyingObject()).length() > 0) {
                    object = (ArrayReference)jDIObjectValue.getUnderlyingObject();
                    Iterator<Value> iterator = object.getValues().iterator();
                    while (iterator.hasNext()) {
                        string = ((StringReference)iterator.next()).value();
                        IJavaValue iJavaValue = (IJavaValue)DebugUtil.getValueByExpression("return getFactory().getVariableResolver(\"" + string + "\").getValue();", jDILocalVariable.getValue());
                        if (iJavaValue != null) {
                            ((JDIObjectValue)iJavaValue).getUnderlyingObject();
                            VariableWrapper variableWrapper = new VariableWrapper(string, iJavaValue);
                            variableWrapper.setPublic(true);
                            arrayList.add((Object)variableWrapper);
                            continue;
                        }
                        DroolsEclipsePlugin.log(new Exception("Unable to get value for variable named '" + string + "' suspend=" + this.isSuspended()));
                    }
                }
                object = arrayList.toArray(new IVariable[arrayList.size()]);
                Arrays.sort(object, new Comparator<IVariable>(){

                    @Override
                    public int compare(IVariable iVariable, IVariable iVariable2) {
                        try {
                            return iVariable.getName().compareTo(iVariable2.getName());
                        }
                        catch (DebugException debugException) {
                            return 0;
                        }
                    }
                });
                arrayList = new ArrayList((((Object)object).length - 1) / 2);
                int n = 0;
                while (n < ((Object)object).length) {
                    string = object[n].getName();
                    if (!string.equals("drools") && !string.endsWith("__Handle__")) {
                        arrayList.add(object[n]);
                    }
                    ++n;
                }
                object = arrayList.toArray(new IVariable[arrayList.size()]);
                this.ctxCache.setCacheVariables((IVariable[])object);
                return object;
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
                return new IVariable[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            int n;
            block10: {
                int n2;
                DroolsLineBreakpoint droolsLineBreakpoint;
                String string;
                block9: {
                    int n3 = this.ctxCache.getCacheLineNumber();
                    if (n3 != -1) {
                        return n3;
                    }
                    DroolsDebugTarget droolsDebugTarget = (DroolsDebugTarget)this.getDebugTarget();
                    droolsLineBreakpoint = droolsDebugTarget.getDroolsBreakpoint(string = this.getMVELName());
                    if (droolsLineBreakpoint != null) break block9;
                    return -1;
                }
                try {
                    n2 = Integer.parseInt(droolsLineBreakpoint.getFileRuleMappings().get(string).toString());
                }
                catch (Throwable throwable) {
                    DroolsEclipsePlugin.log(throwable);
                    return -1;
                }
                int n4 = this.getBreakpointLineNumber();
                n = n2 + n4;
                if (n4 != -1) break block10;
                return -1;
            }
            this.ctxCache.setCacheLineNumber(n);
            return n;
        }
    }

    private int getBreakpointLineNumber() {
        Object object;
        block13: {
            block12: {
                block10: {
                    if (this.ctxCache.getCacheBreakpointLineNumber() != -1) {
                        return this.ctxCache.getCacheBreakpointLineNumber();
                    }
                    object = this.getRemoteVar("lineNumber");
                    if (object != null) break block10;
                    return -1;
                }
                try {
                    IntegerValue integerValue = (IntegerValue)object;
                    int n = integerValue.value();
                    this.ctxCache.setCacheBreakpointLineNumber(n);
                    return n;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Throwable throwable) {
                    DroolsEclipsePlugin.log(throwable);
                }
                object = this.getRemoteVar("label");
                if (object != null) break block12;
                return -1;
            }
            ObjectReference objectReference = (ObjectReference)object;
            ClassType classType = (ClassType)objectReference.type();
            Field field = classType.fieldByName("lineNumber");
            object = objectReference.getValue(field);
            if (object != null) break block13;
            return -1;
        }
        try {
            IntegerValue integerValue = (IntegerValue)object;
            int n = integerValue.value();
            this.ctxCache.setCacheBreakpointLineNumber(n);
            return n;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMVELName() {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            String string = this.ctxCache.getCacheMVELName();
            if (string != null) {
                return string;
            }
            if (!this.isSuspended()) {
                return null;
            }
            try {
                Object object = this.getRemoteVar("sourceName");
                if (object == null) {
                    return null;
                }
                StringReference objectReference = (StringReference)object;
                String classType = objectReference.value();
                this.ctxCache.setCacheMVELName(classType);
                return classType;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
            try {
                Object throwable = this.getRemoteVar("label");
                if (throwable == null) {
                    return null;
                }
                ObjectReference objectReference = (ObjectReference)throwable;
                ClassType classType = (ClassType)objectReference.type();
                Field field = classType.fieldByName("sourceFile");
                if ((throwable = objectReference.getValue(field)) == null) {
                    return null;
                }
                StringReference stringReference = (StringReference)throwable;
                String string2 = stringReference.value();
                this.ctxCache.setCacheMVELName(string2);
                return string2;
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
                return "Unavailable";
            }
        }
    }

    private void evalEnd() {
        this.fireChangeEvent(256);
    }

    private Object getRemoteVar(String string) throws AbsentInformationException, ClassNotLoadedException, DebugException, InvalidTypeException, IncompatibleThreadStateException, InvocationException {
        Method method = this.getUnderlyingMethod();
        LocalVariable localVariable = method.variables().get(0);
        ClassType classType = (ClassType)localVariable.type();
        StackFrame stackFrame = this.getUnderlyingStackFrame();
        Value value = stackFrame.getValue(localVariable);
        ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)value;
        if (objectReferenceImpl == null) {
            return null;
        }
        Field field = classType.fieldByName(string);
        Value value2 = objectReferenceImpl.getValue(field);
        return value2;
    }

    public String getSourcePath() throws DebugException {
        return this.getMVELName();
    }

    public String getSourceName() throws DebugException {
        return this.getMVELName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            this.ctxCache.clear();
        }
        super.stepOver();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canDropToFrame() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean canStepWithFilters() {
        return false;
    }

    public IJavaReferenceType getReferenceType() throws DebugException {
        return REF_TYPE;
    }

    public static class MVELStackFrameContext {
        private int cacheLineNumber = -1;
        private int cacheBreakpointLineNumber = -1;
        private String cacheMVELName = null;
        private IVariable[] cacheVariables = null;

        public synchronized void clear() {
            this.cacheLineNumber = -1;
            this.cacheBreakpointLineNumber = -1;
            this.cacheMVELName = null;
            this.cacheVariables = null;
        }

        public synchronized int getCacheLineNumber() {
            return this.cacheLineNumber;
        }

        public synchronized void setCacheLineNumber(int n) {
            this.cacheLineNumber = n;
        }

        public synchronized int getCacheBreakpointLineNumber() {
            return this.cacheBreakpointLineNumber;
        }

        public synchronized void setCacheBreakpointLineNumber(int n) {
            this.cacheBreakpointLineNumber = n;
        }

        public synchronized String getCacheMVELName() {
            return this.cacheMVELName;
        }

        public synchronized void setCacheMVELName(String string) {
            this.cacheMVELName = string;
        }

        public synchronized IVariable[] getCacheVariables() {
            return this.cacheVariables;
        }

        public synchronized void setCacheVariables(IVariable[] iVariableArray) {
            this.cacheVariables = iVariableArray;
        }
    }
}

