/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.editors.completion.DSLTree;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class DSLAdapter {
    private String dslConfigName;
    private boolean valid = false;
    private List conditionProposals = new ArrayList();
    private List consequenceProposals = new ArrayList();
    private DSLTree dslTree = new DSLTree();
    private static final Pattern EXPANDER_PATTERN = Pattern.compile("\\n\\s*expander\\s*(.*)\\.dsl", 40);

    public DSLAdapter(String string, IFile iFile) throws CoreException {
        this.dslConfigName = DSLAdapter.findDSLConfigName(string, (IResource)iFile);
        if (this.dslConfigName == null) {
            return;
        }
        this.loadConfig(iFile);
    }

    public static Reader getDSLContent(String string, IResource iResource) throws CoreException {
        IFile iFile;
        String string2 = DSLAdapter.findDSLConfigName(string, iResource);
        if (string2 == null) {
            return null;
        }
        IResource iResource2 = DSLAdapter.findDSLResource(iResource, string2);
        if (iResource2 instanceof IFile && (iFile = (IFile)iResource2).exists()) {
            return new InputStreamReader(iFile.getContents());
        }
        return null;
    }

    private void loadConfig(IFile iFile) {
        IFile iFile2;
        IResource iResource = DSLAdapter.findDSLResource((IResource)iFile, this.dslConfigName);
        if (iResource instanceof IFile && (iFile2 = (IFile)iResource).exists()) {
            InputStream inputStream = null;
            try {
                try {
                    inputStream = iFile2.getContents();
                    this.readConfig(inputStream);
                    this.valid = true;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Unable to open DSL config file. (Exception: " + exception.getMessage() + ")");
                }
            }
            finally {
                this.closeStream(inputStream);
            }
        }
    }

    private static IResource findDSLResource(IResource iResource, String string) {
        IResource iResource2 = iResource.getParent().findMember(string);
        if (iResource2 == null) {
            iResource2 = iResource.getParent().getParent().findMember(string);
        }
        if (iResource2 == null) {
            iResource2 = iResource.getProject().findMember(string);
        }
        return iResource2;
    }

    void readConfig(InputStream inputStream) throws IOException, CoreException {
        DSLTokenizedMappingFile dSLTokenizedMappingFile = new DSLTokenizedMappingFile();
        dSLTokenizedMappingFile.parseAndLoad((Reader)new InputStreamReader(inputStream));
        DSLMapping dSLMapping = dSLTokenizedMappingFile.getMapping();
        List list = dSLMapping.getEntries(DSLMappingEntry.CONDITION);
        List list2 = dSLMapping.getEntries(DSLMappingEntry.CONSEQUENCE);
        this.conditionProposals = this.buildProposals(list);
        this.consequenceProposals = this.buildProposals(list2);
        this.dslTree.buildTree(dSLMapping);
    }

    private List buildProposals(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (DSLMappingEntry dSLMappingEntry : list) {
            arrayList.add(dSLMappingEntry.getMappingKey());
        }
        return arrayList;
    }

    private void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    DSLAdapter() {
    }

    private static String findDSLConfigName(String string, IResource iResource) throws CoreException {
        String string2 = DSLAdapter.findDSLConfigName(string);
        if (string2 == null && iResource != null && iResource.getParent() != null) {
            MyResourceVisitor myResourceVisitor = new MyResourceVisitor();
            iResource.getParent().accept((IResourceVisitor)myResourceVisitor, 1, 0);
            IResource iResource2 = myResourceVisitor.getPackageDef();
            if (iResource2 != null && iResource2 instanceof IFile) {
                IFile iFile = (IFile)iResource2;
                try {
                    String string3 = new String(Util.getResourceContentsAsCharArray(iFile));
                    string2 = DSLAdapter.findDSLConfigName(string3);
                }
                catch (CoreException coreException) {
                    DroolsEclipsePlugin.log(coreException);
                }
            }
        }
        return string2;
    }

    static String findDSLConfigName(String string) {
        String string2 = null;
        Matcher matcher = EXPANDER_PATTERN.matcher(string);
        if (matcher.find()) {
            string2 = String.valueOf(matcher.group(1)) + ".dsl";
        }
        return string2;
    }

    String getDSLConfigName() {
        return this.dslConfigName;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasConditions() {
        return this.conditionProposals.size() > 0;
    }

    public boolean hasConsequences() {
        return this.consequenceProposals.size() > 0;
    }

    public List listConditionItems() {
        return this.conditionProposals;
    }

    public List listConsequenceItems() {
        return this.consequenceProposals;
    }

    public DSLTree getDSLTree() {
        return this.dslTree;
    }

    private static class MyResourceVisitor
    implements IResourceVisitor {
        private IResource packageDef;

        private MyResourceVisitor() {
        }

        public boolean visit(IResource iResource) throws CoreException {
            if ("package".equals(iResource.getFileExtension())) {
                this.packageDef = iResource;
            }
            return true;
        }

        public IResource getPackageDef() {
            return this.packageDef;
        }
    }
}

