/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import org.drools.lang.dsl.DSLMappingEntry;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DSLMappingSorter
extends ViewerSorter {
    public static final int OBJECT = 0;
    public static final int EXPRESSION = 1;
    public static final int MAPPING = 2;
    public static final int SCOPE = 3;
    private int criteria;

    public DSLMappingSorter(int n) {
        this.criteria = n;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        DSLMappingEntry dSLMappingEntry = (DSLMappingEntry)object;
        DSLMappingEntry dSLMappingEntry2 = (DSLMappingEntry)object2;
        switch (this.criteria) {
            case 0: {
                return this.compareObject(dSLMappingEntry, dSLMappingEntry2);
            }
            case 1: {
                return this.compareExpressions(dSLMappingEntry, dSLMappingEntry2);
            }
            case 2: {
                return this.compareMappings(dSLMappingEntry, dSLMappingEntry2);
            }
            case 3: {
                return this.compareScope(dSLMappingEntry, dSLMappingEntry2);
            }
        }
        return 0;
    }

    private int compareScope(DSLMappingEntry dSLMappingEntry, DSLMappingEntry dSLMappingEntry2) {
        return dSLMappingEntry.getSection().compareTo((Enum)dSLMappingEntry2.getSection());
    }

    private int compareMappings(DSLMappingEntry dSLMappingEntry, DSLMappingEntry dSLMappingEntry2) {
        return dSLMappingEntry.getMappingValue().compareTo(dSLMappingEntry2.getMappingValue());
    }

    private int compareExpressions(DSLMappingEntry dSLMappingEntry, DSLMappingEntry dSLMappingEntry2) {
        return dSLMappingEntry.getMappingKey().compareTo(dSLMappingEntry2.getMappingKey());
    }

    private int compareObject(DSLMappingEntry dSLMappingEntry, DSLMappingEntry dSLMappingEntry2) {
        return dSLMappingEntry.getMetaData().compareTo((Object)dSLMappingEntry2.getMetaData());
    }

    public int getCriteria() {
        return this.criteria;
    }
}

